/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals.fusionmode.equation;

import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.fusionmode.equation.AbstractExpressionComponent;
import com.mimvista.internals.fusionmode.equation.AdditionOperator;
import com.mimvista.internals.fusionmode.equation.MathEquation;
import com.mimvista.internals.fusionmode.equation.MathExpression;
import com.mimvista.internals.fusionmode.equation.MathSymbol;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class HorizontalOperator
extends AbstractExpressionComponent {
    private static final long serialVersionUID = 2075084806781349L;
    final MathExpression leftOperand;
    final MathExpression rightOperand;
    final String operator;
    final int spacing;

    public HorizontalOperator(MathExpression mathExpression, String string, MathExpression mathExpression2) {
        this(mathExpression, string, mathExpression2, 5);
    }

    public HorizontalOperator(MathExpression mathExpression, String string, MathExpression mathExpression2, int n2) {
        this.leftOperand = mathExpression;
        this.operator = string;
        this.rightOperand = mathExpression2;
        this.spacing = n2;
    }

    @Override
    public Dimension a(MathExpression.RenderMode renderMode, float f2) {
        renderMode = this.a(renderMode);
        Dimension dimension = new Dimension();
        Dimension dimension2 = this.leftOperand.a(renderMode, f2);
        Dimension dimension3 = this.rightOperand.a(renderMode, f2);
        FontMetrics fontMetrics = this.getFontMetrics(MathSymbol.a(f2));
        dimension.height = Math.max(dimension2.height, dimension3.height);
        dimension.width = dimension2.width + this.spacing + fontMetrics.stringWidth(this.operator) + this.spacing + dimension3.width;
        return dimension;
    }

    @Override
    public void a(Graphics2D graphics2D, int n2, int n3, MathExpression.RenderMode renderMode, float f2) {
        renderMode = this.a(renderMode);
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setFont(MathSymbol.a(f2));
        FontMetrics fontMetrics = MIMSwingUtils.a(graphics2D2);
        Dimension dimension = this.a(renderMode, f2);
        Point point = new Point(n2 + dimension.width / 2, n3 + dimension.height / 2);
        int n4 = point.y + fontMetrics.getHeight() / 2 - fontMetrics.getDescent();
        Dimension dimension2 = this.leftOperand.a(renderMode, f2);
        this.leftOperand.a(graphics2D2, n2, point.y - dimension2.height / 2, renderMode, f2);
        int n5 = n2 + dimension2.width + this.spacing;
        graphics2D2.drawString(this.operator, n5, n4 + fontMetrics.getDescent() / 2);
        Dimension dimension3 = this.rightOperand.a(renderMode, f2);
        this.rightOperand.a(graphics2D2, n5 += fontMetrics.stringWidth(this.operator) + this.spacing, point.y - dimension3.height / 2, renderMode, f2);
        graphics2D2.dispose();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(300, 300);
        jFrame.setContentPane(new JPanel(new BorderLayout()));
        MathSymbol mathSymbol = new MathSymbol("", "F", "", "", "(x,y,z)", null);
        MathSymbol mathSymbol2 = new MathSymbol("", "P", "", "NN", "(x,y,z)", null);
        MathSymbol mathSymbol3 = new MathSymbol("", "S", "", "", "(x,y,z)", null);
        AdditionOperator additionOperator = new AdditionOperator(mathSymbol2, mathSymbol3);
        MathEquation mathEquation = new MathEquation(mathSymbol, additionOperator);
        jFrame.getContentPane().add(mathEquation);
        jFrame.setVisible(true);
    }

    @Override
    public Set<MathSymbol> b() {
        Set<MathSymbol> set = this.leftOperand.b();
        set.addAll(this.rightOperand.b());
        return set;
    }
}

