/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals.linking;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.dicom.write.deformable.DcmDeformableRegWriter;
import com.mimvista.intensitybasedwarp.IntensityWarpSettings;
import com.mimvista.intensitybasedwarp.e;
import com.mimvista.intensitybasedwarp.f;
import com.mimvista.intensitybasedwarp.g;
import com.mimvista.intensitybasedwarp.h;
import com.mimvista.intensitybasedwarp.o;
import com.mimvista.intensitybasedwarp.qa.DeformableQA;
import com.mimvista.intensitybasedwarp.s;
import com.mimvista.intensitybasedwarp.t;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.linking.AffineTransform;
import com.mimvista.internals.linking.InverseWarpTransform;
import com.mimvista.internals.linking.PositionTransform;
import com.mimvista.internals.linking.TransformEdge;
import com.mimvista.internals.linking.WarpKey;
import com.mimvista.internals.linking.a;
import com.mimvista.internals.linking.d;
import com.mimvista.internals.linking.i;
import com.mimvista.internals.volumes.ImageVolumeByte;
import com.mimvista.internals.volumes.ImageVolumeFloat;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.Session;
import com.mimvista.mui.overlays.DeformableRatingOverlay;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.qa.model.g;
import com.mimvista.numerics.ArrayListImageCubeFloat;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.MultipliedIndexPoint3i;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.Point3i;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.numerics.VoxelIndexPoint3i;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.aa;
import com.mimvista.numerics.contourtools.b;
import com.mimvista.numerics.contourtools.c;
import com.mimvista.numerics.contourtools.n;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.numerics.p;
import com.mimvista.preferencesNew.ContourPrefs;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.bg;
import com.mimvista.util.ck;
import com.mimvista.util.cn;
import com.mimvista.util.extents.VolumeExtent;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.progress.u;
import com.mimvista.util.work.m;
import com.mimvista.viewer.Interpolator;
import com.mimvista.viewer.SeriesInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class WarpTransform
extends PositionTransform {
    private static final long serialVersionUID = 1L;
    protected DicomPoint3f derivedDicomCenter;
    protected transient s a;
    protected SimpleImageVolume<ImageCube.ImageCubeFloat> xVol;
    protected SimpleImageVolume<ImageCube.ImageCubeFloat> yVol;
    protected SimpleImageVolume<ImageCube.ImageCubeFloat> zVol;
    protected Point3f.PointVolumeInfo warpPvi;
    protected Point3f.PointVolumeInfo originalPrimaryPvi;
    private VolumeExtent extent;
    protected Contour deformationMask = null;
    private boolean forceSmoothAfterWarp = false;
    private float smoothStrength = 0.0f;
    private float trilinearContourThreshold = 0.5f;
    private float fillHoleVolumeThreshold = 0.01f;
    private InverseWarpTransform trueBrother;
    private Matrix4f initialRigidAlignment;
    private Matrix4f currentRigidAlignment;
    private final long creationTime;
    private DeformableQA qa;
    public DcmDeformableRegWriter.DeformableSaveInformation deformableSaveInfo = null;
    private ImageFrame origFirst = null;
    private ImageFrame origSecond = null;
    private DcmDeformableRegWriter.DeformableSaveHelper originalVolumeInfo = null;
    private boolean legacyCantCreateDeformableSaveHelper = false;
    private WarpKey warpKey = new WarpKey(this);
    private WarpKey parentWarpKey = null;
    private g.a warpDisplayInfo;
    private IntensityWarpSettings warpSettings = null;

    public WarpTransform(ImageFrame imageFrame, ImageFrame imageFrame2, Matrix4f matrix4f) {
        super(imageFrame, imageFrame2);
        this.origFirst = imageFrame;
        this.origSecond = imageFrame2;
        this.originalPrimaryPvi = new Point3f.PointVolumeInfo(imageFrame);
        this.qa = new DeformableQA(imageFrame.I(), imageFrame2.I());
        this.initialRigidAlignment = matrix4f;
        this.currentRigidAlignment = matrix4f;
        this.creationTime = System.currentTimeMillis();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.originalVolumeInfo == null && !this.legacyCantCreateDeformableSaveHelper) {
            ImageFrame imageFrame = null;
            try {
                imageFrame = this.x();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (imageFrame == null) {
                SeriesInfo seriesInfo = this.qa.b();
                SeriesInfo seriesInfo2 = this.qa.a();
                if (seriesInfo != null) {
                    this.originalVolumeInfo = new DcmDeformableRegWriter.DeformableSaveHelper(seriesInfo, seriesInfo2);
                }
            } else {
                this.legacyCantCreateDeformableSaveHelper = true;
            }
        }
    }

    public void a(DeformableQA deformableQA) {
        this.qa = deformableQA;
    }

    public DeformableQA c() {
        return this.qa;
    }

    public long d() {
        return this.creationTime;
    }

    public InverseWarpTransform f() {
        return this.trueBrother;
    }

    public void a(InverseWarpTransform inverseWarpTransform) {
        this.trueBrother = inverseWarpTransform;
    }

    public WarpKey i() {
        return this.warpKey;
    }

    @Override
    public List<WarpKey> n() {
        return Lists.newArrayList((Object[])new WarpKey[]{this.warpKey});
    }

    public void a(WarpKey warpKey) {
        this.warpKey = warpKey;
    }

    public WarpKey k() {
        return this.parentWarpKey;
    }

    public void b(WarpKey warpKey) {
        this.parentWarpKey = warpKey;
    }

    @Override
    public boolean g() {
        return true;
    }

    public Point3f.PointVolumeInfo l() {
        return this.originalPrimaryPvi;
    }

    public void b(float f2) {
        this.forceSmoothAfterWarp = true;
        this.smoothStrength = f2;
    }

    public void c(float f2) {
        this.trilinearContourThreshold = f2;
    }

    @Override
    public MetricPoint3f a(MetricPoint3f metricPoint3f) {
        MetricPoint3f metricPoint3f2 = new MetricPoint3f(this.a());
        this.a(metricPoint3f, metricPoint3f2);
        return metricPoint3f2;
    }

    @Override
    public void a(MetricPoint3f metricPoint3f, MetricPoint3f metricPoint3f2) {
        this.as_().a(metricPoint3f, metricPoint3f2);
    }

    private ViewController e(ImageFrame imageFrame) {
        return imageFrame.j();
    }

    public boolean m() {
        List<TransformEdge> list = this.e(this.b()).g().q().a(this);
        if (list != null) {
            for (TransformEdge transformEdge : list) {
                if (transformEdge.a().type != TransformEdge.TransformEdgeType.g) continue;
                return true;
            }
        }
        return false;
    }

    public ImageFrame x() {
        try {
            Collection<TransformEdge> collection = this.e(this.b()).g().q().b(this.b());
            for (TransformEdge transformEdge : collection) {
                if (transformEdge.a().type != TransformEdge.TransformEdgeType.f && transformEdge.a().type != TransformEdge.TransformEdgeType.h) continue;
                return transformEdge.d.d();
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error finding primary of deformation", throwable, this);
        }
        return this.b();
    }

    public synchronized void a(s s2) {
        if (this.a != s2) {
            this.a = s2;
            this.Q();
            this.qa.a((ImageVolumeByte)null);
            this.xVol = new SimpleImageVolume<ImageCube.ImageCubeFloat>(s2.a());
            this.xVol.a(s2.e());
            this.yVol = new SimpleImageVolume<ImageCube.ImageCubeFloat>(s2.b());
            this.yVol.a(s2.e());
            this.zVol = new SimpleImageVolume<ImageCube.ImageCubeFloat>(s2.c());
            this.zVol.a(s2.e());
        }
    }

    private void Q() {
        if (this.a != null) {
            float[] fArray;
            float[] fArray2;
            Object object;
            float[] fArray3 = (float[])this.a.e().clone();
            if (this.extent != null) {
                object = this.extent.a(this.b());
                fArray2 = ((VoxelIndexPoint3f)((Object)object)).d().d().f();
                fArray = MathUtils.f(MathUtils.a(this.extent.k(), 2.0f), this.b().b());
            } else {
                fArray2 = (float[])this.b().G().clone();
                fArray = (float[])this.b().J().clone();
            }
            object = this.b().getUncopiedMutableInfo();
            this.warpPvi = new Point3f.PointVolumeInfo(fArray2, ((SeriesInfo)object).H(), (float[])((SeriesInfo)object).imageOrientation.clone(), fArray3, fArray);
        } else {
            this.warpPvi = null;
        }
    }

    public s y() {
        return this.a;
    }

    public synchronized ImageVolumeByte z() {
        ImageVolumeByte imageVolumeByte = this.qa.g();
        if (imageVolumeByte == null) {
            imageVolumeByte = new ImageVolumeByte();
            imageVolumeByte.b(SeriesInfo.a(this.b().getUncopiedMutableInfo()));
            imageVolumeByte.b(this.I().f());
            imageVolumeByte.a(this.a.e());
            imageVolumeByte.a(ImageCube.ImageCubeByte.b(this.a.a(0).d()));
            this.qa.a(imageVolumeByte);
            this.A();
        }
        return imageVolumeByte;
    }

    public synchronized DeformableRatingOverlay A() {
        OverlayCollection overlayCollection = this.b().n();
        List<DeformableRatingOverlay> list = overlayCollection.a(DeformableRatingOverlay.class, false, false);
        for (DeformableRatingOverlay deformableRatingOverlay : list) {
            if (deformableRatingOverlay.a() != this) continue;
            return deformableRatingOverlay;
        }
        if (this.e(this.b()) != null && this.e(this.b()).bu()) {
            DeformableRatingOverlay deformableRatingOverlay = new DeformableRatingOverlay(this.e(this.b()), this);
            overlayCollection.a((Overlayish)deformableRatingOverlay, false);
            return deformableRatingOverlay;
        }
        return null;
    }

    public VolumeExtent B() {
        return this.extent;
    }

    public VolumeExtent C() {
        Point3f.PointVolumeInfo pointVolumeInfo = this.l();
        VoxelPoint3f voxelPoint3f = new VoxelPoint3f(this.warpPvi);
        VoxelPoint3f voxelPoint3f2 = voxelPoint3f.b().d().b(pointVolumeInfo).b();
        VoxelIndexPoint3i voxelIndexPoint3i = new VoxelIndexPoint3i(pointVolumeInfo);
        voxelIndexPoint3i.x = Math.round(voxelPoint3f2.x);
        voxelIndexPoint3i.y = Math.round(voxelPoint3f2.y);
        voxelIndexPoint3i.z = Math.round(voxelPoint3f2.z);
        int[] nArray = this.a.d();
        VoxelPoint3f voxelPoint3f3 = new VoxelPoint3f((float)nArray[0], (float)nArray[1], (float)nArray[2], this.warpPvi);
        VoxelPoint3f voxelPoint3f4 = voxelPoint3f3.b().d().b(pointVolumeInfo).b();
        VoxelIndexPoint3i voxelIndexPoint3i2 = new VoxelIndexPoint3i(pointVolumeInfo);
        voxelIndexPoint3i2.x = Math.round(voxelPoint3f4.x);
        voxelIndexPoint3i2.y = Math.round(voxelPoint3f4.y);
        voxelIndexPoint3i2.z = Math.round(voxelPoint3f4.z);
        return new VolumeExtent(new int[][]{voxelIndexPoint3i.f(), voxelIndexPoint3i2.f()}, 0);
    }

    public Matrix4f D() {
        return this.initialRigidAlignment;
    }

    public Matrix4f E() {
        return this.currentRigidAlignment;
    }

    public Contour F() {
        if (this.deformationMask != null) {
            this.deformationMask.a(this.b());
        }
        return this.deformationMask;
    }

    public Contour G() {
        Contour contour = this.F();
        if (contour != null) {
            Contour contour2 = new Contour(contour);
            VolumeExtent volumeExtent = this.B();
            if (volumeExtent != null) {
                p.a(contour2, MathUtils.b(volumeExtent.o()[0]), volumeExtent.k());
            }
            return contour2;
        }
        return null;
    }

    public void d(Contour contour) {
        this.deformationMask = contour;
    }

    @Override
    public Contour b(Contour contour, Interpolator.InterpolationType interpolationType, Predicate<?> predicate, Progress progress) {
        if (contour.a != null && contour.Q()) {
            String string = "The contour doesn't have any data.\nPlease change your parameters and try again.";
            System.err.println(string);
            return new Contour(this.b());
        }
        ArrayList<Contour> arrayList = new ArrayList<Contour>(1);
        arrayList.add(contour);
        List<Contour> list = this.b(arrayList, interpolationType, predicate, progress);
        return list.get(0);
    }

    @Override
    public List<Contour> b(List<Contour> list, Interpolator.InterpolationType interpolationType, Predicate<?> predicate, Progress progress) {
        List<Contour> list2;
        long l2 = System.currentTimeMillis();
        ay.b((Object)"Starting bulk contour transfer through reverse warp...", this);
        int[] nArray = this.b().C();
        com.mimvista.intensitybasedwarp.n n2 = new com.mimvista.intensitybasedwarp.n(this, nArray);
        ArrayList<o> arrayList = new ArrayList<o>(list.size());
        for (Contour iterable2 : list) {
            if (!iterable2.a().equals(this.a())) {
                ay.e("The contour is not on the source volume of warping field.\nPlease change your parameters and try again.");
                arrayList.add(null);
                continue;
            }
            if (iterable2.Q()) {
                ay.e("Error: trying to warp an empty contour.");
            }
            list2 = new o(iterable2, this, this.b(), n2);
            arrayList.add((o)((Object)list2));
        }
        this.a(n2, arrayList, progress, predicate);
        if (predicate.apply(null)) {
            return null;
        }
        int n3 = this.extent.k()[2] * this.b().C()[2];
        ArrayList<o> arrayList2 = new ArrayList<o>();
        for (o o2 : arrayList) {
            if (o2 != null && o2.e()) {
                o2.f();
                arrayList2.add(o2);
                continue;
            }
            progress.c(n3);
        }
        if (arrayList2.size() > 0) {
            this.a(n2, arrayList2, progress, predicate);
        }
        if (predicate.apply(null)) {
            return null;
        }
        ay.b((Object)("Transferred contours through reverse warp in: " + (System.currentTimeMillis() - l2) + "ms.  Now beginning smooth & fill stage..."), this);
        l2 = System.currentTimeMillis();
        list2 = this.a((Collection<? extends e>)arrayList, predicate, progress);
        ay.b((Object)("Smoothed and filled in: " + (System.currentTimeMillis() - l2) + "ms."), this);
        return list2;
    }

    public Contour a(Contour contour, Interpolator.InterpolationType interpolationType, Predicate predicate, Progress progress) {
        if (contour.a != null && contour.Q()) {
            String string = "The contour doesn't have any data.\nPlease change your parameters and try again.";
            System.err.println(string);
            return new Contour(this.a());
        }
        ArrayList<Contour> arrayList = new ArrayList<Contour>(1);
        arrayList.add(contour);
        List<Contour> list = this.a(arrayList, interpolationType, predicate, progress);
        return list.get(0);
    }

    @Override
    public List<Contour> a(List<Contour> list, Interpolator.InterpolationType interpolationType, Predicate<?> predicate, Progress progress) {
        Object object;
        long l2 = System.currentTimeMillis();
        ay.b((Object)"Starting bulk contour transfer through forward warp...", this);
        HashMultimap hashMultimap = HashMultimap.create();
        for (Contour iterable2 : list) {
            if (!iterable2.a().equals(this.b())) {
                object = "The contour is not on the target volume of warping field.\nPlease change your parameters and try again.";
                ay.e(object);
                continue;
            }
            if (iterable2.Q()) {
                ay.e("Error: trying to warp an empty contour.");
                continue;
            }
            hashMultimap.put((Object)new Point3i(iterable2.v()), (Object)iterable2);
        }
        HashMap hashMap = Maps.newHashMap();
        Set set = hashMultimap.asMap().entrySet();
        for (Map.Entry entry : set) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            Object object2 = ((Point3i)((Object)entry.getKey())).f();
            boolean bl2 = ContourPrefs.inverseWarpSubsampleContours.getValue();
            f f2 = bl2 ? new h(this, (int[])object2) : new g(this, (int[])object2);
            ArrayList arrayList = Lists.newArrayList();
            for (Contour contour : (Collection)entry.getValue()) {
                com.mimvista.intensitybasedwarp.i i2 = new com.mimvista.intensitybasedwarp.i(contour, this.a(), f2.f(), this.trilinearContourThreshold);
                arrayList.add(i2);
                hashMap.put(contour, i2);
            }
            this.a(f2, arrayList, progress, predicate);
        }
        if (predicate.apply(null)) {
            return null;
        }
        ay.b((Object)("Transferred contours through warp in: " + (System.currentTimeMillis() - l2) + "ms.  Now beginning smooth & fill stage..."), this);
        l2 = System.currentTimeMillis();
        object = Lists.newArrayList();
        for (Object object2 : list) {
            object.add(hashMap.get(object2));
        }
        List<Contour> list2 = this.a((Collection<? extends e>)object, predicate, progress);
        ay.b((Object)("Smoothed and filled in: " + (System.currentTimeMillis() - l2) + "ms."), this);
        return list2;
    }

    private List<Contour> a(Collection<? extends e> collection, Predicate<?> predicate, Progress progress) {
        boolean bl2 = ContourPrefs.smoothAfterWarp.getValue() != false || this.forceSmoothAfterWarp;
        ArrayList<Contour> arrayList = new ArrayList<Contour>(collection.size());
        long l2 = Thread.currentThread().getId();
        String string = "FillHoles" + l2;
        String string2 = "Smooth" + l2;
        for (e e2 : collection) {
            if (e2 == null) {
                arrayList.add(null);
                continue;
            }
            Contour contour = e2.a();
            if (predicate.apply(null)) {
                return null;
            }
            if (bl2 && !contour.Q()) {
                bg.a(string2, 3800L, false);
                n n2 = new n(contour);
                if (this.forceSmoothAfterWarp) {
                    n2.a(this.smoothStrength);
                } else if (this.e(this.b()) != null && this.e(this.b()).bm() || this.e(this.a()) != null && this.e(this.a()).bm()) {
                    n2.a(0.1f);
                }
                n2.a();
                bg.e(string2);
            }
            bg.a(string, 3800L, false);
            this.a(contour, e2.b());
            bg.e(string);
            progress.c(40);
            arrayList.add(contour);
        }
        return arrayList;
    }

    private void a(Contour contour, Contour contour2) {
        try {
            c c2 = new c(contour2);
            if (!c2.a(this.fillHoleVolumeThreshold)) {
                c2 = new c(contour);
                c2.d();
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error in filling warped contour", throwable, this);
        }
    }

    private <T extends e> void a(final com.mimvista.intensitybasedwarp.d<T> d2, final Collection<T> collection, Progress progress, final Predicate<?> predicate) {
        Object object2;
        int n2 = 0;
        HashMultimap hashMultimap = HashMultimap.create();
        int[] nArray = d2.b();
        MultipliedIndexPoint3i multipliedIndexPoint3i = d2.c();
        MultipliedIndexPoint3i multipliedIndexPoint3i2 = d2.d();
        Contour contour = new Contour(this.b());
        contour.d(nArray);
        b b2 = new b(contour, multipliedIndexPoint3i.x, multipliedIndexPoint3i.y, multipliedIndexPoint3i.z, multipliedIndexPoint3i2.x, multipliedIndexPoint3i2.y, multipliedIndexPoint3i2.z);
        for (e e2 : collection) {
            if (e2 == null) continue;
            ++n2;
            object2 = e2.c();
            for (Map.Entry object3 : object2.entrySet()) {
                b b3;
                b b4 = (b)object3.getValue();
                if (d2.a()) {
                    b b5 = b4.a(1, 1, 0);
                }
                if ((b3 = b2.b((b)object3.getValue())).c()) continue;
                hashMultimap.put(object3.getKey(), (Object)b3);
            }
        }
        int n3 = hashMultimap.keySet().size();
        if (n2 == 0 || n3 == 0) {
            return;
        }
        final boolean bl2 = d2.a();
        object2 = Lists.newArrayListWithCapacity((int)n3);
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)n3);
        for (Map.Entry entry : hashMultimap.asMap().entrySet()) {
            object2.add(entry.getKey());
            arrayList.add(((Collection)entry.getValue()).size());
        }
        ck.a(arrayList, object2);
        Collections.reverse(object2);
        final float[] fArray = new float[]{(float)(this.extent.h() * nArray[0]) / (float)this.a.d()[0], (float)(this.extent.i() * nArray[1]) / (float)this.a.d()[1], (float)(this.extent.j() * nArray[2]) / (float)this.a.d()[2]};
        int n4 = object2.size();
        final ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue(object2);
        int n5 = this.extent.k()[2] * this.b().C()[2];
        u u2 = new u(progress, n2 * n5);
        u2.a(n2 * n4);
        FuncUtils.e e2 = new FuncUtils.e((Multimap)hashMultimap, u2){
            final /* synthetic */ Multimap g;
            final /* synthetic */ u h;
            {
                this.g = multimap;
                this.h = u2;
            }

            @Override
            public void f(int n2, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                a a2 = new a(WarpTransform.this.a, bl2, fArray, collection, d2);
                Integer n5 = null;
                while ((n5 = (Integer)concurrentLinkedQueue.poll()) != null) {
                    if (predicate.apply(null)) {
                        return;
                    }
                    a2.a(n5, this.g.get((Object)n5), this.h);
                }
                a2.a();
            }
        };
        FuncUtils.a((ThreadPoolExecutor)m.c, n4, e2, "Deformable Contour Transform");
    }

    @Override
    public int a(Contour contour) {
        return this.extent.k()[2] * contour.b(2) + 40;
    }

    public int e(Contour contour) {
        int[] nArray = this.extent.k();
        int[] nArray2 = this.b().C();
        return 2 * nArray[2] * nArray2[2] + 40;
    }

    public ImageCube.ImageCubeShort a(ImageVolumeShort imageVolumeShort) {
        return this.a(imageVolumeShort, 1);
    }

    public ImageCube.ImageCubeShort a(ImageVolumeShort imageVolumeShort, int n2) {
        ProgressPanel progressPanel = new ProgressPanel();
        ProgressQueueNotification.a(progressPanel);
        progressPanel.a(false);
        progressPanel.a(Messages.a("Internals", "WARPTRANSFORM_REGISTER"));
        progressPanel.b_("");
        int[] nArray = MathUtils.b(this.extent.k(), n2);
        t t2 = new t(this.a, nArray);
        progressPanel.a(nArray[2]);
        progressPanel.a();
        ImageCube.ImageCubeShort imageCubeShort = t2.a((ImageCube.ImageCubeShort)imageVolumeShort.ad(), (Progress)progressPanel, Float.valueOf(imageVolumeShort.ah()));
        progressPanel.b();
        return imageCubeShort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WarpTransform a(final PositionTransform positionTransform, ImageFrame imageFrame) {
        final ProgressPanel progressPanel = new ProgressPanel();
        ProgressQueueNotification.a(progressPanel);
        progressPanel.a(true);
        progressPanel.a(Messages.a("Internals", "WARPTRANSFORM_COREGISTER"));
        progressPanel.b_("");
        progressPanel.a();
        try {
            Object object;
            Object object2;
            if (!this.a().equals(positionTransform.b())) {
                String string = "The primary volume of the affine transform should be the secondary volume of this warp transform.\nPlease check your parameter(s) and try again later.";
                ay.d((Object)string, this);
                WarpTransform warpTransform = null;
                return warpTransform;
            }
            final int[] nArray = (int[])this.a.d().clone();
            final ImageCube.ImageCubeFloat[] imageCubeFloatArray = new ImageCube.ImageCubeFloat[3];
            for (int i2 = 0; i2 < imageCubeFloatArray.length; ++i2) {
                imageCubeFloatArray[i2] = ArrayListImageCubeFloat.b(nArray);
            }
            final ImageCube.ImageCubeFloat imageCubeFloat = this.a.a();
            final ImageCube.ImageCubeFloat imageCubeFloat2 = this.a.b();
            final ImageCube.ImageCubeFloat imageCubeFloat3 = this.a.c();
            progressPanel.a(nArray[2]);
            progressPanel.a(false);
            FuncUtils.a((ThreadPoolExecutor)m.c, nArray[2], new FuncUtils.e(){

                @Override
                public void f(int n2, int n3, int n4) {
                    VoxelIndexPoint3f voxelIndexPoint3f = new VoxelIndexPoint3f(positionTransform.b());
                    VoxelPoint3f voxelPoint3f = new VoxelPoint3f(positionTransform.a());
                    MetricPoint3f metricPoint3f = new MetricPoint3f(positionTransform.b());
                    MetricPoint3f metricPoint3f2 = new MetricPoint3f(positionTransform.a());
                    for (int i2 = n2; i2 < n3; ++i2) {
                        for (int i3 = 0; i3 < nArray[1]; ++i3) {
                            for (int i4 = 0; i4 < nArray[0]; ++i4) {
                                float f2 = imageCubeFloat.a_(i4, i3, i2);
                                float f3 = imageCubeFloat2.a_(i4, i3, i2);
                                float f4 = imageCubeFloat3.a_(i4, i3, i2);
                                voxelIndexPoint3f.set(f2, f3, f4);
                                voxelIndexPoint3f.j().b(metricPoint3f);
                                positionTransform.a(metricPoint3f, metricPoint3f2);
                                metricPoint3f2.a(voxelPoint3f);
                                VoxelIndexPoint3f voxelIndexPoint3f2 = voxelPoint3f.c();
                                imageCubeFloatArray[0].a(i4, i3, i2, voxelIndexPoint3f2.x);
                                imageCubeFloatArray[1].a(i4, i3, i2, voxelIndexPoint3f2.y);
                                imageCubeFloatArray[2].a(i4, i3, i2, voxelIndexPoint3f2.z);
                            }
                        }
                        progressPanel.N_();
                    }
                }
            }, "Co-Reg Warp Gen");
            s s2 = new s(imageCubeFloatArray[0], imageCubeFloatArray[1], imageCubeFloatArray[2], this.a.e());
            Matrix4f matrix4f = null;
            if (this.initialRigidAlignment != null && positionTransform instanceof AffineTransform) {
                object2 = ((AffineTransform)positionTransform).d();
                matrix4f = new Matrix4f();
                matrix4f.setIdentity();
                matrix4f.mul(this.initialRigidAlignment, matrix4f);
                matrix4f.mul((Matrix4f)object2, matrix4f);
            }
            object2 = new WarpTransform(this.b(), imageFrame, matrix4f);
            ((WarpTransform)object2).a(this.B());
            ((WarpTransform)object2).a(s2);
            ((WarpTransform)object2).d(this.F());
            if (this.currentRigidAlignment != null && positionTransform instanceof AffineTransform) {
                object = ((AffineTransform)positionTransform).d();
                Matrix4f matrix4f2 = new Matrix4f();
                matrix4f2.setIdentity();
                matrix4f2.mul(this.currentRigidAlignment, matrix4f2);
                matrix4f2.mul(object, matrix4f2);
                ((WarpTransform)object2).currentRigidAlignment = matrix4f2;
            }
            ((WarpTransform)object2).d(this.origFirst);
            ((WarpTransform)object2).qa.a(this.qa.a());
            ((WarpTransform)object2).b(this.warpKey);
            object = object2;
            return object;
        }
        finally {
            progressPanel.b();
        }
    }

    public void a(VolumeExtent volumeExtent) {
        this.extent = volumeExtent;
        this.Q();
    }

    @Override
    public void a(ImageFrame imageFrame) {
        ImageFrame imageFrame2 = this.b();
        if (imageFrame == imageFrame2) {
            return;
        }
        super.a(imageFrame);
        Matrix4f matrix4f = this.E();
        if (imageFrame != null && imageFrame2 != null && matrix4f != null) {
            Matrix4f matrix4f2 = i.a((SimpleImageFrame)imageFrame, (SimpleImageFrame)imageFrame2);
            if (matrix4f2 != null) {
                matrix4f2.mul(matrix4f, matrix4f2);
                this.currentRigidAlignment = matrix4f2;
            } else {
                this.currentRigidAlignment = null;
            }
        } else {
            this.currentRigidAlignment = null;
        }
        if (imageFrame != null && this.a != null) {
            this.deformationMask = this.G();
            this.extent = new VolumeExtent(imageFrame);
            this.Q();
        }
    }

    public void c(ImageFrame imageFrame) {
        super.a(imageFrame);
    }

    public void H() {
        this.a(this.extent.a(this.b()).d().d());
    }

    public void a(DicomPoint3f dicomPoint3f) {
        this.derivedDicomCenter = (DicomPoint3f)((Object)dicomPoint3f.clone());
        this.Q();
    }

    public DicomPoint3f I() {
        if (this.derivedDicomCenter == null) {
            this.derivedDicomCenter = this.B().a(this.b()).d().d();
        }
        return (DicomPoint3f)((Object)this.derivedDicomCenter.clone());
    }

    public Point3f.PointVolumeInfo J() {
        return this.warpPvi;
    }

    public List<ImageVolumeFloat> K() {
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < 3; ++i2) {
            arrayList.add(i2, this.a(this.a.a(i2)));
        }
        return arrayList;
    }

    public ImageVolumeFloat a(ImageCube.ImageCubeFloat imageCubeFloat) {
        ImageVolumeFloat imageVolumeFloat = new ImageVolumeFloat();
        imageVolumeFloat.b(SeriesInfo.a(this.b().getUncopiedMutableInfo()));
        imageVolumeFloat.a(imageCubeFloat);
        imageVolumeFloat.b(this.I().f());
        imageVolumeFloat.a(this.a.e());
        return imageVolumeFloat;
    }

    public ImageVolumeShort b(ImageCube.ImageCubeFloat imageCubeFloat) {
        ImageVolumeShort imageVolumeShort = new ImageVolumeShort();
        imageVolumeShort.b(SeriesInfo.a(this.b().getUncopiedMutableInfo()));
        Pair<RescaleConverter, ImageCube.ImageCubeShort> pair = aa.b(imageCubeFloat);
        imageVolumeShort.getUncopiedMutableInfo().rescale = (RescaleConverter)pair.x;
        imageVolumeShort.a((ImageCube)pair.y);
        imageVolumeShort.b(this.I().f());
        imageVolumeShort.a(this.a.e());
        imageVolumeShort.getUncopiedMutableInfo().u().a("");
        return imageVolumeShort;
    }

    VoxelIndexPoint3f L() {
        int[] nArray = this.a.d();
        float f2 = (float)nArray[0] / 2.0f;
        float f3 = (float)nArray[1] / 2.0f;
        float f4 = (float)nArray[2] / 2.0f;
        float f5 = this.xVol.a(f2, f3, f4);
        float f6 = this.yVol.a(f2, f3, f4);
        float f7 = this.zVol.a(f2, f3, f4);
        return new VoxelIndexPoint3f(f5, f6, f7, this.a());
    }

    public IsodoseOverlay a(IsodoseOverlay isodoseOverlay, Predicate predicate, Progress progress) {
        i.a();
        return null;
    }

    public InverseWarpTransform M() {
        return new InverseWarpTransform(this);
    }

    @Override
    public d as_() {
        final ImageFrame imageFrame = this.b();
        final ImageFrame imageFrame2 = this.a();
        final Point3f.PointVolumeInfo pointVolumeInfo = new Point3f.PointVolumeInfo(this.b());
        Point3f.PointVolumeInfo pointVolumeInfo2 = new Point3f.PointVolumeInfo(imageFrame2);
        final DicomPoint3f dicomPoint3f = new DicomPoint3f(pointVolumeInfo);
        final VoxelPoint3f voxelPoint3f = new VoxelPoint3f(this.warpPvi);
        final MetricPoint3f metricPoint3f = new MetricPoint3f(this.warpPvi);
        final VoxelIndexPoint3f voxelIndexPoint3f = new VoxelIndexPoint3f(pointVolumeInfo2);
        final VoxelPoint3f voxelPoint3f2 = new VoxelPoint3f(this.warpPvi);
        final MetricPoint3f metricPoint3f2 = new MetricPoint3f(this.warpPvi);
        final DicomPoint3f dicomPoint3f2 = new DicomPoint3f(this.warpPvi);
        final MetricPoint3f metricPoint3f3 = new MetricPoint3f(pointVolumeInfo);
        final VoxelPoint3f voxelPoint3f3 = new VoxelPoint3f(this.warpPvi);
        final MetricPoint3f metricPoint3f4 = new MetricPoint3f(this.warpPvi);
        final DicomPoint3f dicomPoint3f3 = new DicomPoint3f(this.warpPvi);
        final MetricPoint3f metricPoint3f5 = new MetricPoint3f(pointVolumeInfo);
        final MetricPoint3f metricPoint3f6 = new MetricPoint3f(pointVolumeInfo2);
        final MetricPoint3f metricPoint3f7 = new MetricPoint3f(pointVolumeInfo2);
        final MetricPoint3f metricPoint3f8 = new MetricPoint3f(pointVolumeInfo2);
        final Vector3f vector3f = new Vector3f();
        final Vector3f vector3f2 = new Vector3f();
        final Vector3f vector3f3 = new Vector3f();
        return new d(){

            @Override
            public void a(MetricPoint3f metricPoint3f9, MetricPoint3f metricPoint3f22) {
                metricPoint3f9.a(dicomPoint3f);
                dicomPoint3f.a(metricPoint3f, WarpTransform.this.warpPvi);
                metricPoint3f.a(voxelPoint3f);
                voxelIndexPoint3f.x = WarpTransform.this.xVol.a(voxelPoint3f.x, voxelPoint3f.y, voxelPoint3f.z);
                voxelIndexPoint3f.y = WarpTransform.this.yVol.a(voxelPoint3f.x, voxelPoint3f.y, voxelPoint3f.z);
                voxelIndexPoint3f.z = WarpTransform.this.zVol.a(voxelPoint3f.x, voxelPoint3f.y, voxelPoint3f.z);
                voxelIndexPoint3f.a(metricPoint3f22);
                int[] nArray = WarpTransform.this.a.d();
                if (voxelPoint3f.x < 0.5f || voxelPoint3f.x > (float)nArray[0] - 0.5f || voxelPoint3f.y < 0.5f || voxelPoint3f.y > (float)nArray[1] - 0.5f || voxelPoint3f.z < 0.5f || voxelPoint3f.z > (float)nArray[2] - 0.5f) {
                    int n2;
                    float f2 = voxelPoint3f.x > (float)nArray[0] - 0.5f ? (float)nArray[0] - 0.5f : (voxelPoint3f2.x = voxelPoint3f.x < 0.5f ? 0.5f : voxelPoint3f.x);
                    float f3 = voxelPoint3f.y > (float)nArray[1] - 0.5f ? (float)nArray[1] - 0.5f : (voxelPoint3f2.y = voxelPoint3f.y < 0.5f ? 0.5f : voxelPoint3f.y);
                    voxelPoint3f2.z = voxelPoint3f.z > (float)nArray[2] - 0.5f ? (float)nArray[2] - 0.5f : (voxelPoint3f.z < 0.5f ? 0.5f : voxelPoint3f.z);
                    voxelPoint3f2.b(metricPoint3f2);
                    metricPoint3f2.a(dicomPoint3f2);
                    dicomPoint3f2.a(metricPoint3f3, pointVolumeInfo);
                    vector3f.sub((Tuple3f)voxelPoint3f2, (Tuple3f)voxelPoint3f);
                    vector3f.normalize();
                    voxelPoint3f3.set((Tuple3f)voxelPoint3f2);
                    for (n2 = 0; n2 < 4; ++n2) {
                        voxelPoint3f3.add((Tuple3f)vector3f);
                        voxelPoint3f3.b(metricPoint3f4);
                        metricPoint3f4.a(dicomPoint3f3);
                        dicomPoint3f3.a(metricPoint3f5, pointVolumeInfo);
                        voxelIndexPoint3f.x = WarpTransform.this.xVol.a(voxelPoint3f3.x, voxelPoint3f3.y, voxelPoint3f3.z);
                        voxelIndexPoint3f.y = WarpTransform.this.yVol.a(voxelPoint3f3.x, voxelPoint3f3.y, voxelPoint3f3.z);
                        voxelIndexPoint3f.z = WarpTransform.this.zVol.a(voxelPoint3f3.x, voxelPoint3f3.y, voxelPoint3f3.z);
                        voxelIndexPoint3f.a(metricPoint3f6);
                        vector3f2.sub((Tuple3f)metricPoint3f22, (Tuple3f)metricPoint3f6);
                        if (vector3f2.length() > 0.001f) break;
                    }
                    n2 = 0;
                    if (WarpTransform.this.currentRigidAlignment != null) {
                        WarpTransform.this.currentRigidAlignment.transform((Point3f)metricPoint3f3, (Point3f)metricPoint3f8);
                        WarpTransform.this.currentRigidAlignment.transform((Point3f)metricPoint3f5, (Point3f)metricPoint3f7);
                        vector3f3.sub((Tuple3f)metricPoint3f8, (Tuple3f)metricPoint3f7);
                        double d2 = vector3f3.angle(vector3f2);
                        n2 = d2 < Math.toRadians(60.0) ? 1 : 0;
                    }
                    float f4 = vector3f2.length();
                    if (n2 != 0 && f4 != 0.0f) {
                        vector3f2.normalize();
                        vector3f2.scale(metricPoint3f2.distance(metricPoint3f));
                    } else if (WarpTransform.this.currentRigidAlignment != null) {
                        vector3f2.set((Tuple3f)vector3f3);
                        vector3f2.normalize();
                        vector3f2.scale(metricPoint3f2.distance(metricPoint3f));
                    } else {
                        vector3f2.sub((Tuple3f)metricPoint3f, (Tuple3f)metricPoint3f2);
                    }
                    metricPoint3f22.add((Tuple3f)vector3f2);
                }
            }

            @Override
            public ImageFrame b() {
                return imageFrame;
            }

            @Override
            public ImageFrame a() {
                return imageFrame2;
            }
        };
    }

    public g.a N() {
        return this.warpDisplayInfo;
    }

    public g.a a(Session session) {
        TransformEdge transformEdge = this.b(session);
        if (this.warpDisplayInfo == null && transformEdge != null) {
            TransformEdge.TransformEdgeInfo transformEdgeInfo = transformEdge.a();
            String string = transformEdgeInfo.iconName;
            if (cn.h(string)) {
                string = "general_registration";
            }
            String string2 = transformEdgeInfo.b();
            this.warpDisplayInfo = new g.a(string2, string, null);
        }
        return this.warpDisplayInfo;
    }

    private String b(boolean bl2, boolean bl3) {
        if (bl3) {
            return "create_aligned_secondary";
        }
        if (bl2) {
            return "general_coregistration";
        }
        return "general_registration";
    }

    private String c(boolean bl2, boolean bl3) {
        Messages messages = Messages.a("Modes");
        String string = bl3 ? messages.getProperty("MULTIALIGN_CONVERT_ALIGNMENTS") : (bl2 ? messages.b("MULTIALIGN_NORMALIZED_DEFORM") : messages.b("MULTIALIGN_DEFORM"));
        return string;
    }

    public void a(boolean bl2, boolean bl3) {
        String string = this.c(bl2, bl3);
        String string2 = this.b(bl2, bl3);
        this.warpDisplayInfo = new g.a(string, string2, null);
    }

    public void a(String string, String string2, @com.mimvista.d String string3) {
        this.a(string, string3);
        this.warpDisplayInfo.a(string2);
    }

    public void a(String string, String string2) {
        if (cn.h(string)) {
            return;
        }
        Messages messages = Messages.a("Modes");
        string = string.trim();
        if (messages.b("MULTIALIGN_NORMALIZED_DEFORM").trim().equalsIgnoreCase(string)) {
            this.a(true, false);
        } else if (messages.b("MULTIALIGN_CONVERT_ALIGNMENTS").trim().equalsIgnoreCase(string)) {
            this.a(false, true);
        } else if (messages.b("MULTIALIGN_DEFORM").trim().equalsIgnoreCase(string)) {
            this.a(false, false);
        } else {
            this.warpDisplayInfo = new g.a(string, cn.h(string2) ? "general_registration" : string2, null);
        }
    }

    private TransformEdge b(Session session) {
        return session.q().b(this.b(), this.a());
    }

    public void d(ImageFrame imageFrame) {
        this.origFirst = imageFrame;
    }

    public DcmDeformableRegWriter.DeformableSaveHelper O() {
        if (this.originalVolumeInfo != null) {
            return this.originalVolumeInfo;
        }
        return new DcmDeformableRegWriter.DeformableSaveHelper(this.origFirst, this.origSecond);
    }

    public IntensityWarpSettings P() {
        if (this.warpSettings != null) {
            return this.warpSettings.clone();
        }
        return null;
    }

    public void a(IntensityWarpSettings intensityWarpSettings) {
        this.warpSettings = intensityWarpSettings;
    }

    @Override
    public /* synthetic */ PositionTransform j() {
        return this.M();
    }
}

