/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals.statistics;

import com.mimvista.dicom.DataUnitUtils;
import com.mimvista.dicom.Modality;
import com.mimvista.internals.ImageFrame;
import com.mimvista.state.ReadHelper;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class StatisticContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String modality;
    private final UnitHelper.ImageUnit unit;

    public StatisticContext(ImageFrame imageFrame) {
        this(imageFrame.getUncopiedMutableInfo());
    }

    public StatisticContext(SeriesInfo seriesInfo) {
        this.modality = seriesInfo.modality;
        this.unit = seriesInfo.u().m().unit;
    }

    public StatisticContext(UnitHelper.ImageUnit imageUnit, String string) {
        this.modality = string;
        this.unit = imageUnit;
    }

    public String a() {
        if (this.modality == null) {
            throw new RuntimeException("Context does not have a uniform modality.");
        }
        return this.modality;
    }

    public UnitHelper.ImageUnit b() {
        if (this.unit == null) {
            throw new RuntimeException("Context does not have a uniform unit.");
        }
        return this.unit;
    }

    public String c() {
        if (this.unit == null) {
            throw new RuntimeException("Context does not have a uniform unit (desc).");
        }
        if (this.unit.unitDesc == null) {
            return "";
        }
        return this.unit.unitDesc;
    }

    public String d() {
        if (this.unit == null) {
            throw new RuntimeException("Context does not have a uniform unit (canon).");
        }
        return this.unit.canonBaseUnit;
    }

    public boolean a(ImageFrame imageFrame) {
        return this.a(imageFrame.getUncopiedMutableInfo());
    }

    public boolean a(SeriesInfo seriesInfo) {
        if (this.modality != null && Modality.get(seriesInfo.modality) != Modality.get(this.modality)) {
            return false;
        }
        return this.unit == null || seriesInfo.u().c(this.unit.canonBaseUnit);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        ReadHelper readHelper = new ReadHelper();
        readHelper.a(getField, (Object)this);
        if (ReadHelper.b(getField, "units")) {
            String string = (String)getField.get("units", "");
            ReadHelper.a((Object)this, "unit", new UnitHelper.ImageUnit(DataUnitUtils.getCanonicalUnit(string, this.modality)));
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.modality == null ? 0 : this.modality.hashCode());
        n3 = 31 * n3 + (this.unit == null ? 0 : this.unit.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StatisticContext statisticContext = (StatisticContext)object;
        if (this.modality == null ? statisticContext.modality != null : !this.modality.equals(statisticContext.modality)) {
            return false;
        }
        return !(this.unit == null ? statisticContext.unit != null : !this.unit.equals(statisticContext.unit));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.modality);
        if (this.unit != null) {
            stringBuilder.append(":" + this.unit);
        }
        return stringBuilder.toString();
    }
}

