/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals.volumes;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.SurfacePoints;
import com.mimvista.internals.aj;
import com.mimvista.internals.an;
import com.mimvista.internals.volumes.a;
import com.mimvista.mui.PresentationType;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.numerics.Vector3fPro;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.b;
import com.mimvista.util.logging.a.c;
import com.mimvista.util.progress.Progress;
import com.mimvista.viewer.SeriesInfo;
import gnu.trove.list.TFloatList;
import gnu.trove.list.array.TFloatArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class SimpleImageVolume<ImCubeType extends ImageCube>
implements SimpleImageFrame,
aj,
SeriesInfo.a {
    private static final long serialVersionUID = 4314752995767430827L;
    public static short c = Short.MIN_VALUE;
    public static short d = (short)-32767;
    protected boolean refusedReorientation = false;
    protected ImCubeType slices;
    protected float min = Float.NaN;
    protected float max = Float.NaN;
    private int[] originalDims = new int[]{0, 0, 0};
    protected Matrix4f initRotationMatrix = null;
    protected Matrix4f gantryCorrectionMatrix = null;
    protected SeriesInfo info = new SeriesInfo();
    protected List<SliceInfo> sliceInfo = Collections.synchronizedList(new ArrayList());
    protected List<SliceInfo> nonUniformSliceInfo = null;
    protected float[] voxel = new float[]{1.0f, 1.0f, 1.0f};
    private float[] dicomCenter = new float[3];
    private float[] metricCenter = null;
    private boolean atlasVolume = false;
    private boolean atlasDescendant = false;
    private boolean atlasLocked = false;
    protected int dynamicIndex = -1;
    private transient an a;
    protected int multiframeIndex;
    protected boolean multiFrame;
    public SurfacePoints[] epis = null;
    public SurfacePoints[] endos = null;
    public SurfacePoints[] bases = null;
    protected ImCubeType originalSlices;
    private boolean fullyLoaded = false;
    private int[] cachedHistogram = null;
    private transient List<SliceInfo> b;
    private transient TreeMap<Float, SliceInfo> e;

    public SimpleImageVolume() {
    }

    public SimpleImageVolume(ImCubeType ImCubeType) {
        this();
        this.b(ImCubeType);
    }

    public String p() {
        String string = this.a()[0] + " x " + this.a()[1] + " x " + this.a()[2];
        return string;
    }

    public boolean aE_() {
        try {
            return this.getUncopiedMutableInfo().modality.equalsIgnoreCase("RTDose") || this.getUncopiedMutableInfo().u().u();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    protected void a(SimpleImageVolume<?> simpleImageVolume, boolean bl2) {
        com.mimvista.internals.volumes.a.a(simpleImageVolume, this, false);
        if (simpleImageVolume.at() != null) {
            this.nonUniformSliceInfo = SliceInfo.a(simpleImageVolume.at(), bl2);
        }
        this.a(SliceInfo.a(simpleImageVolume.ab(), bl2));
        this.min = Float.NaN;
        this.max = Float.NaN;
        this.f(simpleImageVolume.af());
        this.bases = simpleImageVolume.bases;
        this.epis = simpleImageVolume.epis;
        this.endos = simpleImageVolume.endos;
        if (simpleImageVolume.ak()) {
            this.an();
        } else if (simpleImageVolume.al()) {
            this.ao();
        }
    }

    public SimpleImageVolume<ImCubeType> U() {
        SimpleImageVolume simpleImageVolume = new SimpleImageVolume(((ImageCube)this.ad()).i());
        simpleImageVolume.a(this, true);
        return simpleImageVolume;
    }

    public float[] Y() {
        return com.mimvista.internals.volumes.a.a(this.a(), this.voxel);
    }

    @Override
    public void b(float[] fArray) {
        this.dicomCenter = fArray;
    }

    @Override
    public float[] G() {
        if (this.dicomCenter != null) {
            return (float[])this.dicomCenter.clone();
        }
        return null;
    }

    @Override
    public int am_() {
        return this.dynamicIndex;
    }

    @Override
    public void a(an an2, int n2) {
        this.a = an2;
        this.dynamicIndex = n2;
    }

    @Override
    public an A() {
        return this.a;
    }

    @Override
    public void a(int[] nArray) {
        ((ImageCube)this.ad()).a(nArray);
        this.metricCenter = null;
    }

    @Override
    public int[] a() {
        return (int[])((ImageCube)this.ad()).d().clone();
    }

    @Override
    public long H() {
        int[] nArray = this.a();
        return nArray[0] * nArray[1] * nArray[2];
    }

    public void b(int[] nArray) {
        this.originalDims = (int[])(nArray != null ? (int[])nArray.clone() : null);
    }

    public int[] Z() {
        if (this.originalDims != null) {
            return (int[])this.originalDims.clone();
        }
        return null;
    }

    @Override
    public void a(float[] fArray) {
        this.voxel = (float[])(fArray != null ? (float[])fArray.clone() : null);
        this.metricCenter = null;
    }

    @Override
    public float[] b() {
        return (float[])this.voxel.clone();
    }

    @Override
    public void b(SeriesInfo seriesInfo) {
        this.info = seriesInfo;
    }

    @Override
    public SeriesInfo getUncopiedMutableInfo() {
        return this.info;
    }

    @Override
    public SeriesInfo I() {
        SeriesInfo seriesInfo = this.getUncopiedMutableInfo();
        if (com.mimvista.util.b.b()) {
            return seriesInfo.n();
        }
        return seriesInfo.m();
    }

    @Override
    public int[] C() {
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = this.voxel[2];
        int[] nArray = new int[]{Math.max(1, Math.round(this.voxel[0] / f2)), Math.max(1, Math.round(this.voxel[1] / f3)), Math.max(1, Math.round(this.voxel[2] / f4))};
        return nArray;
    }

    public float b(int n2) {
        return this.info.rescale.apply(n2);
    }

    public int a(float f2) {
        return this.info.rescale.removeWithBounds(f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] J() {
        SimpleImageVolume simpleImageVolume = this;
        synchronized (simpleImageVolume) {
            if (this.metricCenter == null) {
                float[] fArray = new float[3];
                int[] nArray = this.a();
                for (int i2 = 0; i2 < fArray.length; ++i2) {
                    fArray[i2] = (float)nArray[i2] * this.voxel[i2] / 2.0f;
                }
                this.metricCenter = fArray;
            }
        }
        return (float[])this.metricCenter.clone();
    }

    public List<SliceInfo> aa() {
        return this.sliceInfo;
    }

    public List<SliceInfo> ab() {
        return Collections.synchronizedList(Lists.newArrayList(this.sliceInfo));
    }

    public void ac() {
        if (this.nonUniformSliceInfo == null && this.sliceInfo.size() == 0) {
            SliceInfo.a(this, this.sliceInfo);
        }
    }

    public SliceInfo c(int n2) {
        if (this.sliceInfo.isEmpty()) {
            return new SliceInfo();
        }
        if (n2 >= this.sliceInfo.size()) {
            n2 = this.sliceInfo.size() - 1;
        } else if (n2 < 0) {
            n2 = 0;
        }
        return this.sliceInfo.get(n2);
    }

    public ImCubeType ad() {
        return this.slices;
    }

    public void a(ImCubeType ImCubeType) {
        this.b(ImCubeType);
        this.metricCenter = null;
        this.aj();
    }

    protected void b(ImCubeType ImCubeType) {
        this.slices = ImCubeType;
    }

    public void a(List<SliceInfo> list) {
        this.sliceInfo = Collections.synchronizedList(list);
    }

    public float a(float[] fArray, float[] fArray2) {
        Vector3f vector3f = new Vector3f(SimpleOrientationHelper.a(this.getUncopiedMutableInfo().origImageOrientation, this.getUncopiedMutableInfo().H()));
        return com.mimvista.internals.volumes.a.a(vector3f, fArray, fArray2);
    }

    @Override
    public Matrix4f M() {
        if (this.gantryCorrectionMatrix == null) {
            this.gantryCorrectionMatrix = MatrixMultiplier.b();
            Float f2 = this.getUncopiedMutableInfo().H();
            if (f2 != null) {
                float[] fArray = SimpleOrientationHelper.b(this.info.imageOrientation, f2);
                this.gantryCorrectionMatrix = SimpleOrientationHelper.a(this.info.imageOrientation, this.info.H(), fArray, null);
            }
        }
        return (Matrix4f)this.gantryCorrectionMatrix.clone();
    }

    public void ae() {
        this.gantryCorrectionMatrix = null;
    }

    public boolean af() {
        return this.refusedReorientation;
    }

    public void f(boolean bl2) {
        this.refusedReorientation = bl2;
    }

    public Matrix4f ag() {
        float[] fArray = this.info.imageOrientation;
        Matrix4f matrix4f = SimpleOrientationHelper.a(fArray, this.info.H(), null);
        Matrix4f matrix4f2 = new Matrix4f(this.M());
        matrix4f2.invert();
        matrix4f2.mul(matrix4f);
        return matrix4f2;
    }

    @Override
    public Matrix4f N() {
        if (this.initRotationMatrix == null) {
            this.initRotationMatrix = new Matrix4f();
            this.initRotationMatrix.setIdentity();
        }
        Matrix4f matrix4f = new Matrix4f(this.M());
        matrix4f.mul(this.initRotationMatrix);
        return matrix4f;
    }

    public void a(Matrix4f matrix4f) {
        this.initRotationMatrix = (Matrix4f)matrix4f.clone();
    }

    public float ah() {
        if (Float.isNaN(this.min)) {
            this.min = ((ImageCube)this.slices).g();
        }
        return this.min;
    }

    public float ai() {
        if (Float.isNaN(this.max)) {
            this.max = ((ImageCube)this.slices).h();
        }
        return this.max;
    }

    public synchronized void aj() {
        this.min = Float.NaN;
        this.max = Float.NaN;
    }

    public float a(float f2, float f3, float f4, float f5) {
        return ((ImageCube)this.slices).a(f2, f3, f4, f5);
    }

    public float a(float f2, float f3, float f4) {
        return ((ImageCube)this.slices).a(f2, f3, f4);
    }

    public boolean ak() {
        return this.atlasVolume;
    }

    public boolean al() {
        return this.atlasDescendant;
    }

    public boolean am() {
        return this.atlasVolume && this.atlasLocked;
    }

    public void an() {
        this.atlasVolume = true;
        this.ao();
    }

    public void ao() {
        this.atlasDescendant = true;
    }

    public void ap() {
        this.an();
        this.atlasLocked = true;
    }

    @Override
    public void a(int n2) {
        this.multiframeIndex = n2;
    }

    @Override
    public int c() {
        return this.multiframeIndex;
    }

    public boolean s() {
        return this.multiFrame;
    }

    public void a(boolean bl2) {
        this.multiFrame = bl2;
    }

    public boolean aq() {
        return this.nonUniformSliceInfo != null;
    }

    public boolean ar() {
        Vector3f vector3f;
        if (this.getUncopiedMutableInfo().lastSaveHadAppliedViewingRot) {
            return true;
        }
        Vector3f vector3f2 = new Vector3f(SimpleOrientationHelper.a(this.getUncopiedMutableInfo().origImageOrientation, this.getUncopiedMutableInfo().H()));
        float f2 = vector3f2.angle(vector3f = new Vector3f(SimpleOrientationHelper.a(this.getUncopiedMutableInfo().imageOrientation, this.getUncopiedMutableInfo().H())));
        return f2 != 0.0f && f2 != (float)Math.PI;
    }

    public List<SliceInfo> as() {
        if (this.nonUniformSliceInfo != null) {
            return Lists.newArrayList(this.nonUniformSliceInfo);
        }
        return Lists.newArrayList(this.sliceInfo);
    }

    public List<SliceInfo> at() {
        if (this.nonUniformSliceInfo != null) {
            return Lists.newArrayList(this.nonUniformSliceInfo);
        }
        return null;
    }

    public void b(List<SliceInfo> list) {
        this.nonUniformSliceInfo = list;
    }

    public Float au() {
        return this.getUncopiedMutableInfo().H();
    }

    public void d(float[] fArray) {
        this.getUncopiedMutableInfo().imageOrientation = (float[])(fArray != null ? (float[])fArray.clone() : null);
    }

    public float[] av() {
        if (this.getUncopiedMutableInfo().imageOrientation != null) {
            return (float[])this.getUncopiedMutableInfo().imageOrientation.clone();
        }
        return null;
    }

    public PresentationType aw() {
        return SimpleOrientationHelper.d(this.av(), this.au());
    }

    public SliceInfo b(DicomPoint3f dicomPoint3f) {
        if (!this.aq()) {
            return null;
        }
        int n2 = Math.round(dicomPoint3f.b().c().z);
        SliceInfo sliceInfo = null;
        float f2 = Float.MAX_VALUE;
        for (SliceInfo sliceInfo2 : this.at()) {
            float f3;
            DicomPoint3f dicomPoint3f2 = new DicomPoint3f(sliceInfo2.sliceDicomCenter, (SimpleImageFrame)this);
            int n3 = Math.round(dicomPoint3f2.b().c().z);
            if (n3 != n2 || !((f3 = Math.abs(dicomPoint3f.c().z - dicomPoint3f2.c().z)) < f2)) continue;
            f2 = f3;
            sliceInfo = sliceInfo2;
        }
        return sliceInfo;
    }

    public SliceInfo c(DicomPoint3f dicomPoint3f) {
        if (!this.aq()) {
            return null;
        }
        Pair<SliceInfo, Float> pair = SimpleImageVolume.a(this.at(), this.getUncopiedMutableInfo(), dicomPoint3f);
        return (SliceInfo)pair.x;
    }

    public static Pair<SliceInfo, Float> a(List<SliceInfo> list, SeriesInfo seriesInfo, DicomPoint3f dicomPoint3f) {
        float f2 = Float.MAX_VALUE;
        Vector3fPro vector3fPro = new Vector3fPro(SimpleOrientationHelper.a(seriesInfo.origImageOrientation, seriesInfo.H()));
        SliceInfo sliceInfo = null;
        Vector3f vector3f = new Vector3f(dicomPoint3f.f());
        for (SliceInfo sliceInfo2 : list) {
            if (sliceInfo2.sliceDicomCenter == null) {
                return null;
            }
            float f3 = com.mimvista.internals.volumes.a.a((Vector3f)vector3fPro, sliceInfo2.sliceDicomCenter, vector3f);
            if (!(Math.abs(f3) < Math.abs(f2) + 1.0E-4f)) continue;
            f2 = f3;
            sliceInfo = sliceInfo2;
        }
        return Pair.get(sliceInfo, Float.valueOf(f2));
    }

    public void ax() {
        this.e = null;
    }

    public Pair<SliceInfo, Float> d(DicomPoint3f dicomPoint3f) {
        SeriesInfo seriesInfo = this.getUncopiedMutableInfo();
        Vector3fPro vector3fPro = new Vector3fPro(SimpleOrientationHelper.a(seriesInfo.origImageOrientation, seriesInfo.H()));
        Vector3d vector3d = new Vector3d(0.0, 0.0, 0.0);
        List<SliceInfo> list = this.nonUniformSliceInfo;
        if (list == null) {
            list = this.sliceInfo;
        }
        if (this.e == null || list != this.b) {
            this.b = list;
            this.e = new TreeMap();
            for (SliceInfo object2 : list) {
                float entry = (float)com.mimvista.internals.volumes.a.a((Vector3f)vector3fPro, object2.sliceDicomCenter, vector3d);
                this.e.put(Float.valueOf(entry), object2);
            }
        }
        float f3 = (float)com.mimvista.internals.volumes.a.a((Vector3f)vector3fPro, dicomPoint3f.f(), vector3d);
        Map.Entry<Float, SliceInfo> entry = this.e.floorEntry(Float.valueOf(f3));
        Map.Entry<Float, SliceInfo> entry2 = this.e.ceilingEntry(Float.valueOf(f3));
        if (entry2 == null && entry == null || Float.isNaN(f3)) {
            return Pair.get(null, Float.valueOf(Float.MAX_VALUE));
        }
        float f2 = entry == null ? Float.MAX_VALUE : Math.abs(entry.getKey().floatValue() - f3);
        float f4 = entry2 == null ? Float.MAX_VALUE : Math.abs(entry2.getKey().floatValue() - f3);
        Pair<SliceInfo, Float> pair = f2 < f4 + 0.001f ? Pair.get(entry.getValue(), Float.valueOf(f2)) : Pair.get(entry2.getValue(), Float.valueOf(f4));
        return pair;
    }

    public static Pair<SliceInfo, Float> a(SimpleImageVolume<?> simpleImageVolume, DicomPoint3f dicomPoint3f) {
        List<SliceInfo> list = simpleImageVolume.at();
        if (list == null) {
            list = simpleImageVolume.ab();
        }
        return SimpleImageVolume.a(list, simpleImageVolume.getUncopiedMutableInfo(), dicomPoint3f);
    }

    public SliceInfo a(SliceInfo sliceInfo, int n2, int n3, boolean bl2) {
        if (!this.aq()) {
            return sliceInfo;
        }
        if (n2 == 0) {
            return sliceInfo;
        }
        SimpleImageVolume simpleImageVolume = this;
        List<SliceInfo> list = simpleImageVolume.at();
        int n4 = list.indexOf(sliceInfo);
        if (n4 == -1) {
            return null;
        }
        int n5 = SimpleImageVolume.a(sliceInfo, simpleImageVolume);
        int n6 = 0;
        while (n6 < n3 && (n4 += n2) >= 0 && n4 < list.size()) {
            int n7 = SimpleImageVolume.a(list.get(n4), simpleImageVolume);
            if (n7 == n5) continue;
            n5 = n7;
            ++n6;
        }
        if (bl2) {
            if (n4 < 0 || n4 >= list.size()) {
                return null;
            }
        } else if (n4 < 0) {
            n4 = 0;
        } else if (n4 >= list.size()) {
            n4 = list.size() - 1;
        }
        return list.get(n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void g(boolean bl2) {
        SimpleImageVolume simpleImageVolume = this;
        synchronized (simpleImageVolume) {
            this.fullyLoaded = bl2;
            this.notifyAll();
        }
    }

    public boolean ay() {
        return this.fullyLoaded;
    }

    public void c(int[] nArray) {
        int n2;
        this.cachedHistogram = nArray;
        if (nArray == null) {
            return;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] <= 0) continue;
            this.min = n2 + Short.MIN_VALUE;
            break;
        }
        for (n2 = nArray.length - 1; n2 > 0; --n2) {
            if (nArray[n2] <= 0) continue;
            this.max = n2 + Short.MIN_VALUE;
            break;
        }
    }

    public int[] az() {
        return this.cachedHistogram;
    }

    public float aA() {
        return this.aB().sum();
    }

    public TFloatList aB() {
        SliceInfo sliceInfo2;
        int n2 = this.sliceInfo.size();
        if (n2 == 1) {
            return new TFloatArrayList(new float[]{this.sliceInfo.get((int)0).voxel.z});
        }
        ArrayList arrayList = Lists.newArrayList();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f(this.sliceInfo.get((int)0).sliceDicomCenter);
        Vector3f vector3f3 = new Vector3f(this.sliceInfo.get((int)1).sliceDicomCenter);
        vector3f.sub((Tuple3f)vector3f2, (Tuple3f)vector3f3);
        vector3f.add((Tuple3f)vector3f2);
        arrayList.add(vector3f);
        for (SliceInfo sliceInfo2 : this.sliceInfo) {
            arrayList.add(new Vector3f(sliceInfo2.sliceDicomCenter));
        }
        Vector3f vector3f4 = new Vector3f();
        sliceInfo2 = new Vector3f(this.sliceInfo.get((int)(n2 - 2)).sliceDicomCenter);
        Vector3f vector3f5 = new Vector3f(this.sliceInfo.get((int)(n2 - 1)).sliceDicomCenter);
        vector3f4.sub((Tuple3f)vector3f5, (Tuple3f)sliceInfo2);
        vector3f4.add((Tuple3f)vector3f5);
        arrayList.add(vector3f4);
        TFloatArrayList tFloatArrayList = new TFloatArrayList(n2);
        for (int i2 = 1; i2 < arrayList.size() - 1; ++i2) {
            Vector3f vector3f6 = (Vector3f)arrayList.get(i2 - 1);
            Vector3f vector3f7 = (Vector3f)arrayList.get(i2);
            Vector3f vector3f8 = (Vector3f)arrayList.get(i2 + 1);
            Vector3f vector3f9 = new Vector3f();
            vector3f9.sub((Tuple3f)vector3f7, (Tuple3f)vector3f6);
            float f2 = vector3f9.length();
            vector3f9.sub((Tuple3f)vector3f8, (Tuple3f)vector3f7);
            float f3 = vector3f9.length();
            float f4 = f2 / 2.0f + f3 / 2.0f;
            tFloatArrayList.add(f4);
        }
        return tFloatArrayList;
    }

    public float aC() {
        return this.aB().min();
    }

    public float aD() {
        int n2;
        int n3;
        int n4 = 10000;
        HashMultiset hashMultiset = HashMultiset.create();
        TFloatList tFloatList = this.aB();
        for (n3 = 0; n3 < tFloatList.size(); ++n3) {
            n2 = (int)((float)n4 * tFloatList.get(n3));
            hashMultiset.add((Object)n2);
        }
        n3 = -1;
        n2 = -1;
        for (Integer n5 : hashMultiset.elementSet()) {
            int n6 = hashMultiset.count((Object)n5);
            if (n6 <= n2) continue;
            n2 = n6;
            n3 = n5;
        }
        return (float)n3 / (float)n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Progress progress, Collection<SliceInfo> collection) {
        Serializable serializable2;
        SliceInfo sliceInfo;
        ArrayList arrayList = Lists.newArrayList(this.sliceInfo);
        this.sliceInfo.clear();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            sliceInfo = null;
            for (Serializable serializable2 : collection) {
                if (serializable2 != arrayList.get(i2)) continue;
                sliceInfo = serializable2;
                break;
            }
            if (sliceInfo == null) continue;
            this.sliceInfo.add(sliceInfo);
        }
        SliceInfo sliceInfo2 = this.sliceInfo.get(0);
        sliceInfo = this.sliceInfo.get(this.sliceInfo.size() - 1);
        this.b(new float[]{(sliceInfo2.sliceDicomCenter[0] + sliceInfo.sliceDicomCenter[0]) / 2.0f, (sliceInfo2.sliceDicomCenter[1] + sliceInfo.sliceDicomCenter[1]) / 2.0f, (sliceInfo2.sliceDicomCenter[2] + sliceInfo.sliceDicomCenter[2]) / 2.0f});
        Object object = this.a();
        object[2] = this.sliceInfo.size();
        this.a((int[])object);
        serializable2 = this;
        synchronized (serializable2) {
            this.notify();
        }
    }

    public void e(float[] fArray) {
        c c2 = ay.b(this.getClass());
        float f2 = fArray[fArray.length - 1];
        float f3 = MathUtils.a(false, fArray);
        float f4 = fArray[0];
        boolean bl2 = false;
        if (bl2) {
            c2.d("Max slice sep: " + f2);
            c2.d("Median slice separation: " + f3);
            c2.d("Min slice sep: " + f4);
        }
        if (f3 == 0.0f) {
            return;
        }
        float[] fArray2 = this.b();
        if (bl2) {
            c2.d("Original slice sep: " + fArray2[2]);
        }
        fArray2[2] = f3;
        float f5 = 0.05f;
        if (f2 != f4 && Math.abs(f3 - f4) > f5 * f3) {
            int n2 = 0;
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                if (fArray[i2] != f4) continue;
                ++n2;
            }
            if ((double)((float)n2 / (float)fArray.length) > 0.3) {
                fArray2[2] = f4;
            }
        }
        if (Math.abs(fArray2[2] - this.b()[2]) > 0.001f) {
            this.a(fArray2);
            if (bl2) {
                c2.d("Updated slice sep: " + fArray2[2]);
            }
        }
    }

    private static int a(SliceInfo sliceInfo, SimpleImageVolume<?> simpleImageVolume) {
        Vector3f vector3f = new Vector3f(sliceInfo.sliceDicomCenter);
        Vector3f vector3f2 = new Vector3f(SimpleOrientationHelper.a(simpleImageVolume.getUncopiedMutableInfo().origImageOrientation, simpleImageVolume.getUncopiedMutableInfo().H()));
        float f2 = Float.MAX_VALUE;
        int n2 = -1;
        for (int i2 = 0; i2 < simpleImageVolume.ab().size(); ++i2) {
            SliceInfo sliceInfo2 = simpleImageVolume.ab().get(i2);
            float f3 = com.mimvista.internals.volumes.a.a(vector3f2, sliceInfo2.sliceDicomCenter, vector3f);
            if (!(Math.abs(f3) < Math.abs(f2))) continue;
            f2 = f3;
            n2 = i2;
        }
        return n2;
    }

    public static SimpleImageVolume<ImageCube.ImageCubeShort> aE() {
        SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume = new SimpleImageVolume<ImageCube.ImageCubeShort>();
        simpleImageVolume.b(ImageCube.ImageCubeShort.a(0, 0, 0, 0));
        return simpleImageVolume;
    }

    public static SimpleImageVolume<ImageCube.ImageCubeFloat> aF() {
        SimpleImageVolume<ImageCube.ImageCubeFloat> simpleImageVolume = new SimpleImageVolume<ImageCube.ImageCubeFloat>();
        simpleImageVolume.b(ImageCube.ImageCubeFloat.a(0, 0, 0, 0));
        return simpleImageVolume;
    }

    public static SimpleImageVolume<ImageCube.ImageCubeFloat> a(int n2, int n3, int n4) {
        SimpleImageVolume<ImageCube.ImageCubeFloat> simpleImageVolume = new SimpleImageVolume<ImageCube.ImageCubeFloat>();
        simpleImageVolume.b(ImageCube.ImageCubeFloat.b(new int[]{n2, n3, n4}));
        return simpleImageVolume;
    }

    public static SimpleImageVolume<ImageCube.ImageCubeByte> aG() {
        SimpleImageVolume<ImageCube.ImageCubeByte> simpleImageVolume = new SimpleImageVolume<ImageCube.ImageCubeByte>();
        simpleImageVolume.b(ImageCube.ImageCubeByte.a(0, 0, 0, 0));
        return simpleImageVolume;
    }

    public static boolean a(SimpleImageFrame simpleImageFrame) {
        SimpleImageVolume simpleImageVolume;
        return simpleImageFrame instanceof SimpleImageVolume && (simpleImageVolume = (SimpleImageVolume)simpleImageFrame).ad() instanceof ImageCube.ImageCubeShort;
    }

    public static boolean b(SimpleImageFrame simpleImageFrame) {
        SimpleImageVolume simpleImageVolume;
        return simpleImageFrame instanceof SimpleImageVolume && (simpleImageVolume = (SimpleImageVolume)simpleImageFrame).ad() instanceof ImageCube.ImageCubeFloat;
    }

    public static boolean c(SimpleImageFrame simpleImageFrame) {
        SimpleImageVolume simpleImageVolume;
        return simpleImageFrame instanceof SimpleImageVolume && (simpleImageVolume = (SimpleImageVolume)simpleImageFrame).ad() instanceof ImageCube.ImageCubeByte;
    }

    @Override
    public boolean Q() {
        return false;
    }

    @Deprecated
    private class SimpleImageVolumeFloatProxy
    extends SimpleImageVolume<ImageCube.ImageCubeFloat> {
        private SimpleImageVolumeFloatProxy() {
        }
    }

    @Deprecated
    private class SimpleImageVolumeShortProxy
    extends SimpleImageVolume<ImageCube.ImageCubeShort> {
        private SimpleImageVolumeShortProxy() {
        }
    }
}

