/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.iphone;

import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.iphone.gui.BundleEditDialog;
import com.mimvista.iphone.j;
import com.mimvista.preferencesNew.IphonePrefs;
import com.mimvista.swing.widgets.SeriesTableCellRenderers;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.jdesktop.swingx.table.TableColumnExt;

public class IphoneBundleManagementGui
extends Box {
    private static final float a = 1024.0f;
    private static final float b = 1048576.0f;
    private static final Messages c = Messages.a("Iphone");
    private static final String d = IphonePrefs.iphoneExportLocation.getValue();
    private BundleModel bundleModel = new BundleModel();
    private TableRowSorter<BundleModel> tableSorter = new TableRowSorter<BundleModel>(this.bundleModel);
    private JTable bundleTable = new JTable(this.bundleModel, new BundleTableColumnModel(this.tableSorter));
    private static final long serialVersionUID = 1L;

    public IphoneBundleManagementGui() {
        super(3);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tableSorter.toggleSortOrder(0);
        this.tableSorter.setSortsOnUpdates(true);
        this.bundleTable.setAutoCreateRowSorter(false);
        this.bundleTable.setRowSorter(this.tableSorter);
        this.d();
    }

    public void a() {
        JScrollPane jScrollPane = new JScrollPane(this.bundleTable);
        this.bundleTable.setPreferredScrollableViewportSize(new Dimension(300, 300));
        this.add(jScrollPane);
        JButton jButton = new JButton(c.getProperty("IPHONE_BUNDLE_MNG_EDIT_OWNER"), ImageManipulator.c("pencil", 16, 16));
        jButton.addActionListener(this.e());
        JButton jButton2 = new JButton(c.getProperty("IPHONE_BUNDLE_MNG_DELETE"), ImageManipulator.c("x_red", 16, 16));
        jButton2.addActionListener(this.f());
        JButton jButton3 = new JButton(c.getProperty("IPHONE_BUNDLE_MNG_REFRESH"), ImageManipulator.c("recycle", 16, 16));
        jButton3.addActionListener(this.g());
        Box box = new Box(2);
        box.add(jButton);
        box.add(jButton2);
        box.add(jButton3);
        box.add(Box.createHorizontalGlue());
        this.add(box);
    }

    private void d() {
        this.bundleModel.a();
    }

    private ActionListener e() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IphoneBundleManagementGui.this.bundleTable.getSelectedRowCount() == 0) {
                    return;
                }
                ArrayList<File> arrayList = new ArrayList<File>();
                for (int n2 : IphoneBundleManagementGui.this.bundleTable.getSelectedRows()) {
                    int n3 = IphoneBundleManagementGui.this.bundleTable.convertRowIndexToModel(n2);
                    HashMap<String, Object> hashMap = IphoneBundleManagementGui.this.bundleModel.a(n3);
                    arrayList.add((File)hashMap.get("BundleFolder"));
                }
                Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, IphoneBundleManagementGui.this);
                new BundleEditDialog(window, arrayList).a();
                IphoneBundleManagementGui.this.d();
            }
        };
    }

    private ActionListener f() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                if (IphoneBundleManagementGui.this.bundleTable.getSelectedRowCount() == 0) {
                    return;
                }
                String string2 = c.getProperty("IPHONE_BUNDLE_MNG_CONFIRM_DELETE_MSG");
                int n2 = JOptionPane.showConfirmDialog(IphoneBundleManagementGui.this, string2, string = c.getProperty("IPHONE_BUNDLE_MNG_CONFIRM_DELETE"), 0, 3);
                if (n2 != 0) {
                    return;
                }
                for (int n3 : IphoneBundleManagementGui.this.bundleTable.getSelectedRows()) {
                    int n4 = IphoneBundleManagementGui.this.bundleTable.convertRowIndexToModel(n3);
                    HashMap<String, Object> hashMap = IphoneBundleManagementGui.this.bundleModel.a(n4);
                    File file = (File)hashMap.get("BundleFolder");
                    if (!file.exists() || !file.isDirectory()) continue;
                    for (File file2 : file.listFiles()) {
                        file2.delete();
                    }
                    file.delete();
                }
                IphoneBundleManagementGui.this.d();
            }
        };
    }

    private ActionListener g() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IphoneBundleManagementGui.this.d();
            }
        };
    }

    private class BundleModel
    extends AbstractTableModel {
        private ArrayList<HashMap<String, Object>> bundles = new ArrayList();
        private static final long serialVersionUID = 1L;

        private BundleModel() {
        }

        @Override
        public int getColumnCount() {
            return BundleColumn.values().length;
        }

        @Override
        public int getRowCount() {
            return this.bundles.size();
        }

        @Override
        public Class<?> getColumnClass(int n2) {
            return a.class;
        }

        public a a(int n2, int n3) {
            return new a(this.bundles.get(n2), BundleColumn.a(n3));
        }

        public HashMap<String, Object> a(int n2) {
            return this.bundles.get(n2);
        }

        public void a() {
            this.bundles.clear();
            this.bundles.addAll(this.a(new File(d)));
            this.fireTableDataChanged();
        }

        private List<HashMap<String, Object>> a(final File file) {
            if (file == null || !file.exists() || !file.isDirectory()) {
                return Collections.emptyList();
            }
            List<String> list = Arrays.asList(file.list(new FilenameFilter(){

                @Override
                public boolean accept(File file2, String string) {
                    return new File(file, string + "/bundle.plist").exists();
                }
            }));
            if (list.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
            for (String string : list) {
                j j2 = new j(new File(file, string + "/bundle.plist"));
                try {
                    String string2;
                    HashMap<String, Object> hashMap = j2.a();
                    File file2 = new File(file, string);
                    hashMap.put("BundleFolder", file2);
                    hashMap.put("BundleSize", this.c(file2));
                    hashMap.put(BundleColumn.f.name(), this.b(file2));
                    hashMap.put(BundleColumn.d.name(), "");
                    hashMap.put(BundleColumn.e.name(), "");
                    String[] stringArray = string.split("[^0-9*]");
                    if (stringArray != null && stringArray.length > 0) {
                        long l2 = Long.parseLong(stringArray[0]);
                        hashMap.put(BundleColumn.d.name(), new SimpleDateFormat("yyyy-MM-dd").format(l2));
                        hashMap.put(BundleColumn.e.name(), new SimpleDateFormat("hh:mm:ss a").format(l2));
                    }
                    if ((string2 = (String)hashMap.get("AuthorizedUser")) == null) {
                        string2 = (String)hashMap.get("BundleUser");
                    }
                    hashMap.put(BundleColumn.c.name(), string2);
                    arrayList.add(hashMap);
                }
                catch (Exception exception) {
                    ay.d((Object)("Bundle Management GUI, exception while parsing plist in " + string + ": "), (Throwable)exception, this);
                    exception.printStackTrace();
                }
            }
            return arrayList;
        }

        private String b(File file) {
            String string;
            float f2 = this.c(file);
            if (f2 >= 1048576.0f) {
                f2 /= 1048576.0f;
                string = "MB";
            } else {
                f2 /= 1024.0f;
                string = "KB";
            }
            return new DecimalFormat("0.##").format(f2) + " " + string;
        }

        private int c(File file) {
            if (file == null || !file.exists() || !file.isDirectory()) {
                return 0;
            }
            int n2 = 0;
            for (File file2 : file.listFiles()) {
                if (!file2.getName().endsWith(".vol") && !file2.getName().endsWith("vol.gz")) continue;
                n2 = (int)((long)n2 + file2.length());
            }
            return n2;
        }

        @Override
        public /* synthetic */ Object getValueAt(int n2, int n3) {
            return this.a(n2, n3);
        }
    }

    private class a {
        public HashMap<String, Object> a = new HashMap();
        private BundleColumn c;

        public a(HashMap<String, Object> hashMap, BundleColumn bundleColumn) {
            this.a = hashMap;
            this.c = bundleColumn;
        }

        public String toString() {
            return (String)this.a.get(this.c.name());
        }
    }

    private class BundleTableColumnModel
    extends DefaultTableColumnModel {
        private TableCellRenderer renderer = SeriesTableCellRenderers.g;
        private static final long serialVersionUID = 1L;

        public BundleTableColumnModel(TableRowSorter<BundleModel> tableRowSorter) {
            BundleColumn[] bundleColumnArray = BundleColumn.values();
            for (int i2 = 0; i2 < bundleColumnArray.length; ++i2) {
                TableColumnExt tableColumnExt = new TableColumnExt(i2);
                tableColumnExt.setCellRenderer(this.renderer);
                tableColumnExt.setHeaderValue(bundleColumnArray[i2].a());
                tableColumnExt.setPreferredWidth(bundleColumnArray[i2].b());
                tableRowSorter.setComparator(i2, bundleColumnArray[i2].c());
                this.addColumn((TableColumn)tableColumnExt);
            }
        }
    }

    private static enum BundleColumn {
        a("PATIENT_NAME_HEADER", 125),
        b("MODALITIES_HEADER", 100),
        c("OWNER_HEADER", 100),
        d("DATE_CREATED_HEADER", 100),
        e("TIME_CREATED_HEADER", 100),
        f("SIZE_HEADER", 100);

        String labelKey;
        int width;

        private BundleColumn(String string2, int n3) {
            this.labelKey = string2;
            this.width = n3;
        }

        protected String a() {
            return c.getProperty(this.labelKey);
        }

        protected int b() {
            return this.width;
        }

        protected static BundleColumn a(int n2) {
            return BundleColumn.values()[n2];
        }

        public Comparator<a> c() {
            switch (this) {
                case d: 
                case e: {
                    return new Comparator<a>(){

                        public int a(a a2, a a3) {
                            File file = (File)a2.a.get("BundleFolder");
                            File file2 = (File)a3.a.get("BundleFolder");
                            String[] stringArray = file.getName().split("_");
                            String[] stringArray2 = file2.getName().split("_");
                            Long l2 = new Long(0L);
                            if (stringArray != null && stringArray.length > 0) {
                                l2 = Long.parseLong(stringArray[0]);
                            }
                            Long l3 = new Long(0L);
                            if (stringArray2 != null && stringArray2.length > 0) {
                                l3 = Long.parseLong(stringArray2[0]);
                            }
                            return l2.compareTo(l3);
                        }

                        @Override
                        public /* synthetic */ int compare(Object object, Object object2) {
                            return this.a((a)object, (a)object2);
                        }
                    };
                }
                case f: {
                    return new Comparator<a>(){

                        public int a(a a2, a a3) {
                            Integer n2 = (Integer)a2.a.get("BundleSize");
                            Integer n3 = (Integer)a3.a.get("BundleSize");
                            System.out.println("Compare: " + n2 + " to " + n3 + ": " + n2.compareTo(n3));
                            return n2.compareTo(n3);
                        }

                        @Override
                        public /* synthetic */ int compare(Object object, Object object2) {
                            return this.a((a)object, (a)object2);
                        }
                    };
                }
            }
            final String string = this.name();
            return new Comparator<a>(){

                public int a(a a2, a a3) {
                    String string3 = (String)a2.a.get(string);
                    String string2 = (String)a3.a.get(string);
                    if (string3 == null) {
                        string3 = "";
                    }
                    if (string2 == null) {
                        string2 = "";
                    }
                    return string3.compareToIgnoreCase(string2);
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((a)object, (a)object2);
                }
            };
        }
    }
}

