/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.iphone;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.iphone.g;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.logging.a.c;
import com.mimvista.util.logging.a.f;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class IphoneDeviceManagementGui
extends Box {
    private static final long serialVersionUID = 6502457436540653363L;
    private static Messages a = Messages.a("Iphone");
    private HttpClient client = new HttpClient();
    private c log = new c(new f(IphoneDeviceManagementGui.class));
    private final boolean forIpad;
    private DeviceModel activeModel = new DeviceModel();
    private DeviceModel inactiveModel = new DeviceModel();
    private JXTable activeTable = new JXTable((TableModel)this.activeModel, (TableColumnModel)new DeviceTableColumnModel());
    private JXTable inactiveTable = new JXTable((TableModel)this.inactiveModel, (TableColumnModel)new DeviceTableColumnModel());
    private JButton xmoteButton = new JButton(new PromoteAction());
    private JButton deleteButton = new JButton(new DeleteAction());
    private JButton editButton = new JButton(new EditCommentAction());
    private Timer refreshTimer = new Timer(5000, new a());
    private int numDevices = 0;
    private TitledBorder activeBorder;

    public IphoneDeviceManagementGui(boolean bl2) {
        super(3);
        this.forIpad = bl2;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.activeTable.setSelectionMode(0);
        this.inactiveTable.setSelectionMode(0);
        this.c();
    }

    private void c() {
        this.activeTable.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                IphoneDeviceManagementGui.this.inactiveTable.clearSelection();
            }
        });
        this.inactiveTable.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                IphoneDeviceManagementGui.this.activeTable.clearSelection();
            }
        });
        this.activeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (IphoneDeviceManagementGui.this.activeTable.getSelectedRowCount() > 0) {
                    IphoneDeviceManagementGui.this.xmoteButton.setAction(new DemoteAction());
                    IphoneDeviceManagementGui.this.deleteButton.setAction(new DeleteAction());
                    IphoneDeviceManagementGui.this.editButton.setAction(new EditCommentAction());
                }
            }
        });
        this.inactiveTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (IphoneDeviceManagementGui.this.inactiveTable.getSelectedRowCount() > 0) {
                    IphoneDeviceManagementGui.this.xmoteButton.setAction(new PromoteAction());
                    IphoneDeviceManagementGui.this.deleteButton.setAction(new DeleteAction());
                    IphoneDeviceManagementGui.this.editButton.setAction(new EditCommentAction());
                }
            }
        });
    }

    private TableCellRenderer d() {
        return new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 2972301877966897177L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                DeviceModel deviceModel = (DeviceModel)jTable.getModel();
                defaultTableCellRenderer.setToolTipText(this.a(deviceModel.devices.get(n2)));
                return defaultTableCellRenderer;
            }

            private String a(g.a a2) {
                String string = "<html><table>";
                string = string + "<tr><td><b>" + DeviceColumn.a.a() + "</b></td><td>" + IphoneDeviceManagementGui.this.a(a2) + "</td></tr>";
                string = string + "<tr><td><b>" + DeviceColumn.b.a() + "</b></td><td>" + a2.description + "</td></tr>";
                String string2 = a2.comment;
                if (string2 != null) {
                    string = string + "<tr><td><b>" + DeviceColumn.c.a() + "</b></td><td>" + string2 + "</td></tr>";
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a");
                string = string + "<tr><td><b>" + DeviceColumn.d.a() + "</b></td><td>" + simpleDateFormat.format(new Date(a2.lastActivity)) + "</td></tr>";
                string = string + "<tr><td><b>" + DeviceColumn.e.a() + "</b></td><td>" + simpleDateFormat.format(new Date(a2.firstActivity)) + "</td></tr>";
                return string + "</table></html>";
            }
        };
    }

    public void a() {
        try {
            boolean bl2 = this.g();
            if (bl2) {
                this.e();
            } else {
                this.h();
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, this);
            this.h();
        }
    }

    private void e() {
        JScrollPane jScrollPane = new JScrollPane((Component)this.activeTable);
        this.activeBorder = BorderFactory.createTitledBorder("");
        this.f();
        jScrollPane.setBorder(this.activeBorder);
        JScrollPane jScrollPane2 = new JScrollPane((Component)this.inactiveTable);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(a.getProperty("DEVICE_INACTIVE")));
        jScrollPane.setMinimumSize(new Dimension(100, 160));
        jScrollPane.setMaximumSize(new Dimension(1000, 160));
        jScrollPane.setPreferredSize(new Dimension(1000, 160));
        jScrollPane2.setMinimumSize(new Dimension(100, 160));
        jScrollPane2.setMaximumSize(new Dimension(1000, 160));
        jScrollPane2.setPreferredSize(new Dimension(1000, 160));
        this.add(jScrollPane);
        this.add(Box.createVerticalStrut(5));
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.xmoteButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.editButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.deleteButton);
        box.add(Box.createHorizontalGlue());
        this.add(box);
        this.add(Box.createVerticalStrut(5));
        this.add(jScrollPane2);
        this.refreshTimer.start();
    }

    private void f() {
        if (this.activeBorder != null) {
            String string = MIMFormat.a(a.getProperty("DEVICE_ACTIVE"), this.activeModel.devices.size(), this.numDevices);
            JScrollPane jScrollPane = (JScrollPane)this.activeTable.getParent().getParent();
            this.activeBorder = new TitledBorder(string);
            jScrollPane.setBorder(this.activeBorder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean g() {
        GetMethod getMethod = new GetMethod("https://127.0.0.1:17199/manage" + (this.forIpad ? "_pad" : ""));
        try {
            this.client.executeMethod((HttpMethod)getMethod);
            if (getMethod.getStatusCode() != 200) {
                this.log.c("Received error code 200 when fetching device list.");
                boolean bl2 = false;
                return bl2;
            }
            this.a((HttpMethod)getMethod);
            boolean bl3 = true;
            return bl3;
        }
        catch (IOException iOException) {
            this.log.c("Can't fetch devices list", iOException);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, g.a a2, boolean bl2) {
        if (a2 == null) {
            return;
        }
        PostMethod postMethod = new PostMethod("https://127.0.0.1:17199/manage" + (this.forIpad ? "_pad" : "") + "/" + string);
        postMethod.setRequestBody(new GsonBuilder().create().toJson((Object)a2));
        try {
            this.client.executeMethod((HttpMethod)postMethod);
            if (postMethod.getStatusCode() != 200) {
                this.log.c("Received error code 200 performing " + string + " action.");
                this.h();
                return;
            }
            if (bl2) {
                this.a((HttpMethod)postMethod);
            }
            return;
        }
        catch (IOException iOException) {
            this.log.c(iOException);
            this.h();
            return;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    private void a(String string, g.a a2) {
        this.a(string, a2, true);
    }

    private void a(HttpMethod httpMethod) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpMethod.getResponseBodyAsStream()));
        String string = bufferedReader.readLine();
        String string2 = bufferedReader.readLine();
        Map map = (Map)new GsonBuilder().create().fromJson(string, new TypeToken<Map<String, List<g.a>>>(){}.getType());
        this.numDevices = Integer.valueOf(string2.split(":")[1]);
        final List list = (List)map.get("active");
        final List list2 = (List)map.get("denied");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IphoneDeviceManagementGui.this.inactiveModel.a(list2);
                IphoneDeviceManagementGui.this.activeModel.a(list);
                IphoneDeviceManagementGui.this.f();
                IphoneDeviceManagementGui.this.a(IphoneDeviceManagementGui.this.xmoteButton);
                IphoneDeviceManagementGui.this.a(IphoneDeviceManagementGui.this.deleteButton);
                IphoneDeviceManagementGui.this.a(IphoneDeviceManagementGui.this.editButton);
            }
        });
    }

    private void a(JButton jButton) {
        Action action = jButton.getAction();
        jButton.setAction(null);
        jButton.setAction(action);
    }

    private void h() {
        this.removeAll();
        this.add(new JLabel(a.getProperty("DEVICE_CANNOT_TALK_TO_SERVER")));
        if (this.getParent() != null) {
            this.getParent().invalidate();
            this.getParent().validate();
        }
    }

    private g.a i() {
        if (this.activeTable.getSelectedRowCount() == 1) {
            return this.activeModel.devices.get(this.activeTable.convertRowIndexToModel(this.activeTable.getSelectedRow()));
        }
        if (this.inactiveTable.getSelectedRowCount() == 1) {
            return this.inactiveModel.devices.get(this.inactiveTable.convertRowIndexToModel(this.inactiveTable.getSelectedRow()));
        }
        return null;
    }

    private String a(g.a a2) {
        return a2.deviceID.length() < 8 ? a2.deviceID : a2.deviceID.substring(0, 8);
    }

    private class a
    implements ActionListener {
        private a() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IphoneDeviceManagementGui.this.isDisplayable()) {
                ay.e("stopping refresh timer");
                IphoneDeviceManagementGui.this.refreshTimer.stop();
                return;
            }
            if (!IphoneDeviceManagementGui.this.g()) {
                IphoneDeviceManagementGui.this.refreshTimer.stop();
            }
        }
    }

    private class EditCommentAction
    extends AbstractAction {
        private static final long serialVersionUID = 2885521900794459976L;

        EditCommentAction() {
            super(a.getProperty("DEVICE_EDIT_COMMENT"), com.mimvista.gui.util.c.b("EDIT_BUTTON_ICON"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            g.a a2 = IphoneDeviceManagementGui.this.i();
            String string2 = a2.comment;
            if (string2 == null) {
                string2 = "";
            }
            if ((string = JOptionPane.showInputDialog(IphoneDeviceManagementGui.this.editButton, this.getValue("Name"), string2)) == null) {
                return;
            }
            a2.comment = string;
            IphoneDeviceManagementGui.this.a("save", a2, false);
            IphoneDeviceManagementGui.this.activeModel.fireTableDataChanged();
            IphoneDeviceManagementGui.this.inactiveModel.fireTableDataChanged();
        }

        @Override
        public boolean isEnabled() {
            return IphoneDeviceManagementGui.this.activeTable.getSelectedRowCount() + IphoneDeviceManagementGui.this.inactiveTable.getSelectedRowCount() == 1;
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = -5344160207255342405L;

        DeleteAction() {
            super(Messages.a("ButtonFactory", "DELETE_BUTTON"), com.mimvista.gui.util.c.b("DELETE_BUTTON_ICON"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IphoneDeviceManagementGui.this.a("delete", IphoneDeviceManagementGui.this.i());
        }

        @Override
        public boolean isEnabled() {
            return IphoneDeviceManagementGui.this.activeTable.getSelectedRowCount() + IphoneDeviceManagementGui.this.inactiveTable.getSelectedRowCount() == 1;
        }
    }

    private class DemoteAction
    extends AbstractAction {
        private static final long serialVersionUID = 672803478674817283L;

        DemoteAction() {
            super(a.getProperty("DEVICE_DEACTIVATE"), ImageManipulator.c("arrow_down", 18, 18));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IphoneDeviceManagementGui.this.a("demote", IphoneDeviceManagementGui.this.i());
        }

        @Override
        public boolean isEnabled() {
            return IphoneDeviceManagementGui.this.activeTable.getSelectedRowCount() == 1;
        }
    }

    private class PromoteAction
    extends AbstractAction {
        private static final long serialVersionUID = 542833670211338290L;

        PromoteAction() {
            super(a.getProperty("DEVICE_ACTIVATE"), ImageManipulator.c("arrow_up", 18, 18));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IphoneDeviceManagementGui.this.a("promote", IphoneDeviceManagementGui.this.i());
        }

        @Override
        public boolean isEnabled() {
            boolean bl2 = ((IphoneDeviceManagementGui)IphoneDeviceManagementGui.this).activeModel.devices.size() < IphoneDeviceManagementGui.this.numDevices;
            return IphoneDeviceManagementGui.this.inactiveTable.getSelectedRowCount() == 1 && bl2;
        }
    }

    private class DeviceModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4386055675222703249L;
        List<g.a> devices = Lists.newArrayList();

        private DeviceModel() {
        }

        public void a(List<g.a> list) {
            Collections.sort(list, Ordering.natural().onResultOf((Function)new Function<g.a, Long>(){

                public Long a(g.a a2) {
                    return -a2.lastActivity;
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((g.a)object);
                }
            }));
            this.devices = list;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return this.devices.size();
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            g.a a2 = this.devices.get(n2);
            switch (DeviceColumn.a(n3)) {
                case b: {
                    return a2.description;
                }
                case c: {
                    return a2.comment;
                }
                case d: {
                    return new SimpleDateFormat("yyyy-MM-dd").format(new Date(a2.lastActivity));
                }
                case e: {
                    return new SimpleDateFormat("yyyy-MM-dd").format(new Date(a2.firstActivity));
                }
                case a: {
                    return IphoneDeviceManagementGui.this.a(a2);
                }
            }
            return "WHAA?";
        }

        @Override
        public void fireTableDataChanged() {
            JXTable jXTable = this == IphoneDeviceManagementGui.this.activeModel ? IphoneDeviceManagementGui.this.activeTable : IphoneDeviceManagementGui.this.inactiveTable;
            int n2 = jXTable.getSelectedRow();
            g.a a2 = null;
            if (n2 >= 0 && n2 < this.devices.size()) {
                n2 = jXTable.convertRowIndexToModel(n2);
                a2 = this.devices.get(n2);
            }
            super.fireTableDataChanged();
            if (a2 != null && this.devices.contains(a2)) {
                int n3 = jXTable.convertRowIndexToView(this.devices.indexOf(a2));
                jXTable.setRowSelectionInterval(n3, n3);
            } else if (n2 >= 0 && !this.devices.isEmpty()) {
                n2 = jXTable.convertRowIndexToModel(Math.min(n2, this.devices.size() - 1));
                jXTable.setRowSelectionInterval(n2, n2);
            }
        }
    }

    private class DeviceTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 1L;

        public DeviceTableColumnModel() {
            DeviceColumn[] deviceColumnArray = DeviceColumn.values();
            for (int i2 = 0; i2 < deviceColumnArray.length; ++i2) {
                TableColumnExt tableColumnExt = new TableColumnExt(i2);
                tableColumnExt.setCellRenderer(IphoneDeviceManagementGui.this.d());
                tableColumnExt.setHeaderValue(deviceColumnArray[i2].a());
                tableColumnExt.setPreferredWidth(deviceColumnArray[i2].b());
                this.addColumn((TableColumn)tableColumnExt);
            }
        }
    }

    private static enum DeviceColumn {
        a("DEVICE_ID", 75),
        b("DEVICE_DESCRIPTION", 125),
        c("DEVICE_COMMENT", 125),
        d("DEVICE_LAST_ACTIVITY", 100),
        e("DEVICE_FIRST_ACTIVITY", 100);

        String labelKey;
        int width;

        private DeviceColumn(String string2, int n3) {
            this.labelKey = string2;
            this.width = n3;
        }

        protected String a() {
            return a.getProperty(this.labelKey);
        }

        protected int b() {
            return this.width;
        }

        protected static DeviceColumn a(int n2) {
            return DeviceColumn.values()[n2];
        }
    }
}

