/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.license;

import com.mimvista.ExternallyVisible;
import com.mimvista.file.MIMFile;
import com.mimvista.license.AsymEncryptedEnvelope;
import com.mimvista.license.KeyBox;
import com.mimvista.license.LicenseRecorder;
import com.mimvista.license.db.License;
import com.mimvista.license.db.Usage;
import com.mimvista.util.ay;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;

@ExternallyVisible
public class ClientLicense
implements Serializable {
    private static final long serialVersionUID = 1L;
    public LicenseRecorder record = new LicenseRecorder();
    public Calendar lastContact = null;
    public String siteName = null;
    private boolean validAtAll = false;
    private PublicKey serverKey = null;
    private KeyBox authServerKeyBox = null;
    public Set<License> lastUsedLicenses = new HashSet<License>();
    public static final long daysValid = 14L;
    public static final int viewsValid = 30;
    public static final int usagesValid = 30;
    private Set<License> licenses = new HashSet<License>();

    public void setServerKey(PublicKey publicKey) {
        this.serverKey = publicKey;
    }

    public PublicKey getServerKey() {
        return this.serverKey;
    }

    public Calendar getLastValidTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.lastContact.getTimeInMillis() + 1209600000L);
        return calendar;
    }

    public int getRemainingUsages(String string) {
        int n2 = this.getUnreportedUsages(string);
        return 30 - n2;
    }

    public int getUnreportedUsages(String string) {
        int n2 = 0;
        for (Usage usage : this.record.b()) {
            if (!usage.getCode().equals(string)) continue;
            ++n2;
        }
        return n2;
    }

    public int getRemainingViews() {
        return 30 - this.record.a().size();
    }

    public int getUsedUsages() {
        return this.record.b().size();
    }

    public int getUsedViews() {
        return this.record.a().size();
    }

    public void setValidAtAll(boolean bl2) {
        this.validAtAll = bl2;
    }

    public void setAuthServerKeyBox(KeyBox keyBox) {
        this.authServerKeyBox = keyBox;
    }

    public KeyBox getAuthServerKeyBox() {
        return this.authServerKeyBox;
    }

    public boolean isStillValid(String string) {
        if (!this.validAtAll) {
            return false;
        }
        if (this.lastContact == null) {
            return false;
        }
        if (this.lastContact.getTimeInMillis() + 1209600000L < Calendar.getInstance().getTimeInMillis()) {
            return false;
        }
        return this.getUnreportedUsages(string) <= 30;
    }

    public void setLicenses(Set<License> set) {
        this.licenses = set;
    }

    public Set<License> getLicenses() {
        return this.licenses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveLicense(SecretKey secretKey, String string) {
        FileOutputStream fileOutputStream = null;
        try {
            AsymEncryptedEnvelope<ClientLicense> asymEncryptedEnvelope = new AsymEncryptedEnvelope<ClientLicense>(this, secretKey);
            MIMFile mIMFile = new MIMFile(string).g();
            if (mIMFile != null) {
                mIMFile.mkdirs();
            }
            fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(asymEncryptedEnvelope);
            objectOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            ay.d((Object)"Saving license", (Throwable)iOException, this);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    ay.d((Object)"Saving license", (Throwable)iOException, this);
                }
            }
        }
        return true;
    }
}

