/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.license;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.license.LicenseManager;
import com.mimvista.license.LicenseManagerImpl;
import com.mimvista.license.LicenseReferee;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.license.db.Usage;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.LicensingPrefs;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class ConcurrentLicenseManagementGui
extends Box {
    private static final long serialVersionUID = -2843573968255980541L;
    private static Messages a = Messages.a("License");
    private com.mimvista.util.logging.a.c log = ay.b(ConcurrentLicenseManagementGui.class);
    private LicenseComboBoxModel licenseModel = new LicenseComboBoxModel();
    private JComboBox licenseCombo = new JComboBox(this.licenseModel);
    private MachineModel activeModel = new MachineModel();
    private JXTable activeTable = new JXTable((TableModel)this.activeModel, (TableColumnModel)new MachineTableColumnModel());
    private JButton kickButton;
    private Timer refreshTimer = new Timer(5000, new d());

    public ConcurrentLicenseManagementGui() {
        super(3);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public void a() {
        try {
            if (this.d()) {
                this.f();
            } else {
                this.c();
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, this);
            this.c();
        }
    }

    private void c() {
        this.removeAll();
        this.add(new JLabel("<html>" + a.getProperty("LICENSE_MANAGE_CANNOT_TALK") + "</html>"));
        if (this.getParent() != null) {
            this.getParent().invalidate();
            this.getParent().validate();
        }
    }

    private boolean d() {
        LicenseManager licenseManager = this.e();
        if (licenseManager == null) {
            return false;
        }
        Collection<LicenseReferee> collection = null;
        Map<String, Long> map = null;
        try {
            if (licenseManager.isLicensed()) {
                collection = licenseManager.getLicenseReferees();
                map = licenseManager.getMachinesBeingKicked();
            }
        }
        catch (RemoteException remoteException) {
            this.log.d(remoteException);
            return false;
        }
        if (collection == null) {
            return false;
        }
        this.a(collection, map);
        this.a(collection);
        return true;
    }

    private void a(Collection<LicenseReferee> collection, Map<String, Long> map) {
        ArrayList arrayList = Lists.newArrayList();
        for (LicenseReferee licenseReferee : collection) {
            LicenseOption licenseOption = LicenseTransformer.networkToLocalByCode(licenseReferee.a());
            for (HashMap<String, Usage> hashMap : licenseReferee.f().values()) {
                for (Usage usage : hashMap.values()) {
                    b b2 = new b(usage);
                    b2.h = map.containsKey(b2.b);
                    if (arrayList.contains(b2)) {
                        ((b)Iterables.find((Iterable)arrayList, (Predicate)Predicates.equalTo((Object)b2))).a(b2);
                        continue;
                    }
                    arrayList.add(b2);
                }
            }
        }
        this.activeModel.a(arrayList);
    }

    private void a(Collection<LicenseReferee> collection) {
        c c2 = (c)this.licenseCombo.getSelectedItem();
        if (c2 == null) {
            c2 = new c(LicenseOption.a, 0, 0);
        }
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new c(LicenseOption.a, 0, 0));
        for (LicenseReferee licenseReferee : collection) {
            arrayList.add(new c(LicenseTransformer.networkToLocalByCode(licenseReferee.a()), licenseReferee.seats, licenseReferee.maxSeats));
        }
        Collections.sort(arrayList);
        this.licenseModel.a(arrayList);
        if (!arrayList.contains(c2)) {
            c2 = (c)arrayList.get(0);
        }
        this.licenseCombo.setSelectedItem(c2);
    }

    private LicenseManager e() {
        com.mimvista.rmi.a a2 = new com.mimvista.rmi.a();
        a2.a("127.0.0.1").a(13913).b(13913).b("MIMLicense").a(LicenseManagerImpl.class);
        try {
            LicenseManager licenseManager = (LicenseManager)a2.a();
            return licenseManager;
        }
        catch (RemoteException remoteException) {
            this.log.a(remoteException);
        }
        catch (NotBoundException notBoundException) {
            this.log.a(notBoundException);
        }
        return null;
    }

    private void f() {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(a.getProperty("LICENSE_MANAGE_FILTER")));
        box.add(Box.createHorizontalStrut(5));
        box.add(this.licenseCombo);
        this.licenseCombo.addActionListener(new a());
        box.add(Box.createHorizontalGlue());
        this.kickButton = new JButton(new KickAction());
        box.add(this.kickButton);
        this.activeTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane((Component)this.activeTable);
        jScrollPane.setMinimumSize(new Dimension(100, 320));
        jScrollPane.setMaximumSize(new Dimension(1000, 320));
        jScrollPane.setPreferredSize(new Dimension(1000, 320));
        this.add(box);
        this.add(Box.createVerticalStrut(5));
        this.add(jScrollPane);
        this.activeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ConcurrentLicenseManagementGui.this.activeTable.getSelectedRowCount() == 0) {
                    ConcurrentLicenseManagementGui.this.kickButton.setEnabled(false);
                } else if (((ConcurrentLicenseManagementGui)ConcurrentLicenseManagementGui.this).h().h) {
                    ConcurrentLicenseManagementGui.this.kickButton.setAction(new UnkickAction());
                } else {
                    ConcurrentLicenseManagementGui.this.kickButton.setAction(new KickAction());
                }
            }
        });
        this.refreshTimer.start();
    }

    private TableCellRenderer g() {
        return new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -6847160633220659628L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                MachineModel machineModel = (MachineModel)jTable.getModel();
                defaultTableCellRenderer.setToolTipText(this.a(machineModel.machines.get(n2)));
                return defaultTableCellRenderer;
            }

            private String a(b b2) {
                String string = "<html><table>";
                string = string + "<tr><td><b>" + MachineColumn.a.a() + "</b></td><td>" + b2.b + "</td></tr>";
                string = string + "<tr><td><b>" + MachineColumn.d.a() + "</b></td><td>" + b2.d + "</td></tr>";
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a");
                String string2 = simpleDateFormat.format(new Date(b2.f));
                if (b2.f == 0L) {
                    string2 = a.getProperty("MACHINE_NOT_AVAILABLE");
                }
                String string3 = b2.c == null ? a.getProperty("MACHINE_NOT_AVAILABLE") : b2.c;
                string = string + "<tr><td><b>" + MachineColumn.c.a() + "</b></td><td>" + string3 + "</td></tr>";
                string = string + "<tr><td><b>" + MachineColumn.e.a() + "</b></td><td>" + string2 + "</td></tr>";
                string = string + "<tr><td><b>" + a.getProperty("MACHINE_LAST_CONTACT") + "</b></td><td>" + simpleDateFormat.format(new Date(b2.g)) + "</td></tr>";
                string = string + "<tr><td valign=top><b>" + a.getProperty("MACHINE_LICENSES_USED") + "</b></td><td>" + b2.b() + " </td></tr>";
                return string + "</table></html>";
            }
        };
    }

    private b h() {
        int n2 = this.activeTable.getSelectedRow();
        if (n2 == -1) {
            return null;
        }
        n2 = this.activeTable.convertRowIndexToModel(n2);
        return this.activeModel.machines.get(n2);
    }

    private class d
    implements ActionListener {
        private d() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ConcurrentLicenseManagementGui.this.isDisplayable()) {
                ay.e("stopping refresh timer");
                ConcurrentLicenseManagementGui.this.refreshTimer.stop();
                return;
            }
            if (!ConcurrentLicenseManagementGui.this.d()) {
                ConcurrentLicenseManagementGui.this.refreshTimer.stop();
            }
        }
    }

    private class KickAction
    extends AbstractAction {
        private static final long serialVersionUID = -4860363694199965706L;

        public KickAction() {
            super(a.getProperty("LICENSE_MANAGE_KICK_MACHINE"), ImageManipulator.a("remove", 18));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            b b2 = ConcurrentLicenseManagementGui.this.h();
            if (b2 == null) {
                return;
            }
            String string = this.a();
            if (string == null) {
                return;
            }
            try {
                ConcurrentLicenseManagementGui.this.e().kickUser(b2.b, string);
                ConcurrentLicenseManagementGui.this.d();
            }
            catch (RemoteException remoteException) {
                ConcurrentLicenseManagementGui.this.log.a(remoteException);
            }
        }

        private String a() {
            String string = a.getProperty("LICENSE_MANAGE_KICK_MESSAGE");
            final JDialog jDialog = new JDialog(SwingUtilities.getWindowAncestor(ConcurrentLicenseManagementGui.this));
            jDialog.setDefaultCloseOperation(0);
            jDialog.setModal(true);
            jDialog.setTitle((String)this.getValue("Name"));
            Box box = new Box(1){
                private static final long serialVersionUID = -8624938880434359920L;

                @Override
                public Insets getInsets() {
                    return new Insets(10, 10, 10, 10);
                }
            };
            final JButton jButton = com.mimvista.gui.util.c.c(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            }, null);
            final JTextArea jTextArea = new JTextArea();
            jTextArea.setMinimumSize(new Dimension(400, 200));
            jTextArea.setPreferredSize(new Dimension(400, 200));
            jTextArea.setBorder(BorderFactory.createTitledBorder(string));
            String string2 = a.getProperty("LICENSE_MANAGE_DEFAULT_MESSAGE");
            string2 = LicensingPrefs.lastKickMessage.getValue();
            string2 = string2.replaceAll("~!~", "\n");
            jTextArea.setText(string2);
            jTextArea.selectAll();
            MIMSwingUtils.a((JTextComponent)jTextArea, new FuncUtils.m<String>(){

                public void a(String string) {
                    jButton.setEnabled(!string.isEmpty());
                }

                @Override
                public /* synthetic */ void doIt(Object object) {
                    this.a((String)object);
                }
            });
            box.add(jTextArea);
            box.add(Box.createVerticalStrut(5));
            Box box2 = Box.createHorizontalBox();
            box2.add(Box.createHorizontalGlue());
            box2.add(jButton);
            box2.add(Box.createHorizontalStrut(5));
            box2.add(com.mimvista.gui.util.c.a(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jTextArea.setText("");
                    jDialog.dispose();
                }
            }, null));
            box2.add(Box.createHorizontalStrut(5));
            box.add(box2);
            box.add(Box.createVerticalStrut(5));
            jDialog.getContentPane().add(box);
            jDialog.pack();
            MIMSwingUtils.a((Component)jDialog);
            jDialog.setVisible(true);
            String string3 = jTextArea.getText();
            if (string3.isEmpty()) {
                return null;
            }
            LicensingPrefs.lastKickMessage.setValue(string3.replaceAll("\n", "~!~").replaceAll("\r", ""));
            return string3;
        }

        @Override
        public boolean isEnabled() {
            b b2 = ConcurrentLicenseManagementGui.this.h();
            return b2 != null && !b2.h;
        }
    }

    private class UnkickAction
    extends AbstractAction {
        private static final long serialVersionUID = -5084182317759791427L;

        public UnkickAction() {
            super(a.getProperty("LICENSE_MANAGE_UNKICK_MACHINE"), ImageManipulator.a("remove", 18));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            b b2 = ConcurrentLicenseManagementGui.this.h();
            if (b2 == null) {
                return;
            }
            try {
                ConcurrentLicenseManagementGui.this.e().unkickUser(b2.b);
                ConcurrentLicenseManagementGui.this.d();
            }
            catch (RemoteException remoteException) {
                ConcurrentLicenseManagementGui.this.log.a(remoteException);
            }
        }

        @Override
        public boolean isEnabled() {
            b b2 = ConcurrentLicenseManagementGui.this.h();
            return b2 != null && b2.h;
        }
    }

    private class a
    implements ActionListener {
        private a() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConcurrentLicenseManagementGui.this.activeModel.a();
        }
    }

    private class LicenseComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = -8666244811649805196L;

        public LicenseComboBoxModel() {
            super(new c[]{new c(LicenseOption.a, 0, 0)});
        }

        void a(List<c> list) {
            this.removeAllElements();
            for (c c2 : list) {
                this.addElement(c2);
            }
        }
    }

    private class MachineTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 1L;

        public MachineTableColumnModel() {
            MachineColumn[] machineColumnArray = MachineColumn.values();
            for (int i2 = 0; i2 < machineColumnArray.length; ++i2) {
                TableColumnExt tableColumnExt = new TableColumnExt(i2);
                tableColumnExt.setCellRenderer(ConcurrentLicenseManagementGui.this.g());
                tableColumnExt.setHeaderValue(machineColumnArray[i2].a());
                tableColumnExt.setPreferredWidth(machineColumnArray[i2].b());
                this.addColumn((TableColumn)tableColumnExt);
            }
        }
    }

    private static enum MachineColumn {
        a("MACHINE_ID", 100),
        b("MACHINE_PRODUCT", 100),
        c("MACHINE_USERNAME", 125),
        d("MACHINE_NICKNAME", 125),
        e("MACHINE_LAST_ACTIVITY", 100),
        f("MACHINE_BEING_KICKED", 50);

        String labelKey;
        int width;

        private MachineColumn(String string2, int n3) {
            this.labelKey = string2;
            this.width = n3;
        }

        protected String a() {
            return a.getProperty(this.labelKey);
        }

        protected int b() {
            return this.width;
        }

        protected static MachineColumn a(int n2) {
            return MachineColumn.values()[n2];
        }
    }

    private class MachineModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4064399135031365225L;
        List<b> allMachines = Lists.newArrayList();
        List<b> machines = Lists.newArrayList();

        private MachineModel() {
        }

        public void a(List<b> list) {
            Collections.sort(list, Ordering.natural().onResultOf((Function)new Function<b, String>(){

                public String a(b b2) {
                    return b2.b.toUpperCase().replace('-', ':');
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((b)object);
                }
            }));
            this.allMachines = list;
            this.a();
        }

        void a() {
            if (ConcurrentLicenseManagementGui.this.licenseCombo.getItemCount() == 0 || ConcurrentLicenseManagementGui.this.licenseCombo.getSelectedIndex() == -1) {
                return;
            }
            if (ConcurrentLicenseManagementGui.this.licenseCombo.getSelectedIndex() == 0) {
                this.machines = this.allMachines;
            } else {
                final LicenseOption licenseOption = ((c)((ConcurrentLicenseManagementGui)ConcurrentLicenseManagementGui.this).licenseCombo.getSelectedItem()).a;
                this.machines = Lists.newArrayList((Iterable)Iterables.filter(this.allMachines, (Predicate)new Predicate<b>(){

                    public boolean a(b b2) {
                        return b2.e.contains(licenseOption);
                    }

                    public /* synthetic */ boolean apply(Object object) {
                        return this.a((b)object);
                    }
                }));
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public int getRowCount() {
            return this.machines.size();
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            if (n2 < 0 || n2 >= this.machines.size()) {
                this.fireTableDataChanged();
                return null;
            }
            b b2 = this.machines.get(n2);
            switch (MachineColumn.a(n3)) {
                case a: {
                    return b2.b.toUpperCase().replace('-', ':');
                }
                case d: {
                    return b2.d;
                }
                case e: {
                    if (b2.f > 0L) {
                        return new SimpleDateFormat("h:mm a").format(new Date(b2.f));
                    }
                    return a.getProperty("MACHINE_NOT_AVAILABLE");
                }
                case c: {
                    if (b2.c != null && !b2.c.isEmpty()) {
                        return b2.c;
                    }
                    return a.getProperty("MACHINE_NOT_AVAILABLE");
                }
                case b: {
                    return b2.a();
                }
                case f: {
                    if (b2.h) {
                        return Messages.a("General").getProperty("YES");
                    }
                    return "";
                }
            }
            return "WHAA?";
        }

        @Override
        public void fireTableDataChanged() {
            JXTable jXTable = this == ConcurrentLicenseManagementGui.this.activeModel ? ConcurrentLicenseManagementGui.this.activeTable : null;
            int n2 = jXTable.getSelectedRow();
            b b2 = null;
            if (n2 > -1 && n2 < this.machines.size() && (n2 = jXTable.convertRowIndexToModel(n2)) > -1 && n2 < this.machines.size()) {
                b2 = this.machines.get(n2);
            }
            super.fireTableDataChanged();
            if (b2 != null && this.machines.contains(b2)) {
                int n3 = jXTable.convertRowIndexToView(this.machines.indexOf(b2));
                jXTable.setRowSelectionInterval(n3, n3);
            } else if (n2 >= 0 && !this.machines.isEmpty()) {
                n2 = jXTable.convertRowIndexToModel(Math.min(n2, this.machines.size() - 1));
                jXTable.setRowSelectionInterval(n2, n2);
            }
        }
    }

    private class b {
        boolean a = true;
        String b;
        String c;
        String d;
        List<LicenseOption> e = Lists.newArrayList();
        long f = 0L;
        long g;
        boolean h = false;

        String a() {
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            for (LicenseOption licenseOption : this.e) {
                String string = LicenseTransformer.localToNetwork(licenseOption);
                if (string.startsWith("MIM_")) {
                    bl2 = true;
                    continue;
                }
                if (string.startsWith("MV_")) {
                    bl3 = true;
                    continue;
                }
                if (!string.startsWith("SVC_")) continue;
                bl4 = true;
            }
            ArrayList arrayList = Lists.newArrayList();
            if (bl2) {
                arrayList.add("MIM");
            }
            if (bl3) {
                arrayList.add("MIMviewer");
            }
            if (bl4) {
                arrayList.add("MIMpacs");
            }
            return Joiner.on((String)", ").join((Iterable)arrayList);
        }

        b(Usage usage) {
            LicenseOption licenseOption;
            this.b = usage.getMacAddress();
            this.d = usage.getMachineNickname();
            this.g = usage.getUsed().getTimeInMillis();
            if (usage.getLastUITime() != null) {
                this.f = usage.getLastUITime();
            }
            if (usage.getUserName() != null && !usage.getUserName().isEmpty()) {
                this.c = usage.getUserName();
            }
            if (!this.e.contains(licenseOption = LicenseTransformer.networkToLocalByCode(usage.getCode()))) {
                this.e.add(licenseOption);
            }
        }

        void a(b b2) {
            this.d = this.a(this.d, b2.d, b2);
            this.c = this.a(this.c, b2.c, b2);
            this.g = Math.max(this.g, b2.g);
            this.f = Math.max(this.f, b2.f);
            this.e.removeAll(b2.e);
            this.e.addAll(b2.e);
        }

        private String a(String string, String string2, b b2) {
            if (string == null) {
                return string2;
            }
            if (string2 != null && b2.g > this.g) {
                return string2;
            }
            return string;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.c().hashCode();
            n3 = 31 * n3 + (this.b == null ? 0 : this.b.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            b b2 = (b)object;
            if (!this.c().equals(b2.c())) {
                return false;
            }
            return !(this.b == null ? b2.b != null : !this.b.equals(b2.b));
        }

        private ConcurrentLicenseManagementGui c() {
            return ConcurrentLicenseManagementGui.this;
        }

        public String b() {
            List list = Ordering.natural().sortedCopy(this.e);
            Iterable iterable = Iterables.transform((Iterable)list, (Function)new Function<LicenseOption, String>(){

                public String a(LicenseOption licenseOption) {
                    if (licenseOption.b() != null) {
                        return licenseOption.b();
                    }
                    return licenseOption.name();
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((LicenseOption)object);
                }
            });
            return Joiner.on((String)"<br>").join(iterable);
        }
    }

    private class c
    implements Comparable<c> {
        LicenseOption a;
        int b;
        int c;

        public c(LicenseOption licenseOption, int n2, int n3) {
            this.a = licenseOption;
            this.b = n2;
            this.c = n3;
        }

        public String toString() {
            if (this.a == LicenseOption.a) {
                return a.getProperty("LICENSE_MANAGE_ANY_LICENSE");
            }
            String string = this.a.b();
            if (string == null) {
                string = this.a.toString();
            }
            if (this.a == LicenseOption.b) {
                string = "MIM";
            } else if (this.a == LicenseOption.m) {
                string = "MIMviewer";
            }
            return MIMFormat.a(a.getProperty("LICENSE_MANAGE_LICENSE_SEATS"), string, this.b);
        }

        public int a(c c2) {
            return this.a.compareTo(c2.a);
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.a().hashCode();
            n3 = 31 * n3 + (this.a == null ? 0 : this.a.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            c c2 = (c)object;
            if (!this.a().equals(c2.a())) {
                return false;
            }
            return this.a == c2.a;
        }

        private ConcurrentLicenseManagementGui a() {
            return ConcurrentLicenseManagementGui.this;
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.a((c)object);
        }
    }
}

