/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.license;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.ExternallyVisible;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.commandline.c;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.d;
import com.mimvista.gui.SplashScreen;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.license.LicenseClient;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.license.db.License;
import com.mimvista.mui.ak;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.StartupPrefs;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

@ExternallyVisible
public class LicensePicker {
    public static Messages props = Messages.a("License");
    private LicenseClient a;
    private String[] b;
    private String c;
    private boolean d = false;
    private String[] e = null;
    private Set<License> f;
    private Set<License> g;

    public LicensePicker(String string) {
        this.c = string;
        this.a = LicenseClient.getInstance(string);
    }

    public String[] pickLicensesSafely() {
        return this.pickLicensesSafely(null);
    }

    public String[] pickLicensesSafely(@d List<WorkflowCommand> list) {
        try {
            String[] stringArray = this.a(list);
            return stringArray;
        }
        catch (Exception exception) {
            ay.d((Object)"getting lics", (Throwable)exception, LicensePicker.class);
            exception.printStackTrace();
            return null;
        }
    }

    private String[] a(@d List<WorkflowCommand> list) {
        this.b = this.a.getSublicenses();
        boolean bl2 = this.a.getLicensingMessage().length() > 0;
        boolean bl3 = Boolean.parseBoolean(System.getProperty("java.awt.headless"));
        if (bl2) {
            this.d = true;
            if (bl3) {
                ay.b((Object)this.a.getLicensingMessage(), this);
            } else {
                JOptionPane.showMessageDialog(SplashScreen.a(), this.a.getLicensingMessage(), props.getProperty("LICENSEPICKER_NETWORK"), 1);
            }
        }
        if (!this.a.isLicensed()) {
            return null;
        }
        Set<String> set = com.mimvista.commandline.c.a().b();
        if (!set.isEmpty()) {
            ay.b((Object)("Received --licenses on the commandline, pulling: " + cn.a(set, ", ")), this);
            ArrayList arrayList = Lists.newArrayList();
            String[] stringArray = this.a(set.toArray(new String[0]), arrayList::add);
            for (a a2 : arrayList) {
                if (a2.b) continue;
                if (this.b(arrayList)) break;
                LicenseClient.freeAllLicenses();
                return null;
            }
            ay.b((Object)("Pulled: " + cn.a(stringArray, ", ")), this);
            return stringArray;
        }
        if (this.a.canSafelyPullAllSublicenses()) {
            ay.b((Object)("Can safely pull all: " + cn.a(this.b, ", ")), this);
            String[] stringArray = this.a(this.b);
            ay.b((Object)("Pulled: " + cn.a(stringArray, ", ")), this);
            return stringArray;
        }
        if (this.a.getCannotContact()) {
            return this.a(this.b);
        }
        if (bl3) {
            return this.b(list);
        }
        return this.a();
    }

    private void a(StringBuilder stringBuilder, a a2) {
        String string = Messages.a("License", "LICENSEPICKER_CMDLINE_FAIL_LIST_ITEM_FORMAT");
        String string2 = Messages.a("License", "LICENSEPICKER_CMDLINE_SUCCESS_LIST_ITEM_FORMAT");
        stringBuilder.append("    ");
        LicenseOption licenseOption = LicenseTransformer.networkToLocalByCode(a2.a);
        if (licenseOption != null) {
            String string3 = licenseOption.b();
            if (string3 == null) {
                string3 = a2.a;
            }
            if (a2.b) {
                stringBuilder.append(MIMFormat.a(string2, string3));
            } else {
                stringBuilder.append(MIMFormat.a(string, string3, a2.c));
            }
        } else {
            stringBuilder.append(MIMFormat.a(string, a2.a, Messages.a("License", "LICENSEPICKER_UNKNOWN_LICENSE_CODE")));
        }
    }

    private String a(Iterable<a> iterable) {
        StringBuilder stringBuilder = new StringBuilder("<ul>");
        Iterator<a> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append("<li>");
            this.a(stringBuilder, iterator.next());
            stringBuilder.append("</li>");
        }
        stringBuilder.append("</ul>");
        return stringBuilder.toString();
    }

    private boolean b(Iterable<a> iterable) {
        String string = MIMFormat.a(Messages.a("License", "LICENSEPICKER_CMDLINE_FAIL_MESSAGE"), this.a(iterable));
        int n2 = MOptionPane.a(SplashScreen.a(), "<html>" + string.toString() + "</html>", Messages.a("License", "LICENSEPICKER_CMDLINE_FAIL_DIALOG_CAPTION"), 0, 3, null, new Object[]{Messages.a("License", "LICENSEPICKER_CMDLINE_FAIL_DIALOG_CHOICE_CONTINUE"), Messages.a("License", "LICENSEPICKER_CMDLINE_FAIL_DIALOG_CHOICE_CONFIGURE_SETTINGS"), Box.createRigidArea(new Dimension(30, 0)), Messages.a("License", "LICENSEPICKER_CMDLINE_FAIL_DIALOG_CHOICE_EXIT")}, 0);
        switch (n2) {
            case -1: {
                return false;
            }
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 3: {
                LicenseClient.freeAllLicenses();
                System.exit(0);
                return false;
            }
        }
        return false;
    }

    private String[] b(List<WorkflowCommand> list) {
        this.b();
        Set<String> set = LicenseTransformer.getMinimalLicenses(list, this.f, this.g);
        String[] stringArray = set.toArray(new String[0]);
        this.e = this.a(stringArray);
        return stringArray;
    }

    public boolean didDisplayMsg() {
        return this.d;
    }

    private String[] a() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Trying to run LicensePicker from the EventDispatchThread! Hello, deadlock!");
        }
        final JDialog jDialog = new JDialog(SplashScreen.a());
        jDialog.setResizable(false);
        jDialog.setTitle(props.getProperty("LICENSEPICKER_SELECTION"));
        jDialog.setMinimumSize(new Dimension(270, 100));
        jDialog.setLocationRelativeTo(null);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jDialog.add(jPanel);
        License license = this.a.getLicenseForProduct(this.c);
        Integer n2 = license.getSeats();
        String string = license.isPayPerView() ? "unlimited" : n2.toString();
        final ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>();
        final ArrayList<String> arrayList2 = new ArrayList<String>();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new JLabel(MIMFormat.a(props.getProperty("LICENSEPICKER_SIMULTANEOUS"), string)), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 50, 5);
        jPanel.add((Component)new JLabel(props.getProperty("LICENSEPICKER_LIMIT")), gridBagConstraints);
        final ArrayList arrayList3 = new ArrayList();
        this.b();
        arrayList3.addAll(this.f.stream().map(License::getCodeName).collect(Collectors.toList()));
        int n3 = 2;
        for (License object2 : this.g) {
            Integer bl2 = object2.getSeats();
            JCheckBox exception = new JCheckBox(object2.getCodeDesc() + " (" + bl2.toString() + ")");
            arrayList2.add(object2.getCodeName());
            arrayList.add(exception);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = n3++;
            jPanel.add((Component)exception, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        JButton jButton = new JButton(props.b("LICENSEPICKER_OK"), ImageManipulator.c("checkmark_green", 24, 24));
        jPanel.add((Component)jButton, gridBagConstraints);
        final FuncUtils.f f2 = new FuncUtils.f();
        jButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    if (!((JCheckBox)arrayList.get(i2)).isSelected()) continue;
                    arrayList3.add(arrayList2.get(i2));
                }
                try {
                    String string;
                    int n2;
                    do {
                        void var3_7;
                        LicensePicker.a(LicensePicker.this, LicensePicker.this.a(arrayList3.toArray(new String[0])));
                        if (LicensePicker.this.e.length > 0) {
                            LicenseTransformer.getInstance().reset();
                        }
                        if (LicensePicker.this.e.length >= arrayList3.size()) return;
                        ArrayList arrayList4 = new ArrayList(arrayList3);
                        String[] stringArray = LicensePicker.this.e;
                        n2 = stringArray.length;
                        for (int i3 = 0; i3 < n2; ++i3) {
                            String string2 = stringArray[i3];
                            arrayList4.remove(string2);
                        }
                        String string3 = props.getProperty("LICENSEPICKER_RESERVE_FAIL");
                        for (String string4 : arrayList4) {
                            License license = LicensePicker.this.a.getLicenseForProduct(string4);
                            String string5 = (String)var3_7 + license.getCodeDesc() + "\n";
                        }
                        string = (String)var3_7 + props.getProperty("LICENSEPICKER_RESERVE_RETRY");
                    } while ((n2 = JOptionPane.showConfirmDialog(ak.b().O(), string, props.getProperty("LICENSEPICKER_FAIL"), 0)) != 1);
                    return;
                }
                finally {
                    f2.b();
                    jDialog.setVisible(false);
                }
            }
        });
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                f2.b();
                jDialog.setVisible(false);
            }
        });
        jDialog.pack();
        boolean bl2 = StartupPrefs.pickLicenses.getValue();
        if (bl2 && arrayList.size() > 0) {
            jDialog.setVisible(true);
            try {
                f2.a();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.e = this.a(arrayList3.toArray(new String[0]));
        }
        return (String[])this.e.clone();
    }

    private void b() {
        this.f = Sets.newHashSet();
        License license = this.a.getLicenseForProduct(this.c);
        this.f.add(license);
        this.g = Sets.newHashSet();
        Integer n2 = license.getSeats();
        for (String string : this.b) {
            License license2 = this.a.getLicenseForProduct(string);
            if (license2.isPayPerView()) {
                this.f.add(license2);
                continue;
            }
            Integer n3 = license2.getSeats();
            if (!license.isPayPerView() && n3 >= n2) {
                this.f.add(license2);
                continue;
            }
            this.g.add(license2);
        }
    }

    private String[] a(String[] stringArray) {
        return this.a(stringArray, (a a2) -> {});
    }

    private String[] a(String[] stringArray, Consumer<a> consumer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            License license = this.a.getLicenseForProduct(string);
            if (license == null) {
                consumer.accept(new a(string, Messages.a("License", "LICENSEPICKER_NOT_LICENSED")));
                continue;
            }
            if (!this.a.reserveLicense(license)) {
                consumer.accept(new a(string, Messages.a("License", "LICENSEPICKER_ALL_RESERVED")));
                continue;
            }
            consumer.accept(new a(string));
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    static /* synthetic */ String[] a(LicensePicker licensePicker, String[] stringArray) {
        licensePicker.e = stringArray;
        return stringArray;
    }

    private static class a {
        public String a;
        public boolean b;
        public String c;

        public a(String string) {
            this(string, null);
        }

        public a(String string, String string2) {
            this.a = string;
            this.b = string2 == null;
            this.c = string2;
        }
    }
}

