/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.license;

import com.mimvista.ExternallyVisible;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.gui.util.c;
import com.mimvista.license.AuthKey;
import com.mimvista.license.LicenseManager;
import com.mimvista.license.LicenseStatus;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.license.db.License;
import com.mimvista.license.f;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.ProgressDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

@ExternallyVisible
public class LicenseServerGui
extends JPanel {
    private static final long serialVersionUID = 1662419578644888033L;
    public static Messages props = Messages.a("License");
    private f serverManager = new f();
    private LicenseManager manager;

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MIMLookAndFeel.M();
                JFrame jFrame = new JFrame(props.getProperty("LICENSESERVER_TITLE"));
                jFrame.setDefaultCloseOperation(3);
                jFrame.setLayout(new BorderLayout());
                jFrame.add((Component)new LicenseServerGui(), "Center");
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
    }

    public LicenseServerGui() {
        super(new GridBagLayout());
        new Thread(new Runnable(){

            @Override
            public void run() {
                LicenseServerGui.this.build();
            }
        }).start();
    }

    @Override
    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    public void build() {
        this.removeAll();
        final GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)new JLabel(props.getProperty("LICENSESERVER_RUNNING_TXT")), gridBagConstraints);
        final JLabel jLabel = new JLabel(Messages.a("General").getProperty("NO"));
        ++gridBagConstraints.gridx;
        jLabel.setForeground(Color.RED);
        this.add((Component)jLabel, gridBagConstraints);
        this.a();
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean bl2 = LicenseServerGui.this.serverManager.a();
                jLabel.setText(Messages.a("General").getProperty(bl2 ? "YES" : "NO"));
                jLabel.setForeground(bl2 ? Color.CYAN : Color.RED);
                if (!bl2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LicenseServerGui.this.a();
                        }
                    });
                    return;
                }
                LicenseServerGui.this.manager = LicenseServerGui.this.serverManager.b();
                boolean bl3 = false;
                LicenseStatus licenseStatus = null;
                try {
                    bl3 = LicenseServerGui.this.manager.isLicensed();
                    if (bl3) {
                        licenseStatus = LicenseServerGui.this.manager.getLicenseStatus();
                    }
                }
                catch (RemoteException remoteException) {
                    ay.d((Object)"Checking/Listing licensed status:", (Throwable)remoteException, this);
                }
                final boolean bl4 = bl3;
                final LicenseStatus licenseStatus2 = licenseStatus;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ++gridBagConstraints.gridy;
                        gridBagConstraints.gridx = 0;
                        LicenseServerGui.this.add((Component)new JLabel(props.getProperty("LICENSESERVER_STATUS") + ": "), gridBagConstraints);
                        ++gridBagConstraints.gridx;
                        JLabel jLabel = new JLabel(bl4 ? props.getProperty("LICENSESERVER_LICENSED") : props.getProperty("LICENSESERVER_UNLICENSED"));
                        jLabel.setForeground(bl4 ? Color.CYAN : Color.RED);
                        LicenseServerGui.this.add((Component)jLabel, gridBagConstraints);
                        ++gridBagConstraints.gridy;
                        gridBagConstraints.gridx = 0;
                        if (!bl4) {
                            gridBagConstraints.gridwidth = 2;
                            gridBagConstraints.anchor = 10;
                            JButton jButton = new JButton(props.getProperty("LICENSESERVER_ACTIVATE"));
                            jButton.addActionListener(LicenseServerGui.this.b());
                            LicenseServerGui.this.add((Component)jButton, gridBagConstraints);
                        } else if (licenseStatus2 != null) {
                            LicenseServerGui.this.add((Component)new JLabel(props.getProperty("LICENSESERVER_TO")), gridBagConstraints);
                            ++gridBagConstraints.gridx;
                            LicenseServerGui.this.add((Component)new JLabel(licenseStatus2.institutionName), gridBagConstraints);
                            gridBagConstraints.gridx = 0;
                            ++gridBagConstraints.gridy;
                            gridBagConstraints.gridwidth = 2;
                            LicenseServerGui.this.add((Component)new JLabel(), gridBagConstraints);
                            ++gridBagConstraints.gridy;
                            gridBagConstraints.anchor = 10;
                            LicenseServerGui.this.add((Component)new JLabel(props.getProperty("LICENSESERVER_LICENSES")), gridBagConstraints);
                            gridBagConstraints.anchor = 21;
                            gridBagConstraints.gridwidth = 1;
                            List<License> list = Arrays.asList(licenseStatus2.licenses.toArray(new License[0]));
                            Collections.sort(list, new a());
                            for (License license : list) {
                                ++gridBagConstraints.gridy;
                                gridBagConstraints.gridx = 0;
                                LicenseServerGui.this.add((Component)new JLabel(license.getCodeDesc()), gridBagConstraints);
                                ++gridBagConstraints.gridx;
                                if (license.isPayPerView()) {
                                    LicenseServerGui.this.add((Component)new JLabel(props.getProperty("LICENSESERVER_PAYPER")), gridBagConstraints);
                                    continue;
                                }
                                LicenseServerGui.this.add((Component)new JLabel(MIMFormat.a(props.getProperty("LICENSESERVER_SEATS"), license.getSeats(), license.getMaxSeats())), gridBagConstraints);
                            }
                        }
                        LicenseServerGui.this.a();
                    }
                });
            }
        }).start();
    }

    private void a() {
        this.revalidate();
    }

    private ActionListener b() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LicenseServerGui.this.c();
            }
        };
    }

    private void c() {
        new ActivationDialog(SwingUtilities.getWindowAncestor(this)).setVisible(true);
        this.build();
    }

    public static class JTextFieldLimit
    extends PlainDocument {
        private static final long serialVersionUID = 4224530094721429292L;
        private int limit;
        private boolean toUppercase = false;

        JTextFieldLimit(int n2) {
            this.limit = n2;
        }

        JTextFieldLimit(int n2, boolean bl2) {
            this.limit = n2;
            this.toUppercase = bl2;
        }

        @Override
        public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            if (this.getLength() + string.length() <= this.limit) {
                if (this.toUppercase) {
                    string = string.toUpperCase();
                }
                super.insertString(n2, string, attributeSet);
            }
        }
    }

    private class ActivationDialog
    extends JDialog {
        private static final long serialVersionUID = -9090910528521426774L;
        private JTextField keyText;

        public ActivationDialog(Window window) {
            super(window);
            this.setLayout(new BorderLayout());
            this.setModal(true);
            this.setLocationRelativeTo(window);
            try {
                this.a();
                this.pack();
            }
            catch (RemoteException remoteException) {
                ay.d((Object)"Buildling dialog:", (Throwable)remoteException, LicenseServerGui.class);
                remoteException.printStackTrace();
            }
        }

        private void a() throws RemoteException {
            this.setTitle(props.getProperty("LICENSESERVER_ACT_LIC"));
            JPanel jPanel = new JPanel(){
                private static final long serialVersionUID = -5252762962134337685L;

                @Override
                public Insets getInsets() {
                    return new Insets(10, 10, 10, 10);
                }
            };
            jPanel.setLayout(new GridBagLayout());
            this.add(jPanel);
            String string = null;
            try {
                string = LicenseServerGui.this.manager.getLoneWolfCode();
            }
            catch (Exception exception) {
                string = null;
            }
            final String string2 = string;
            final String string3 = LicenseServerGui.this.manager.getActivationCode();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 2;
            JLabel jLabel = new JLabel(props.getProperty("LICENSESERVER_ACT_CODE"));
            jPanel.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            final JTextField jTextField = new JTextField("", 18);
            jTextField.setEditable(false);
            jTextField.setText(string3);
            jPanel.add((Component)jTextField, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            final JLabel jLabel2 = new JLabel(props.getProperty("LICENSESERVER_ACT_KEY"));
            jPanel.add((Component)jLabel2, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            this.keyText = new JTextField(new JTextFieldLimit(8, true), "", 8);
            String string4 = LicenseServerGui.this.manager.getActivationKey();
            if (string4 != null) {
                this.keyText.setText(string4);
            }
            jPanel.add((Component)this.keyText, gridBagConstraints);
            jPanel.add(Box.createVerticalStrut(this.keyText.getPreferredSize().height), gridBagConstraints);
            JPanel jPanel2 = new JPanel(){
                private static final long serialVersionUID = -9204621624261608474L;

                @Override
                public Insets getInsets() {
                    return new Insets(10, 10, 10, 10);
                }
            };
            BoxLayout boxLayout = new BoxLayout(jPanel2, 2);
            jPanel2.setLayout(boxLayout);
            jPanel2.add(Box.createHorizontalGlue());
            final JButton jButton = c.c(this.b(), null);
            jButton.setText(props.getProperty("LICENSESERVER_ACT"));
            jPanel2.add(jButton);
            jPanel2.add(Box.createHorizontalStrut(5));
            final JButton jButton2 = c.a(this.c(), null);
            jPanel2.add(jButton2);
            this.add((Component)jPanel2, "South");
            this.doLayout();
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            if (string2 != null) {
                final JCheckBox jCheckBox = new JCheckBox(props.getProperty("CONCURR_LICENSE_WOLF_MODE"));
                jPanel.add((Component)jCheckBox, gridBagConstraints);
                jCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Messages messages = Messages.a("ButtonFactory");
                        if (jCheckBox.isSelected()) {
                            jTextField.setText(string2);
                            jLabel2.setVisible(false);
                            ActivationDialog.this.keyText.setVisible(false);
                            jButton.setVisible(false);
                            jButton2.setText(messages.getProperty("CLOSE_BUTTON"));
                        } else {
                            jTextField.setText(string3);
                            jLabel2.setVisible(true);
                            ActivationDialog.this.keyText.setVisible(true);
                            jButton.setVisible(true);
                            jButton2.setText(messages.getProperty("CANCEL_NO_CONFIRM_BUTTON"));
                        }
                    }
                });
            }
        }

        private ActionListener b() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!AuthKey.a(ActivationDialog.this.keyText.getText().toUpperCase())) {
                        JOptionPane.showMessageDialog(ActivationDialog.this, props.getProperty("LICENSESERVER_ACT_INVALID"), props.getProperty("LICENSESERVER_ACT_KEY_INCORRECT"), 0);
                        return;
                    }
                    final boolean[] blArray = new boolean[]{false};
                    final String string = ActivationDialog.this.keyText.getText().toUpperCase();
                    final int[] nArray = new int[]{0};
                    final ProgressDialog progressDialog = new ProgressDialog(ActivationDialog.this);
                    progressDialog.a(true);
                    progressDialog.c(false);
                    progressDialog.a(props.getProperty("LICENSESERVER_ACTIVATING_LICENSE"));
                    progressDialog.b_(props.getProperty("LICENSESERVER_VERIFYING"));
                    progressDialog.a();
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                int n2;
                                LicenseServerGui.this.manager.setActivationKey(string);
                                LicenseServerGui.this.manager.getLicense();
                                blArray[0] = LicenseServerGui.this.manager.isLicensed();
                                nArray[0] = n2 = LicenseServerGui.this.manager.getFailureCode();
                                progressDialog.b();
                                progressDialog.p();
                            }
                            catch (RemoteException remoteException) {
                                try {
                                    remoteException.printStackTrace();
                                    progressDialog.b();
                                    progressDialog.p();
                                }
                                catch (Throwable throwable) {
                                    progressDialog.b();
                                    progressDialog.p();
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            String string;
                                            int n2 = 0;
                                            String string2 = props.getProperty("LICENSESERVER_STATUS");
                                            boolean bl2 = false;
                                            if (blArray[0]) {
                                                string = props.getProperty("LICENSESERVER_SUCCESS");
                                                n2 = 1;
                                                bl2 = true;
                                            } else {
                                                String string3;
                                                if (nArray[0] == 1) {
                                                    string3 = props.getProperty("LICENSESERVER_INCORRECT");
                                                } else if (nArray[0] == 2) {
                                                    string3 = props.getProperty("LICENSESERVER_DISABLED");
                                                    bl2 = true;
                                                } else {
                                                    string3 = nArray[0] == 3 ? props.getProperty("LICENSESERVER_UNKNOWN") : props.getProperty("LICENSESERVER_CONTACT_FAIL");
                                                }
                                                string = props.getProperty("LICENSESERVER_FAIL") + string3;
                                            }
                                            JOptionPane.showMessageDialog(ActivationDialog.this, string, string2, n2);
                                            if (bl2) {
                                                ActivationDialog.this.setVisible(false);
                                            }
                                        }
                                    });
                                    throw throwable;
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    };
                    thread.start();
                }
            };
        }

        private ActionListener c() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ActivationDialog.this.setVisible(false);
                }
            };
        }
    }

    private static class a
    implements Comparator<License> {
        private a() {
        }

        public int a(License license, License license2) {
            LicenseOption licenseOption = LicenseTransformer.networkToLocal(license);
            LicenseOption licenseOption2 = LicenseTransformer.networkToLocal(license2);
            int n2 = licenseOption == null ? 100 : licenseOption.ordinal();
            int n3 = licenseOption2 == null ? 100 : licenseOption2.ordinal();
            return n2 - n3;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((License)object, (License)object2);
        }
    }
}

