/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.metabase;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Sets;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.mimvista.ExternallyVisible;
import com.mimvista.dicom.util.DicomTagParseException;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.dicom.util.TagPathComponent;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.util.ay;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javassist.Modifier;

@ExternallyVisible
public class MetabaseKeys {
    public static final String SERIES_PK = "_id";
    public static final String VERSION = "mimdata.version";
    public static final String PATIENT_LISTS = "mimdata.patientLists";
    public static final String DATE_ADDED = "mimdata.dateAdded";
    public static final String FOLDERS = "mimdata.folders";
    public static final String LAST_ACCESSED_DATE = "mimdata.lastAccessed";
    public static final String REFERENCES = "mimdata.references";
    public static final String REFERENCED_UID = "mimdata.references.uid";
    public static final String REFERENCED_UID_TYPE = "mimdata.references.uidType";
    public static final String REFERENCED_UID_SOURCE = "mimdata.references.source";
    public static final String SEARCH_DATE = "mimdata.searchDate";
    public static final String SEARCH_TIME = "mimdata.searchTime";
    public static final String EQUALITY_HASH_KEY = "mimdata.equalityHash";
    public static final String CRUNCHED_NAME = "mimdata.crunchedName";
    public static final String CRUNCHED_PATIENT_ID = "mimdata.crunchedPatientId";
    public static final String CRUNCHED_SERIES_DESC = "mimdata.crunchedSeriesDesc";
    public static final String CRUNCHED_STUDY_DESC = "mimdata.crunchedStudyDesc";
    public static final String SOP_INSTANCE_UIDS = "mimdata.sopInstanceUids";
    public static final String SOP_INFOS = "mimdata.sops";
    public static final String STATUSES = "mimdata.statuses";
    public static final String STATUS_TIME = "mimdata.statuses.time";
    public static final String STATUS_ID = "mimdata.statuses.statusId";
    public static final String STATUS_USER = "mimdata.statuses.user";
    public static final String STATUS_TYPE = "mimdata.statuses.type";
    public static final String OWNERS = "mimdata.owners";
    public static final String OWNER_TIME = "mimdata.owners.time";
    public static final String OWNER_NAME = "mimdata.owners.ownerName";
    public static final String OWNER_ACTOR = "mimdata.owners.actor";
    public static final String OWNER_CURRENT = "mimdata.currentOwner";
    public static final String SPECIAL_UID_REF = "mimdata.parentSeriesUids";
    public static final String CHILD_IDS = "mimdata.childIds";
    public static final String PARENT_ID = "mimdata.parentId";
    public static final String EMBED_IDX = "mimdata.embedIdx";
    public static final String MIMDATA = "mimdata";
    public static final String VERSION_SHORT = "version";
    public static final String PATIENT_LISTS_SHORT = "patientLists";
    public static final String PATIENT_LIST_INFO_SHORT = "plInfo";
    public static final String DATE_ADDED_SHORT = "dateAdded";
    public static final String FOLDERS_SHORT = "folders";
    public static final String LAST_ACCESSED_DATE_SHORT = "lastAccessed";
    public static final String REFERENCES_SHORT = "references";
    public static final String UID_SHORT = "uid";
    public static final String UID_TYPE_SHORT = "uidType";
    public static final String SOURCE_SHORT = "source";
    public static final String SEARCH_DATE_SHORT = "searchDate";
    public static final String SEARCH_TIME_SHORT = "searchTime";
    public static final String CRUNCHED_NAME_SHORT = "crunchedName";
    public static final String CRUNCHED_PATIENT_ID_SHORT = "crunchedPatientId";
    public static final String CRUNCHED_SERIES_DESC_SHORT = "crunchedSeriesDesc";
    public static final String CRUNCHED_STUDY_DESC_SHORT = "crunchedStudyDesc";
    public static final String SOP_INSTANCE_UIDS_SHORT = "sopInstanceUids";
    public static final String SOP_INFOS_SHORT = "sops";
    public static final String STATUSES_SHORT = "statuses";
    public static final String STATUS_TIME_SHORT = "time";
    public static final String STATUS_ID_SHORT = "statusId";
    public static final String STATUS_USER_SHORT = "user";
    public static final String STATUS_TYPE_SHORT = "type";
    public static final String STATUS_NAME_SHORT = "name";
    public static final String OWNERS_SHORT = "owners";
    public static final String OWNER_TIME_SHORT = "time";
    public static final String OWNER_NAME_SHORT = "ownerName";
    public static final String OWNER_CURRENT_SHORT = "currentOwner";
    public static final String OWNER_ACTOR_SHORT = "actor";
    public static final String SPECIAL_UID_REF_SHORT = "parentSeriesUids";
    public static final String CHILD_IDS_SHORT = "childIds";
    public static final String PARENT_ID_SHORT = "parentId";
    public static final String EMBED_IDX_SHORT = "embedIdx";
    public static final String SOP_COUNT_SHORT = "sopCount";
    public static final String EQUALITY_HASH_SHORT = "equalityHash";
    private static final ImmutableBiMap<Integer, String> a = new ImmutableBiMap.Builder().put((Object)0x37733003, (Object)"mimdata.lastAccessed").put((Object)930295812, (Object)"mimdata.dateAdded").put((Object)930295816, (Object)"mimdata.crunchedName").build();
    public static final Set<String> MIMDATA_KEYS;
    public static final String DICOM_PREFIX = "$.";

    public static boolean isMIMFakeDicomTag(TagPathComponent tagPathComponent) {
        if (tagPathComponent.isStringTag()) {
            return MIMDATA_KEYS.contains(tagPathComponent.getTagString());
        }
        return MetabaseKeys.isMIMFakeDicomTag(tagPathComponent.getTagInt());
    }

    public static boolean isMIMFakeDicomTag(int n2) {
        return a.containsKey((Object)n2);
    }

    public static boolean isMIMFakeDicomTagMetabaseKey(String string) {
        return a.inverse().containsKey((Object)string);
    }

    public static String getMIMFakeDicomTagMetabaseKey(int n2) {
        return (String)a.get((Object)n2);
    }

    public static String getMIMFakeDicomTagMetabaseKey(TagPathComponent tagPathComponent) {
        if (tagPathComponent.isStringTag()) {
            return tagPathComponent.getTagString();
        }
        return MetabaseKeys.getMIMFakeDicomTagMetabaseKey(tagPathComponent.getTagInt());
    }

    public static int getMIMFakeDicomTagFromMetabaseKey(String string) {
        return (Integer)a.inverse().get((Object)string);
    }

    public static String dateAdded(long l2) {
        return "mimdata.plInfo." + l2 + ".dateAdded";
    }

    public static String fromTag(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return "";
        }
        if (nArray.length == 1 && MetabaseKeys.isMIMFakeDicomTag(nArray[0])) {
            return MetabaseKeys.getMIMFakeDicomTagMetabaseKey(nArray[0]);
        }
        return TagUtils.toHexString(nArray);
    }

    public static String fromSingleTag(int n2) {
        return TagUtils.singleTagToHexString(n2);
    }

    public static String fromTag(TagPath tagPath) {
        if (tagPath == null || tagPath.isEmpty()) {
            return "";
        }
        return MetabaseKeys.fromTagWithIndexes(tagPath);
    }

    public static String fromTagWithIndexes(TagPath tagPath) {
        TagPathComponent[] tagPathComponentArray = tagPath.getTags();
        if (tagPathComponentArray == null || tagPathComponentArray.length == 0) {
            return "";
        }
        if (tagPathComponentArray.length == 1 && !tagPathComponentArray[0].isStringTag() && MetabaseKeys.isMIMFakeDicomTag(tagPathComponentArray[0].getTagInt())) {
            String string = MetabaseKeys.getMIMFakeDicomTagMetabaseKey(tagPathComponentArray[0].getTagInt());
            if (tagPathComponentArray[0].getIndex() != -1) {
                string = string + "." + tagPathComponentArray[1];
            }
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder("" + TagUtils.toHexString(tagPathComponentArray[0]));
        int n2 = 0;
        while (n2 < tagPathComponentArray.length) {
            if (tagPathComponentArray[n2].getIndex() != -1) {
                stringBuilder.append("." + tagPathComponentArray[n2].getIndex());
            }
            if (++n2 >= tagPathComponentArray.length) continue;
            stringBuilder.append("." + TagUtils.toHexString(tagPathComponentArray[n2]));
        }
        return stringBuilder.toString();
    }

    public static int[] toTag(String string) {
        if (MetabaseKeys.isMIMFakeDicomTagMetabaseKey(string)) {
            return new int[]{MetabaseKeys.getMIMFakeDicomTagFromMetabaseKey(string)};
        }
        try {
            TagPath tagPath = TagUtils.parse(string);
            TagPathComponent[] tagPathComponentArray = tagPath.getTags();
            int[] nArray = new int[tagPathComponentArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = tagPathComponentArray[i2].getTagInt();
            }
            return nArray;
        }
        catch (DicomTagParseException dicomTagParseException) {
            return null;
        }
    }

    public static JsonPath compile(String string, int ... nArray) {
        String string2 = string;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 > 0) {
                string2 = string2 + ".";
            }
            string2 = string2 + MetabaseKeys.fromTag(nArray[i2]);
            if (i2 >= nArray.length - 1) continue;
            string2 = string2 + "[*]";
        }
        return JsonPath.compile((String)string2, (Filter[])new Filter[0]);
    }

    public static JsonPath compile(int ... nArray) {
        return MetabaseKeys.compile(DICOM_PREFIX, nArray);
    }

    public static String fromTagNoIndex(TagPath tagPath) {
        return MetabaseKeys.fromTag(tagPath.getTags());
    }

    public static String fromTag(TagPathComponent ... tagPathComponentArray) {
        if (tagPathComponentArray == null || tagPathComponentArray.length == 0) {
            return "";
        }
        if (tagPathComponentArray.length == 1 && !tagPathComponentArray[0].isStringTag() && MetabaseKeys.isMIMFakeDicomTag(tagPathComponentArray[0].getTagInt())) {
            return MetabaseKeys.getMIMFakeDicomTagMetabaseKey(tagPathComponentArray[0].getTagInt());
        }
        return TagUtils.toHexString(tagPathComponentArray);
    }

    static {
        Class<MetabaseKeys> clazz = MetabaseKeys.class;
        Field[] fieldArray = clazz.getFields();
        HashSet hashSet = Sets.newHashSet();
        for (Field field : fieldArray) {
            if (!field.getType().equals(String.class) || !Modifier.isStatic((int)field.getModifiers()) || !field.getName().contains("SHORT")) continue;
            try {
                String string = (String)field.get(null);
                hashSet.add(string);
            }
            catch (Exception exception) {
                ay.d((Object)"Error building mimdata key set.", (Throwable)exception, MetabaseKeys.class);
            }
        }
        hashSet.add(MIMDATA);
        MIMDATA_KEYS = hashSet;
    }

    public static enum MetabaseKeysDicom {
        a(MetabaseKeys.compile(528661, 528714, 0x20000E)),
        b(MetabaseKeys.compile(805699600, 805699602, 805699604));

        final JsonPath tagPath;

        private MetabaseKeysDicom(JsonPath jsonPath) {
            this.tagPath = jsonPath;
        }

        public JsonPath a() {
            return this.tagPath;
        }
    }
}

