/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.metabase;

import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.metabase.UserWorkflowStatusParser;
import com.mimvista.preferencesNew.ViewStatusPrefs;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class StatusMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Integer, String> statuses = new HashMap<Integer, String>();
    private Map<String, List<String>> setPermissions = new HashMap<String, List<String>>();
    private Map<String, List<String>> delPermissions = new HashMap<String, List<String>>();
    private Map<String, List<String>> dependencies = new HashMap<String, List<String>>();
    private static File a = PathUtils.joinFile(PathUtils.getMiscDataPath(), "mimpacs", "statuses", "workflow-status.txt");
    private static final int b = 1000;
    private static StatusMap c;

    private void f() {
        this.g();
        this.h();
    }

    private void g() {
        ay.b((Object)"Loading view status file...", this);
        this.statuses.put(1, "Locked");
        this.setPermissions.put("Locked", new ArrayList());
        this.delPermissions.put("Locked", new ArrayList());
        if (ViewStatusPrefs.prohibitiveLock.getValue().booleanValue()) {
            ay.b((Object)"PROHIBITIVE LOCK is On", this);
            ay.b((Object)"Need to intialize permission of removing lock", this);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : ViewStatusPrefs.lockOverrideGroupList.getValue()) {
                ay.b((Object)("Overriding Group: " + string.trim()), this);
                arrayList.add(string.trim());
            }
            this.delPermissions.put("Locked", arrayList);
        }
    }

    private void h() {
        try {
            ay.b((Object)"Loading user workflow status file...", this);
            ay.b((Object)("Parsing user workflow status file " + a), this);
            UserWorkflowStatusParser userWorkflowStatusParser = new UserWorkflowStatusParser(a);
            userWorkflowStatusParser.a();
            for (Map.Entry<Integer, String> entry : userWorkflowStatusParser.b().entrySet()) {
                this.statuses.put(entry.getKey() + 1000, entry.getValue());
            }
            this.setPermissions = userWorkflowStatusParser.c();
            this.delPermissions.putAll(this.setPermissions);
            this.dependencies = userWorkflowStatusParser.d();
            ay.b((Object)"Finished loading user workflow status file.", this);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ay.d((Object)("The workflow status file " + a + " could not be found..."), this);
            ay.d((Object)"...but don't worry, we'll generate a default status file for you.", this);
            this.i();
        }
        catch (Exception exception) {
            ay.d((Object)("Problems encountered reading workflow status file " + a + ": "), (Throwable)exception, this);
        }
    }

    public String a(int n2) {
        return this.statuses.get(n2);
    }

    public int a(String string) {
        Set<Map.Entry<Integer, String>> set = this.statuses.entrySet();
        for (Map.Entry<Integer, String> entry : set) {
            if (!entry.getValue().equalsIgnoreCase(string)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public Set<Integer> a(Pattern pattern) {
        Set<Map.Entry<Integer, String>> set = this.statuses.entrySet();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Map.Entry<Integer, String> entry : set) {
            try {
                if (!pattern.matcher(entry.getValue()).matches()) continue;
                hashSet.add(entry.getKey());
            }
            catch (Exception exception) {}
        }
        if (hashSet.isEmpty()) {
            hashSet.add(-1);
        }
        return hashSet;
    }

    public String b(int n2) {
        if (n2 < 1000) {
            return "view";
        }
        return "workflow";
    }

    public static boolean a(String string, int n2) {
        return "View".equalsIgnoreCase(string) ? n2 < 1000 : "Workflow".equalsIgnoreCase(string) && n2 >= 1000;
    }

    public boolean a(String string, List<String> list) {
        List<String> list2 = this.setPermissions.get(string);
        if (list2.size() == 0 || list2.size() == 1 && list2.get(0).equals("")) {
            return true;
        }
        for (String string2 : list2) {
            if (!list.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean b(String string, List<String> list) {
        List<String> list2 = this.delPermissions.get(string);
        if (!ViewStatusPrefs.prohibitiveLock.getValue().booleanValue()) {
            ay.b((Object)("PROHIBITIVE LOCK is off, everyone can remove this status " + string), this);
            return true;
        }
        if (list2.size() == 0 || list2.size() == 1 && list2.get(0).equals("")) {
            return false;
        }
        for (String string2 : list2) {
            if (!list.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean a() {
        return ViewStatusPrefs.prohibitiveLock.getValue();
    }

    public boolean b() {
        return ViewStatusPrefs.autoLock.getValue();
    }

    public List<String> b(String string) {
        ay.b((Object)("Listing statuses of type " + string), this);
        Set<Map.Entry<Integer, String>> set = this.statuses.entrySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        if ("View".equalsIgnoreCase(string)) {
            for (Map.Entry<Integer, String> entry : set) {
                if (entry.getKey() >= 1000) continue;
                arrayList.add(entry.getValue());
            }
            ay.a((Object)("Following are View statuses: " + arrayList), this);
        } else if ("Workflow".equalsIgnoreCase(string)) {
            for (Map.Entry<Integer, String> entry : set) {
                if (entry.getKey() < 1000) continue;
                arrayList.add(entry.getValue());
            }
            ay.a((Object)("Following are Workflow status: " + arrayList), this);
        } else {
            ay.d((Object)("This type of statuses is not recognized: " + string), this);
        }
        return arrayList;
    }

    public List<String> c(String string, List<String> list) {
        ay.b((Object)("Listing eligible next workflow status of status " + string + " for following user groups: " + cn.a(list, " ")), this);
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (Map.Entry<String, List<String>> entry : this.dependencies.entrySet()) {
            String string2 = entry.getKey();
            List<String> list2 = entry.getValue();
            if (!list2.contains(string)) continue;
            List<String> list3 = this.setPermissions.get(string2);
            if (list3.size() == 0 || list3.size() == 1 && list3.get(0).equals("")) {
                ay.b((Object)("No permission need for setting next workflow status " + string2), this);
                arrayList.add(string2);
                continue;
            }
            for (String string3 : list3) {
                if (!list.contains(string3)) continue;
                ay.b((Object)("Current user groups have permission for setting next workflow status " + string2), this);
                arrayList.add(string2);
                continue block0;
            }
        }
        return arrayList;
    }

    private void i() {
        ay.b((Object)"Generating default workflow status file...", this);
        this.statuses.put(1001, "Read");
        this.statuses.put(1002, "Unverified");
        this.statuses.put(1003, "Verified");
        this.statuses.put(1004, "Approved");
        this.setPermissions.put("Read", Arrays.asList(""));
        this.setPermissions.put("Unverified", Arrays.asList(""));
        this.setPermissions.put("Verified", Arrays.asList(""));
        this.setPermissions.put("Approved", Arrays.asList(""));
        this.delPermissions.putAll(this.setPermissions);
        this.dependencies.put("Read", Arrays.asList(""));
        this.dependencies.put("Unverified", Arrays.asList("Read"));
        this.dependencies.put("Verified", Arrays.asList("Unverified", "Read"));
        this.dependencies.put("Approved", Arrays.asList("Verified"));
        MIMFile.l(a);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(a));){
            String string;
            String string2;
            for (Map.Entry<Integer, String> entry : this.statuses.entrySet()) {
                int n2 = entry.getKey() - 1000;
                if (n2 < 0) continue;
                string2 = entry.getValue();
                string = this.setPermissions.get(string2).toString();
                string = string.substring(1, string.length() - 1);
                String string3 = n2 + " " + string2 + " -- " + string;
                bufferedWriter.write(string3, 0, string3.length());
                bufferedWriter.newLine();
            }
            for (Map.Entry<Object, Object> entry : this.dependencies.entrySet()) {
                String string4 = (String)entry.getKey();
                string2 = this.dependencies.get(string4).toString();
                string2 = string2.substring(1, string2.length() - 1);
                string = string4 + " -> " + string2;
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            ay.d((Object)"Error storing default workflow status file", (Throwable)iOException, this);
        }
        catch (Exception exception) {
            ay.d((Object)"Exception while creating default workflow status file, ", (Throwable)exception, this);
        }
        ay.b((Object)"Finished generating default workflow status.", this);
    }

    public static synchronized StatusMap c() {
        if (c == null) {
            c = new StatusMap();
            c.f();
        }
        return c;
    }

    public static synchronized StatusMap d() {
        c = null;
        ay.b((Object)"resetting the status map cache", StatusMap.class);
        return StatusMap.c();
    }

    public Map<Integer, String> e() {
        return this.statuses;
    }

    public static void main(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        System.out.println("ELIGIBLE NEXT STATUSES: ");
        System.out.println(" GROUPS: " + arrayList);
        StatusMap statusMap = StatusMap.c();
        Set<Map.Entry<Integer, String>> set = statusMap.e().entrySet();
        System.out.println("  for '': " + statusMap.c("", arrayList));
        for (Map.Entry<Integer, String> entry : set) {
            System.out.println("  for '" + entry.getValue() + "': " + statusMap.c(entry.getValue(), arrayList));
        }
        System.out.println("DONE");
    }
}

