/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.metabase.hsqldb;

import java.io.File;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.Session;

@Entity
@Table(name="Folder")
public class Folder {
    private long pk;
    private String path;

    public static List<Folder> getByRootPath(Session session, File file) throws Throwable {
        session.beginTransaction();
        try {
            List list = session.createQuery("FROM Folder WHERE path LIKE :rootPath ORDER BY path ASC").setParameter("rootPath", (Object)(file.getAbsolutePath() + "%")).list();
            session.getTransaction().commit();
            return list;
        }
        catch (Throwable throwable) {
            session.getTransaction().rollback();
            throw throwable;
        }
    }

    public Folder() {
    }

    public Folder(String string) {
        this.path = string;
    }

    @Id
    @GeneratedValue
    public long getPk() {
        return this.pk;
    }

    public void setPk(long l2) {
        this.pk = l2;
    }

    @Column(unique=true)
    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Folder)) {
            return false;
        }
        Folder folder = (Folder)object;
        return this.path.equalsIgnoreCase(folder.path);
    }

    public String toString() {
        return this.path;
    }
}

