/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.metabase.hsqldb;

import com.google.common.collect.Sets;
import com.mimvista.metabase.hsqldb.HsqldbStudy;
import com.mimvista.metabase.l;
import com.mimvista.metabase.v;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che2.data.DicomObject;
import org.hibernate.Session;

@Entity
@Table(name="patient")
public class HsqldbPatient
implements l,
Serializable {
    private static final long serialVersionUID = 1L;
    private long pk;
    private String id;
    private String name;
    private Date birthDate;
    private String age;
    private Double weight;
    private String sex;
    private Set<HsqldbStudy> studies = Sets.newHashSet();

    @Override
    @Id
    @GeneratedValue
    public long getPk() {
        return this.pk;
    }

    public void setPk(long l2) {
        this.pk = l2;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Date getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(Date date) {
        this.birthDate = date;
    }

    @Override
    public String getAge() {
        return this.age;
    }

    public void setAge(String string) {
        this.age = string;
    }

    @Override
    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double d2) {
        this.weight = d2;
    }

    @Override
    public String getSex() {
        return this.sex;
    }

    public void setSex(String string) {
        this.sex = string;
    }

    @Override
    @OneToMany(mappedBy="patient", targetEntity=HsqldbStudy.class)
    public Set<v> getStudies() {
        return new HashSet<v>(this.studies);
    }

    public void setStudies(Set<HsqldbStudy> set) {
        this.studies = set;
    }

    public int hashCode() {
        int n2 = 31;
        return 31 * this.id.hashCode() + this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof HsqldbPatient)) {
            return false;
        }
        HsqldbPatient hsqldbPatient = (HsqldbPatient)object;
        return StringUtils.equalsIgnoreCase((CharSequence)this.id, (CharSequence)hsqldbPatient.id) && StringUtils.equalsIgnoreCase((CharSequence)this.name, (CharSequence)hsqldbPatient.name);
    }

    public String toString() {
        return this.name;
    }

    public static HsqldbPatient fromDicom(DicomObject dicomObject) {
        HsqldbPatient hsqldbPatient = new HsqldbPatient();
        hsqldbPatient.id = dicomObject.getString(0x100020);
        hsqldbPatient.age = dicomObject.getString(0x101010);
        try {
            hsqldbPatient.birthDate = dicomObject.getDate(0x100030);
        }
        catch (Exception exception) {
            ay.d((Object)"Couldn't get patient birth date, using null instead", HsqldbPatient.class);
            hsqldbPatient.birthDate = null;
        }
        hsqldbPatient.name = dicomObject.getString(0x100010);
        hsqldbPatient.sex = dicomObject.getString(0x100040);
        hsqldbPatient.weight = dicomObject.getDouble(0x101030);
        if (hsqldbPatient.name != null && !hsqldbPatient.name.isEmpty()) {
            hsqldbPatient.name = cn.d(hsqldbPatient.name).replace('^', ' ');
        }
        return hsqldbPatient;
    }

    public boolean existsInDatabase(Session session) {
        Long l2 = (Long)session.createQuery("SELECT pk FROM HsqldbPatient WHERE id = :id AND name = :name").setString("id", this.id).setString("name", this.name).uniqueResult();
        if (l2 != null) {
            this.pk = l2;
            return true;
        }
        return false;
    }
}

