/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.metabase.hsqldb;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mimvista.ExternallyVisible;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.dicom.DcmSeriesReference;
import com.mimvista.dicom.SeriesOwnerInfo;
import com.mimvista.dicom.SeriesStatusInfo;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.dicom.util.TagPathComponent;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.metabase.Series;
import com.mimvista.metabase.StatusMap;
import com.mimvista.metabase.hsqldb.Folder;
import com.mimvista.metabase.hsqldb.HsqldbPatientList;
import com.mimvista.metabase.hsqldb.HsqldbSeriesReference;
import com.mimvista.metabase.hsqldb.HsqldbSopInstance;
import com.mimvista.metabase.hsqldb.HsqldbStatus;
import com.mimvista.metabase.hsqldb.HsqldbStudy;
import com.mimvista.metabase.hsqldb.SeriesReferenceUID;
import com.mimvista.metabase.hsqldb.SeriesTagInfo;
import com.mimvista.metabase.l;
import com.mimvista.metabase.r;
import com.mimvista.metabase.u;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.hibernate.Session;
import org.hibernate.annotations.Index;

@ExternallyVisible
@Entity
@Table(name="Series", uniqueConstraints={@UniqueConstraint(columnNames={"seriesInstanceUid"})})
public class HsqldbSeries
implements Series,
Serializable,
Comparable<HsqldbSeries> {
    private static final long serialVersionUID = 2L;
    public static final Set<Integer> TAG_WHITELIST = Sets.newHashSet((Object[])new Integer[]{0x100020, 0x101010, 0x100030, 0x100010, 0x100040, 0x101030, 524368, 524432, 524320, 528432, 0x20000D, 524336, 0x200010, 524306, 524416, 524384, 1593600, 524321, 528446, 0x20000E, 5509120, 0x200011, 0x200052, 524312, 0x300A0003, 805961730, 805961732, 805568518, 0x30020003, 0x30020002, 805437444, 806092928, 806092896, 528661, 806092802, 805699600, 930283796});
    public long seriesPk;
    public String seriesInstanceUid;
    public String seriesDescription;
    public String seriesNumber;
    public Date instanceCreationDate;
    public String modality;
    public String manufacturer;
    public Date seriesDate;
    public String institutionName;
    public String seriesType;
    public String patientPosition;
    public String frameOfReferenceUid;
    public HsqldbStudy study;
    public Set<Folder> folders = Sets.newHashSet();
    public Set<HsqldbSeriesReference> seriesReferences = Sets.newHashSet();
    public Set<HsqldbSopInstance> sopInstances = Sets.newHashSet();
    public String sopInstanceUid;
    public String rtPlanName;
    public String rtPlanLabel;
    public String rtPlanDescription;
    public String rtImageName;
    public String rtImageLabel;
    public String rtImageDescription;
    public String doseComment;
    private Date searchDate;
    private Set<SeriesTagInfo> flattenedDicomElements = Sets.newHashSet();
    private Date lastAccessedTime;
    private Date dateAdded;
    private List<HsqldbStatus> statuses = Lists.newArrayList();
    private Set<HsqldbPatientList> patientLists = Sets.newTreeSet();

    @Id
    @GeneratedValue
    public long getSeriesPk() {
        return this.seriesPk;
    }

    public void setSeriesPk(long l2) {
        this.seriesPk = l2;
    }

    @Override
    @NotNull
    @Index(name="ix_Series_seriesInstanceUid")
    public String getSeriesInstanceUid() {
        return this.seriesInstanceUid;
    }

    public void setSeriesInstanceUid(String string) {
        this.seriesInstanceUid = string;
    }

    @Index(name="ix_Series_searchDate")
    public Date getSearchDate() {
        return this.searchDate;
    }

    public void setSearchDate(Date date) {
        this.searchDate = date;
    }

    @Override
    @Index(name="ix_Series_seriesDescription")
    public String getSeriesDescription() {
        return this.seriesDescription;
    }

    public void setSeriesDescription(String string) {
        this.seriesDescription = string;
    }

    @Override
    @Index(name="ix_Series_modality")
    public String getModality() {
        return this.modality;
    }

    public void setModality(String string) {
        this.modality = string;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String string) {
        this.manufacturer = string;
    }

    @Override
    @Index(name="ix_Series_seriesDate")
    public Date getSeriesDate() {
        return this.seriesDate;
    }

    public void setSeriesDate(Date date) {
        this.seriesDate = date;
    }

    @Index(name="ix_Series_institutionName")
    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String string) {
        this.institutionName = string;
    }

    @Index(name="ix_Series_instanceCreationDate")
    public Date getInstanceCreationDate() {
        return this.instanceCreationDate;
    }

    public void setInstanceCreationDate(Date date) {
        this.instanceCreationDate = date;
    }

    @Index(name="ix_Series_seriesType")
    public String getSeriesType() {
        return this.seriesType;
    }

    public void setSeriesType(String string) {
        this.seriesType = string;
    }

    @Index(name="ix_Series_patientPosition")
    public String getPatientPosition() {
        return this.patientPosition;
    }

    public void setPatientPosition(String string) {
        this.patientPosition = string;
    }

    @Index(name="ix_Series_seriesNumber")
    public String getSeriesNumber() {
        return this.seriesNumber;
    }

    public void setSeriesNumber(String string) {
        this.seriesNumber = string;
    }

    @Override
    @Index(name="ix_Series_frameOfReferenceUid")
    public String getFrameOfReferenceUid() {
        return this.frameOfReferenceUid;
    }

    public void setFrameOfReferenceUid(String string) {
        this.frameOfReferenceUid = string;
    }

    @Override
    @ManyToOne
    @JoinColumn(name="Study_StudyPK")
    public HsqldbStudy getStudy() {
        return this.study;
    }

    public void setStudy(HsqldbStudy hsqldbStudy) {
        this.study = hsqldbStudy;
    }

    @Override
    @OneToMany(mappedBy="series", targetEntity=HsqldbStatus.class)
    public List<u> getStatuses() {
        return new ArrayList<u>(this.statuses);
    }

    public void setStatuses(List<HsqldbStatus> list) {
        this.statuses = list;
    }

    @Override
    @OneToMany(mappedBy="series", targetEntity=HsqldbStatus.class)
    public List<SeriesOwnerInfo> getOwners() {
        return new ArrayList<SeriesOwnerInfo>();
    }

    @Override
    public SeriesOwnerInfo getCurrentOwner() {
        return null;
    }

    @Override
    public boolean hasOwner() {
        return false;
    }

    @OneToMany(mappedBy="series")
    public Set<SeriesTagInfo> getFlattenedDicomElements() {
        return this.flattenedDicomElements;
    }

    public void setFlattenedDicomElements(Set<SeriesTagInfo> set) {
        this.flattenedDicomElements = set;
    }

    @ManyToMany
    public Set<Folder> getFolderObjects() {
        return this.folders;
    }

    public void setFolderObjects(Set<Folder> set) {
        this.folders = set;
    }

    @Override
    @Transient
    public Set<String> getFolders() {
        HashSet hashSet = Sets.newHashSet();
        for (Folder folder : this.folders) {
            hashSet.add(folder.getPath());
        }
        return hashSet;
    }

    @OneToMany(mappedBy="series")
    public List<r> getSeriesReferences(DcmSeriesReference.ReferenceSource referenceSource) {
        ArrayList<r> arrayList = new ArrayList<r>(this.seriesReferences.size());
        for (HsqldbSeriesReference hsqldbSeriesReference : this.seriesReferences) {
            arrayList.add(hsqldbSeriesReference);
        }
        return arrayList;
    }

    public void setSeriesReferences(Set<HsqldbSeriesReference> set) {
        this.seriesReferences = set;
    }

    @Override
    @ManyToMany(mappedBy="series")
    public List<String> getPatientLists() {
        ArrayList<String> arrayList = new ArrayList<String>(this.patientLists.size());
        for (HsqldbPatientList hsqldbPatientList : this.patientLists) {
            arrayList.add(hsqldbPatientList.getName());
        }
        return arrayList;
    }

    public void setPatientLists(Set<HsqldbPatientList> set) {
        this.patientLists = set;
    }

    @Override
    @Index(name="ix_Series_lastAccessedTime")
    public Date getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setLastAccessedTime(Date date) {
        this.lastAccessedTime = date;
    }

    @Override
    public Date getDateAdded() {
        return this.dateAdded;
    }

    public void setDateAdded(Date date) {
        this.dateAdded = date;
    }

    @Index(name="ix_Series_sopInstanceUid")
    public void setSopInstanceUid(String string) {
        this.sopInstanceUid = string;
    }

    public String getSopInstanceUid() {
        return this.sopInstanceUid;
    }

    @Index(name="ix_Series_rtPlanName")
    public String getRtPlanName() {
        return this.rtPlanName;
    }

    public void setRtPlanName(String string) {
        this.rtPlanName = string;
    }

    @Index(name="ix_Series_rtPlanLabel")
    public String getRtPlanLabel() {
        return this.rtPlanLabel;
    }

    public void setRtPlanLabel(String string) {
        this.rtPlanLabel = string;
    }

    @Index(name="ix_Series_rtPlanDescription")
    public String getRtPlanDescription() {
        return this.rtPlanDescription;
    }

    public void setRtPlanDescription(String string) {
        this.rtPlanDescription = string;
    }

    @Override
    public int getNumberOfImages() {
        return 0;
    }

    @Index(name="ix_Series_doseComment")
    public String getDoseComment() {
        return this.doseComment;
    }

    public void setDoseComment(String string) {
        this.doseComment = string;
    }

    @Index(name="ix_Series_rtImageName")
    public String getRtImageName() {
        return this.rtImageName;
    }

    public void setRtImageName(String string) {
        this.rtImageName = string;
    }

    @Index(name="ix_Series_rtImageLabel")
    public String getRtImageLabel() {
        return this.rtImageLabel;
    }

    public void setRtImageLabel(String string) {
        this.rtImageLabel = string;
    }

    @Index(name="ix_Series_rtImageDescription")
    public String getRtImageDescription() {
        return this.rtImageDescription;
    }

    public void setRtImageDescription(String string) {
        this.rtImageDescription = string;
    }

    @OneToMany(mappedBy="series")
    public Set<HsqldbSopInstance> getSopInstances() {
        return this.sopInstances;
    }

    public void setSopInstances(Set<HsqldbSopInstance> set) {
        this.sopInstances = set;
    }

    public Set<HsqldbStatus> getStatuses(String string) {
        HashSet hashSet = Sets.newHashSet();
        for (HsqldbStatus hsqldbStatus : this.statuses) {
            if (!StatusMap.a(string, hsqldbStatus.getStatus())) continue;
            hashSet.add(hsqldbStatus);
        }
        return hashSet;
    }

    public String getStatusesAsString(String string) {
        String string2 = "";
        if ("View".equalsIgnoreCase(string)) {
            for (HsqldbStatus hsqldbStatus : this.statuses) {
                int n2 = hsqldbStatus.getStatus();
                if (!StatusMap.a(string, n2)) continue;
                string2 = string2 + new SeriesStatusInfo(hsqldbStatus.getStatus(), hsqldbStatus.getUser(), hsqldbStatus.getTime().getTimeInMillis(), StatusMap.c().a(hsqldbStatus.getStatus())).getStringEncoding() + "~!~";
            }
        } else if ("Workflow".equalsIgnoreCase(string)) {
            ArrayList arrayList = Lists.newArrayList(this.statuses);
            Collections.sort(arrayList, Collections.reverseOrder(u.a));
            for (HsqldbStatus hsqldbStatus : arrayList) {
                int n3 = hsqldbStatus.getStatus();
                if (!StatusMap.a(string, n3)) continue;
                string2 = new SeriesStatusInfo(hsqldbStatus.getStatus(), hsqldbStatus.getUser(), hsqldbStatus.getTime().getTimeInMillis(), StatusMap.c().a(hsqldbStatus.getStatus())).getStringEncoding();
                break;
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string2.endsWith("~!~")) {
            string2 = string2.substring(0, string2.length() - 3);
        }
        return string2;
    }

    @Transient
    public Folder getFirstFolder() {
        return this.folders.iterator().next();
    }

    public boolean addToPatientList(HsqldbPatientList hsqldbPatientList) {
        if (hsqldbPatientList != null && !cn.h(hsqldbPatientList.getName())) {
            return this.patientLists.add(hsqldbPatientList);
        }
        return false;
    }

    public boolean removeFromPatientList(HsqldbPatientList hsqldbPatientList) {
        return this.patientLists.remove(hsqldbPatientList);
    }

    public int removeFromPatientLists(Iterable<HsqldbPatientList> iterable) {
        if (iterable == null) {
            return 0;
        }
        int n2 = 0;
        for (HsqldbPatientList hsqldbPatientList : iterable) {
            if (!this.removeFromPatientList(hsqldbPatientList)) continue;
            ++n2;
        }
        return n2;
    }

    public boolean isInPatientList(HsqldbPatientList hsqldbPatientList) {
        return this.patientLists.contains(hsqldbPatientList);
    }

    public void addSopInstance(HsqldbSopInstance hsqldbSopInstance) {
    }

    @Override
    public int compareTo(HsqldbSeries hsqldbSeries) {
        return Long.valueOf(this.seriesPk).compareTo(hsqldbSeries.getSeriesPk());
    }

    public int hashCode() {
        return this.seriesInstanceUid == null ? 0 : this.seriesInstanceUid.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof HsqldbSeries)) {
            return false;
        }
        HsqldbSeries hsqldbSeries = (HsqldbSeries)object;
        return this.seriesInstanceUid.equalsIgnoreCase(hsqldbSeries.seriesInstanceUid);
    }

    public void copy(HsqldbSeries hsqldbSeries) {
        this.setFrameOfReferenceUid(hsqldbSeries.getFrameOfReferenceUid());
        this.setInstanceCreationDate(hsqldbSeries.getInstanceCreationDate());
        this.setInstitutionName(hsqldbSeries.getInstitutionName());
        this.setLastAccessedTime(Calendar.getInstance().getTime());
        this.setModality(hsqldbSeries.getModality());
        this.setPatientPosition(hsqldbSeries.getPatientPosition());
        this.setSeriesDate(hsqldbSeries.getSeriesDate());
        this.setSeriesDescription(hsqldbSeries.getSeriesDescription());
        this.setSeriesInstanceUid(hsqldbSeries.getSeriesInstanceUid());
        this.setSeriesType(hsqldbSeries.getSeriesType());
        this.setStudy(hsqldbSeries.getStudy());
        this.setSeriesNumber(hsqldbSeries.getSeriesNumber());
        this.setSearchDate(hsqldbSeries.getSearchDate());
        this.setSopInstanceUid(hsqldbSeries.getSopInstanceUid());
        this.setRtPlanName(hsqldbSeries.getRtPlanName());
        this.setRtPlanLabel(hsqldbSeries.getRtPlanLabel());
        this.setRtPlanDescription(hsqldbSeries.getRtPlanDescription());
        this.setDoseComment(hsqldbSeries.getDoseComment());
        this.setRtImageName(hsqldbSeries.getRtImageName());
        this.setRtImageLabel(hsqldbSeries.getRtImageLabel());
        this.setRtImageDescription(hsqldbSeries.getRtImageDescription());
        Set<HsqldbSeriesReference> set = hsqldbSeries.seriesReferences;
        if (set != null) {
            HashSet hashSet = Sets.newHashSetWithExpectedSize((int)set.size());
            for (HsqldbSeriesReference hsqldbSeriesReference : set) {
                if (hsqldbSeriesReference == null) continue;
                HsqldbSeriesReference hsqldbSeriesReference2 = new HsqldbSeriesReference();
                hsqldbSeriesReference2.copy(hsqldbSeriesReference);
                hsqldbSeriesReference2.setSeries(this);
                hashSet.add(hsqldbSeriesReference2);
            }
            this.setSeriesReferences(hashSet);
        }
    }

    public static HsqldbSeries fromDicom(DicomObject dicomObject) {
        Object object;
        Object object222;
        Multimap<DcmSeriesReference.ReferenceSource, DcmSeriesReference> multimap;
        HsqldbSeries hsqldbSeries = new HsqldbSeries();
        hsqldbSeries.setInstitutionName(dicomObject.getString(524416));
        hsqldbSeries.setSeriesDescription(dicomObject.getString(528446));
        hsqldbSeries.setSeriesInstanceUid(dicomObject.getString(0x20000E));
        hsqldbSeries.setSeriesNumber(dicomObject.getString(0x200011));
        hsqldbSeries.setSeriesType(dicomObject.getString(5509120));
        hsqldbSeries.setFrameOfReferenceUid(dicomObject.getString(0x200052));
        hsqldbSeries.setSopInstanceUid(dicomObject.getString(524312));
        hsqldbSeries.setRtPlanName(dicomObject.getString(0x300A0003));
        hsqldbSeries.setRtPlanLabel(dicomObject.getString(805961730));
        hsqldbSeries.setRtPlanDescription(dicomObject.getString(805961732));
        hsqldbSeries.setDoseComment(dicomObject.getString(805568518));
        hsqldbSeries.setRtImageName(dicomObject.getString(0x30020003));
        hsqldbSeries.setRtImageLabel(dicomObject.getString(0x30020002));
        hsqldbSeries.setRtImageDescription(dicomObject.getString(805437444));
        hsqldbSeries.setPatientPosition(dicomObject.getString(1593600));
        String string = RawDicomUtils.readProperDateForPatientList(dicomObject);
        if (string != null) {
            try {
                hsqldbSeries.setSearchDate(new SimpleDateFormat("yyyyMMdd").parse(string));
            }
            catch (Exception exception) {
                ay.c((Object)"The date returned from RawDicomUtils.readProperDateForPatientList failed to parse, using null instead", (Throwable)exception, HsqldbSeries.class);
            }
        }
        try {
            hsqldbSeries.setInstanceCreationDate(dicomObject.getDate(524306));
        }
        catch (Exception exception) {
            ay.d((Object)"Couldn't get instance creation date, using null instead", HsqldbSeries.class);
            hsqldbSeries.setInstanceCreationDate(null);
        }
        String string2 = dicomObject.getString(524310);
        if ("1.2.840.10008.5.1.4.1.1.481.1".equals(string2)) {
            hsqldbSeries.setModality("RTIMAGE");
        } else if ("1.2.840.10008.5.1.4.1.1.481.2".equals(string2)) {
            hsqldbSeries.setModality("RTDOSE");
        } else if ("1.2.840.10008.5.1.4.1.1.481.5".equals(string2) || "1.2.840.10008.5.1.4.1.1.481.8".equals(string2)) {
            hsqldbSeries.setModality("RTPLAN");
        } else {
            hsqldbSeries.setModality(dicomObject.getString(524384));
        }
        try {
            multimap = dicomObject.getDate(524321);
            if (multimap != null) {
                hsqldbSeries.setSeriesDate(new Date(multimap.getYear(), multimap.getMonth(), multimap.getDate()));
            }
        }
        catch (Exception exception) {
            hsqldbSeries.setSeriesDate(null);
        }
        multimap = DcmSeriesReference.extractSeriesReferences(dicomObject);
        for (Object object222 : multimap.values()) {
            HsqldbSeriesReference hsqldbSeriesReference = new HsqldbSeriesReference();
            for (Map.Entry<DcmSeriesReference.ReferenceUidType, String> tagPathComponentArray : ((DcmSeriesReference)object222).getReferences().entrySet()) {
                object = new SeriesReferenceUID();
                ((SeriesReferenceUID)object).setReferenceUIDType(tagPathComponentArray.getKey());
                ((SeriesReferenceUID)object).setReferenceUID(tagPathComponentArray.getValue());
                ((SeriesReferenceUID)object).setSeriesReference(hsqldbSeriesReference);
                hsqldbSeriesReference.getSeriesReferenceUids().add((SeriesReferenceUID)object);
            }
            if (hsqldbSeriesReference.getSeriesReferenceUids().isEmpty()) continue;
            hsqldbSeriesReference.setReferenceSource(((DcmSeriesReference)object222).getSource());
            hsqldbSeriesReference.setSeries(hsqldbSeries);
            hsqldbSeries.seriesReferences.add(hsqldbSeriesReference);
        }
        StringBuilder stringBuilder = new StringBuilder();
        object222 = RawDicomUtils.flattenDicomObject(dicomObject, new RawDicomUtils.DicomElementFilter(){

            @Override
            public boolean accept(DicomObject dicomObject, DicomElement dicomElement) {
                return dicomElement.tag() != 805699641 && dicomElement.vr() != VR.AT;
            }
        });
        for (Object object3 : object222.keySet()) {
            TagPathComponent[] tagPathComponentArray = ((TagPath)object3).getTags();
            object = null;
            String string3 = null;
            String string4 = null;
            stringBuilder.delete(0, stringBuilder.length());
            HsqldbSeries.appendTagPathString(tagPathComponentArray, stringBuilder);
            object = stringBuilder.toString();
            stringBuilder.delete(0, stringBuilder.length());
            HsqldbSeries.appendReverseTagPathString(tagPathComponentArray, stringBuilder);
            string3 = stringBuilder.toString();
            stringBuilder.delete(0, stringBuilder.length());
            HsqldbSeries.appendTagPathIndicesString(((TagPath)object3).getSequenceIndexes(), stringBuilder);
            string4 = stringBuilder.toString();
            hsqldbSeries.flattenedDicomElements.add(new SeriesTagInfo(hsqldbSeries, (String)object, string3, string4, (String)object222.get(object3)));
        }
        return hsqldbSeries;
    }

    private static void appendTagPathString(TagPathComponent[] tagPathComponentArray, StringBuilder stringBuilder) {
        stringBuilder.append(TagUtils.getTagName(tagPathComponentArray[0]));
        for (int i2 = 1; i2 < tagPathComponentArray.length; ++i2) {
            stringBuilder.append('.').append(TagUtils.getTagName(tagPathComponentArray[i2]));
        }
    }

    private static void appendReverseTagPathString(TagPathComponent[] tagPathComponentArray, StringBuilder stringBuilder) {
        stringBuilder.append(TagUtils.getTagName(tagPathComponentArray[tagPathComponentArray.length - 1]));
        for (int i2 = tagPathComponentArray.length - 2; i2 >= 0; --i2) {
            stringBuilder.append('.').append(TagUtils.getTagName(tagPathComponentArray[i2]));
        }
    }

    private static void appendTagPathIndicesString(int[] nArray, StringBuilder stringBuilder) {
        stringBuilder.append(nArray[0]);
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            stringBuilder.append('.').append(nArray[i2]);
        }
    }

    public boolean existsInDatabase(Session session) {
        Long l2 = (Long)session.createQuery("SELECT seriesPk FROM HsqldbSeries WHERE seriesInstanceUid = :uid").setString("uid", this.seriesInstanceUid).uniqueResult();
        if (l2 != null) {
            this.seriesPk = l2;
            return true;
        }
        return false;
    }

    public Long save(Session session) {
        Long l2 = (Long)session.save((Object)this);
        for (HsqldbSeriesReference object : this.seriesReferences) {
            session.save((Object)object);
        }
        for (SeriesTagInfo seriesTagInfo : this.flattenedDicomElements) {
            session.save((Object)seriesTagInfo);
        }
        return l2;
    }

    @Override
    @Transient
    public List<String> getSopInstanceUids() {
        return null;
    }

    @Override
    public long getPk() {
        return 0L;
    }

    @Override
    public Set<String> getPatientListSet() {
        return null;
    }

    @Override
    public QueryResult asQueryResult() {
        return null;
    }

    @Override
    public TreeMap<Integer, String> asTreeMap() {
        return null;
    }

    @Override
    public Date getSeriesTime() {
        return null;
    }

    @Override
    public List<Long> getPatientListIds() {
        return null;
    }

    @Override
    public Set<Long> getPatientListIdSet() {
        return null;
    }

    @Override
    public boolean hasTag(int ... nArray) {
        return false;
    }

    @Override
    public int getInt(int ... nArray) {
        return 0;
    }

    @Override
    public long getLong(int ... nArray) {
        return 0L;
    }

    @Override
    public String getString(int ... nArray) {
        return null;
    }

    @Override
    public double getDouble(int ... nArray) {
        return 0.0;
    }

    @Override
    public boolean getBoolean(int ... nArray) {
        return false;
    }

    @Override
    public Date getDate(int ... nArray) {
        return null;
    }

    @Override
    public Date getTime(int ... nArray) {
        return null;
    }

    @Override
    public LoaderDataProvider getDataProvider() {
        return null;
    }

    @Override
    public String toJson(int n2) {
        return null;
    }

    @Override
    public Map<String, Object> asJsonMap(int n2) {
        return null;
    }

    public List<r> getEmbeddedReferences() {
        return Collections.emptyList();
    }

    @Override
    public l getPatient() {
        return null;
    }

    @Override
    public Integer getEmbedIndex() {
        return null;
    }

    @Override
    public List<Long> getChildren() {
        return null;
    }
}

