/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.metabase.hsqldb;

import com.google.common.collect.Sets;
import com.mimvista.dicom.DcmSeriesReference;
import com.mimvista.metabase.Series;
import com.mimvista.metabase.e;
import com.mimvista.metabase.hsqldb.HsqldbSeries;
import com.mimvista.metabase.hsqldb.SeriesReferenceUID;
import com.mimvista.metabase.p;
import com.mimvista.metabase.r;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.classic.Session;

@Entity
@Table(name="seriesreference")
public class HsqldbSeriesReference
implements r,
Serializable,
Comparable<HsqldbSeriesReference> {
    private static final long serialVersionUID = 1L;
    private long pk;
    private HsqldbSeries series;
    private Set<SeriesReferenceUID> seriesReferenceUids = Sets.newHashSet();
    private transient Set<HsqldbSeries> referencedSeries;
    @Enumerated(value=EnumType.STRING)
    private DcmSeriesReference.ReferenceSource referenceSource;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public long getPk() {
        return this.pk;
    }

    public void setPk(long l2) {
        this.pk = l2;
    }

    @ManyToOne(fetch=FetchType.EAGER, targetEntity=HsqldbSeries.class)
    @JoinColumn(name="Series_SeriesPK")
    public HsqldbSeries getSeries() {
        return this.series;
    }

    public void setSeries(HsqldbSeries hsqldbSeries) {
        this.series = hsqldbSeries;
    }

    @OneToMany(mappedBy="seriesReference")
    public Set<SeriesReferenceUID> getSeriesReferenceUids() {
        return this.seriesReferenceUids;
    }

    public void setSeriesReferenceUids(Set<SeriesReferenceUID> set) {
        this.seriesReferenceUids = set;
    }

    @Enumerated(value=EnumType.STRING)
    public DcmSeriesReference.ReferenceSource getReferenceSource() {
        return this.referenceSource;
    }

    public void setReferenceSource(DcmSeriesReference.ReferenceSource referenceSource) {
        this.referenceSource = referenceSource;
    }

    @Transient
    public List<Series> getReferencedSeries(e e2) {
        ArrayList<Series> arrayList = new ArrayList<Series>(this.referencedSeries.size());
        for (HsqldbSeries hsqldbSeries : this.referencedSeries) {
            arrayList.add(hsqldbSeries);
        }
        return arrayList;
    }

    public void setReferencedSeries(Set<HsqldbSeries> set) {
        this.referencedSeries = set;
    }

    @Override
    public int compareTo(HsqldbSeriesReference hsqldbSeriesReference) {
        return Long.valueOf(this.pk).compareTo(hsqldbSeriesReference.getPk());
    }

    public void copy(HsqldbSeriesReference hsqldbSeriesReference) {
        this.setReferenceSource(hsqldbSeriesReference.getReferenceSource());
        Set<SeriesReferenceUID> set = hsqldbSeriesReference.getSeriesReferenceUids();
        if (set != null) {
            HashSet hashSet = Sets.newHashSetWithExpectedSize((int)set.size());
            for (SeriesReferenceUID seriesReferenceUID : set) {
                if (seriesReferenceUID == null) continue;
                SeriesReferenceUID seriesReferenceUID2 = new SeriesReferenceUID();
                seriesReferenceUID2.copy(seriesReferenceUID);
                seriesReferenceUID2.setSeriesReference(this);
                hashSet.add(seriesReferenceUID2);
            }
            this.setSeriesReferenceUids(hashSet);
        }
    }

    public Long save(Session session) {
        this.pk = (Long)session.save((Object)this);
        for (SeriesReferenceUID seriesReferenceUID : this.seriesReferenceUids) {
            session.save((Object)seriesReferenceUID);
        }
        return this.pk;
    }

    @Override
    public DcmSeriesReference.ReferenceSource getSource() {
        return null;
    }

    @Override
    public List<p> getUids() {
        return null;
    }
}

