/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.metabase.hsqldb;

import com.mimvista.metabase.hsqldb.HsqldbPatient;
import com.mimvista.metabase.v;
import java.io.Serializable;
import java.sql.Time;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.dcm4che2.data.DicomObject;
import org.hibernate.Session;

@Entity
@Table(name="study")
public class HsqldbStudy
implements v,
Serializable,
Comparable<HsqldbStudy> {
    private static final long serialVersionUID = 1L;
    private long studyPk;
    private String studyInstanceUid;
    private Date studyDate;
    private String studyDescription;
    private String accessionNumber;
    private String referringPhysicianName;
    private String studyId;
    private Time studyTime;
    private HsqldbPatient patient;

    @Id
    @GeneratedValue
    public long getStudyPk() {
        return this.studyPk;
    }

    public void setStudyPk(long l2) {
        this.studyPk = l2;
    }

    @Override
    @NotNull
    public String getStudyInstanceUid() {
        return this.studyInstanceUid;
    }

    public void setStudyInstanceUid(String string) {
        this.studyInstanceUid = string;
    }

    @Override
    public Date getStudyDate() {
        return this.studyDate;
    }

    public void setStudyDate(Date date) {
        this.studyDate = date;
    }

    @Override
    public Time getStudyTime() {
        return this.studyTime;
    }

    public void setStudyTime(Time time) {
        this.studyTime = time;
    }

    @Override
    public String getStudyDescription() {
        return this.studyDescription;
    }

    public void setStudyDescription(String string) {
        this.studyDescription = string;
    }

    @Override
    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setAccessionNumber(String string) {
        this.accessionNumber = string;
    }

    @Override
    public String getReferringPhysicianName() {
        return this.referringPhysicianName;
    }

    public void setReferringPhysicianName(String string) {
        this.referringPhysicianName = string;
    }

    public void setStudyId(String string) {
        this.studyId = string;
    }

    @Override
    public String getStudyId() {
        return this.studyId;
    }

    @Override
    @ManyToOne
    @JoinColumn(name="Patient_pk")
    public HsqldbPatient getPatient() {
        return this.patient;
    }

    public void setPatient(HsqldbPatient hsqldbPatient) {
        this.patient = hsqldbPatient;
    }

    public int hashCode() {
        return Long.valueOf(this.studyPk).hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof HsqldbStudy)) {
            return false;
        }
        HsqldbStudy hsqldbStudy = (HsqldbStudy)object;
        return this.studyInstanceUid.equalsIgnoreCase(hsqldbStudy.studyInstanceUid);
    }

    @Override
    public int compareTo(HsqldbStudy hsqldbStudy) {
        return Long.valueOf(this.studyPk).compareTo(hsqldbStudy.studyPk);
    }

    public boolean existsInDatabase(Session session) {
        Long l2 = (Long)session.createQuery("SELECT studyPk FROM HsqldbStudy WHERE studyInstanceUid = :uid").setString("uid", this.studyInstanceUid).uniqueResult();
        if (l2 != null) {
            this.studyPk = l2;
            return true;
        }
        return false;
    }

    public static HsqldbStudy fromDicom(DicomObject dicomObject) {
        HsqldbStudy hsqldbStudy = new HsqldbStudy();
        hsqldbStudy.accessionNumber = dicomObject.getString(524368);
        hsqldbStudy.referringPhysicianName = dicomObject.getString(524432);
        try {
            hsqldbStudy.studyDate = dicomObject.getDate(524320);
        }
        catch (Exception exception) {
            hsqldbStudy.studyDate = null;
        }
        try {
            hsqldbStudy.studyTime = new Time(dicomObject.getDate(524336).getTime());
        }
        catch (Exception exception) {
            hsqldbStudy.studyTime = null;
        }
        hsqldbStudy.studyDescription = dicomObject.getString(528432);
        hsqldbStudy.studyInstanceUid = dicomObject.getString(0x20000D);
        return hsqldbStudy;
    }
}

