/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.metabase.hsqldb;

import com.google.common.collect.Sets;
import com.mimvista.archive.search.Searchable;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.file.j;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.metabase.Series;
import com.mimvista.metabase.e;
import com.mimvista.metabase.f;
import com.mimvista.metabase.g;
import com.mimvista.metabase.h;
import com.mimvista.metabase.hsqldb.Folder;
import com.mimvista.metabase.hsqldb.HsqldbPatient;
import com.mimvista.metabase.hsqldb.HsqldbPatientList;
import com.mimvista.metabase.hsqldb.HsqldbSeries;
import com.mimvista.metabase.hsqldb.HsqldbSeriesReference;
import com.mimvista.metabase.hsqldb.HsqldbSopInstance;
import com.mimvista.metabase.hsqldb.HsqldbStatus;
import com.mimvista.metabase.hsqldb.HsqldbStudy;
import com.mimvista.metabase.hsqldb.SeriesReferenceUID;
import com.mimvista.metabase.hsqldb.SeriesTagInfo;
import com.mimvista.metabase.hsqldb.Version;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.ay;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.dcm4che2.data.DicomObject;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;

public class a
implements e {
    private Configuration b = new AnnotationConfiguration().addAnnotatedClass(HsqldbStatus.class).addAnnotatedClass(HsqldbPatient.class).addAnnotatedClass(HsqldbPatientList.class).addAnnotatedClass(HsqldbStudy.class).addAnnotatedClass(SeriesReferenceUID.class).addAnnotatedClass(HsqldbSeriesReference.class).addAnnotatedClass(HsqldbSeries.class).addAnnotatedClass(SeriesTagInfo.class).addAnnotatedClass(HsqldbSopInstance.class).addAnnotatedClass(Folder.class).addAnnotatedClass(Version.class).setProperty("hibernate.dialect", "org.hibernate.dialect.HSQLDialect").setProperty("hibernate.connection.driver_class", "org.hsqldb.jdbcDriver").setProperty("hibernate.connection.url", "jdbc:hsqldb:hsql://localhost/metabase;hsqldb.default_table_type=cached").setProperty("hibernate.connection.username", "sa").setProperty("hibernate.connection.password", "").setProperty("hibernate.connection.pool_size", "1").setProperty("hibernate.connection.autocommit", "true").setProperty("hibernate.current_session_context_class", "org.hibernate.context.ThreadLocalSessionContext").setProperty("hibernate.hbm2ddl.auto", "update").setProperty("hibernate.cache.provider_class", "org.hibernate.cache.HashtableCacheProvider");
    private SessionFactory c = this.b.buildSessionFactory();

    public g a(File file, List<String> list) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("folder cannot be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("The specified path doesn't exist: " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The specified path is not a folder: " + file.getAbsolutePath());
        }
        g g2 = new g();
        HashSet hashSet = null;
        try {
            hashSet = Sets.newHashSet(Folder.getByRootPath(this.f(), file));
        }
        catch (Throwable throwable) {
            hashSet = Sets.newHashSet();
        }
        this.a(hashSet, file, g2);
        return g2;
    }

    private void a(Set<Folder> set, File file, g g2) {
        for (File file2 : file.listFiles(j.a)) {
            this.a(set, file2, g2);
        }
        Folder folder = new Folder(file.getAbsolutePath());
        if (set.contains(folder)) {
            return;
        }
        this.f().beginTransaction();
        try {
            this.f().save((Object)folder);
            for (File file3 : file.listFiles(j.b)) {
                try {
                    this.a(folder, file3, g2);
                }
                catch (Exception exception) {
                    ay.d((Object)("Failed to index file: " + file3.getName()), (Throwable)exception, this);
                }
            }
            this.f().getTransaction().commit();
        }
        catch (Exception exception) {
            ay.d((Object)("Unable to index folder: " + file.getAbsolutePath()), (Throwable)exception, this);
            this.f().getTransaction().rollback();
        }
    }

    private boolean a(Folder folder, File file, g g2) {
        Object object;
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(file, new ArrayList<Integer>(HsqldbSeries.TAG_WHITELIST));
        if (dicomObject == null) {
            return false;
        }
        HsqldbSeries hsqldbSeries = HsqldbSeries.fromDicom(dicomObject);
        if (!hsqldbSeries.existsInDatabase(this.f())) {
            ++g2.a;
            object = HsqldbStudy.fromDicom(dicomObject);
            if (!((HsqldbStudy)object).existsInDatabase(this.f())) {
                HsqldbPatient hsqldbPatient = HsqldbPatient.fromDicom(dicomObject);
                if (!hsqldbPatient.existsInDatabase(this.f())) {
                    this.f().save((Object)hsqldbPatient);
                } else {
                    hsqldbPatient = (HsqldbPatient)this.f().load(HsqldbPatient.class, (Serializable)Long.valueOf(hsqldbPatient.getPk()));
                }
                ((HsqldbStudy)object).setPatient(hsqldbPatient);
                this.f().save(object);
            } else {
                object = (HsqldbStudy)this.f().load(HsqldbStudy.class, (Serializable)Long.valueOf(((HsqldbStudy)object).getStudyPk()));
            }
            hsqldbSeries.study = object;
            hsqldbSeries.folders.add(folder);
            hsqldbSeries.save(this.f());
        }
        object = new HsqldbSopInstance(hsqldbSeries.sopInstanceUid, file.getName());
        ((HsqldbSopInstance)object).setSeries(hsqldbSeries);
        this.f().save(object);
        return true;
    }

    public Session f() {
        return this.c.getCurrentSession();
    }

    @Override
    public MetabaseQuery e() {
        return null;
    }

    public List<Series> a(MetabaseQuery metabaseQuery) {
        return null;
    }

    @Override
    public int a(MetabaseQuery metabaseQuery, FuncUtils.m<List<? extends Series>> m2, Searchable.a a2) {
        return 0;
    }

    @Override
    public void a() {
    }

    @Override
    public void a(String ... stringArray) {
    }

    @Override
    public void b(String ... stringArray) {
    }

    @Override
    public void b(String string) {
    }

    @Override
    public h c() {
        return null;
    }

    @Override
    public void a(String string, String string2) {
    }

    @Override
    public void a(long l2, String string) {
    }

    @Override
    public void b() {
    }

    @Override
    public void a(Iterable<String> iterable) {
    }

    @Override
    public long a(String string) {
        return 0L;
    }

    @Override
    public long c(String string) {
        return 0L;
    }

    @Override
    public String a(long l2) {
        return null;
    }

    @Override
    public f d() {
        return null;
    }

    @Override
    public Series d(String string) {
        return null;
    }

    @Override
    public void e(String string) {
    }

    @Override
    public void a(File file) {
    }

    @Override
    public boolean a(long l2, TimeUnit timeUnit) {
        return false;
    }
}

