/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.metabase.indexing.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.metabase.indexing.ScanOptions;
import com.mimvista.metabase.indexing.service.MetabaseIndexingService;
import com.mimvista.metabase.indexing.service.c;
import com.mimvista.metabase.j;
import com.mimvista.preferencesNew.h;
import com.mimvista.properties.af;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.ay;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MetabaseIndexingServiceImpl
extends UnicastRemoteObject
implements MetabaseIndexingService {
    private static final long serialVersionUID = 1L;
    private Queue<c> taskQueue;
    private Map<Integer, c> taskByIdLookup;
    private Map<File, c> taskByFolderLookup;
    private c taskInProgress;
    private Lock queueLock = new ReentrantLock();
    private Condition queueHasTasks = this.queueLock.newCondition();
    private boolean shouldStopScanning = false;
    private boolean shouldCreateIndexes = false;
    private a scanningThread;

    public MetabaseIndexingServiceImpl() throws RemoteException {
        this.taskQueue = new ArrayDeque<c>(10);
        this.taskByIdLookup = Maps.newTreeMap();
        this.taskByFolderLookup = Maps.newTreeMap();
    }

    private c c() {
        c c2 = this.taskQueue.remove();
        this.taskByIdLookup.remove(c2.b());
        this.taskByFolderLookup.remove(c2.a());
        return c2;
    }

    private void a(c c2) {
        try (com.mimvista.util.e.a a2 = com.mimvista.util.e.a.a(this.queueLock);){
            this.taskQueue.add(c2);
            this.taskByIdLookup.put(c2.b(), c2);
            this.taskByFolderLookup.put(c2.a(), c2);
            this.queueHasTasks.signalAll();
        }
    }

    private void b(c c2) {
        try (com.mimvista.util.e.a a2 = com.mimvista.util.e.a.a(this.queueLock);){
            this.taskQueue.remove(c2);
            this.taskByIdLookup.remove(c2.b());
            this.taskByFolderLookup.remove(c2.a());
        }
    }

    private void d() {
        try (com.mimvista.util.e.a a2 = com.mimvista.util.e.a.a(this.queueLock);){
            this.taskQueue.clear();
            this.taskByIdLookup.clear();
            this.taskByFolderLookup.clear();
        }
    }

    public void a() {
        if (this.scanningThread == null) {
            this.shouldStopScanning = false;
            this.scanningThread = new a();
            this.scanningThread.start();
        }
    }

    public void b() {
        if (this.scanningThread != null) {
            this.shouldStopScanning = true;
            this.scanningThread.interrupt();
            try {
                this.scanningThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.scanningThread = null;
        }
    }

    @Override
    public String getVersion() throws RemoteException {
        return VersionNumber.rawCurrentVersionNotAccountingForMIMviewer().getFullVersionString();
    }

    @Override
    public void scanArchiveFolder(File file) throws RemoteException {
        this.scanArchiveFolder(file, ScanOptions.a());
    }

    @Override
    public void scanArchiveFolder(File file, ScanOptions scanOptions) throws RemoteException {
        Preconditions.checkArgument((boolean)file.isAbsolute(), (String)"Not an absolute path: %s", (Object[])new Object[]{file});
        file = Path.getCanonicalOrAbsoluteFile(file);
        MIMFile.j(file);
        try (com.mimvista.util.e.a a2 = com.mimvista.util.e.a.a(this.queueLock);){
            c c2 = this.taskByFolderLookup.get(file);
            if (c2 == null) {
                this.a(new c(file, scanOptions));
            } else {
                ay.b((Object)("Ignoring request to scan folder " + file + " - it's already in the queue to be scanned"), this);
            }
        }
    }

    @Override
    public void createIndexes() throws RemoteException {
        this.shouldCreateIndexes = true;
    }

    @Override
    public boolean cancelScan(File file) throws RemoteException {
        c c2 = null;
        try (com.mimvista.util.e.a a2 = com.mimvista.util.e.a.a(this.queueLock);){
            c c3;
            if (this.taskInProgress != null && this.taskInProgress.a().equals(file)) {
                this.taskInProgress.c();
                c2 = this.taskInProgress;
            }
            if ((c3 = this.taskByFolderLookup.get(file)) != null) {
                this.b(c3);
            }
        }
        if (c2 != null) {
            try {
                c2.d();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void getProgress() throws RemoteException {
    }

    @Override
    public void reloadConfiguration() throws RemoteException {
        af.clearCache();
        h.a().l();
    }

    private class a
    extends Thread {
        public a() {
            super("metabase-scanning-thread");
        }

        @Override
        public void run() {
            ay.b((Object)"Scanning thread starting up", this);
            block15: while (!MetabaseIndexingServiceImpl.this.shouldStopScanning) {
                try {
                    try (com.mimvista.util.e.a a2 = com.mimvista.util.e.a.a(MetabaseIndexingServiceImpl.this.queueLock);){
                        while (MetabaseIndexingServiceImpl.this.taskQueue.isEmpty()) {
                            if (MetabaseIndexingServiceImpl.this.shouldCreateIndexes) {
                                MetabaseIndexingServiceImpl.this.shouldCreateIndexes = false;
                                j.a().b();
                            }
                            MetabaseIndexingServiceImpl.this.queueHasTasks.await(250L, TimeUnit.MILLISECONDS);
                            if (!MetabaseIndexingServiceImpl.this.shouldStopScanning) continue;
                            break block15;
                        }
                        MetabaseIndexingServiceImpl.this.taskInProgress = MetabaseIndexingServiceImpl.this.c();
                    }
                    MetabaseIndexingServiceImpl.this.taskInProgress.run();
                    MetabaseIndexingServiceImpl.this.shouldCreateIndexes = true;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error on scanning thread", throwable, this);
                }
            }
            ay.b((Object)"Scanning thread shutting down", this);
        }
    }
}

