/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.metabase.mongo;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.archive.Parser;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.dicom.DcmSeriesReference;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesOwnerInfo;
import com.mimvista.dicom.SeriesStatusInfo;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.file.j;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.metabase.MetabaseOwnerStrings;
import com.mimvista.metabase.Series;
import com.mimvista.metabase.StatusMap;
import com.mimvista.metabase.i;
import com.mimvista.metabase.l;
import com.mimvista.metabase.mongo.a;
import com.mimvista.metabase.mongo.h;
import com.mimvista.metabase.mongo.k;
import com.mimvista.metabase.mongo.n;
import com.mimvista.metabase.mongo.q;
import com.mimvista.metabase.mongo.s;
import com.mimvista.metabase.r;
import com.mimvista.metabase.u;
import com.mimvista.metabase.v;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.json.b;
import com.mimvista.util.logging.MIMLogLevel;
import com.mongodb.BasicDBObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.dcm4che2.util.DateUtils;

public class MongoSeries
implements Series {
    static final long serialVersionUID = 1L;
    transient k a;
    Map<String, Object> dbObject;

    a a() {
        Object object = this.dbObject.get("mimdata");
        if (object != null) {
            return new a((Map<String, Object>)((BasicDBObject)object));
        }
        return null;
    }

    void a(k k2) {
        this.a = k2;
    }

    public MongoSeries(k k2, Map<String, Object> map) {
        this.a = k2;
        this.dbObject = map;
    }

    @Override
    public long getPk() {
        try {
            return this.c("_id");
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.c, "Couldn't get PrimaryKey '_id' (it might not exist in this object)", exception);
            return -1L;
        }
    }

    @Override
    public String getSeriesInstanceUid() {
        return this.getString(0x20000E);
    }

    @Override
    public String getSeriesDescription() {
        return this.getString(528446);
    }

    @Override
    public String getModality() {
        return this.getString(524384);
    }

    @Override
    public String getManufacturer() {
        return this.getString(524400);
    }

    @Override
    public Date getSeriesDate() {
        try {
            return this.getDate(524321);
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.c, "Couldn't get SeriesDate (it might not exist in this object)", exception);
            return null;
        }
    }

    @Override
    public Date getSeriesTime() {
        try {
            return this.getTime(524337);
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.c, "Couldn't get SeriesTime (it might not exist in this object)", exception);
            return null;
        }
    }

    @Override
    public Integer getEmbedIndex() {
        try {
            a a2 = this.a();
            if (a2 != null) {
                return a2.j();
            }
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.c, "Couldn't get mimdata.embedIdx (it might not exist in this object)", exception);
        }
        return null;
    }

    @Override
    public String getFrameOfReferenceUid() {
        return this.getString(0x200052);
    }

    @Override
    public v getStudy() {
        return new s(this.dbObject);
    }

    @Override
    public l getPatient() {
        return new n(this.dbObject);
    }

    @Override
    public List<u> getStatuses() {
        a a2 = this.a();
        if (a2 != null) {
            return a2.p();
        }
        return Collections.emptyList();
    }

    @Override
    public List<SeriesOwnerInfo> getOwners() {
        a a2 = this.a();
        if (a2 != null) {
            return a2.q();
        }
        return null;
    }

    @Override
    public SeriesOwnerInfo getCurrentOwner() {
        a a2 = this.a();
        if (a2 != null) {
            return a2.r();
        }
        return null;
    }

    @Override
    public boolean hasOwner() {
        SeriesOwnerInfo seriesOwnerInfo = this.getCurrentOwner();
        return seriesOwnerInfo != null && !cn.h(seriesOwnerInfo.getOwnerName()) && MetabaseOwnerStrings.c.b(seriesOwnerInfo.getOwnerName()) == null;
    }

    @Override
    public List<Long> getChildren() {
        a a2 = this.a();
        if (a2 != null) {
            return Lists.newArrayList(a2.n());
        }
        return Collections.emptyList();
    }

    @Override
    public Set<String> getFolders() {
        a a2 = this.a();
        if (a2 != null) {
            return a2.m();
        }
        return Collections.emptySet();
    }

    @Override
    public Date getLastAccessedTime() {
        a a2 = this.a();
        if (a2 != null) {
            return a2.d();
        }
        return null;
    }

    @Override
    public Date getDateAdded() {
        a a2 = this.a();
        if (a2 != null) {
            return a2.c();
        }
        return null;
    }

    @Override
    public List<String> getSopInstanceUids() {
        a a2 = this.a();
        if (a2 != null) {
            return Lists.newArrayList(a2.h());
        }
        return Collections.emptyList();
    }

    @Override
    public int getNumberOfImages() {
        a a2 = this.a();
        if (a2 != null && a2.i() > 0) {
            return a2.i();
        }
        String string = null;
        try {
            string = this.getFolders().iterator().next();
            return Parser.getNumSeriesRelatedInstances(string);
        }
        catch (Throwable throwable) {
            String string2 = String.format("Couldn't get number of images from series path %s using 1 instead", string != null ? "- " + string + " -" : "-");
            this.a(MIMLogLevel.d, string2, throwable);
            return 1;
        }
    }

    @Override
    public boolean hasTag(int ... nArray) {
        return this.a(this.a(nArray));
    }

    public boolean a(String ... stringArray) {
        return this.i(stringArray) != null;
    }

    @Override
    public int getInt(int ... nArray) {
        return this.b(this.a(nArray));
    }

    public int b(String ... stringArray) {
        Object object = this.i(stringArray);
        if (object == null) {
            throw new NullPointerException(Arrays.toString(stringArray) + " is null, can't coerce to an int");
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        throw new IllegalArgumentException("can't convert: " + Arrays.toString(stringArray) + " (" + object.getClass().getName() + ") to int");
    }

    @Override
    public long getLong(int ... nArray) {
        return this.c(this.a(nArray));
    }

    public long c(String ... stringArray) {
        return ((Number)this.i(stringArray)).longValue();
    }

    @Override
    public String getString(int ... nArray) {
        return this.d(this.a(nArray));
    }

    public String d(String ... stringArray) {
        Object object = this.i(stringArray);
        return object == null ? null : object.toString();
    }

    @Override
    public double getDouble(int ... nArray) {
        return this.e(this.a(nArray));
    }

    public double e(String ... stringArray) {
        return ((Number)this.i(stringArray)).doubleValue();
    }

    @Override
    public boolean getBoolean(int ... nArray) {
        return this.f(this.a(nArray));
    }

    public boolean f(String ... stringArray) {
        Object object = this.i(stringArray);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() > 0;
        }
        throw new IllegalArgumentException("can't coerce " + Arrays.toString(stringArray) + " (" + object.getClass().getName() + ") to bool");
    }

    @Override
    public Date getDate(int ... nArray) {
        return this.g(this.a(nArray));
    }

    public Date g(String ... stringArray) {
        return (Date)this.i(stringArray);
    }

    @Override
    public Date getTime(int ... nArray) {
        return this.getDate(nArray);
    }

    public Date h(String ... stringArray) {
        return this.g(stringArray);
    }

    private String[] a(int ... nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringArray[i2] = MetabaseKeys.fromTag(nArray[i2]);
        }
        return stringArray;
    }

    private Object i(String ... stringArray) {
        Map map = this.dbObject;
        if (stringArray == null) {
            throw new NullPointerException("keyPath can't be null");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("keyPath can't be empty");
        }
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            Object object = map.get(stringArray[i2]);
            if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                if (Iterables.isEmpty((Iterable)iterable)) {
                    return null;
                }
                map = (Map)iterable.iterator().next();
                continue;
            }
            if (object instanceof Map) {
                map = (Map)object;
                continue;
            }
            ay.c((Object)("MongoSeries: Pulled an object with unexpected type out of a dbObject: " + object.getClass()), this);
            return null;
        }
        return map.get(stringArray[stringArray.length - 1]);
    }

    @Override
    public List<String> getPatientLists() {
        a a2 = this.a();
        if (a2 == null) {
            return Collections.emptyList();
        }
        ArrayList arrayList = Lists.newArrayList();
        Set<Long> set = a2.o();
        if (set != null) {
            for (Long l2 : set) {
                arrayList.add(this.a.a(l2));
            }
        }
        return arrayList;
    }

    @Override
    public Set<String> getPatientListSet() {
        a a2 = this.a();
        if (a2 == null) {
            return Collections.emptySet();
        }
        HashSet hashSet = Sets.newHashSet();
        Set<Long> set = a2.o();
        if (set != null) {
            for (Long l2 : set) {
                hashSet.add(this.a.a(l2));
            }
        }
        return hashSet;
    }

    @Override
    public List<Long> getPatientListIds() {
        a a2 = this.a();
        if (a2 == null) {
            return Collections.emptyList();
        }
        ArrayList arrayList = Lists.newArrayList();
        Set<Long> set = a2.o();
        if (set != null) {
            arrayList.addAll(set);
        }
        return arrayList;
    }

    @Override
    public Set<Long> getPatientListIdSet() {
        a a2 = this.a();
        if (a2 == null) {
            return Collections.emptySet();
        }
        HashSet hashSet = Sets.newHashSet();
        Set<Long> set = a2.o();
        if (set != null) {
            hashSet.addAll(set);
        }
        return hashSet;
    }

    @Override
    public LoaderDataProvider getDataProvider() {
        for (String string : this.getFolders()) {
            File[] fileArray;
            File file = new File(string);
            if (!file.isDirectory() || (fileArray = file.listFiles(j.b)) == null || fileArray.length == 0) continue;
            return new LoaderDataProvider.FileBasedLoaderDataProvider(fileArray);
        }
        return null;
    }

    public List<r> b() {
        try {
            return this.a(DcmSeriesReference.ReferenceSource.ReferencedStructureSetSequence);
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.d, "Couldn't get references from ReferencedStructureSetSequence", exception);
            return null;
        }
    }

    public List<r> c() {
        try {
            return this.a(DcmSeriesReference.ReferenceSource.ReferencedRTPlanSequence);
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.d, "Couldn't get references from ReferencedRTPlanSequence", exception);
            return null;
        }
    }

    public List<r> d() {
        try {
            return this.a(DcmSeriesReference.ReferenceSource.ReferencedDoseSequence);
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.d, "Couldn't get references from ReferencedDoseSequence", exception);
            return null;
        }
    }

    public List<r> e() {
        try {
            Collection collection = (Collection)this.dbObject.get(MetabaseKeys.fromTag(805699600));
            if (collection == null || collection.isEmpty()) {
                return null;
            }
            ArrayList arrayList = Lists.newArrayList();
            String string = MetabaseKeys.fromTag(0x20000E);
            String string2 = MetabaseKeys.fromTag(528725);
            for (Object e2 : collection) {
                BasicDBObject basicDBObject = (BasicDBObject)e2;
                Collection collection2 = (Collection)basicDBObject.get(MetabaseKeys.fromTag(805699602));
                String string3 = basicDBObject.getString(MetabaseKeys.fromTag(0x200052));
                if (collection2 == null || collection2.isEmpty()) continue;
                for (Object e3 : collection2) {
                    Collection collection3 = (Collection)((BasicDBObject)e3).get(MetabaseKeys.fromTag(805699604));
                    if (collection3 == null || collection3.isEmpty()) continue;
                    for (Object e4 : collection3) {
                        BasicDBObject basicDBObject2;
                        String string4;
                        Object object;
                        BasicDBObject basicDBObject3 = (BasicDBObject)e4;
                        if (Modality.RTST.isSameModality(this.getModality()) && (object = (Collection)basicDBObject3.get(MetabaseKeys.fromTag(805699606))) != null && object.size() == 1 && !cn.h(string4 = (basicDBObject2 = (BasicDBObject)Iterables.get((Iterable)object, (int)0)).getString(string2, null))) {
                            q q2 = new q(DcmSeriesReference.ReferenceSource.ReferencedFrameOfReferenceSequence).a(524312, string4);
                            if (string3 != null) {
                                q2.a(0x200052, string3);
                            }
                            arrayList.add(q2);
                            continue;
                        }
                        if (!basicDBObject3.containsField(string)) continue;
                        object = new q(DcmSeriesReference.ReferenceSource.ReferencedFrameOfReferenceSequence).a(0x20000E, basicDBObject3.getString(string));
                        if (string3 != null) {
                            ((q)object).a(0x200052, string3);
                        }
                        arrayList.add(object);
                    }
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.d, "Couldn't get references from ReferencedFrameOfReferenceSequence", exception);
            return null;
        }
    }

    public List<r> f() {
        try {
            Collection collection = (Collection)this.dbObject.get(MetabaseKeys.fromTag(930283796));
            if (collection == null || collection.isEmpty()) {
                return null;
            }
            ArrayList arrayList = Lists.newArrayList();
            String string = MetabaseKeys.fromTag(806092896);
            for (Object e2 : collection) {
                Collection collection2 = (Collection)((BasicDBObject)e2).get(string);
                if (collection2 == null || collection2.isEmpty()) continue;
                this.a(DcmSeriesReference.ReferenceSource.ReferencedStructureSetSequence, collection2, arrayList);
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.d, "Couldn't get references from MIMBrachySequence", exception);
            return null;
        }
    }

    public List<r> g() {
        try {
            Collection collection = (Collection)this.dbObject.get(MetabaseKeys.fromTag(528661));
            if (collection == null || collection.isEmpty()) {
                if (this.m()) {
                    return this.j();
                }
                return null;
            }
            ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)collection.size());
            String string = MetabaseKeys.fromTag(0x20000E);
            for (Object e2 : collection) {
                BasicDBObject basicDBObject = (BasicDBObject)e2;
                if (!basicDBObject.containsField(string)) continue;
                arrayList.add(new q(DcmSeriesReference.ReferenceSource.ReferencedSeriesSequence).a(0x20000E, basicDBObject.getString(string)));
            }
            if (this.m()) {
                this.a(arrayList, this.j());
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.d, "Couldn't get references from ReferencedSeriesSequence", exception);
            return null;
        }
    }

    public List<r> h() {
        try {
            BasicDBObject basicDBObject = (BasicDBObject)this.dbObject.get("mimdata");
            if (basicDBObject == null) {
                return Collections.emptyList();
            }
            Collection collection = (Collection)basicDBObject.get("parentSeriesUids");
            if (collection == null || collection.isEmpty()) {
                return null;
            }
            ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)collection.size());
            for (Object e2 : collection) {
                String string = (String)e2;
                arrayList.add(new q(DcmSeriesReference.ReferenceSource.MimdataSpecialTag).a(0x20000E, string));
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.d, "Couldn't get references from mimdata.parentSeriesUids", exception);
            return null;
        }
    }

    public List<r> i() {
        try {
            String string = (String)this.dbObject.get(MetabaseKeys.fromTag(1245186));
            if (string == null || string.isEmpty()) {
                return null;
            }
            ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)1);
            arrayList.add(new q(DcmSeriesReference.ReferenceSource.DocAndSRDerivedSeries).a(0x20000E, string));
            return arrayList;
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.d, "Couldn't get references from MIMSoftwareDocAndSRDerivedSeriesSequence", exception);
            return null;
        }
    }

    public List<r> j() {
        try {
            Collection collection = (Collection)this.dbObject.get(MetabaseKeys.fromTag(528704));
            if (collection == null || collection.isEmpty()) {
                return null;
            }
            ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)collection.size());
            String string = MetabaseKeys.fromTag(528725);
            BasicDBObject basicDBObject = (BasicDBObject)collection.iterator().next();
            if (basicDBObject.containsField(string)) {
                arrayList.add(new q(DcmSeriesReference.ReferenceSource.ReferencedSeriesSequence).a(0x20000E, basicDBObject.getString(string)));
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.d, "Couldn't get MIM dose reference back to it's volume from the ReferencedImageSequence", exception);
            return null;
        }
    }

    public List<r> k() {
        try {
            Collection collection = (Collection)this.dbObject.get(MetabaseKeys.fromTag(528896));
            if (collection == null || collection.isEmpty()) {
                return null;
            }
            ArrayList arrayList = Lists.newArrayList();
            String string = MetabaseKeys.fromTag(0x20000E);
            String string2 = MetabaseKeys.fromTag(528661);
            for (Object e2 : collection) {
                BasicDBObject basicDBObject = (BasicDBObject)e2;
                Collection collection2 = (Collection)basicDBObject.get(string2);
                if (collection2 == null || collection2.isEmpty()) continue;
                for (Object e3 : collection2) {
                    BasicDBObject basicDBObject2 = (BasicDBObject)e3;
                    if (!basicDBObject2.containsField(string)) continue;
                    q q2 = new q(DcmSeriesReference.ReferenceSource.SCORIS).a(0x20000E, basicDBObject2.getString(string));
                    arrayList.add(q2);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.d, "Couldn't get references from SCORIS", exception);
            return null;
        }
    }

    private boolean m() {
        return Modality.RTDOSE.isSameModality(this.getModality()) && this.getManufacturer() != null && this.getManufacturer().toLowerCase().contains("mim software");
    }

    public List<r> l() {
        try {
            if (Modality.RTDOSE.isSameModality(this.getModality()) && !this.m()) {
                List<r> list = this.a(DcmSeriesReference.ReferenceSource.ReferencedImageSequence);
                if (list != null) {
                    System.currentTimeMillis();
                }
                return list;
            }
        }
        catch (Exception exception) {
            this.a(MIMLogLevel.d, "Couldn't get references from ReferencedImageSequence", exception);
        }
        return null;
    }

    public List<r> getSeriesReferences(DcmSeriesReference.ReferenceSource referenceSource) {
        if (referenceSource == null) {
            ArrayList arrayList = Lists.newArrayList();
            this.a(arrayList, this.d());
            this.a(arrayList, this.e());
            this.a(arrayList, this.c());
            this.a(arrayList, this.g());
            this.a(arrayList, this.h());
            this.a(arrayList, this.i());
            this.a(arrayList, this.b());
            this.a(arrayList, this.f());
            this.a(arrayList, this.k());
            this.a(arrayList, this.l());
            return arrayList;
        }
        switch (referenceSource) {
            case ReferencedDoseSequence: {
                return this.d();
            }
            case ReferencedFrameOfReferenceSequence: {
                return this.e();
            }
            case ReferencedRTPlanSequence: {
                return this.c();
            }
            case ReferencedSeriesSequence: {
                return this.g();
            }
            case ReferencedStructureSetSequence: {
                ArrayList arrayList = Lists.newArrayList();
                this.a(arrayList, this.b());
                this.a(arrayList, this.f());
                return arrayList;
            }
            case MimdataSpecialTag: {
                return this.h();
            }
            case DocAndSRDerivedSeries: {
                return this.i();
            }
            case SCORIS: {
                return this.k();
            }
            case ReferencedImageSequence: {
                return this.l();
            }
        }
        return null;
    }

    private List<r> a(DcmSeriesReference.ReferenceSource referenceSource) {
        Collection collection = (Collection)this.dbObject.get(MetabaseKeys.fromTag(referenceSource.getSequenceTag()));
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)collection.size());
        this.a(referenceSource, collection, arrayList);
        return arrayList;
    }

    private void a(DcmSeriesReference.ReferenceSource referenceSource, Collection collection, List<r> list) {
        String string = MetabaseKeys.fromTag(528725);
        for (Object e2 : collection) {
            BasicDBObject basicDBObject = (BasicDBObject)e2;
            if (!basicDBObject.containsField(string)) continue;
            list.add(new q(referenceSource).a(524312, basicDBObject.getString(string)));
        }
    }

    @Override
    public List<? extends r> getEmbeddedReferences() {
        a a2 = this.a();
        if (a2 == null) {
            return Collections.emptyList();
        }
        List<h> list = a2.s();
        for (h h2 : list) {
            for (MongoSeries mongoSeries : h2.getReferencedSeries(this.a)) {
                mongoSeries.a(this.a);
            }
        }
        return list;
    }

    @Override
    public QueryResult asQueryResult() {
        List<String> list;
        Object object2;
        String string = this.getFolders().iterator().next();
        QueryResult queryResult = new QueryResult(string);
        queryResult.attributes.put("primarykey", Long.toString(this.getPk()));
        queryResult.attributes.put("patientListNames", cn.a(this.getPatientLists(), "~!~"));
        List<u> list2 = this.getStatuses();
        Collections.sort(list2, Collections.reverseOrder(u.a));
        ArrayList arrayList = Lists.newArrayList();
        SeriesStatusInfo seriesStatusInfo = null;
        for (u object22 : list2) {
            if (!StatusMap.a("View", object22.getId())) continue;
            arrayList.add(new SeriesStatusInfo(object22.getId(), object22.getUser(), object22.getTime().getTimeInMillis(), object22.getName()));
        }
        List<Long> list22 = this.getChildren();
        for (Object object2 : list2) {
            if (!StatusMap.a("Workflow", object2.getId())) continue;
            seriesStatusInfo = new SeriesStatusInfo(object2.getId(), object2.getUser(), object2.getTime().getTimeInMillis(), object2.getName());
            break;
        }
        queryResult.attributes.put("viewstatus", cn.a(arrayList, "~!~", SeriesStatusInfo::getStringEncoding));
        queryResult.attributes.put("childIds", cn.a(list22, "~!~"));
        if (seriesStatusInfo != null) {
            queryResult.attributes.put("workflowstatus", seriesStatusInfo.getStringEncoding());
        }
        if ((list = this.getSopInstanceUids()).size() > 0) {
            queryResult.attributes.put("sopinstanceuid", list.get(0));
        }
        if (this.getSeriesInstanceUid() != null) {
            queryResult.attributes.put("seriesinstanceuid", this.getSeriesInstanceUid());
        }
        if (this.getFrameOfReferenceUid() != null) {
            queryResult.attributes.put("frameofreferenceuid", this.getFrameOfReferenceUid());
        }
        if (this.hasTag(0x300A0003)) {
            queryResult.attributes.put("rtplanname", this.getString(0x300A0003));
        }
        if (this.hasTag(805961730)) {
            queryResult.attributes.put("rtplanlabel", this.getString(805961730));
        }
        if (this.hasTag(805961732)) {
            queryResult.attributes.put("rtplandesc", this.getString(805961732));
        }
        if (this.hasTag(805568518)) {
            queryResult.attributes.put("dosecomment", this.getString(805568518));
        }
        if (this.hasTag(0x30020003)) {
            queryResult.attributes.put("rtimagename", this.getString(0x30020003));
        }
        if (this.hasTag(0x30020002)) {
            queryResult.attributes.put("rtimagelabel", this.getString(0x30020002));
        }
        if (this.hasTag(805437444)) {
            queryResult.attributes.put("rtimagedesc", this.getString(805437444));
        }
        if (this.getSeriesDate() != null) {
            queryResult.attributes.put("seriesdate", DateUtils.formatDA((Date)this.getSeriesDate()));
        }
        if (this.getSeriesTime() != null) {
            queryResult.attributes.put("seriestime", DateUtils.formatTM((Date)this.getSeriesTime()));
        }
        if (this.getEmbedIndex() != null) {
            queryResult.attributes.put("embedindex", String.valueOf(this.getEmbedIndex()));
        }
        if ((object2 = this.getModality()) != null) {
            if (Modality.RAW.isSameModality((String)object2) && this.dbObject.containsKey(MetabaseKeys.fromTag(1253424))) {
                queryResult.attributes.put("#tag" + MetabaseKeys.fromTag(524384), "SESSION");
            } else if (Modality.RAW.isSameModality((String)object2) && this.dbObject.containsKey(MetabaseKeys.fromTag(930291986))) {
                queryResult.attributes.put("#tag" + MetabaseKeys.fromTag(524384), "BXplan");
            } else {
                queryResult.attributes.put("#tag" + MetabaseKeys.fromTag(524384), (String)object2);
            }
        }
        ImmutableList immutableList = ImmutableList.of((Object)MetabaseKeys.fromTag(928055632), (Object)MetabaseKeys.fromTag(805699586), (Object)MetabaseKeys.fromTag(805699588), (Object)MetabaseKeys.fromTag(528496), (Object)MetabaseKeys.fromTag(805699592), (Object)MetabaseKeys.fromTag(1253536), (Object)MetabaseKeys.fromTag(524307), (Object)MetabaseKeys.fromTag(524306), (Object)MetabaseKeys.fromTag(805699593));
        for (String string2 : immutableList) {
            Object object3 = this.dbObject.get(string2);
            String string3 = object3 == null ? null : object3.toString();
            if (string3 == null) continue;
            queryResult.attributes.put("#tag" + string2, string3);
        }
        return queryResult;
    }

    @Override
    public TreeMap<Integer, String> asTreeMap() {
        TreeMap treeMap = Maps.newTreeMap();
        for (Map.Entry<String, Object> entry : this.dbObject.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof String)) continue;
            treeMap.put(MetabaseKeys.toTag(entry.getKey())[0], (String)object);
        }
        return treeMap;
    }

    @Override
    public Map<String, Object> asJsonMap(int n2) {
        return i.a(n2, this.dbObject);
    }

    @Override
    public String toJson(int n2) {
        return b.a(this.asJsonMap(n2));
    }

    private <T> void a(List<T> list, List<T> list2) {
        if (list2 != null) {
            list.addAll(list2);
        }
    }

    public String toString() {
        return "Mongo Pk: " + this.getPk() + " SeriesUID: " + this.getSeriesInstanceUid() + " Modality: " + this.getModality() + " SeriesDate: " + this.getSeriesDate() + " SeriesTime: " + this.getSeriesTime() + " Date Added: " + this.getDateAdded();
    }

    private void a(MIMLogLevel mIMLogLevel, String string, Throwable throwable) {
        Runnable runnable = () -> ay.a(mIMLogLevel, string, throwable, MongoSeries.class);
        FuncUtils.a(runnable, 1000L);
    }
}

