/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mimcloud.connection;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.mimvista.ExternallyVisible;
import com.mimvista.MimJsonSerializable;
import com.mimvista.mimcloud.b.a;
import com.mimvista.mimcloud.connection.d;
import com.mimvista.mimcloud.connection.i;
import com.mimvista.preferencesNew.DebugPrefs;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

@MimJsonSerializable
public class CloudProxy {
    public final String name;
    public final String host;
    public final int port;
    public final String realm;
    public final ProxyProtocol protocol;
    public final ProxyAuthType authType;
    public final BasicUserCreds creds;

    public static CloudProxy noneProxyEntry(String string) {
        return new CloudProxy(string);
    }

    @JsonCreator
    public CloudProxy(@JsonProperty(value="name") String string, @JsonProperty(value="host") String string2, @JsonProperty(value="port") int n2, @JsonProperty(value="realm") String string3, @JsonProperty(value="protocol") ProxyProtocol proxyProtocol, @JsonProperty(value="authType") ProxyAuthType proxyAuthType, @JsonProperty(value="creds") BasicUserCreds basicUserCreds) {
        this.name = string;
        this.host = string2;
        this.port = n2;
        this.realm = string3;
        this.protocol = proxyProtocol;
        this.authType = proxyAuthType;
        this.creds = basicUserCreds;
    }

    public CloudProxy(String string, String string2, int n2, ProxyProtocol proxyProtocol, ProxyAuthType proxyAuthType, BasicUserCreds basicUserCreds) {
        this.name = string;
        this.host = string2;
        this.port = n2;
        this.realm = AuthScope.ANY_REALM;
        this.protocol = proxyProtocol;
        this.authType = proxyAuthType;
        this.creds = basicUserCreds;
    }

    public CloudProxy(String string) {
        this.name = string;
        this.host = null;
        this.port = 0;
        this.realm = AuthScope.ANY_REALM;
        this.protocol = null;
        this.authType = null;
        this.creds = null;
    }

    @JsonIgnore
    public ProxyHost getProxyHost() {
        if (this.protocol == null || this.protocol == ProxyProtocol.a) {
            return null;
        }
        if (!cn.h(this.host)) {
            return new ProxyHost(this.host, this.port);
        }
        return null;
    }

    @JsonIgnore
    public AuthScope getAuthScope() {
        if (this.protocol == null || this.protocol == ProxyProtocol.a) {
            return null;
        }
        if (!cn.h(this.host)) {
            return new AuthScope(this.host, this.port, this.realm);
        }
        return null;
    }

    @JsonIgnore
    public boolean isProtocolNone() {
        return this.protocol == null || this.protocol == ProxyProtocol.a;
    }

    @JsonIgnore
    public Credentials getCredentials() {
        if (this.creds != null) {
            return this.creds.getCredentials();
        }
        return null;
    }

    @JsonIgnore
    public String getProxyUri() {
        if (this.protocol == null || this.protocol == ProxyProtocol.a) {
            return "NONE";
        }
        return this.host + ":" + this.port;
    }

    public String toString() {
        return this.name + " - " + this.getProxyUri();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.authType == null ? 0 : this.authType.hashCode());
        n3 = 31 * n3 + (this.creds == null ? 0 : this.creds.hashCode());
        n3 = 31 * n3 + (this.host == null ? 0 : this.host.hashCode());
        n3 = 31 * n3 + (this.name == null ? 0 : this.name.hashCode());
        n3 = 31 * n3 + this.port;
        n3 = 31 * n3 + (this.protocol == null ? 0 : this.protocol.hashCode());
        n3 = 31 * n3 + (this.realm == null ? 0 : this.realm.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CloudProxy cloudProxy = (CloudProxy)object;
        if (this.authType != cloudProxy.authType) {
            return false;
        }
        if (this.creds == null ? cloudProxy.creds != null : !this.creds.equals(cloudProxy.creds)) {
            return false;
        }
        if (this.host == null ? cloudProxy.host != null : !this.host.equals(cloudProxy.host)) {
            return false;
        }
        if (this.name == null ? cloudProxy.name != null : !this.name.equals(cloudProxy.name)) {
            return false;
        }
        if (this.port != cloudProxy.port) {
            return false;
        }
        if (this.protocol != cloudProxy.protocol) {
            return false;
        }
        return !(this.realm == null ? cloudProxy.realm != null : !this.realm.equals(cloudProxy.realm));
    }

    @ExternallyVisible
    @MimJsonSerializable
    public static class NTUserCreds
    extends BasicUserCreds {
        public final String workstation;
        public final String domain;

        @JsonCreator
        protected NTUserCreds(@JsonProperty(value="user") String string, @JsonProperty(value="pass") String string2, @JsonProperty(value="workstation") String string3, @JsonProperty(value="domain") String string4) {
            super(string, string2);
            this.workstation = this.c(string3);
            this.domain = string4;
        }

        private String c(String string) {
            if (!cn.h(string)) {
                return string;
            }
            return d.q();
        }

        @Override
        public Credentials getCredentials() {
            if (DebugPrefs.logCloudProxyCredentials.getValue().booleanValue()) {
                ay.b((Object)("Getting MIMcloud Proxy credentials.  Username: " + this.user + ".  Password: " + this.deobfuscatedPassword), this);
            }
            return new NTCredentials(this.user, this.deobfuscatedPassword, this.workstation, this.domain);
        }

        @Override
        public int hashCode() {
            int n2 = 31;
            int n3 = super.hashCode();
            n3 = 31 * n3 + (this.domain == null ? 0 : this.domain.hashCode());
            n3 = 31 * n3 + (this.workstation == null ? 0 : this.workstation.hashCode());
            return n3;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NTUserCreds nTUserCreds = (NTUserCreds)object;
            if (this.domain == null ? nTUserCreds.domain != null : !this.domain.equals(nTUserCreds.domain)) {
                return false;
            }
            return !(this.workstation == null ? nTUserCreds.workstation != null : !this.workstation.equals(nTUserCreds.workstation));
        }

        public static NTUserCreds newInstance(String string, String string2, String string3, String string4) {
            return new NTUserCreds(string, a.a(string2), string3, string4);
        }
    }

    @ExternallyVisible
    @MimJsonSerializable
    public static class BasicUserCreds {
        public String user;
        public String pass;
        @JsonIgnore
        protected String deobfuscatedPassword;

        @JsonCreator
        protected BasicUserCreds(@JsonProperty(value="user") String string, @JsonProperty(value="pass") String string2) {
            this.user = string;
            this.pass = string2;
            this.deobfuscatedPassword = a.b(string2);
        }

        @JsonSetter(value="a")
        protected void a(String string) {
            if (this.user == null) {
                this.user = string;
            }
        }

        @JsonSetter(value="b")
        protected void b(String string) {
            if (this.deobfuscatedPassword == null) {
                this.deobfuscatedPassword = string;
                this.pass = a.a(string);
            }
        }

        public Credentials getCredentials() {
            if (DebugPrefs.logCloudProxyCredentials.getValue().booleanValue()) {
                ay.b((Object)("Getting MIMcloud Proxy credentials.  Username: " + this.user + ".  Password: " + this.deobfuscatedPassword), this);
            }
            if (cn.g(this.user) || cn.g(this.deobfuscatedPassword)) {
                return null;
            }
            return new UsernamePasswordCredentials(this.user, this.deobfuscatedPassword);
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.pass == null ? 0 : this.pass.hashCode());
            n3 = 31 * n3 + (this.user == null ? 0 : this.user.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            BasicUserCreds basicUserCreds = (BasicUserCreds)object;
            if (this.pass == null ? basicUserCreds.pass != null : !this.pass.equals(basicUserCreds.pass)) {
                return false;
            }
            return !(this.user == null ? basicUserCreds.user != null : !this.user.equals(basicUserCreds.user));
        }

        public static BasicUserCreds newInstance(String string, String string2) {
            return new BasicUserCreds(string, a.a(string2));
        }
    }

    public static enum ProxyAuthType {
        a,
        b,
        c;


        public String toString() {
            if (this == a) {
                return i.a.getProperty("CONNECTION_PROXY_NONE");
            }
            return i.a.getProperty("PROXY_AUTH_TYPE_" + super.toString());
        }

        public static ProxyAuthType a(String string) {
            try {
                return ProxyAuthType.valueOf(string);
            }
            catch (Throwable throwable) {
                try {
                    for (ProxyAuthType proxyAuthType : ProxyAuthType.values()) {
                        if (!proxyAuthType.toString().equals(string)) continue;
                        return proxyAuthType;
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                return a;
            }
        }
    }

    public static enum ProxyProtocol {
        a,
        b,
        c;


        public String toString() {
            if (this == a) {
                return i.a.getProperty("CONNECTION_PROXY_NONE");
            }
            return super.toString();
        }

        public static ProxyProtocol a(String string) {
            try {
                return ProxyProtocol.valueOf(string);
            }
            catch (Throwable throwable) {
                try {
                    for (ProxyProtocol proxyProtocol : ProxyProtocol.values()) {
                        if (!proxyProtocol.toString().equals(string)) continue;
                        return proxyProtocol;
                    }
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                return a;
            }
        }
    }
}

