/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mimcloud.connection;

import com.mimvista.mimcloud.connection.i;
import com.mimvista.preferencesNew.MimcloudPrefs;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;

public abstract class CloudResponseException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String message = null;
    public final String statusMessage;

    public CloudResponseException(String string) {
        super(string);
        this.statusMessage = string;
    }

    public CloudResponseException(Throwable throwable, String string) {
        super(string, throwable);
        this.statusMessage = string;
    }

    public int a() {
        return 0;
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!cn.h(this.statusMessage)) {
            stringBuilder.append(this.statusMessage);
        }
        if (!cn.h(this.message)) {
            if (!cn.h(stringBuilder.toString())) {
                stringBuilder.append(" | ");
            }
            stringBuilder.append(this.message);
        }
        if (!cn.h(stringBuilder.toString())) {
            return stringBuilder.toString();
        }
        return super.getMessage();
    }

    protected void a(String string) {
        this.message = string;
    }

    public static void a(HttpMethod httpMethod) throws CloudResponseException {
        if (httpMethod.getStatusCode() == LoginRequiredException.b()) {
            throw new LoginRequiredException();
        }
        if (httpMethod.getStatusCode() == ChangePasswordException.b()) {
            throw new ChangePasswordException();
        }
        if (httpMethod.getStatusCode() == UpdateAccountException.b()) {
            throw new UpdateAccountException();
        }
        if (httpMethod.getStatusCode() == BadCredentialsException.b()) {
            if (!cn.h(MimcloudPrefs.ssoUsername.getValue()) || !cn.h(MimcloudPrefs.ssoToken.getValue())) {
                ay.c((Object)("Clearing MIMcloud SSO fields because we got: " + httpMethod.getStatusCode() + " when trying to login!"), CloudResponseException.class);
                MimcloudPrefs.ssoToken.setValue(null);
                MimcloudPrefs.ssoUsername.setValue(null);
            }
            throw new BadCredentialsException();
        }
        if (httpMethod.getStatusCode() == BadPayException.b()) {
            throw new BadPayException();
        }
        if (httpMethod.getStatusCode() == BadAccessException.b()) {
            throw new BadAccessException();
        }
        if (httpMethod.getStatusCode() == InternalServerErrorException.b()) {
            throw new InternalServerErrorException();
        }
        if (httpMethod.getStatusCode() != 200) {
            throw new UnrecognizedResponseException(httpMethod);
        }
    }

    public static class NoCredentialsProvidedException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static class CloudRequestException
    extends CloudResponseException {
        private static final long serialVersionUID = 1L;

        public CloudRequestException(Throwable throwable) {
            super(throwable, i.a.getProperty("CLOUD_FAIL_CONNECT"));
        }

        public CloudRequestException(String string) {
            super(string);
        }

        public CloudRequestException(Throwable throwable, String string) {
            super(throwable, string);
        }

        @Override
        public int a() {
            return -1;
        }
    }

    public static class CannotDecompressDataException
    extends CloudResponseException {
        private static final long serialVersionUID = 1L;

        public CannotDecompressDataException(Throwable throwable) {
            super(throwable, throwable.getMessage());
        }

        @Override
        public int a() {
            return -22;
        }
    }

    public static class UnrecognizedResponseException
    extends CloudResponseException {
        private static final long serialVersionUID = 1L;
        public final int code;
        public final String text;
        public final String body;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UnrecognizedResponseException(HttpMethod httpMethod) {
            super(httpMethod.getStatusText());
            String string;
            this.code = httpMethod.getStatusCode();
            this.text = httpMethod.getStatusText();
            try {
                string = httpMethod.getResponseBodyAsString();
            }
            catch (IOException iOException) {
                string = null;
            }
            finally {
                httpMethod.releaseConnection();
            }
            this.body = string;
            this.a("\tRequest: " + httpMethod.getPath() + "\r\n\tResponse: " + this.code + " - " + this.text);
        }

        public UnrecognizedResponseException(String string, int n2) {
            super(string);
            this.code = n2;
            this.text = string;
            this.body = null;
            this.a("\tResponse: " + this.code + " - " + this.text);
        }

        @Override
        public int a() {
            return this.code;
        }
    }

    public static class InternalServerErrorException
    extends CloudResponseException {
        private static final long serialVersionUID = 1L;

        public InternalServerErrorException() {
            super(i.a.getProperty("CLOUD_FAIL_INTERNAL_ERROR"));
        }

        @Override
        public int a() {
            return InternalServerErrorException.b();
        }

        public static int b() {
            return 500;
        }
    }

    public static class BadAccessException
    extends CloudResponseException {
        private static final long serialVersionUID = 1L;

        public BadAccessException() {
            super(i.a.getProperty("CLOUD_FAIL_BAD_ACCESS"));
        }

        @Override
        public int a() {
            return BadAccessException.b();
        }

        public static int b() {
            return 406;
        }
    }

    public static class BadPayException
    extends CloudResponseException {
        private static final long serialVersionUID = 1L;

        public BadPayException() {
            super(i.a.getProperty("CLOUD_FAIL_BAD_PAY"));
        }

        @Override
        public int a() {
            return BadPayException.b();
        }

        public static int b() {
            return 407;
        }
    }

    public static class BadCredentialsException
    extends CloudResponseException {
        private static final long serialVersionUID = 1L;

        public BadCredentialsException() {
            super(i.a.getProperty("CLOUD_FAIL_BAD_CREDS"));
        }

        @Override
        public int a() {
            return BadCredentialsException.b();
        }

        public static int b() {
            return 403;
        }
    }

    public static class LoginRequiredException
    extends CloudResponseException {
        private static final long serialVersionUID = 1L;

        public LoginRequiredException() {
            super(i.a.getProperty("SENDTO_DESTINATION_LOGIN_FAIL"));
        }

        @Override
        public int a() {
            return LoginRequiredException.b();
        }

        public static int b() {
            return 401;
        }
    }

    public static class ChangePasswordException
    extends CloudResponseException {
        private static final long serialVersionUID = 1L;

        public ChangePasswordException() {
            super(i.a.getProperty("CHANGE_PASS_XCP"));
        }

        @Override
        public int a() {
            return ChangePasswordException.b();
        }

        public static int b() {
            return 211;
        }
    }

    public static class UpdateAccountException
    extends CloudResponseException {
        private static final long serialVersionUID = 1L;

        public UpdateAccountException() {
            super(i.a.getProperty("CLOUD_FAIL_UPDATE_ACCOUNT"));
        }

        @Override
        public int a() {
            return UpdateAccountException.b();
        }

        public static int b() {
            return 210;
        }
    }
}

