/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mimcloud.connection;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mimvista.MimJsonSerializable;
import com.mimvista.util.NaiveTrustProvider;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;

@MimJsonSerializable
public class CloudType {
    public final String typeName;
    public final ProtocolPrefix protocolPrefix;
    public final String host;
    public final int port;
    @JsonIgnore
    private HostConfiguration hostConf = null;

    @JsonCreator
    public CloudType(@JsonProperty(value="typeName") String string, @JsonProperty(value="protocolPrefix") ProtocolPrefix protocolPrefix, @JsonProperty(value="host") String string2, @JsonProperty(value="port") int n2) {
        this.typeName = string;
        this.protocolPrefix = protocolPrefix;
        this.host = string2;
        this.port = n2 == -1 ? this.protocolPrefix.port : n2;
    }

    @JsonIgnore
    public String getServerUrl() {
        return this.protocolPrefix.toString().toLowerCase() + "://" + this.host + ":" + this.port;
    }

    @JsonIgnore
    public ProtocolSocketFactory getProtocolSocketFactory() {
        if (this.protocolPrefix == ProtocolPrefix.a) {
            return new DefaultProtocolSocketFactory();
        }
        if (this.protocolPrefix == ProtocolPrefix.b) {
            NaiveTrustProvider.a(true);
            return new SSLProtocolSocketFactory();
        }
        return null;
    }

    @JsonIgnore
    public HostConfiguration getHostConfiguration() {
        if (this.hostConf != null) {
            return this.hostConf;
        }
        this.hostConf = new HostConfiguration();
        Protocol protocol = new Protocol(this.protocolPrefix.toString(), this.getProtocolSocketFactory(), this.port);
        HttpHost httpHost = new HttpHost(this.host, this.port, protocol);
        this.hostConf.setHost(httpHost);
        return this.hostConf;
    }

    public String toString() {
        return this.typeName + " - " + this.getServerUrl();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.host == null ? 0 : this.host.hashCode());
        n3 = 31 * n3 + this.port;
        n3 = 31 * n3 + (this.protocolPrefix == null ? 0 : this.protocolPrefix.hashCode());
        n3 = 31 * n3 + (this.typeName == null ? 0 : this.typeName.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CloudType cloudType = (CloudType)object;
        if (this.host == null ? cloudType.host != null : !this.host.equals(cloudType.host)) {
            return false;
        }
        if (this.port != cloudType.port) {
            return false;
        }
        if (this.protocolPrefix != cloudType.protocolPrefix) {
            return false;
        }
        return !(this.typeName == null ? cloudType.typeName != null : !this.typeName.equals(cloudType.typeName));
    }

    public String getTypeName() {
        return this.typeName;
    }

    public ProtocolPrefix getProtocolPrefix() {
        return this.protocolPrefix;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static enum ProtocolPrefix {
        a(80),
        b(443);

        public final int port;

        private ProtocolPrefix(int n3) {
            this.port = n3;
        }

        public static ProtocolPrefix a(String string) {
            try {
                return ProtocolPrefix.valueOf(string);
            }
            catch (Throwable throwable) {
                return b;
            }
        }
    }
}

