/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui;

import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.mui.ak;
import com.mimvista.mui.ao;
import com.mimvista.util.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class AttachmentsPanel
extends JPanel {
    private static final long serialVersionUID = -3583468360189288769L;
    private static Messages props = Messages.a("GUI");
    private JButton addButton = AttachmentsPanel.makeButton(props.getProperty("ATTACHMENT_ADD"), "add");
    private JButton removeButton = AttachmentsPanel.makeButton(props.getProperty("ATTACHMENT_REMOVE"), "subtract");
    private JButton clearButton = AttachmentsPanel.makeButton(props.getProperty("ATTACHMENT_CLEAR"), "clean");
    private DefaultListModel attachListModel = new DefaultListModel();
    private JList attachList = new JList(this.attachListModel);
    private InputNotification inputNot = null;

    private static JButton makeButton(String string, String string2) {
        return new JButton(string, ImageManipulator.c(string2, 18));
    }

    public AttachmentsPanel(InputNotification inputNotification) {
        this.inputNot = inputNotification;
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(10));
        Box box = new Box(2);
        box.add(this.addButton);
        box.add(this.removeButton);
        box.add(this.clearButton);
        box.add(Box.createHorizontalGlue());
        this.add(box);
        this.add(new JScrollPane(this.attachList));
        this.addActionListeners();
        this.setPreferredSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
    }

    public void addAttachments(ArrayList<File> arrayList) {
        for (File file : arrayList) {
            this.attachListModel.addElement(file);
        }
    }

    public ArrayList<File> getAttachments() {
        Enumeration enumeration = this.attachListModel.elements();
        ArrayList<File> arrayList = new ArrayList<File>();
        while (enumeration.hasMoreElements()) {
            arrayList.add((File)enumeration.nextElement());
        }
        return arrayList;
    }

    public abstract File getLastVisitedFolder();

    public abstract void setLastVisitedFolder(File var1);

    private void addActionListeners() {
        this.attachListModel.addListDataListener(this.inputNot.getInputEditor());
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MIMFileDialog mIMFileDialog = MIMFileDialog.a(ao.Q().O(), "", MIMFileDialog.FileDialogType.a, true);
                File file = AttachmentsPanel.this.getLastVisitedFolder();
                if (file != null) {
                    mIMFileDialog.b(file.getAbsolutePath());
                }
                mIMFileDialog.a(true);
                String string = mIMFileDialog.a();
                if (string == null) {
                    return;
                }
                File file2 = new File(string);
                if (!file2.exists()) {
                    JOptionPane.showMessageDialog(ak.b().M(), props.getProperty("ATTACHMENT_NOT_FOUND"));
                    return;
                }
                AttachmentsPanel.this.setLastVisitedFolder(file2.getParentFile());
                if (AttachmentsPanel.this.attachListModel.contains(file2)) {
                    int n2 = JOptionPane.showConfirmDialog(ak.b().M(), props.getProperty("ATTACHMENT_OVERWRITE"), props.getProperty("ATTACHMENT_WARNING"), 0);
                    if (n2 == 0) {
                        AttachmentsPanel.this.attachListModel.removeElement(file2);
                        AttachmentsPanel.this.attachListModel.addElement(file2);
                    }
                } else {
                    AttachmentsPanel.this.attachListModel.addElement(file2);
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray;
                for (Object object : objectArray = AttachmentsPanel.this.attachList.getSelectedValues()) {
                    AttachmentsPanel.this.attachListModel.removeElement(object);
                }
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttachmentsPanel.this.attachListModel.removeAllElements();
            }
        });
    }
}

