/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mimvista.d;
import com.mimvista.internals.ContrastState;
import com.mimvista.internals.PresetWindowLevel;
import com.mimvista.numerics.MathUtils;
import com.mimvista.state.ReadHelper;
import com.mimvista.util.ay;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;

public class ColorTable
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String a = "Functional";
    public static final String b = "Anatomic";
    public static final String c = "Variant";
    public static final String d = "Z-score";
    public static final String e = "Spectrum";
    private static String[] f = new String[]{"Functional", "Invert B-W"};
    private static String[] g = new String[]{"Anatomic", "B-W Linear"};
    private static String[] h = new String[]{"Variant", "Immersion Diff 10 Steps"};
    private static String[] i = new String[]{"Variant", "Immersion Diff 10 Steps"};
    private static String[] j = new String[]{"Functional", "Invert B-W"};
    private static String[] k = new String[]{"Z-score", "Hypo 1-tail 95-99-99.9"};
    private static String[] l = new String[]{"Spectrum", "Rainbow"};
    private static String[] m = new String[]{"Functional", "Hot Metal"};
    private static String[] n = new String[]{"Spectrum", "Rainbow"};
    public final String name;
    public final String set;
    public final String description;
    public final Float contrastUpper;
    public final Float contrastLower;
    @d
    public final ContrastState.ContrastLockMode lockMode;
    public final String units;
    public final boolean variant;
    public final boolean delineated;
    public final PaletteData palette;
    public final RGB overlayRGB;
    private PaletteData reversedPalette;
    public final RGB reversedOverlayRGB;

    public static String[] a() {
        return g;
    }

    public static String[] b() {
        return f;
    }

    public static String[] c() {
        return h;
    }

    public static String[] d() {
        return i;
    }

    public static String[] e() {
        return j;
    }

    public static String[] f() {
        return k;
    }

    public static String[] g() {
        return l;
    }

    public static String[] a(String string) {
        if ("PT".equalsIgnoreCase(string)) {
            return ColorTable.b();
        }
        if ("NM".equalsIgnoreCase(string)) {
            return ColorTable.b();
        }
        if ("SP".equalsIgnoreCase(string)) {
            return ColorTable.b();
        }
        if ("NEURO".equalsIgnoreCase(string)) {
            return ColorTable.e();
        }
        if ("Z-SCORE".equalsIgnoreCase(string)) {
            return ColorTable.f();
        }
        if ("SUBTRACTION".equalsIgnoreCase(string)) {
            return ColorTable.c();
        }
        if ("ADDITION".equalsIgnoreCase(string)) {
            return ColorTable.d();
        }
        if ("RTDOSE".equalsIgnoreCase(string)) {
            return ColorTable.g();
        }
        return ColorTable.a();
    }

    public static String[] b(String string) {
        if ("RTDOSE".equalsIgnoreCase(string)) {
            return n;
        }
        return m;
    }

    public ColorTable(String string, String string2, PaletteData paletteData) {
        this(string, string2, paletteData, null, null, null, null, false, false, null, null);
    }

    public ColorTable(String string, String string2, PaletteData paletteData, String string3, Float f2, Float f3, String string4, boolean bl2, boolean bl3, RGB rGB, @d ContrastState.ContrastLockMode contrastLockMode) {
        this.name = string;
        this.set = string2;
        this.palette = paletteData;
        this.description = string3;
        this.contrastLower = f2;
        this.contrastUpper = f3;
        this.units = string4;
        this.variant = bl2;
        this.delineated = bl3;
        this.overlayRGB = rGB;
        this.lockMode = contrastLockMode;
        this.reversedOverlayRGB = rGB != null ? new RGB(255 - rGB.red, 255 - rGB.green, 255 - rGB.blue) : null;
    }

    public Color h() {
        if (this.overlayRGB != null) {
            return this.overlayRGB.a();
        }
        RGB rGB = (RGB)this.palette.colors256.get(0);
        RGB rGB2 = new RGB(255 - rGB.red, 255 - rGB.green, 255 - rGB.blue);
        return new Color(rGB2.red, rGB2.green, rGB2.blue);
    }

    public Color i() {
        if (this.variant) {
            return Color.black;
        }
        RGB rGB = (RGB)this.palette.colors256.get(0);
        return rGB.a();
    }

    public boolean j() {
        return this.palette.colors256.size() != this.palette.fullColors.size();
    }

    public Image a(int n2, int n3, boolean bl2) {
        return this.a(n2, n3, bl2, 1.0f);
    }

    public Image a(int n2, int n3, boolean bl2, float f2) {
        return this.a(bl2, f2).getScaledInstance(n2, n3, 0);
    }

    public BufferedImage a(boolean bl2, float f2) {
        int n2;
        int n3;
        if (bl2) {
            n3 = 256;
            n2 = 1;
        } else {
            n3 = 1;
            n2 = 256;
        }
        ColorModel colorModel = this.palette.e();
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n3, n2), colorModel.isAlphaPremultiplied(), null);
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (f2 != 1.0f) {
            double d2 = f2 > 0.0f ? 255.0 / Math.pow(255.0, 1.0f / f2) : 0.0;
            for (int i2 = 0; i2 < 256; ++i2) {
                int n4 = (int)Math.round(d2 == 0.0 ? 0.0 : d2 * Math.pow(i2, 1.0f / f2));
                if (bl2) {
                    writableRaster.setSample(i2, 0, 0, n4);
                    continue;
                }
                writableRaster.setSample(0, 255 - i2, 0, n4);
            }
        } else {
            for (int i3 = 0; i3 < 256; ++i3) {
                if (bl2) {
                    writableRaster.setSample(i3, 0, 0, i3);
                    continue;
                }
                writableRaster.setSample(0, 255 - i3, 0, i3);
            }
        }
        return bufferedImage;
    }

    public String toString() {
        return this.name;
    }

    public ColorTable k() {
        ColorTable colorTable = new ColorTable(this.name, this.set, this.palette, this.description, this.contrastLower, this.contrastUpper, this.units, this.variant, this.delineated, this.overlayRGB, this.lockMode);
        return colorTable;
    }

    public ColorTable l() {
        Object object;
        if (this.reversedPalette == null) {
            object = (RGB[])this.palette.fullColors.toArray((Object[])new RGB[this.palette.fullColors.size()]);
            MathUtils.a(object);
            this.reversedPalette = new PaletteData((RGB[])object);
        }
        object = new ColorTable(this.name, this.set, this.reversedPalette, this.description, this.contrastLower, this.contrastUpper, this.units, this.variant, this.delineated, this.reversedOverlayRGB, this.lockMode);
        object.reversedPalette = this.palette;
        return object;
    }

    public boolean a(ContrastState contrastState) {
        boolean bl2;
        boolean bl3 = bl2 = this.units != null && (this.units.equalsIgnoreCase("ANY") || this.units.equalsIgnoreCase(contrastState.B()));
        if (!bl2) {
            return false;
        }
        if (this.lockMode != null) {
            contrastState.a(this.lockMode);
        }
        if (this.contrastLower != null) {
            if (this.contrastUpper != null) {
                contrastState.b(contrastState.b(this.contrastLower.floatValue()), contrastState.b(this.contrastUpper.floatValue()));
            } else if (contrastState.D() != null && contrastState.D().size() > 0) {
                contrastState.b(contrastState.b(((PresetWindowLevel)contrastState.D().get((int)0)).windowWidth), contrastState.b(((PresetWindowLevel)contrastState.D().get((int)0)).windowCenter), 1.0f);
            } else {
                contrastState.b(contrastState.i(), contrastState.b(this.contrastLower.floatValue()), 1.0f);
            }
            contrastState.K();
            return true;
        }
        return false;
    }

    public ColorTable c(String string) {
        ColorTable colorTable = new ColorTable(this.name, string, this.palette, this.description, this.contrastLower, this.contrastUpper, this.units, this.variant, this.delineated, this.overlayRGB, this.lockMode);
        return colorTable;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.contrastLower == null ? 0 : this.contrastLower.hashCode());
        n3 = 31 * n3 + (this.contrastUpper == null ? 0 : this.contrastUpper.hashCode());
        n3 = 31 * n3 + (this.description == null ? 0 : this.description.hashCode());
        n3 = 31 * n3 + (this.name == null ? 0 : this.name.hashCode());
        n3 = 31 * n3 + (this.set == null ? 0 : this.set.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColorTable colorTable = (ColorTable)object;
        if (this.contrastLower == null ? colorTable.contrastLower != null : !this.contrastLower.equals(colorTable.contrastLower)) {
            return false;
        }
        if (this.contrastUpper == null ? colorTable.contrastUpper != null : !this.contrastUpper.equals(colorTable.contrastUpper)) {
            return false;
        }
        if (this.description == null ? colorTable.description != null : !this.description.equals(colorTable.description)) {
            return false;
        }
        if (this.name == null ? colorTable.name != null : !this.name.equals(colorTable.name)) {
            return false;
        }
        return !(this.set == null ? colorTable.set != null : !this.set.equals(colorTable.set));
    }

    public ColorTable a(Float f2, Float f3) {
        return new ColorTable(this.name, this.set, this.palette, this.description, f2, f3, this.units, this.variant, this.delineated, this.overlayRGB, this.lockMode);
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.k();
    }

    public static class RGB
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int red;
        public final int green;
        public final int blue;

        public RGB(int n2, int n3, int n4) {
            this.red = MathUtils.b(n2, 0, 255);
            this.green = MathUtils.b(n3, 0, 255);
            this.blue = MathUtils.b(n4, 0, 255);
        }

        public RGB(Color color) {
            this.red = color.getRed();
            this.green = color.getGreen();
            this.blue = color.getBlue();
        }

        public String toString() {
            return "RGB: " + this.red + "/" + this.green + "/" + this.blue;
        }

        public Color a() {
            return new Color(MathUtils.b(this.red, 0, 255), MathUtils.b(this.green, 0, 255), MathUtils.b(this.blue, 0, 255));
        }

        public int b() {
            return (this.red << 16) + (this.green << 8) + this.blue + -16777216;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.blue;
            n3 = 31 * n3 + this.green;
            n3 = 31 * n3 + this.red;
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            RGB rGB = (RGB)object;
            if (this.blue != rGB.blue) {
                return false;
            }
            if (this.green != rGB.green) {
                return false;
            }
            return this.red == rGB.red;
        }
    }

    public static class PaletteData
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private ImmutableList<RGB> fullColors;
        private ImmutableList<RGB> colors256;
        private transient int[] a;
        private transient int[] b;
        private transient ColorModel c;
        private transient ColorModel d;

        public PaletteData(RGB[] rGBArray) {
            this.fullColors = ImmutableList.copyOf((Object[])rGBArray);
            if (this.fullColors.size() == 256) {
                this.colors256 = this.fullColors;
            } else {
                ArrayList arrayList = Lists.newArrayList();
                int n2 = rGBArray.length;
                for (int i2 = 0; i2 < 256; ++i2) {
                    int n3 = Math.round(1.0f * (float)i2 * (float)n2 / 256.0f);
                    n3 = MathUtils.b(n3, 0, n2 - 1);
                    arrayList.add(rGBArray[n3]);
                }
                this.colors256 = ImmutableList.copyOf((Collection)arrayList);
            }
        }

        public int a() {
            return this.fullColors.size();
        }

        public synchronized int[] b() {
            if (this.b != null) {
                return (int[])this.b.clone();
            }
            this.b = new int[256];
            for (int i2 = 0; i2 < 256; ++i2) {
                RGB rGB = (RGB)this.colors256.get(i2);
                this.b[i2] = (rGB.red << 16) + (rGB.green << 8) + rGB.blue + -16777216;
            }
            return (int[])this.b.clone();
        }

        public synchronized int[] c() {
            if (this.a != null) {
                return (int[])this.a.clone();
            }
            this.a = new int[this.fullColors.size()];
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                RGB rGB = (RGB)this.fullColors.get(i2);
                this.a[i2] = (rGB.red << 16) + (rGB.green << 8) + rGB.blue + -16777216;
            }
            return (int[])this.a.clone();
        }

        public PaletteData d() {
            try {
                return (PaletteData)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                ay.d((Object)cloneNotSupportedException, this);
                return null;
            }
        }

        public ColorModel e() {
            return this.a((byte)-1);
        }

        public synchronized ColorModel a(byte by2) {
            if (this.d != null) {
                return this.d;
            }
            byte[] byArray = new byte[256];
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            byte[] byArray4 = new byte[256];
            for (int i2 = 0; i2 < 256; ++i2) {
                RGB rGB = (RGB)this.colors256.get(i2);
                byArray[i2] = (byte)rGB.red;
                byArray2[i2] = (byte)rGB.green;
                byArray3[i2] = (byte)rGB.blue;
                byArray4[i2] = by2;
            }
            IndexColorModel indexColorModel = (by2 & 0xFF) == 255 ? new IndexColorModel(8, 256, byArray, byArray2, byArray3) : new IndexColorModel(8, 256, byArray, byArray2, byArray3, byArray4);
            return indexColorModel;
        }

        public synchronized ColorModel b(byte by2) {
            if (this.c != null) {
                return this.c;
            }
            int n2 = (int)Math.ceil(MathUtils.e((float)this.fullColors.size()));
            byte[] byArray = new byte[this.fullColors.size()];
            byte[] byArray2 = new byte[this.fullColors.size()];
            byte[] byArray3 = new byte[this.fullColors.size()];
            byte[] byArray4 = new byte[this.fullColors.size()];
            for (int i2 = 0; i2 < this.fullColors.size(); ++i2) {
                RGB rGB = (RGB)this.fullColors.get(i2);
                byArray[i2] = (byte)rGB.red;
                byArray2[i2] = (byte)rGB.green;
                byArray3[i2] = (byte)rGB.blue;
                byArray4[i2] = by2;
            }
            IndexColorModel indexColorModel = (by2 & 0xFF) == 255 ? new IndexColorModel(n2, byArray.length, byArray, byArray2, byArray3) : new IndexColorModel(n2, byArray.length, byArray, byArray2, byArray3, byArray4);
            return indexColorModel;
        }

        public ImmutableList<RGB> f() {
            return this.colors256;
        }

        public ImmutableList<RGB> g() {
            return this.fullColors;
        }

        private void readObject(ObjectInputStream objectInputStream) throws Throwable {
            Object[] objectArray;
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            ReadHelper readHelper = new ReadHelper();
            readHelper.a(getField, (Object)this);
            if (ReadHelper.b(getField, "colors") && (objectArray = (RGB[])getField.get("colors", null)) != null) {
                Field field = ReadHelper.a(this.getClass(), "colors256");
                field.setAccessible(true);
                field.set(this, ImmutableList.copyOf((Object[])objectArray));
                field.setAccessible(false);
                field = ReadHelper.a(this.getClass(), "fullColors");
                field.setAccessible(true);
                field.set(this, ImmutableList.copyOf((Object[])objectArray));
                field.setAccessible(false);
            }
        }

        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.d();
        }
    }
}

