/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui;

import com.mimvista.proui.MIMLookAndFeel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SpringLayout;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorWheel
extends AbstractColorChooserPanel {
    private static final long serialVersionUID = 1L;
    private SpringLayout layout;
    private BufferedImage colorWheelImage;
    private JSlider brightnessSlider;
    private JPanel colorWheelPanel;
    private JPanel previewColorPanel;
    private Point lastMousePoint;
    private Point center;
    private int diameter;
    private int activeRadius;
    private float[] currentHSB = new float[]{0.0f, 0.0f, 1.0f};
    private static final float a = 0.08f;
    private static final int b = 64;
    private static final int c = 255;
    private static final int d = 255;
    private static final int e = 5;
    private static final int f = 6;

    public ColorWheel() {
        this(64);
    }

    public ColorWheel(int n2) {
        this.diameter = n2;
        this.activeRadius = n2 / 2 - 6;
        this.lastMousePoint = this.center = new Point(n2 / 2, n2 / 2);
        this.colorWheelImage = this.b();
        this.c();
        this.d();
    }

    public ColorWheel(int n2, Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.currentHSB[i2] = fArray[i2];
        }
        this.diameter = n2;
        this.activeRadius = n2 / 2 - 6;
        this.lastMousePoint = this.center = new Point(n2 / 2, n2 / 2);
        this.colorWheelImage = this.b();
        this.c();
        this.d();
    }

    public ColorWheel(int n2, float[] fArray) {
        this(n2, fArray[0], fArray[1], fArray[2]);
    }

    public ColorWheel(int n2, float f2, float f3, float f4) {
        this.currentHSB[0] = this.a(f2);
        this.currentHSB[1] = this.a(f3);
        this.currentHSB[2] = this.a(f4);
        this.diameter = n2;
        this.activeRadius = n2 / 2 - 6;
        this.lastMousePoint = this.center = new Point(n2 / 2, n2 / 2);
        this.colorWheelImage = this.b();
        this.c();
        this.d();
    }

    private float a(float f2) {
        return Math.min(Math.max(f2, 1.0f), 0.0f);
    }

    public void a(Color color) {
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), this.currentHSB);
        this.brightnessSlider.setValue((int)(255.0f * this.currentHSB[2]));
        this.e();
    }

    @Override
    protected void buildChooser() {
        this.layout = new SpringLayout();
        this.setLayout(this.layout);
        this.add(this.colorWheelPanel);
        this.add(this.brightnessSlider);
        this.add(this.previewColorPanel);
        this.brightnessSlider.setPreferredSize(new Dimension(32, this.colorWheelImage.getHeight() - 37));
        this.colorWheelPanel.setPreferredSize(new Dimension(this.colorWheelImage.getWidth(), this.colorWheelImage.getHeight()));
        this.previewColorPanel.setPreferredSize(new Dimension(32, 32));
        this.layout.putConstraint("North", (Component)this.colorWheelPanel, 5, "North", (Component)this);
        this.layout.putConstraint("West", (Component)this.colorWheelPanel, 5, "West", (Component)this);
        this.layout.putConstraint("West", (Component)this.brightnessSlider, 5, "East", (Component)this.colorWheelPanel);
        this.layout.putConstraint("North", (Component)this.brightnessSlider, 0, "North", (Component)this.colorWheelPanel);
        this.layout.putConstraint("North", (Component)this.previewColorPanel, 5, "South", (Component)this.brightnessSlider);
        this.layout.putConstraint("West", (Component)this.previewColorPanel, 5, "East", (Component)this.colorWheelPanel);
        this.layout.putConstraint("South", (Component)this.previewColorPanel, 0, "South", (Component)this.colorWheelPanel);
        this.layout.putConstraint("South", (Component)this, 5, "South", (Component)this.colorWheelPanel);
        this.layout.putConstraint("East", (Component)this, 5, "East", (Component)this.brightnessSlider);
        this.getColorSelectionModel().setSelectedColor(this.a());
        this.f();
        this.getColorSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ColorWheel.this.previewColorPanel.setBackground(ColorWheel.this.getColorSelectionModel().getSelectedColor());
            }
        });
        this.previewColorPanel.setBackground(this.getColorSelectionModel().getSelectedColor());
    }

    private Color a() {
        return new Color(Color.HSBtoRGB(this.currentHSB[0], this.currentHSB[1], this.currentHSB[2]));
    }

    private BufferedImage b() {
        BufferedImage bufferedImage = new BufferedImage(this.diameter, this.diameter, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f2 = 0.0f;
        float f3 = this.currentHSB[1];
        float f4 = this.currentHSB[2];
        for (int i2 = 0; i2 < this.diameter; ++i2) {
            for (int i3 = 0; i3 < this.diameter; ++i3) {
                Color color = new Color(255, 255, 255, 0);
                Point point = new Point(i2, i3);
                f2 = this.a(point);
                f3 = this.b(point);
                if (f2 >= 0.0f) {
                    color = new Color(Color.HSBtoRGB(f2, f3, f4));
                }
                graphics2D.setColor(color);
                graphics2D.drawLine(i2, i3, i2 + 1, i3);
            }
        }
        graphics2D.setColor(MIMLookAndFeel.e());
        graphics2D.setStroke(new BasicStroke(6.0f));
        graphics2D.drawOval(6, 6, this.diameter - 12, this.diameter - 12);
        graphics2D.setColor(MIMLookAndFeel.b());
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.drawOval(6, 6, this.diameter - 12, this.diameter - 12);
        graphics2D.dispose();
        return bufferedImage;
    }

    private float a(Point point) {
        if (this.center.distance(point) > (double)this.activeRadius) {
            return -1.0f;
        }
        double d2 = Math.atan2(point.x - this.center.x, point.y - this.center.y);
        d2 += Math.PI;
        return (float)(d2 /= Math.PI * 2);
    }

    private float b(Point point) {
        float f2 = (float)this.center.distance(point) / ((float)this.diameter / 2.0f);
        if (f2 < 0.08f) {
            f2 = 0.0f;
        } else {
            float f3 = (float)this.diameter / 2.0f * 0.08f;
            f2 = (float)(this.center.distance(point) - (double)f3) / ((float)this.diameter / 2.0f - f3);
        }
        return f2;
    }

    private void c() {
        this.colorWheelPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.drawImage(ColorWheel.this.colorWheelImage, 0, 0, this);
            }
        };
        this.colorWheelPanel.setSize(new Dimension(this.colorWheelImage.getWidth(), this.colorWheelImage.getHeight()));
        this.colorWheelPanel.setVisible(true);
        this.colorWheelPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (mouseEvent.getPoint().distance(ColorWheel.this.center) > (double)(ColorWheel.this.activeRadius - 3)) {
                    return;
                }
                ColorWheel.this.lastMousePoint = mouseEvent.getPoint();
                ((ColorWheel)ColorWheel.this).currentHSB[0] = ColorWheel.this.a(ColorWheel.this.lastMousePoint);
                ((ColorWheel)ColorWheel.this).currentHSB[1] = ColorWheel.this.b(ColorWheel.this.lastMousePoint);
                ColorWheel.this.getColorSelectionModel().setSelectedColor(ColorWheel.this.a());
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
        this.colorWheelPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getPoint().distance(ColorWheel.this.center) > (double)(ColorWheel.this.activeRadius - 3)) {
                    return;
                }
                ColorWheel.this.lastMousePoint = mouseEvent.getPoint();
                ((ColorWheel)ColorWheel.this).currentHSB[0] = ColorWheel.this.a(ColorWheel.this.lastMousePoint);
                ((ColorWheel)ColorWheel.this).currentHSB[1] = ColorWheel.this.b(ColorWheel.this.lastMousePoint);
                ColorWheel.this.getColorSelectionModel().setSelectedColor(ColorWheel.this.a());
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }
        });
    }

    private void d() {
        this.brightnessSlider = new JSlider(1, 0, 255, (int)(this.currentHSB[2] * 255.0f));
        this.brightnessSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ((ColorWheel)ColorWheel.this).currentHSB[2] = (float)ColorWheel.this.brightnessSlider.getValue() / 255.0f;
                ColorWheel.this.e();
            }
        });
        this.previewColorPanel = new JPanel();
        this.previewColorPanel.setPreferredSize(new Dimension(32, 32));
        this.previewColorPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
    }

    private void e() {
        this.getColorSelectionModel().setSelectedColor(this.a());
        this.f();
    }

    private void f() {
        if (this.colorWheelPanel.getGraphics() == null) {
            return;
        }
        Graphics graphics = this.colorWheelPanel.getGraphics();
        this.colorWheelImage = this.b();
        graphics.drawImage(this.colorWheelImage, 0, 0, this.colorWheelPanel);
        graphics.dispose();
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void updateChooser() {
    }
}

