/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.internals.ContourSlice;
import com.mimvista.mui.TransparentJPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DimmerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private List<JComponent> componentsToExcludeFromDimming;
    private List<JPanel> dimmedAreas = Lists.newArrayList();
    private Color dimColor = new Color(0.1f, 0.1f, 0.1f, 0.6f);
    private ComponentAdapter resizeListener;
    private Container prevParent;
    private Map<JScrollBar, AdjustmentListener> scrollListeners = Maps.newHashMap();

    private JPanel a() {
        TransparentJPanel transparentJPanel = new TransparentJPanel();
        transparentJPanel.addMouseListener(new MouseAdapter(){});
        transparentJPanel.setOpaque(false);
        transparentJPanel.setBackground(this.dimColor);
        return transparentJPanel;
    }

    private List<JPanel> b() {
        return Lists.newArrayList(this.dimmedAreas);
    }

    public void a(Color color) {
        this.dimColor = color;
        for (JPanel jPanel : this.b()) {
            jPanel.setBackground(color);
        }
    }

    public DimmerPanel(JComponent jComponent) {
        this(Lists.newArrayList((Object[])new JComponent[]{jComponent}));
    }

    public DimmerPanel(List<JComponent> list) {
        super(null);
        this.setOpaque(false);
        this.componentsToExcludeFromDimming = Lists.newArrayList(list);
        this.resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DimmerPanel.this.doLayout();
            }
        };
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (DimmerPanel.this.prevParent != null) {
                    DimmerPanel.this.prevParent.removeComponentListener(DimmerPanel.this.resizeListener);
                }
                DimmerPanel.this.prevParent = DimmerPanel.this.getParent();
                DimmerPanel.this.c();
                if (DimmerPanel.this.prevParent != null && DimmerPanel.this.prevParent.getLayout() == null) {
                    DimmerPanel.this.doLayout();
                    DimmerPanel.this.prevParent.addComponentListener(DimmerPanel.this.resizeListener);
                }
            }
        });
    }

    private void c() {
        for (Map.Entry<JScrollBar, AdjustmentListener> entry : this.scrollListeners.entrySet()) {
            entry.getKey().removeAdjustmentListener(entry.getValue());
        }
        this.scrollListeners.clear();
    }

    private List<Rectangle> a(int n2, List<Rectangle> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (Rectangle rectangle : list) {
            if (rectangle.y > n2 || rectangle.y + rectangle.height <= n2) continue;
            arrayList.add(rectangle);
        }
        return arrayList;
    }

    private List<Rectangle> a(List<Rectangle> list) {
        ArrayList arrayList = Lists.newArrayList();
        PriorityQueue<Integer> priorityQueue = new PriorityQueue<Integer>();
        for (Rectangle serializable : list) {
            priorityQueue.add(serializable.y);
            priorityQueue.add(serializable.y + serializable.height);
        }
        priorityQueue.add(0);
        while (!priorityQueue.isEmpty()) {
            int n2 = (Integer)priorityQueue.poll();
            ContourSlice.ScanLine scanLine = new ContourSlice.ScanLine(0);
            List<Rectangle> list2 = this.a(n2, list);
            for (Rectangle rectangle2 : list2) {
                scanLine.d(rectangle2.x, rectangle2.x + rectangle2.width);
            }
            int n3 = priorityQueue.isEmpty() ? this.getHeight() : ((Integer)priorityQueue.peek()).intValue();
            scanLine.a(0, this.getWidth());
            boolean bl2 = false;
            short s2 = 0;
            for (short s3 : scanLine.invPoints) {
                boolean bl3 = bl2 = !bl2;
                if (!bl2) {
                    arrayList.add(new Rectangle(s2, n2, s3 - s2, n3 - n2));
                    continue;
                }
                s2 = s3;
            }
        }
        return arrayList.stream().filter(rectangle -> rectangle.width > 0 && rectangle.height > 0).collect(Collectors.toList());
    }

    private void a(JScrollBar jScrollBar) {
        if (jScrollBar == null || this.scrollListeners.containsKey(jScrollBar)) {
            return;
        }
        AdjustmentListener adjustmentListener = adjustmentEvent -> this.revalidate();
        jScrollBar.addAdjustmentListener(adjustmentListener);
        this.scrollListeners.put(jScrollBar, adjustmentListener);
    }

    private List<Rectangle> a(JComponent jComponent, boolean bl2) {
        Container container;
        if (jComponent == null) {
            return Lists.newArrayList();
        }
        Rectangle rectangle = jComponent.getBounds();
        Container container2 = container = jComponent.getParent();
        ArrayList arrayList = Lists.newArrayList();
        while (container2 != null && !(container2 instanceof Window)) {
            Rectangle rectangle2 = container2.getBounds();
            Container container3 = container2.getParent();
            Rectangle rectangle3 = SwingUtilities.convertRectangle(container3, rectangle2, container);
            Rectangle.intersect(rectangle, rectangle3, rectangle);
            if (container2 instanceof JScrollPane && bl2) {
                JScrollPane jScrollPane = (JScrollPane)container2;
                JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
                JScrollBar jScrollBar2 = jScrollPane.getVerticalScrollBar();
                this.a(jScrollBar);
                this.a(jScrollBar2);
                arrayList.addAll(this.a(jScrollBar, false));
                arrayList.addAll(this.a(jScrollBar2, false));
            }
            container2 = container3;
        }
        arrayList.add(SwingUtilities.convertRectangle(container, rectangle, this.getParent()));
        return arrayList;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Rectangle rectangle = SwingUtilities.getLocalBounds(this.getParent());
        this.setBounds(rectangle);
        ArrayList arrayList = Lists.newArrayList();
        for (JComponent jComponent : this.componentsToExcludeFromDimming) {
            arrayList.addAll(this.a(jComponent, true));
        }
        List<Rectangle> list = this.a(arrayList);
        if (list.size() != this.dimmedAreas.size()) {
            JComponent jComponent;
            while (list.size() > this.dimmedAreas.size()) {
                jComponent = this.a();
                this.dimmedAreas.add((JPanel)jComponent);
                this.add(jComponent);
            }
            while (list.size() < this.dimmedAreas.size()) {
                jComponent = this.dimmedAreas.remove(this.dimmedAreas.size() - 1);
                this.remove(jComponent);
            }
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.dimmedAreas.get(i2).setBounds((Rectangle)list.get(i2));
        }
    }
}

