/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui;

import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.preferencesNew.BoundsPrefs;
import com.mimvista.util.ay;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class MIMJDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    boolean useDefaultBounds = true;
    private boolean boppable = false;
    private JButton dismissBtnForRobots;
    private Runnable dismissRunnableForRobots;
    private String boundsKey = null;
    private boolean disableAutoBounding = false;

    public MIMJDialog(Window window, String string, boolean bl2, boolean bl3) {
        this(window, string, bl2, bl3, true);
    }

    public MIMJDialog(Window window, String string, boolean bl2, boolean bl3, boolean bl4) {
        this(window, string, bl2, null, bl3, bl4);
    }

    public MIMJDialog(Window window, String string, boolean bl2) {
        this(window, string, bl2, null, true);
    }

    public MIMJDialog(Window window, String string) {
        this(window, string, false, null, true);
    }

    public MIMJDialog(Window window, String string, boolean bl2, GraphicsConfiguration graphicsConfiguration, boolean bl3) {
        this(window, string, bl2, graphicsConfiguration, bl3, true);
    }

    public MIMJDialog(Window window, String string, boolean bl2, GraphicsConfiguration graphicsConfiguration, boolean bl3, boolean bl4) {
        super(window, string, bl2 ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS, graphicsConfiguration);
        this.useDefaultBounds = bl3;
        this.setResizable(bl4);
        this.prepare();
    }

    public void setBoundsKey(String string) {
        this.boundsKey = string;
    }

    public String getBoundsKey() {
        if (this.boundsKey != null) {
            return this.boundsKey;
        }
        return this.getTitle();
    }

    public void setUseDefaultBounds(boolean bl2) {
        this.useDefaultBounds = bl2;
    }

    public void setBoppable(boolean bl2) {
        this.boppable = bl2;
    }

    public boolean isBoppable() {
        return this.boppable;
    }

    public void setRoboDismissBtn(JButton jButton) {
        this.dismissBtnForRobots = jButton;
    }

    public void setAutoBounding(boolean bl2) {
        this.disableAutoBounding = !bl2;
    }

    public JButton getRoboDismissBtn() {
        return this.dismissBtnForRobots;
    }

    public void setDismissRunnableForRobots(Runnable runnable) {
        this.dismissRunnableForRobots = runnable;
    }

    public Runnable getDismissRunnableForRobots() {
        return this.dismissRunnableForRobots;
    }

    private void prepare() {
        ImageManipulator.a(this);
        this.setDefaultCloseOperation(2);
        this.loadBounds(this.getBoundsKey());
        this.setupCloseListener();
    }

    protected boolean loadBounds(String string) {
        if (this.disableAutoBounding) {
            return false;
        }
        if (string != null && !string.isEmpty()) {
            try {
                int[] nArray = BoundsPrefs.windows.b(string).getValue();
                if (nArray != null) {
                    if (this.isResizable()) {
                        if (nArray.length == 4) {
                            Rectangle rectangle = new Rectangle();
                            rectangle.x = nArray[0];
                            rectangle.y = nArray[1];
                            rectangle.width = nArray[2];
                            rectangle.height = nArray[3];
                            this.setBounds(rectangle);
                            MIMSwingUtils.a((Window)this);
                            return true;
                        }
                    } else if (nArray.length >= 2) {
                        int n2 = nArray[0];
                        int n3 = nArray[1];
                        this.setLocation(n2, n3);
                        MIMSwingUtils.a((Window)this);
                        return true;
                    }
                }
            }
            catch (Throwable throwable) {
                ay.d((Object)("Error retrieving stored dialog bounds " + string), throwable, this);
            }
        }
        if (this.useDefaultBounds) {
            this.setBounds(this.getDefaultBounds());
        }
        return false;
    }

    public boolean hasStoredBounds() {
        return this.loadBounds(this.getBoundsKey());
    }

    public void storeBounds() {
        if (this.disableAutoBounding) {
            return;
        }
        String string = this.getBoundsKey();
        if (string == null || "".equals(string)) {
            return;
        }
        if (this.isResizable()) {
            Rectangle rectangle = this.getBounds();
            BoundsPrefs.windows.b(string).setValue(new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height});
        } else {
            Point point = this.getLocation();
            BoundsPrefs.windows.b(string).setValue(new int[]{point.x, point.y});
        }
    }

    private void setupCloseListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MIMJDialog.this.storeBounds();
            }
        });
    }

    @Override
    public void setVisible(boolean bl2) {
        this.setVisible(bl2, true);
    }

    public void setVisible(boolean bl2, boolean bl3) {
        if (bl2) {
            if (!this.loadBounds(this.getBoundsKey())) {
                this.setLocationRelativeTo(this.getOwner());
            }
        } else {
            this.storeBounds();
        }
        super.setVisible(bl2);
        if (!bl2 && bl3) {
            super.dispose();
        }
    }

    @Override
    public void dispose() {
        this.storeBounds();
        super.dispose();
    }

    public void setVisibleNoLoadBounds(boolean bl2) {
        super.setVisible(bl2);
    }

    @Override
    public void setMinimumSize(final Dimension dimension) {
        String string = System.getProperty("java.version");
        if (!string.startsWith("1.5")) {
            super.setMinimumSize(dimension);
        } else {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    Dimension dimension2 = new Dimension(MIMJDialog.this.getWidth(), MIMJDialog.this.getHeight());
                    MIMJDialog.this.setSize(dimension2.width < dimension.width ? dimension.width : dimension2.width, dimension2.height < dimension.height ? dimension.height : dimension2.height);
                }
            });
        }
    }

    public static Rectangle getDefaultDialogBounds() {
        return new Rectangle(0, 0, 400, 300);
    }

    public Rectangle getDefaultBounds() {
        return MIMJDialog.getDefaultDialogBounds();
    }

    public static void main(String[] stringArray) {
        final JFrame jFrame = new JFrame("test");
        JButton jButton = new JButton("boo");
        jFrame.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MIMJDialog mIMJDialog = new MIMJDialog((Window)jFrame, "sweet test");
                mIMJDialog.setMinimumSize(new Dimension(400, 400));
                mIMJDialog.setVisible(true);
            }
        });
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

