/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui;

import com.google.common.collect.Lists;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.mui.ak;
import com.mimvista.preferencesNew.ArchivePrefs;
import com.mimvista.preferencesNew.BoundsPrefs;
import com.mimvista.preferencesNew.InterfacePrefs;
import com.mimvista.swing.DelayedActionRunner;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeListener;

public class MIMJFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static List<WeakReference<MIMJFrame>> allFrames = new ArrayList<WeakReference<MIMJFrame>>();
    private String boundsKey = "";
    private Rectangle boundsToStore;
    private DelayedActionRunner delayedBoundsChecker;
    private Rectangle defaultBounds;

    private static void addMIMJFrame(MIMJFrame mIMJFrame) {
        allFrames.add(new WeakReference<MIMJFrame>(mIMJFrame));
    }

    public static List<WeakReference<MIMJFrame>> getAllMIMJFrames() {
        return Lists.newArrayList(allFrames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getMainWindowMinSize() {
        String string = InterfacePrefs.minimumMainWindowSize.getValue();
        String[] stringArray = string.split("x");
        if (stringArray.length != 2) {
            stringArray = "1024x768".split("x");
        }
        Dimension dimension = null;
        try {
            dimension = new Dimension(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
        }
        catch (Throwable throwable) {
            ay.d((Object)"Unreadable minimum window size preference in interface.txt", MIMJFrame.class);
        }
        finally {
            if (dimension == null) {
                dimension = new Dimension(1024, 768);
            }
        }
        return dimension;
    }

    public static Dimension getAltWindowMinSize() {
        return new Dimension(800, 600);
    }

    public MIMJFrame(String string) {
        this(string, null, new Rectangle(new Point(), MIMJFrame.getAltWindowMinSize()));
    }

    public MIMJFrame(String string, Rectangle rectangle) {
        this(string, null, rectangle);
    }

    public MIMJFrame(String string, GraphicsConfiguration graphicsConfiguration) {
        this(string, graphicsConfiguration, new Rectangle(new Point(), MIMJFrame.getAltWindowMinSize()));
    }

    public MIMJFrame(String string, GraphicsConfiguration graphicsConfiguration, Rectangle rectangle) {
        super(string, graphicsConfiguration);
        this.boundsKey = string;
        this.defaultBounds = rectangle;
        this.boundsToStore = this.getBounds();
        this.setDefaultCloseOperation(1);
        ImageManipulator.a(this);
        this.loadBounds(string, rectangle);
        if (this.isAlwaysOnTopSupported()) {
            MIMJFrame.addMIMJFrame(this);
            this.setAlwaysOnTop(ArchivePrefs.MimAlwaysOnTop.getValue());
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                MIMJFrame.this.updateBoundsOnDar();
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                this.componentMoved(componentEvent);
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                this.componentMoved(componentEvent);
            }
        });
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MIMJFrame.this.storeBounds();
            }

            @Override
            public void windowStateChanged(WindowEvent windowEvent) {
                if ((windowEvent.getNewState() & 0) > 0 || (windowEvent.getNewState() & 1) > 0) {
                    return;
                }
                MIMJFrame.this.updateBoundsOnDar();
            }
        };
        this.addWindowListener(windowAdapter);
        this.addWindowStateListener(windowAdapter);
        this.removePopupMenuListenersOnFrameCloseToStopLeak();
        MIMSwingUtils.b(this);
    }

    private void updateBoundsOnDar() {
        if (this.delayedBoundsChecker == null) {
            this.delayedBoundsChecker = new DelayedActionRunner(100, new Runnable(){

                @Override
                public void run() {
                    int n2 = MIMJFrame.this.getExtendedState();
                    if ((n2 & 1) == 0) {
                        MIMJFrame.this.boundsToStore = MIMJFrame.this.getBounds();
                    }
                }
            });
        }
        this.delayedBoundsChecker.b();
    }

    private void removePopupMenuListenersOnFrameCloseToStopLeak() {
        if (ak.b().O() != this) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    try {
                        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                        for (ChangeListener changeListener : menuSelectionManager.getChangeListeners()) {
                            Class<?> clazz = Class.forName("javax.swing.plaf.basic.BasicPopupMenuUI$MenuKeyboardHelper");
                            if (!clazz.isInstance(changeListener)) continue;
                            Field field = clazz.getDeclaredField("menuInputMap");
                            field.setAccessible(true);
                            field.set(changeListener, null);
                            field.setAccessible(false);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void setBoundsKey(String string) {
        this.boundsKey = string;
    }

    public String getBoundsKey() {
        return this.boundsKey;
    }

    protected void loadBounds(String string) {
        this.loadBounds(string, this.defaultBounds);
    }

    protected void loadBounds(String string, Rectangle rectangle) {
        Pair<Rectangle, Integer> pair;
        if (!cn.g(string) && (pair = this.getStoredBounds()) != null) {
            this.setBounds((Rectangle)pair.x);
            MIMSwingUtils.a((Window)this);
            pair.x = this.getBounds();
            this.setExtendedState((Integer)pair.y);
            this.boundsToStore = new Rectangle((Rectangle)pair.x);
            return;
        }
        this.setBounds(rectangle);
        if (ak.b().O() != null) {
            MIMSwingUtils.a((Component)this, ak.b().O());
        } else if (this.getGraphicsConfiguration() != null && this.getGraphicsConfiguration().getDevice() != null && this.getGraphicsConfiguration().getDevice().getFullScreenWindow() != null) {
            MIMSwingUtils.a((Component)this, this.getGraphicsConfiguration().getDevice().getFullScreenWindow());
        }
        MIMSwingUtils.a((Window)this);
        this.boundsToStore = this.getBounds();
    }

    public String getBoundsStorageKey() {
        return this.boundsKey;
    }

    protected Pair<Rectangle, Integer> getStoredBounds() {
        return this.getStoredBounds(this.getBoundsStorageKey());
    }

    protected Pair<Rectangle, Integer> getStoredBounds(String string) {
        if (cn.g(string)) {
            return null;
        }
        try {
            int[] nArray = BoundsPrefs.windows.b(string).getValue();
            if (nArray != null && nArray.length == 5) {
                Rectangle rectangle = new Rectangle();
                rectangle.x = nArray[0];
                rectangle.y = nArray[1];
                rectangle.width = nArray[2];
                rectangle.height = nArray[3];
                Integer n2 = nArray[4];
                return Pair.get(rectangle, n2);
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)("Error retrieving stored window bounds " + string), throwable, this);
        }
        return null;
    }

    public void storeBounds() {
        String string = this.getBoundsStorageKey();
        if (cn.g(string) || this.boundsToStore == null) {
            return;
        }
        int n2 = this.getExtendedState();
        BoundsPrefs.windows.b(string).setValue(new int[]{this.boundsToStore.x, this.boundsToStore.y, this.boundsToStore.width, this.boundsToStore.height, n2 &= 0xFFFFFFFE});
    }

    protected void deleteStoredBounds() {
        BoundsPrefs.windows.b(this.getBoundsStorageKey()).remove();
    }

    protected void setBoundsToStore(Rectangle rectangle) {
        this.boundsToStore = rectangle;
    }

    @Override
    public void setVisible(boolean bl2) {
        boolean bl3 = this.isVisible();
        if (bl2 && bl3) {
            return;
        }
        if (bl2) {
            this.loadBounds(this.getBoundsStorageKey());
        } else {
            this.storeBounds();
        }
        super.setVisible(bl2);
    }

    @Override
    public void setMinimumSize(final Dimension dimension) {
        String string = System.getProperty("java.version");
        if (!string.startsWith("1.5")) {
            super.setMinimumSize(dimension);
        } else {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    Dimension dimension2 = new Dimension(MIMJFrame.this.getWidth(), MIMJFrame.this.getHeight());
                    MIMJFrame.this.setSize(dimension2.width < dimension.width ? dimension.width : dimension2.width, dimension2.height < dimension.height ? dimension.height : dimension2.height);
                }
            });
        }
    }

    @Override
    public void setMaximumSize(final Dimension dimension) {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension2 = new Dimension(MIMJFrame.this.getWidth(), MIMJFrame.this.getHeight());
                MIMJFrame.this.setSize(dimension2.width > dimension.width ? dimension.width : dimension2.width, dimension2.height > dimension.height ? dimension.height : dimension2.height);
            }
        });
    }

    public void setDefaultBounds(Rectangle rectangle) {
        this.defaultBounds = rectangle;
    }
}

