/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui;

import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.swing.widgets.popup.MenuElementPanel;
import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

public class ThumbnailMenuItem
extends MenuElementPanel {
    private static final long serialVersionUID = 1L;
    public static final int a = 250;
    private static final Color b = Color.GRAY;
    private Color oldColor;
    private boolean active;
    private JLabel thumbnailItem;
    private JLabel closeButton;
    private Runnable clickAction;
    private Runnable closeAction;
    private boolean reallyToClose;
    private boolean mouseInCloseButton;
    private boolean roundIconCorners = true;
    private long lastEventTime = -1L;
    private static final long c = 50L;

    public ThumbnailMenuItem(BufferedImage bufferedImage, String string, boolean bl2, boolean bl3, boolean bl4, String string2, String string3, Runnable runnable, Runnable runnable2) {
        this.active = bl2;
        this.clickAction = runnable;
        this.closeAction = runnable2;
        this.roundIconCorners = bl4;
        this.b();
        this.a(bufferedImage, string, bl3, string2, string3);
        this.oldColor = this.getBackground();
    }

    public ThumbnailMenuItem(BufferedImage bufferedImage, String string, boolean bl2, boolean bl3, String string2, String string3, Runnable runnable, Runnable runnable2) {
        this(bufferedImage, string, bl2, bl3, true, string2, string3, runnable, runnable2);
    }

    public ThumbnailMenuItem(BufferedImage bufferedImage, String string, boolean bl2, boolean bl3, String string2, Runnable runnable) {
        this(bufferedImage, string, bl2, bl3, false, string2, null, runnable, null);
    }

    public ThumbnailMenuItem(BufferedImage bufferedImage, String string, boolean bl2) {
        this(bufferedImage, string, bl2, false, null, null, null, null);
    }

    private void b() {
        this.updateUI();
        this.setRequestFocusEnabled(false);
    }

    private void a(BufferedImage bufferedImage, String string, boolean bl2, String string2, String string3) {
        this.a(bufferedImage, string, bl2, string2);
        this.a(string3);
    }

    private void a(BufferedImage bufferedImage, String string, boolean bl2, String string2) {
        Graphics2D graphics2D;
        int n2 = 16;
        string = this.active ? "<html><b>" + string + "</b></html>" : "<html>" + string + "</html>";
        this.thumbnailItem = new JLabel(string);
        int n3 = 4;
        int n4 = n3 / 2;
        if (this.roundIconCorners) {
            graphics2D = bufferedImage.createGraphics();
            graphics2D.setStroke(new BasicStroke(n3));
            graphics2D.setColor(new Color(0, 0, 0, 0));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setComposite(AlphaComposite.DstAtop);
            graphics2D.drawRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.drawRect(-n4, -n4, bufferedImage.getWidth() + 2 * n4, bufferedImage.getHeight() + 2 * n4);
        }
        if (bl2) {
            graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage((Image)ImageManipulator.d("star_green", n2, n2), -1, -1, null);
            graphics2D.dispose();
        }
        this.thumbnailItem.setIcon(new ImageIcon(bufferedImage));
        if (!cn.h(string2)) {
            this.thumbnailItem.setToolTipText(string2);
        }
        this.thumbnailItem.setForeground(Color.LIGHT_GRAY);
        this.thumbnailItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ThumbnailMenuItem.this.c();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ThumbnailMenuItem.this.thumbnailItem.setForeground(Color.WHITE);
                ThumbnailMenuItem.this.setBackground(b);
                ThumbnailMenuItem.this.revalidate();
                ThumbnailMenuItem.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ThumbnailMenuItem.this.thumbnailItem.setForeground(Color.LIGHT_GRAY);
                ThumbnailMenuItem.this.setBackground(ThumbnailMenuItem.this.oldColor);
                ThumbnailMenuItem.this.revalidate();
                ThumbnailMenuItem.this.repaint();
            }
        });
        this.add(this.thumbnailItem);
    }

    public void a(int n2) {
        Dimension dimension = this.thumbnailItem.getPreferredSize();
        dimension.width = n2;
        this.thumbnailItem.setPreferredSize(dimension);
    }

    private void a(String string) {
        if (this.closeAction == null || cn.h(string)) {
            return;
        }
        this.closeButton = new JLabel(ImageManipulator.a("badge_x_grey", 32));
        this.closeButton.setHorizontalTextPosition(2);
        this.closeButton.setToolTipText(string);
        this.closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ThumbnailMenuItem.this.d();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ThumbnailMenuItem.this.mouseInCloseButton = true;
                ThumbnailMenuItem.this.closeButton.setIcon(ImageManipulator.a("badge_x_red", 32));
                ThumbnailMenuItem.this.closeButton.revalidate();
                ThumbnailMenuItem.this.closeButton.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ThumbnailMenuItem.this.mouseInCloseButton = false;
                ThumbnailMenuItem.this.closeButton.setIcon(ImageManipulator.a("badge_x_grey", 32));
                ThumbnailMenuItem.this.closeButton.revalidate();
                ThumbnailMenuItem.this.closeButton.repaint();
            }
        });
        this.add(this.closeButton);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(MIMLookAndFeel.j());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Rectangle2D.Double double_ = new Rectangle2D.Double(1.0, 1.0, this.getWidth() - 2, this.getHeight() - 2);
        Rectangle rectangle = graphics.getClipBounds();
        Area area = new Area(double_);
        if (rectangle != null) {
            area.intersect(new Area(rectangle));
        }
        graphics.setClip(area);
        super.paintComponent(graphics);
        graphics.setClip(rectangle);
        if (this.active) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(new Color(128, 128, 255));
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            graphics.setColor(new Color(80, 80, 160));
            graphics.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            graphics.setColor(new Color(50, 50, 100));
            graphics.drawRect(2, 2, this.getWidth() - 5, this.getHeight() - 5);
        }
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        long l2 = 0L;
        if (this.lastEventTime == -1L) {
            this.lastEventTime = mouseEvent.getWhen();
        } else {
            l2 = mouseEvent.getWhen() - this.lastEventTime;
        }
        if (l2 > 50L && mouseEvent.getID() == 502) {
            if (this.mouseInCloseButton) {
                this.d();
            } else {
                this.c();
            }
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        if (keyEvent.getKeyChar() == '\n') {
            this.c();
        }
    }

    private void c() {
        if (this.clickAction == null) {
            return;
        }
        SwingUtilities.invokeLater(this.clickAction);
    }

    private void d() {
        if (this.closeAction == null) {
            return;
        }
        if (!this.reallyToClose) {
            this.reallyToClose = true;
            Dimension dimension = this.closeButton.getPreferredSize();
            Messages messages = Messages.a("Swing");
            this.closeButton.setText(messages.b("PAGESESSION_ASK_REALLY"));
            Rectangle rectangle = this.closeButton.getBounds();
            this.closeButton.setPreferredSize(new Dimension(80, rectangle.height));
            Dimension dimension2 = this.thumbnailItem.getPreferredSize();
            dimension2.width += dimension.width - this.closeButton.getPreferredSize().width;
            ++dimension2.width;
            this.thumbnailItem.setPreferredSize(dimension2);
            this.closeButton.revalidate();
            this.closeButton.repaint();
        } else {
            SwingUtilities.invokeLater(this.closeAction);
        }
    }
}

