/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.findings;

import com.google.common.collect.Lists;
import com.mimvista.internals.ImageFrame;
import com.mimvista.mui.findings.Finding;
import com.mimvista.mui.findings.FindingElement;
import com.mimvista.mui.findings.FindingElementListModel;
import com.mimvista.mui.findings.FindingListSelectionModel;
import com.mimvista.mui.findings.FindingsAutoCreationType;
import com.mimvista.mui.findings.FindingsSortType;
import com.mimvista.mui.findings.OverlayFindingElement;
import com.mimvista.mui.findings.SessionFindingsState;
import com.mimvista.mui.findings.a.a;
import com.mimvista.mui.findings.a.b;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.preferencesNew.FindingsPrefs;
import com.mimvista.swing.TypedListModel;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FindingListModel
extends TypedListModel<Finding> {
    private static final long serialVersionUID = 1L;
    private final SessionFindingsState state;
    private Finding currFinding = null;
    private FindingListSelectionModel selectionModel = new FindingListSelectionModel(this);
    private List<Finding> findings = Lists.newCopyOnWriteArrayList();
    private AtomicInteger newFindingNumber = new AtomicInteger(1);
    private FindingListener findingsListener = new FindingListener();
    private AtomicInteger timingNumber = new AtomicInteger(1);

    public FindingListModel(SessionFindingsState sessionFindingsState) {
        this.state = sessionFindingsState;
    }

    @Override
    public int getSize() {
        return this.findings.size();
    }

    public int a() {
        return this.timingNumber.getAndIncrement();
    }

    public Finding a(int n2) {
        return this.findings.get(n2);
    }

    public List<Finding> b() {
        return Lists.newArrayList(this.findings);
    }

    @Override
    public Iterator<Finding> iterator() {
        return this.findings.iterator();
    }

    public Finding c() {
        return this.currFinding;
    }

    public Finding a(Overlayish overlayish, boolean bl2) {
        if (!bl2) {
            a a2 = new b().a(new OverlayFindingElement(overlayish)).a(this.currFinding).a(overlayish.ao()).a();
            if (FindingsPrefs.automaticFindingCreationType.getValue().a(a2)) {
                return this.currFinding;
            }
            if (FindingsPrefs.automaticFindingCreationType.getValue() == FindingsAutoCreationType.b) {
                return this.a(overlayish.ao(), overlayish.aW());
            }
            return null;
        }
        ArrayList<Finding> arrayList = new ArrayList<Finding>(this.findings);
        if (this.currFinding != null) {
            arrayList.remove(this.currFinding);
            arrayList.add(0, this.currFinding);
        }
        for (Finding finding : arrayList) {
            a a3 = new b().a(new OverlayFindingElement(overlayish)).a(finding).a();
            FindingElementListModel findingElementListModel = finding.e();
            if (FindingsPrefs.automaticFindingCreationType.getValue().a(a3) || !findingElementListModel.b().stream().filter(findingElement -> findingElement instanceof OverlayFindingElement).anyMatch(findingElement -> overlayish.getName().toLowerCase().equals(((OverlayFindingElement)findingElement).f().getName().toLowerCase()))) continue;
            return finding;
        }
        return null;
    }

    public int d() {
        if (this.currFinding == null) {
            return -1;
        }
        return this.findings.indexOf(this.currFinding);
    }

    public synchronized void a(Finding finding) {
        if (finding != this.currFinding && this.findings.contains(finding)) {
            this.currFinding = finding;
            this.selectionModel.b();
        }
    }

    public void e() {
        this.b(this.currFinding);
    }

    public synchronized void b(Finding finding) {
        int n2 = this.findings.indexOf(finding);
        if (n2 > -1) {
            this.findings.remove(n2);
            finding.c();
            if (finding == this.currFinding) {
                this.currFinding = null;
            }
            this.fireIntervalRemoved(this, n2, n2);
            if (this.currFinding == null && this.findings.size() > 0) {
                Finding finding2 = this.findings.get(Math.min(n2, this.findings.size() - 1));
                this.a(finding2);
            } else {
                this.selectionModel.b();
            }
            this.state.j();
        }
    }

    public FindingListSelectionModel f() {
        return this.selectionModel;
    }

    public void c(Finding finding) {
        Comparator<Finding> comparator = FindingsSortType.b();
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.findings.size(); ++i2) {
            if (comparator.compare(finding, this.findings.get(i2)) >= 0) continue;
            bl2 = true;
            this.a(finding, i2);
            break;
        }
        if (!bl2) {
            this.a(finding, this.findings.size());
        }
        this.newFindingNumber.incrementAndGet();
    }

    public int d(Finding finding) {
        return this.findings.indexOf(finding);
    }

    public synchronized void a(Finding finding, int n2) {
        this.findings.add(n2, finding);
        finding.a(this.findingsListener);
        this.fireIntervalAdded(this, n2, n2);
        if (this.currFinding == null) {
            this.currFinding = finding;
            this.f().b();
        }
        this.state.j();
    }

    public Finding a(String string, boolean bl2) {
        String string2;
        if (string == null) {
            int n2;
            int n3 = this.newFindingNumber.getAndIncrement();
            for (n2 = n3 - 1; n2 > 0 && !this.a(string2 = MIMFormat.a(Messages.a("Findings", "NEW_FINDING_NAME"), n2)); --n2) {
            }
            this.newFindingNumber.set(n2 + 1);
            n3 = this.newFindingNumber.getAndIncrement();
            string2 = MIMFormat.a(Messages.a("Findings", "NEW_FINDING_NAME"), n3);
        } else {
            string2 = string;
        }
        Finding finding = new Finding(this.state, string2, bl2);
        this.c(finding);
        return finding;
    }

    public void a(FindingElement findingElement) {
        for (Finding finding : this.findings) {
            if (finding.e().c(findingElement)) break;
        }
    }

    private boolean a(String string) {
        for (Finding finding : this.findings) {
            if (!finding.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void g() {
        Collections.sort(this.findings, FindingsSortType.b());
        this.fireContentsChanged(this, 0, this.getSize());
        this.state.j();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        for (Finding finding : this.findings) {
            finding.a(this.findingsListener);
        }
    }

    public Finding a(ImageFrame imageFrame, com.mimvista.numerics.contourtools.a.a a2) {
        if (a2 == null) {
            return null;
        }
        HashMap<Finding, Object> hashMap = new HashMap<Finding, Object>();
        for (Finding finding : this.findings) {
            com.mimvista.numerics.contourtools.a.a a3 = finding.a(imageFrame);
            if (!(a2.e(a3) >= FindingsPrefs.automaticFindingIntersectionPercentageThreshold.getValue().floatValue())) continue;
            hashMap.put(finding, a3);
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        if (hashMap.size() == 1) {
            return (Finding)hashMap.keySet().iterator().next();
        }
        Object object = null;
        float f2 = 0.0f;
        for (Map.Entry entry : hashMap.entrySet()) {
            float f3 = a2.e((com.mimvista.numerics.contourtools.a.a)entry.getValue());
            if (!(f3 > f2)) continue;
            object = (Finding)entry.getKey();
            f2 = f3;
        }
        return object;
    }

    @Override
    public /* synthetic */ Object getElementAt(int n2) {
        return this.a(n2);
    }

    public class FindingListener
    implements Serializable,
    ChangeListener {
        private static final long serialVersionUID = 1L;

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            for (Finding finding : FindingListModel.this.findings) {
                if (finding != changeEvent.getSource()) continue;
                FindingListModel.this.b(finding);
                FindingListModel.this.c(finding);
            }
        }
    }
}

