/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.goals.view;

import com.google.common.collect.Lists;
import com.mimvista.archive.gui.AbstractSeriesPanel;
import com.mimvista.archive.gui.MIMSeriesPanel;
import com.mimvista.archive.gui.SeriesContextMenuModel;
import com.mimvista.archive.gui.SwingPatientList;
import com.mimvista.archive.gui.aj;
import com.mimvista.archive.gui.ap;
import com.mimvista.archive.gui.s;
import com.mimvista.archive.search.DicomSearchSource;
import com.mimvista.archive.search.LocalSearchSource;
import com.mimvista.archive.search.RemoteSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.cloud.crypto.common.a.e;
import com.mimvista.cloud.shared.common.enums.StudyEnums;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmStudy;
import com.mimvista.dicom.read.AtomicLoadUnit;
import com.mimvista.gui.util.DynamicPopupMenu;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.gui.util.ah;
import com.mimvista.mimcloud.MIMcloudSearchSource;
import com.mimvista.mui.goals.view.BusyPanel;
import com.mimvista.mui.goals.view.StudySelectionView;
import com.mimvista.mui.goals.view.b;
import com.mimvista.mui.goals.view.c;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.swing.widgets.DecoratingJXTable;
import com.mimvista.swing.widgets.SeriesTableCellRenderers;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.TableColumnExt;

public class SeriesSelectionView
extends BusyPanel {
    private static final long serialVersionUID = 4015581365005554050L;
    private static final TableCellRenderer a = SeriesTableCellRenderers.g;
    private static final TableCellRenderer b = new StudySelectionView.ToggleSelectionCellRenderer();
    private static final TableCellEditor c = new StudySelectionView.ToggleSelectionCellEditor();
    private static final TableCellRenderer d = new SeriesIconRenderer();
    private JXTable seriesTable;
    private SeriesTableModel model;
    private StudySelectionView.ToggleAllSelectionHeader toggleHeader;
    private JScrollPane scroll;
    private List<DcmSeries> series = Lists.newArrayList();
    private List<a> listeners = Lists.newArrayList();
    private SearchSource source;

    public SeriesSelectionView(aj aj2) {
        this.setLayout(new BorderLayout());
        int n2 = 10;
        this.setBorder(new EmptyBorder(n2, n2, n2, n2));
        this.model = new SeriesTableModel();
        this.seriesTable = new DecoratingJXTable(this.model, null);
        MIMSwingUtils.a((JComponent)this.seriesTable, SwingPatientList.a());
        this.seriesTable.setForeground(Color.WHITE);
        this.seriesTable.setSelectionMode(2);
        this.seriesTable.setShowHorizontalLines(false);
        this.seriesTable.setHighlighters(new Highlighter[]{MIMLookAndFeel.c(this.seriesTable.getBackground())});
        this.seriesTable.setRowHeightEnabled(true);
        JTableHeader jTableHeader = this.seriesTable.getTableHeader();
        final ListSelectionModel listSelectionModel = this.seriesTable.getSelectionModel();
        this.toggleHeader = new StudySelectionView.ToggleAllSelectionHeader(listSelectionModel, jTableHeader);
        MIMSwingUtils.a((JComponent)jTableHeader, 16.0f);
        jTableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = SeriesSelectionView.this.seriesTable.getColumnModel();
                Point point = mouseEvent.getPoint();
                int n2 = tableColumnModel.getColumnIndexAtX(point.x);
                int n3 = tableColumnModel.getColumn(n2).getModelIndex();
                if (n3 == SeriesTableColumn.a.ordinal()) {
                    if (SeriesSelectionView.this.toggleHeader.a()) {
                        int n4 = SeriesSelectionView.this.seriesTable.getRowCount();
                        listSelectionModel.setSelectionInterval(0, n4 - 1);
                    } else {
                        listSelectionModel.clearSelection();
                    }
                }
            }
        });
        this.seriesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SeriesSelectionView.this.a(SeriesSelectionView.this.b(), SeriesSelectionView.this.c(), false);
            }
        });
        MIMSwingUtils.a((JTable)this.seriesTable, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SeriesSelectionView.this.a(SeriesSelectionView.this.b(), SeriesSelectionView.this.c(), true);
            }
        });
        this.scroll = new JScrollPane((Component)this.seriesTable);
        MIMSwingUtils.a((JTable)this.seriesTable, this.scroll, new ah(){

            @Override
            public void a(int n2, int n3) {
                com.mimvista.mui.goals.view.c.b();
                for (int i2 = n2; i2 <= n3; ++i2) {
                    DcmSeries dcmSeries = SeriesSelectionView.this.model.a(i2);
                    if (dcmSeries == null) continue;
                    com.mimvista.mui.goals.view.c.b(dcmSeries);
                }
            }
        });
        this.add((Component)this.scroll, "Center");
        Supplier<DynamicPopupMenu> supplier = () -> new DynamicPopupMenu(new SeriesContextMenuModel(aj2, MIMSeriesPanel.a(aj2, (JTable)this.seriesTable)));
        DynamicPopupMenu.a((JTable)this.seriesTable, supplier, null);
        this.l();
        this.seriesTable.setSortsOnUpdates(true);
    }

    public void a(@d List<DcmSeries> list) {
        this.series.clear();
        if (list != null) {
            this.series.addAll(list);
        }
        this.model.smashModel.a(list);
        this.model.b();
        this.seriesTable.requestFocusInWindow();
    }

    public void b(List<DcmSeries> list) {
        DcmSeries.removeAll(this.series, list);
        this.model.b();
    }

    public void a() {
        this.model.b();
    }

    public List<DcmSeries> b() {
        ArrayList arrayList = Lists.newArrayList();
        int n2 = this.seriesTable.getSelectionModel().getMinSelectionIndex();
        int n3 = this.seriesTable.getSelectionModel().getMaxSelectionIndex();
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!this.seriesTable.isRowSelected(i2)) continue;
            arrayList.add(this.model.a(i2));
        }
        return arrayList;
    }

    public List<AtomicLoadUnit> c() {
        int n2 = this.seriesTable.getSelectionModel().getMinSelectionIndex();
        int n3 = this.seriesTable.getSelectionModel().getMaxSelectionIndex();
        ArrayList<DcmSeries> arrayList = new ArrayList<DcmSeries>();
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!this.seriesTable.isRowSelected(i2)) continue;
            arrayList.add(this.model.a(i2));
        }
        return this.model.a(arrayList);
    }

    public List<AtomicLoadUnit> c(List<DcmSeries> list) {
        return this.model.a(list);
    }

    public List<DcmSeries> f() {
        return Lists.newArrayList(this.series);
    }

    public void a(a a2) {
        this.listeners.add(a2);
    }

    public void b(a a2) {
        this.listeners.remove(a2);
    }

    public void a(List<DcmSeries> list, List<AtomicLoadUnit> list2, boolean bl2) {
        for (a a2 : Lists.newArrayList(this.listeners)) {
            a2.a(list, list2, bl2);
        }
    }

    private SearchSource k() {
        Iterator<DcmSeries> iterator = this.series.iterator();
        if (iterator.hasNext()) {
            DcmSeries dcmSeries = iterator.next();
            return dcmSeries.getSearchSource();
        }
        return null;
    }

    private void l() {
        MIMSwingUtils.a(new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                TableColumnModel tableColumnModel = SeriesSelectionView.this.seriesTable.getColumnModel();
                while (tableColumnModel.getColumns().hasMoreElements()) {
                    tableColumnModel.removeColumn(tableColumnModel.getColumns().nextElement());
                }
                if (SeriesSelectionView.this.source == null) {
                    SeriesSelectionView.this.source = SeriesSelectionView.this.k();
                }
                if (SeriesSelectionView.this.source == null) {
                    return;
                }
                boolean bl2 = SeriesSelectionView.this.source instanceof RemoteSearchSource;
                boolean bl3 = SeriesSelectionView.this.source instanceof LocalSearchSource;
                boolean bl4 = SeriesSelectionView.this.source instanceof DicomSearchSource;
                boolean bl5 = SeriesSelectionView.this.source instanceof MIMcloudSearchSource;
                boolean bl6 = SeriesSelectionView.this.source.c();
                boolean bl7 = SeriesSelectionView.this.source.F() == Searchable.SearchType.b;
                boolean bl8 = SeriesSelectionView.this.source.F() == Searchable.SearchType.c;
                boolean bl9 = AbstractSeriesPanel.a(SeriesSelectionView.this.series);
                boolean bl10 = AbstractSeriesPanel.b(SeriesSelectionView.this.series);
                SeriesTableColumn[] seriesTableColumnArray = SeriesTableColumn.values();
                int n2 = seriesTableColumnArray.length;
                int n3 = 0;
                while (true) {
                    block20: {
                        if (n3 >= n2) {
                            SeriesSelectionView.this.n();
                            SeriesSelectionView.this.m();
                            return;
                        }
                        SeriesTableColumn seriesTableColumn = seriesTableColumnArray[n3];
                        switch (seriesTableColumn) {
                            case c: {
                                if (bl2 && bl9) break;
                                break block20;
                            }
                            case q: {
                                if (bl2 && bl10) break;
                                break block20;
                            }
                            case e: {
                                if (bl3 && bl8) break;
                                break block20;
                            }
                            case o: {
                                if (bl2 && bl4) break;
                                break block20;
                            }
                            case d: {
                                if (bl6 && bl7) break;
                                break block20;
                            }
                            case i: {
                                if (bl5) break;
                                break block20;
                            }
                            case h: {
                                if (bl5) break;
                                break block20;
                            }
                            case g: {
                                break block20;
                            }
                            case j: {
                                break block20;
                            }
                            case k: {
                                break block20;
                            }
                        }
                        TableColumnExt tableColumnExt = seriesTableColumn.c();
                        switch (seriesTableColumn) {
                            case a: {
                                tableColumnExt.setHeaderRenderer((TableCellRenderer)SeriesSelectionView.this.toggleHeader);
                                tableColumnExt.setHeaderValue((Object)SeriesSelectionView.this.toggleHeader);
                                tableColumnExt.sizeWidthToFit();
                                tableColumnExt.setResizable(false);
                                break;
                            }
                        }
                        tableColumnModel.addColumn((TableColumn)tableColumnExt);
                    }
                    ++n3;
                }
            }
        });
    }

    private void m() {
        if (this.k() != null) {
            if (this.k().F() == Searchable.SearchType.c) {
                this.seriesTable.setSortOrder((Object)SeriesTableColumn.e, SortOrder.DESCENDING);
            } else if (this.k().F() == Searchable.SearchType.b) {
                this.seriesTable.setSortOrder((Object)SeriesTableColumn.d, SortOrder.DESCENDING);
            }
        }
    }

    private void n() {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                int n2 = Math.min(SeriesSelectionView.this.seriesTable.getRowCount(), 100);
                int n3 = MIMSwingUtils.a((JTable)SeriesSelectionView.this.seriesTable, (Integer)n2);
                if (n3 > 0) {
                    SeriesSelectionView.this.seriesTable.setRowHeight(n3 + 4);
                }
                SeriesSelectionView.this.seriesTable.packTable(7);
            }
        });
    }

    public void a(SearchSource searchSource) {
        this.source = searchSource;
    }

    public static class SeriesIconRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -7128403226484536296L;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, "", bl2, bl3, n2, n3);
            if (object instanceof b) {
                b b2 = (b)object;
                jLabel.setIcon(b2);
                jLabel.setHorizontalAlignment(0);
            }
            return jLabel;
        }
    }

    private class SeriesTableModel
    extends MIMSeriesPanel.MIMSeriesModel
    implements FuncUtils.m<DcmSeries> {
        private static final long serialVersionUID = 5660507825384462372L;
        private ap smashModel = new ap();

        public SeriesTableModel() {
            com.mimvista.mui.goals.view.c.a(this);
        }

        @Override
        public String getColumnName(int n2) {
            try {
                return SeriesTableColumn.values()[n2].b();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("Column out of range: " + n2);
            }
        }

        @Override
        public int getColumnCount() {
            return SeriesTableColumn.values().length;
        }

        @Override
        public int getRowCount() {
            return SeriesSelectionView.this.series.size();
        }

        @Override
        public DcmSeries a(int n2) {
            try {
                int n3 = SeriesSelectionView.this.seriesTable.convertRowIndexToModel(n2);
                return (DcmSeries)SeriesSelectionView.this.series.get(n3);
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            try {
                DcmSeries dcmSeries = (DcmSeries)SeriesSelectionView.this.series.get(n2);
                e e2 = dcmSeries.getCloudStudyItem();
                try {
                    SeriesTableColumn seriesTableColumn = SeriesTableColumn.values()[n3];
                    switch (seriesTableColumn) {
                        case b: {
                            return com.mimvista.mui.goals.view.c.a(dcmSeries);
                        }
                        case c: {
                            return new s(dcmSeries.getViewStatusNames(), dcmSeries.getWorkflowStatusName());
                        }
                        case d: {
                            Date date = dcmSeries.getNewlyReceived();
                            String string = "";
                            if (date != null) {
                                string = DateUtils.a(date, DateUtils.b() + " " + DateUtils.d());
                            }
                            return string;
                        }
                        case e: {
                            Date date = dcmSeries.getRecentlyViewed();
                            String string = "";
                            if (date != null) {
                                string = DateUtils.a(date, DateUtils.b() + " " + DateUtils.d());
                            }
                            return string;
                        }
                        case g: {
                            return dcmSeries.getPatientName();
                        }
                        case h: {
                            if (e2 != null && e2.a() != null && e2.a().s() != null) {
                                return StudyEnums.Sex.a(e2.a().s().g());
                            }
                            return null;
                        }
                        case i: {
                            if (e2 != null && e2.a() != null && e2.a().s() != null) {
                                return e2.a().s().f();
                            }
                            return null;
                        }
                        case j: {
                            return dcmSeries.getPatientID();
                        }
                        case k: {
                            return dcmSeries.getModality();
                        }
                        case f: {
                            try {
                                return Integer.parseInt(dcmSeries.getNumberOfImages());
                            }
                            catch (NumberFormatException numberFormatException) {
                                return "";
                            }
                        }
                        case l: {
                            return dcmSeries.getSeriesOrStudyDateTime(true);
                        }
                        case n: {
                            String string = DcmStudy.getStringTimeFromSeriesAndStudy(dcmSeries, dcmSeries.getStudy());
                            if (!"00:00:00".equals(string)) {
                                return string;
                            }
                            return null;
                        }
                        case o: {
                            return dcmSeries.getSeriesNumber();
                        }
                        case m: {
                            return dcmSeries.getSeriesDescription();
                        }
                        case p: {
                            return dcmSeries.getStudyDescription();
                        }
                        case a: {
                            int n4 = SeriesSelectionView.this.seriesTable.convertRowIndexToView(n2);
                            return SeriesSelectionView.this.seriesTable.getSelectionModel().isSelectedIndex(n4);
                        }
                    }
                    return "";
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IllegalArgumentException("Column out of range: " + n3);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalArgumentException("Row out of range: " + n2);
            }
            catch (NullPointerException nullPointerException) {
                ay.e((Object)String.format("Error obtaining value at (r: %d, c: %d)", n2, n3), (Throwable)nullPointerException, StudySelectionView.class);
                return null;
            }
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return SeriesTableColumn.values()[n3].a();
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            boolean bl2 = (Boolean)object;
            int n4 = SeriesSelectionView.this.seriesTable.convertRowIndexToView(n2);
            if (bl2) {
                SeriesSelectionView.this.seriesTable.getSelectionModel().addSelectionInterval(n4, n4);
            } else {
                SeriesSelectionView.this.seriesTable.getSelectionModel().removeSelectionInterval(n4, n4);
            }
        }

        public void b() {
            this.fireTableDataChanged();
            SeriesSelectionView.this.l();
        }

        public void b(DcmSeries dcmSeries) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SeriesSelectionView.this.seriesTable.repaint();
                }
            });
        }

        @Override
        public List<AtomicLoadUnit> a(Collection<DcmSeries> collection) {
            return this.smashModel.a(collection);
        }

        @Override
        public boolean a(DcmSeries dcmSeries) {
            return SeriesSelectionView.this.series.contains(dcmSeries);
        }

        @Override
        public /* synthetic */ void doIt(Object object) {
            this.b((DcmSeries)object);
        }
    }

    private static enum SeriesTableColumn {
        a(null, true),
        b("THUMB_HEADER"),
        c("STATUS_HEADER"),
        d("RECEIVED_HEADER"),
        e("OPENED_HEADER"),
        f("IMAGES_HEADER"),
        g("PATIENT_NAME_HEADER"),
        h("GENDER_HEADER"),
        i("BIRTHDAY_HEADER"),
        j("PATIENT_ID_HEADER"),
        k("MODALITY_HEADER"),
        l("DATE_HEADER"),
        m("SERIES_DESCRIPTION_HEADER"),
        n("TIME_HEADER"),
        o("SERIES_NUMBER_HEADER"),
        p("STUDY_DESCRIPTION_HEADER"),
        q("OWNER_HEADER");

        private String name;
        private boolean editable;
        private TableColumnExt column;

        private SeriesTableColumn(String string2) {
            this(string2, false);
        }

        private SeriesTableColumn(String string2, boolean bl2) {
            this.name = string2 == null ? "" : Messages.a("PatientList", string2);
            this.editable = bl2;
        }

        public boolean a() {
            return this.editable;
        }

        public String b() {
            return this.name;
        }

        public TableColumnExt c() {
            TableColumnExt tableColumnExt = new TableColumnExt(this.ordinal());
            tableColumnExt.setIdentifier((Object)this);
            tableColumnExt.setHeaderValue((Object)this.name);
            switch (this) {
                case b: {
                    tableColumnExt.setCellRenderer(d);
                    tableColumnExt.setSortable(false);
                    break;
                }
                case a: {
                    tableColumnExt.setCellRenderer(b);
                    tableColumnExt.setCellEditor(c);
                    tableColumnExt.setSortable(false);
                    break;
                }
                default: {
                    tableColumnExt.setCellRenderer(a);
                }
            }
            this.column = tableColumnExt;
            return this.column;
        }
    }

    public static interface a {
        public void a(List<DcmSeries> var1, List<AtomicLoadUnit> var2, boolean var3);
    }
}

