/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.goals.view;

import com.google.common.collect.Maps;
import com.mimvista.archive.gui.PatientSearchPanel;
import com.mimvista.archive.m;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.archive.search.f;
import com.mimvista.archive.search.i;
import com.mimvista.d;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.mui.goals.view.QuickSearchPanel;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXDatePicker;

public class TaskSearchPanel
extends JPanel
implements QuickSearchPanel {
    private static final long serialVersionUID = 9163675764218332234L;
    private ActionListener searchListener;
    private FuncUtils.m<Searchable.SearchType> quickListener;
    private FuncUtils.m<Void> changeListener;
    protected String dateFormat = "MM-dd-yyyy";
    protected JTextField nameField;
    protected JTextField idField;
    protected JTextField keywordsField;
    protected JTextField modalityField;
    protected JXDatePicker startDateField = new JXDatePicker(Locale.getDefault());
    protected JXDatePicker endDateField = new JXDatePicker(Locale.getDefault());
    protected JButton recentlyViewed;
    private HashMap<String, String> lastValues = Maps.newHashMap();
    protected boolean built = false;

    public TaskSearchPanel() {
        this.buildPanel();
        this.setDateFormat(this.dateFormat);
    }

    protected void buildPanel() {
        if (this.built) {
            return;
        }
        int n2 = 10;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(20, 50, 0, 50));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.getFieldLabel("STANDARD_NAME"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.getFieldLabel("STANDARD_ID"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.getFieldLabel("STANDARD_KEYWORDS"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.getFieldLabel("STANDARD_MODALITY"), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n2, n2, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.nameField = this.getNewField();
        jPanel.add((Component)this.erasableFieldPanel(this.nameField), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.idField = this.getNewField();
        jPanel.add((Component)this.erasableFieldPanel(this.idField), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.keywordsField = this.getNewField();
        jPanel.add((Component)this.erasableFieldPanel(this.keywordsField), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.modalityField = this.getNewField();
        jPanel.add((Component)this.erasableFieldPanel(this.modalityField), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(this.buildPanelForDatePicker("STANDARD_START_DATE", this.startDateField));
        jPanel2.add(this.buildPanelForDatePicker("STANDARD_END_DATE", this.endDateField));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(n2, 0, 0, 0);
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(20));
        JButton jButton = this.getQuickButton("PATIENTSEARCH_PANEL_NEW", "PATIENTSEARCH_PANEL_NEW_ICON");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskSearchPanel.this.fireQuickListener(Searchable.SearchType.b);
            }
        });
        box.add(jButton);
        box.add(Box.createVerticalStrut(n2));
        this.recentlyViewed = this.getQuickButton("PATIENTSEARCH_PANEL_RECENT", "PATIENTSEARCH_PANEL_RECENT_ICON");
        this.recentlyViewed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskSearchPanel.this.fireQuickListener(Searchable.SearchType.c);
            }
        });
        box.add(this.recentlyViewed);
        this.add((Component)jPanel, "Center");
        this.add((Component)box, "East");
        this.addWrappersListenerForSecretListener();
        this.built = true;
    }

    public void madeVisible() {
        this.nameField.requestFocusInWindow();
    }

    public void setRecentlyViewedEnabled(boolean bl2) {
        this.recentlyViewed.setVisible(bl2);
    }

    protected JLabel getFieldLabel(String string) {
        JLabel jLabel = new JLabel(Messages.a("PatientList", string));
        MIMSwingUtils.a((JComponent)jLabel, 18.0f);
        jLabel.setHorizontalAlignment(4);
        return jLabel;
    }

    protected JTextField getNewField() {
        JTextField jTextField = new JTextField();
        MIMSwingUtils.a((JComponent)jTextField, 18.0f);
        return jTextField;
    }

    protected JComboBox getNewCombo() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setEditable(false);
        MIMSwingUtils.a(jComboBox, 18.0f);
        return jComboBox;
    }

    protected JPanel erasableFieldPanel(final JTextField jTextField) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jTextField, gridBagConstraints);
        JButton jButton = new JButton(ImageManipulator.c("erase", 20));
        jButton.setFocusable(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextField.setText(null);
                jTextField.requestFocusInWindow();
            }
        });
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    protected JPanel comboFieldPanel(JComboBox jComboBox) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jComboBox, gridBagConstraints);
        return jPanel;
    }

    protected JButton getQuickButton(String string, String string2) {
        String string3 = "<html><center>" + Messages.a("Archive", string) + "</center></html>";
        String string4 = Messages.a("Archive", string2);
        Icon icon = ImageManipulator.c(string4, 50);
        JButton jButton = new JButton(string3, icon);
        jButton.setIconTextGap(5);
        jButton.setVerticalTextPosition(3);
        jButton.setHorizontalTextPosition(0);
        jButton.setHorizontalAlignment(0);
        MIMSwingUtils.a((JComponent)jButton, 18.0f);
        Dimension dimension = new Dimension(120, 120);
        jButton.setMinimumSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.setMaximumSize(dimension);
        return jButton;
    }

    protected JPanel buildPanelForDatePicker(String string, JXDatePicker jXDatePicker) {
        int n2 = 10;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.getFieldLabel(string), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, n2, n2, n2);
        JFormattedTextField jFormattedTextField = jXDatePicker.getEditor();
        MIMSwingUtils.a((JComponent)jFormattedTextField, 18.0f);
        jPanel.add((Component)this.erasableFieldPanel(jFormattedTextField), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jXDatePicker.getMonthView(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        return jPanel;
    }

    @Override
    public void clearFields() {
        this.clearFieldsWithoutFiringListeners();
        this.fireChangeListener();
    }

    protected void clearFieldsWithoutFiringListeners() {
        this.nameField.setText("");
        this.idField.setText("");
        this.startDateField.getEditor().setText(null);
        this.startDateField.setDate(null);
        this.endDateField.getEditor().setText(null);
        this.endDateField.setDate(null);
        this.keywordsField.setText("");
        this.modalityField.setText("");
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public HashMap<String, String> getSearchParameters() {
        String string = "";
        String string2 = "";
        if (this.startDateField.getDate() != null) {
            string = DateUtils.b(this.startDateField.getDate());
        }
        if (this.endDateField.getDate() != null) {
            string2 = DateUtils.b(this.endDateField.getDate());
        }
        String string3 = this.keywordsField.getText();
        String string4 = this.nameField.getText();
        String string5 = this.idField.getText();
        String string6 = this.modalityField.getText();
        String string7 = "";
        HashMap<String, String> hashMap = m.a(string3, string4, string5, string6, string, string2, string7);
        return hashMap;
    }

    @Override
    public void setActionListener(ActionListener actionListener) {
        this.searchListener = actionListener;
    }

    @Override
    public void setDateFormat(String string) {
        this.dateFormat = string;
        this.startDateField.setFormats(new String[]{string});
        this.endDateField.setFormats(new String[]{string});
    }

    @Override
    public void setParameter(String string, String string2) {
        Map map = this.getSearchParameters();
        ((HashMap)map).put(string, string2);
        this.setSearchParameters(map);
    }

    @Override
    public void setSearchParameters(Map<String, String> map) {
        this.clearFieldsWithoutFiringListeners();
        if (map != null) {
            String string = map.get("keywords");
            String string2 = map.get("name");
            String string3 = map.get("id");
            String string4 = map.get("modality");
            String string5 = map.get("startDate");
            String string6 = map.get("endDate");
            if (string != null) {
                this.keywordsField.setText(string);
            }
            if (string2 != null) {
                this.nameField.setText(string2);
            }
            if (string3 != null) {
                this.idField.setText(string3);
            }
            if (string4 != null) {
                this.modalityField.setText(string4);
            }
            if (string5 != null && !"".equals(string5)) {
                this.startDateField.setDate(DateUtils.c(string5));
            }
            if (string6 != null && !"".equals(string6)) {
                this.endDateField.setDate(DateUtils.c(string6));
            }
        }
        this.fireChangeListener();
    }

    @Override
    public void setQuickSearchListener(FuncUtils.m<Searchable.SearchType> m2) {
        this.quickListener = m2;
    }

    public void setChangeListener(FuncUtils.m<Void> m2) {
        this.changeListener = m2;
    }

    protected void fireChangeListener() {
        Map map;
        if (this.changeListener != null && !((AbstractMap)(map = this.getSearchParameters())).equals(this.lastValues)) {
            this.lastValues = map;
            this.changeListener.doIt(null);
        }
    }

    protected void fireQuickListener(Searchable.SearchType searchType) {
        switch (searchType) {
            case a: {
                this.fireSearchListener(null);
                return;
            }
        }
        if (this.quickListener != null) {
            this.quickListener.doIt(searchType);
        }
    }

    protected void fireSearchListener(@d ActionEvent actionEvent) {
        if (this.searchListener != null) {
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 0, "magnifying_glass");
            }
            this.searchListener.actionPerformed(actionEvent);
        }
    }

    protected void addWrappersListenerForSecretListener() {
        final ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskSearchPanel.this.fireSearchListener(actionEvent);
            }
        };
        this.nameField.addActionListener(actionListener);
        this.idField.addActionListener(actionListener);
        this.keywordsField.addActionListener(actionListener);
        this.modalityField.addActionListener(actionListener);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    actionListener.actionPerformed(null);
                }
            }
        };
        this.startDateField.getEditor().addKeyListener(keyAdapter);
        this.endDateField.getEditor().addKeyListener(keyAdapter);
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.nameField.getDocument().addDocumentListener(documentListener);
        this.idField.getDocument().addDocumentListener(documentListener);
        this.keywordsField.getDocument().addDocumentListener(documentListener);
        this.modalityField.getDocument().addDocumentListener(documentListener);
        this.startDateField.getEditor().getDocument().addDocumentListener(documentListener);
        this.endDateField.getEditor().getDocument().addDocumentListener(documentListener);
    }

    @Override
    public void prepareForSource(Searchable searchable) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void commitDateEdit() {
    }

    @Override
    public void saveSearchParameters() {
    }

    @Override
    public boolean isSearchBlank() {
        return ((HashMap)this.getSearchParameters()).isEmpty();
    }

    @Override
    public Future<?> doSearch(SearchSource searchSource, f<i> f2, Searchable.a a2) {
        PatientSearchPanel.a(searchSource);
        return com.mimvista.util.work.m.e.a(searchSource.b((Map<String, String>)this.getSearchParameters(), f2, a2), "Import Search");
    }
}

