/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.graph;

import com.mimvista.d;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.mui.graph.MIMChartFactory;
import com.mimvista.mui.graph.PlotHelper;
import com.mimvista.mui.graph.XYTextAnnoOutlined;
import com.mimvista.mui.graph.a;
import com.mimvista.mui.graph.c;
import com.mimvista.numerics.MathUtils;
import com.mimvista.response.gui.components.MIMChartLAF;
import com.mimvista.response.gui.components.b;
import com.mimvista.response.k;
import com.mimvista.swing.DelayedActionRunner;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.vecmath.Point2d;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.entity.TitleEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;

public class Graph
extends ChartPanel {
    private static final long serialVersionUID = 1L;
    private static final int a = 100;
    private static final int b = 20;
    private static final int c = 40;
    private static final Color d = Color.BLACK;
    private static final double e = 10.0;
    private static final double f = 0.05;
    private Point textLocation = new Point();
    private String toolTipText = "";
    private MIMChartLAF lookAndFeel;
    protected c dataset;
    private MIMChartFactory.a mimChart;
    private final DelayedActionRunner updateDAR;
    private final GraphUpdateListener listener;
    private Optional<Runnable> postUpdateRunnable = Optional.empty();
    private final Progress loadProgress;
    private boolean userSetSnapDrag = true;
    private WeakReference<k> lastAnnotationDragged;
    private boolean needsToUpdateDomainZoomAfterDrag = false;
    private boolean needsToRebuildAfterDrag = false;
    private Double minRangeHeight = null;
    private XYTextAnnoOutlined infoAnno;

    public Graph(c c2) {
        this(c2, new MIMChartLAF(), new o());
    }

    public Graph(c c2, Progress progress) {
        this(c2, new MIMChartLAF(), progress);
    }

    public Graph(c c2, MIMChartLAF mIMChartLAF, Progress progress) {
        super(new JFreeChart((Plot)new XYPlot()));
        if (mIMChartLAF == null) {
            mIMChartLAF = new MIMChartLAF();
        }
        this.lookAndFeel = mIMChartLAF;
        this.dataset = c2;
        this.loadProgress = progress;
        GraphUpdateRunnable graphUpdateRunnable = new GraphUpdateRunnable();
        this.updateDAR = new DelayedActionRunner(100, graphUpdateRunnable);
        this.listener = new GraphUpdateListener();
        this.setMaximumDrawHeight(Integer.MAX_VALUE);
        this.setMaximumDrawWidth(Integer.MAX_VALUE);
        if (c2 instanceof a) {
            ((a)c2).a(this.listener, true);
        }
        graphUpdateRunnable.run();
    }

    public boolean a() {
        return this.b();
    }

    public boolean b() {
        WeakReference<k> weakReference = this.lastAnnotationDragged;
        return weakReference != null && weakReference.get() != null;
    }

    public Optional<k> c() {
        if (this.lastAnnotationDragged == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.lastAnnotationDragged.get());
    }

    public void a(Marker marker) {
        new PlotHelper(this.getChart().getPlot()).a(marker);
    }

    public void a(MIMChartLAF mIMChartLAF) {
        if (mIMChartLAF != null) {
            this.lookAndFeel = mIMChartLAF;
            this.i();
            this.f();
        }
    }

    public MIMChartLAF d() {
        return this.lookAndFeel.f();
    }

    public c e() {
        return this.dataset;
    }

    public void f() {
        this.updateDAR.b();
    }

    public void a(@d Runnable runnable) {
        this.postUpdateRunnable = Optional.ofNullable(runnable);
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ay.d((Object)"Graph threw error while painting", (Throwable)illegalArgumentException, (Object)this);
        }
        this.a(graphics);
        this.j();
    }

    private void i() {
        if (this.lookAndFeel != null) {
            this.lookAndFeel.a(this.getChart());
        }
    }

    private void a(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (this.lookAndFeel != null) {
            graphics.setColor(this.lookAndFeel.d());
        }
        this.l();
        int n2 = this.textLocation.x > rectangle.width / 2 ? this.toolTipText.length() * 40 / 7 : -10;
        int n3 = (int)((this.textLocation.y > rectangle.height / 2 ? 0.3 : -0.5) * 40.0);
        graphics.drawString(this.toolTipText, this.textLocation.x - n2, this.textLocation.y - n3);
    }

    private void j() {
        if (this.getChart().getPlot() instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)this.getChart().getPlot();
            int n2 = this.k();
            int n3 = categoryPlot.getDataset().getColumnCount();
            int n4 = this.a(categoryPlot);
            CategoryLabelPositions categoryLabelPositions = this.a(n2, n3, n4);
            if (!categoryPlot.getDomainAxis().getCategoryLabelPositions().equals((Object)categoryLabelPositions)) {
                categoryPlot.getDomainAxis().setCategoryLabelPositions(categoryLabelPositions);
            }
        }
    }

    public void a(@d Double d2) {
        this.minRangeHeight = d2;
    }

    private int k() {
        Rectangle2D rectangle2D = this.getChartRenderingInfo().getPlotInfo().getDataArea().getBounds2D();
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
        Point2D.Double double_2 = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
        Point point = this.translateJava2DToScreen(double_);
        Point point2 = this.translateJava2DToScreen(double_2);
        int n2 = point2.x - point.x;
        return n2;
    }

    private int a(CategoryPlot categoryPlot) {
        FontMetrics fontMetrics = this.getFontMetrics(MIMChartFactory.a());
        int n2 = -1;
        for (Object e2 : categoryPlot.getDataset().getColumnKeys()) {
            n2 = Math.max(fontMetrics.stringWidth(e2.toString()), n2);
        }
        return n2;
    }

    private CategoryLabelPositions a(int n2, int n3, int n4) {
        if (n3 > 0 && n2 / n3 < n4 + 20) {
            return CategoryLabelPositions.UP_45;
        }
        return CategoryLabelPositions.STANDARD;
    }

    private void l() {
        XYPlot xYPlot;
        Point point = null;
        String string = null;
        Plot plot = this.getChart().getPlot();
        if (plot instanceof XYPlot && (xYPlot = (XYPlot)plot).isDomainCrosshairVisible()) {
            double d2 = xYPlot.getDomainCrosshairValue();
            double d3 = xYPlot.getRangeCrosshairValue();
            XYDataset xYDataset = xYPlot.getDataset();
            block0: for (int i2 = 0; i2 < xYDataset.getSeriesCount(); ++i2) {
                int n2 = xYDataset.getItemCount(i2);
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (xYDataset.getXValue(i2, i3) != d2 || xYDataset.getYValue(i2, i3) != d3) continue;
                    double d4 = xYPlot.getDomainAxis().valueToJava2D(d2, this.getScreenDataArea(), xYPlot.getDomainAxisEdge());
                    double d5 = xYPlot.getRangeAxis().valueToJava2D(d3, this.getScreenDataArea(), xYPlot.getRangeAxisEdge());
                    point = new Point((int)d4, (int)d5);
                    string = this.getEntityForPoint(point.x, point.y).getToolTipText();
                    break block0;
                }
            }
        }
        if (point != null && string != null) {
            this.toolTipText = string;
            this.textLocation = point;
        }
    }

    protected MIMChartFactory.a g() {
        return MIMChartFactory.a(this.dataset, this.lookAndFeel);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            ChartEntity chartEntity = this.getEntityForPoint(mouseEvent.getX(), mouseEvent.getY());
            if (chartEntity instanceof LegendItemEntity || chartEntity instanceof TitleEntity) {
                return;
            }
            this.lastAnnotationDragged = new WeakReference<k>(this.a(mouseEvent.getPoint()));
            ay.a((Object)("Mouse down on annotation: " + (this.lastAnnotationDragged == null || this.lastAnnotationDragged.get() == null ? null : ((k)this.lastAnnotationDragged.get()).i())), (Object)this);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.lastAnnotationDragged != null) {
            this.a((k)this.lastAnnotationDragged.get(), mouseEvent.getPoint());
        }
    }

    public void validate() {
        super.validate();
        this.m();
    }

    public void doLayout() {
        super.doLayout();
        this.m();
    }

    private void m() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object object;
                if (!(Graph.this.dataset instanceof b) || Graph.this.mimChart == null) {
                    return;
                }
                JFreeChart jFreeChart = Graph.this.getChart();
                Plot plot = jFreeChart.getPlot();
                if (plot instanceof XYPlot) {
                    object = (XYPlot)plot;
                    for (MIMChartFactory.b object2 : ((Graph)Graph.this).mimChart.b.d.values()) {
                        object2.b((XYPlot)object);
                    }
                    ((Graph)Graph.this).mimChart.b.d.clear();
                }
                object = (b)Graph.this.dataset;
                for (k k2 : ((a)object).d()) {
                    Graph.this.a(k2);
                }
                Graph.this.n();
            }
        });
    }

    private void n() {
        Object object;
        if (this.b()) {
            this.needsToUpdateDomainZoomAfterDrag = true;
            return;
        }
        PlotHelper plotHelper = new PlotHelper(this.getChart().getPlot());
        if (!plotHelper.g()) {
            return;
        }
        XYPlot xYPlot = plotHelper.h();
        if (xYPlot == null) {
            return;
        }
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        a a2 = (a)this.dataset;
        for (k k2 : a2.d()) {
            object = k2.b();
            if (!MathUtils.a(object)) continue;
            d2 = Math.min(d2, ((Number)object).doubleValue());
            d3 = Math.max(d3, ((Number)object).doubleValue());
        }
        int n2 = xYPlot.getDatasetCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            object = xYPlot.getDataset(i2);
            int n3 = object.getSeriesCount();
            boolean bl2 = false;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (object.getItemCount(i3) <= 0) continue;
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            Range range = xYPlot.getDataRange(xYPlot.getDomainAxisForDataset(i2));
            d2 = Math.min(d2, range.getLowerBound());
            d3 = Math.max(d3, range.getUpperBound());
        }
        if (Math.abs(d2 - d3) < 1.0 || d3 < d2) {
            return;
        }
        double d4 = d3 - d2;
        double d5 = d4 * 0.05;
        double d6 = d2 - d5;
        double d7 = d3 + d5;
        Double d8 = this.dataset.m();
        Double d9 = this.dataset.n();
        if (d8 != null) {
            d6 = d8;
        }
        if (d9 != null) {
            d7 = d9;
        }
        double d10 = d6;
        double d11 = d7;
        valueAxis.setRange(d10, d11);
    }

    private void o() {
        XYPlot xYPlot = new PlotHelper(this.getChart().getPlot()).h();
        if (xYPlot == null) {
            return;
        }
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        if (this.dataset.m() != null && this.dataset.n() != null) {
            Range range = null;
            Range range2 = null;
            for (int i2 = 0; i2 < xYPlot.getDatasetCount(); ++i2) {
                ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
                for (int i3 = 0; i3 < xYPlot.getDataset(i2).getSeriesCount(); ++i3) {
                    arrayList.add(xYPlot.getDataset(i2).getSeriesKey(i3));
                }
                Range range3 = DatasetUtilities.iterateToFindRangeBounds((XYDataset)xYPlot.getDataset(i2), arrayList, (Range)new Range(this.dataset.m().doubleValue(), this.dataset.n().doubleValue()), (boolean)true);
                Range range4 = DatasetUtilities.findRangeBounds((XYDataset)xYPlot.getDataset(i2));
                range = Range.combine(range, (Range)range3);
                range2 = Range.combine(range2, (Range)range4);
            }
            if (range != null && range2 != null && (range.getUpperBound() < range2.getUpperBound() || range.getLowerBound() > range2.getLowerBound())) {
                double d2 = (range.getUpperBound() - range.getLowerBound()) * 0.05;
                double d3 = range.getLowerBound() - (range.getLowerBound() == 0.0 ? 0.0 : d2);
                double d4 = range.getUpperBound() + d2;
                valueAxis.setRange(d3, d4);
            }
        }
        double d5 = valueAxis.getUpperBound();
        if (this.minRangeHeight != null && this.minRangeHeight > d5) {
            valueAxis.setUpperBound(this.minRangeHeight.doubleValue());
        }
    }

    private void a(k k2) {
        MIMChartFactory.a(k2, this, this.mimChart.b, (b)this.dataset);
    }

    private void a(k k2, Point point) {
        if (k2 == null || !k2.j()) {
            return;
        }
        boolean bl2 = k2.f();
        XYPlot xYPlot = new PlotHelper(this.getChart().getPlot()).h();
        double d2 = xYPlot.getDomainAxis().java2DToValue((double)point.x, this.getScreenDataArea(), xYPlot.getDomainAxisEdge());
        double d3 = xYPlot.getDataset().getSeriesCount() == 0 ? xYPlot.getDomainAxis().getUpperBound() : DatasetUtilities.findMaximumDomainValue((XYDataset)xYPlot.getDataset()).doubleValue();
        if (!bl2) {
            d2 = Math.min(Math.max(d2, 0.0), d3);
        } else {
            double d4 = Math.abs(d3 - 0.0);
            double d5 = -(d4 /= 3.0);
            double d6 = d3 + d4;
            Double d7 = k2.d();
            if (d7 != null) {
                d5 = d7;
            }
            d2 = MathUtils.d(d2, d5, d6);
        }
        if (d2 >= 0.0 && d2 <= d3 || bl2) {
            b b2 = (b)this.dataset;
            if (this.h()) {
                Point2d point2d;
                int n2 = -1;
                int n3 = b2.o().indexOf(k2.c());
                MIMChartFactory.d d8 = this.mimChart.b.b.get(n3);
                if (d8 != null) {
                    XYDataset xYDataset = (XYDataset)this.mimChart.b.a;
                    n2 = xYDataset.indexOf((Comparable)((Object)d8.a));
                }
                if ((point2d = MIMChartFactory.b(d2, xYPlot, n2)) == null) {
                    return;
                }
                k2.a((Number)point2d.x);
            } else {
                ay.a((Object)("changing annotation " + k2.i() + " to data value " + d2), (Object)this);
                k2.a((Number)d2);
            }
            k2.a(point);
            this.revalidate();
        } else {
            ay.a((Object)"drag went out of range", (Object)this);
        }
    }

    public void mouseClicked(final MouseEvent mouseEvent) {
        if (!MIMSwingUtils.a(mouseEvent) || !(this.dataset instanceof b)) {
            return;
        }
        ChartEntity chartEntity = this.getEntityForPoint(mouseEvent.getX(), mouseEvent.getY());
        if (chartEntity instanceof LegendItemEntity) {
            return;
        }
        b b2 = (b)this.dataset;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenu jMenu = new JMenu(Messages.a("Nukes", "MOVE_ANNOTATION"));
        for (final k k2 : b2.d()) {
            if (!k2.j()) continue;
            JMenuItem jMenuItem = new JMenuItem(k2.i());
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Graph.this.a(k2, mouseEvent.getPoint());
                }
            });
            jMenu.add(jMenuItem);
        }
        jMenu.setEnabled(b2.w());
        jPopupMenu.add(jMenu);
        jPopupMenu.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            ChartEntity chartEntity;
            if (this.b()) {
                ay.a((Object)"done dragging annotation", (Object)this);
                this.lastAnnotationDragged.clear();
                if (this.needsToRebuildAfterDrag) {
                    this.updateDAR.b();
                } else if (this.needsToUpdateDomainZoomAfterDrag) {
                    this.n();
                }
                this.needsToRebuildAfterDrag = false;
                this.needsToUpdateDomainZoomAfterDrag = false;
                this.revalidate();
            }
            if ((chartEntity = this.getEntityForPoint(mouseEvent.getX(), mouseEvent.getY())) instanceof LegendItemEntity) {
                LegendItemEntity legendItemEntity = (LegendItemEntity)chartEntity;
                String string = legendItemEntity.getSeriesKey().toString();
                if (this.dataset instanceof b && this.mimChart.b != null) {
                    com.mimvista.response.series.c c2;
                    b b2 = (b)this.dataset;
                    MIMChartFactory.d d2 = this.mimChart.b.c.get(string);
                    c2.a(!(c2 = b2.e(d2.b)).r());
                }
            }
        }
    }

    private k a(Point point) {
        k k2 = null;
        if (this.dataset instanceof b) {
            b b2 = (b)this.dataset;
            XYPlot xYPlot = new PlotHelper(this.getChart().getPlot()).h();
            double d2 = Double.MAX_VALUE;
            for (k k3 : b2.d()) {
                double d3;
                double d4;
                Object x2 = k3.b();
                if (x2 == null || !((d4 = Math.abs((double)point.x - (d3 = xYPlot.getDomainAxis().valueToJava2D(((Number)x2).doubleValue(), this.getScreenDataArea(), xYPlot.getDomainAxisEdge())))) < 10.0) || !(d4 < d2)) continue;
                d2 = d4;
                k2 = k3;
            }
        }
        return k2;
    }

    public boolean h() {
        boolean bl2 = false;
        if (this.dataset instanceof b) {
            bl2 = ((b)this.dataset).u();
        }
        return this.userSetSnapDrag || bl2;
    }

    public void a(boolean bl2) {
        this.userSetSnapDrag = bl2;
    }

    private class GraphUpdateListener
    implements com.mimvista.mui.graph.d,
    Serializable {
        private static final long serialVersionUID = 1L;

        private GraphUpdateListener() {
        }

        @Override
        public void a() {
            Graph.this.updateDAR.b();
        }

        @Override
        public void b() {
            Graph.this.revalidate();
        }
    }

    private class GraphUpdateRunnable
    implements Serializable,
    Runnable {
        private static final long serialVersionUID = 1L;

        private GraphUpdateRunnable() {
        }

        @Override
        public void run() {
            if (Graph.this.b()) {
                Graph.this.needsToRebuildAfterDrag = true;
                return;
            }
            Graph.this.loadProgress.a();
            Graph.this.mimChart = Graph.this.g();
            Graph.this.setChart(((Graph)Graph.this).mimChart.a);
            Graph.this.i();
            Graph.this.setMouseZoomable(false, false);
            Graph.this.o();
            Graph.this.n();
            Graph.this.revalidate();
            Graph.this.repaint();
            Graph.this.loadProgress.b();
            Graph.this.postUpdateRunnable.ifPresent(Runnable::run);
        }
    }
}

