/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.layout;

import com.mimvista.mui.PresentationType;
import com.mimvista.mui.layout.Edge;
import com.mimvista.mui.layout.SeriesViewInfo;
import com.mimvista.mui.layout.ViewPortSignature;
import com.mimvista.util.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.NumberFormat;

public class HangingInfo
implements Serializable {
    private static final long serialVersionUID = -2682393312526428895L;
    public Edge north = new Edge(this, Edge.Direction.a);
    public Edge south = new Edge(this, Edge.Direction.b);
    public Edge east = new Edge(this, Edge.Direction.c);
    public Edge west = new Edge(this, Edge.Direction.d);
    public PresentationType type;
    public PresentationType mipReplacedType;
    public SeriesViewInfo seriesInfo;
    public transient Component a;
    protected int gridx = 1;
    protected int gridy = 1;
    protected float gridSpacing = 1.0f;
    protected transient int b;
    protected int monitor = 0;

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        long l2 = Double.doubleToLongBits(this.east.x);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.north.x);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.west.x);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.south.x);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        n3 = 31 * n3 + this.type.ordinal();
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HangingInfo hangingInfo = (HangingInfo)object;
        if (this.east == null ? hangingInfo.east != null : this.east.x != hangingInfo.east.x) {
            return false;
        }
        if (this.north == null ? hangingInfo.north != null : this.north.x != hangingInfo.north.x) {
            return false;
        }
        if (this.type != hangingInfo.type) {
            return false;
        }
        if (this.south == null ? hangingInfo.south != null : this.south.x != hangingInfo.south.x) {
            return false;
        }
        if (this.west == null ? hangingInfo.west != null : this.west.x != hangingInfo.west.x) {
            return false;
        }
        if (this.seriesInfo == null ? hangingInfo.seriesInfo != null : this.seriesInfo.index != hangingInfo.seriesInfo.index) {
            return false;
        }
        return this.gridx == hangingInfo.gridx && this.gridy == hangingInfo.gridy && this.gridSpacing == hangingInfo.gridSpacing;
    }

    public HangingInfo() {
        this.north.a();
        this.south.a();
        this.east.a();
        this.west.a();
        this.type = PresentationType.a;
        this.seriesInfo = null;
        this.a = null;
    }

    public HangingInfo(HangingInfo hangingInfo, SeriesViewInfo seriesViewInfo) {
        this();
        this.a(hangingInfo);
        this.type = hangingInfo.type;
        this.mipReplacedType = hangingInfo.mipReplacedType;
        this.seriesInfo = seriesViewInfo;
        this.a = hangingInfo.a;
        this.gridx = hangingInfo.gridx;
        this.gridy = hangingInfo.gridy;
        this.gridSpacing = hangingInfo.gridSpacing;
        this.monitor = hangingInfo.monitor;
        this.b = hangingInfo.b;
    }

    public HangingInfo(double d2, double d3, double d4, double d5) {
        this();
        this.west.x = d2;
        this.north.x = d3;
        this.east.x = d4;
        this.south.x = d5;
    }

    public void a(ViewPortSignature viewPortSignature) {
        this.gridx = viewPortSignature.gridx;
        this.gridy = viewPortSignature.gridy;
        this.gridSpacing = viewPortSignature.gridSpacing;
        if (viewPortSignature.showColorbar) {
            this.seriesInfo.a(viewPortSignature.type);
        }
        this.monitor = viewPortSignature.monitor;
    }

    public void a(HangingInfo hangingInfo) {
        this.north.x = hangingInfo.north.x;
        this.south.x = hangingInfo.south.x;
        this.east.x = hangingInfo.east.x;
        this.west.x = hangingInfo.west.x;
        this.north.pos = hangingInfo.north.pos;
        this.south.pos = hangingInfo.south.pos;
        this.east.pos = hangingInfo.east.pos;
        this.west.pos = hangingInfo.west.pos;
        this.monitor = hangingInfo.monitor;
    }

    public int a() {
        return this.south.pos - this.north.pos;
    }

    public int b() {
        return this.east.pos - this.west.pos;
    }

    public double c() {
        return (this.south.x - this.north.x) * (this.east.x - this.west.x);
    }

    public Rectangle a(Rectangle rectangle) {
        return this.a(rectangle.getSize());
    }

    public Rectangle a(Dimension dimension) {
        this.west.pos = (int)Math.round(this.west.x * (double)dimension.width);
        this.north.pos = (int)Math.round(this.north.x * (double)dimension.height);
        this.east.pos = (int)Math.round(this.east.x * (double)dimension.width);
        this.south.pos = (int)Math.round(this.south.x * (double)dimension.height);
        return new Rectangle(this.west.pos, this.north.pos, this.east.pos - this.west.pos, this.south.pos - this.north.pos);
    }

    public void b(Rectangle rectangle) {
        this.west.x = (double)this.west.pos / (double)rectangle.width;
        this.east.x = (double)this.east.pos / (double)rectangle.width;
        this.north.x = (double)this.north.pos / (double)rectangle.height;
        this.south.x = (double)this.south.pos / (double)rectangle.height;
    }

    public String toString() {
        String string = Messages.a("General", "LOCATION");
        String string2 = Messages.a("Commands", "GRID_SPACING");
        String string3 = Messages.a("mui", "HANGINGPROTOCOL_MONITOR");
        String string4 = Messages.a("Commands", "GRID_NAME");
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(1);
        StringBuilder stringBuilder = new StringBuilder(255);
        stringBuilder.append(this.type);
        stringBuilder.append("\n");
        stringBuilder.append(string);
        stringBuilder.append(": x:");
        stringBuilder.append(numberFormat.format(this.west.x));
        stringBuilder.append(" y:");
        stringBuilder.append(numberFormat.format(this.north.x));
        stringBuilder.append(" w:");
        stringBuilder.append(numberFormat.format(this.east.x - this.west.x));
        stringBuilder.append(" h:");
        stringBuilder.append(numberFormat.format(this.south.x - this.north.x));
        stringBuilder.append("\n");
        stringBuilder.append(string3);
        stringBuilder.append(": ");
        stringBuilder.append(this.monitor);
        stringBuilder.append("\n");
        stringBuilder.append(string4);
        stringBuilder.append(": ");
        stringBuilder.append(this.gridx);
        stringBuilder.append("x");
        stringBuilder.append(this.gridy);
        stringBuilder.append("\n");
        stringBuilder.append(string2);
        stringBuilder.append(": ");
        stringBuilder.append(this.gridSpacing);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public void b(HangingInfo hangingInfo) {
        this.north.x = hangingInfo.north.x;
        this.south.x = hangingInfo.south.x;
        this.east.x = hangingInfo.east.x;
        this.west.x = hangingInfo.west.x;
    }

    public boolean a(Point2D.Double double_) {
        return Double.compare(this.west.x, double_.x) < 0 && Double.compare(this.east.x, double_.x) > 0 && Double.compare(this.north.x, double_.y) < 0 && Double.compare(this.south.x, double_.y) > 0;
    }

    public ViewPortSignature d() {
        return new ViewPortSignature(this.type, this.type == this.seriesInfo.b(), this.f(), this.g(), this.gridSpacing, this.monitor);
    }

    public void a(int n2, int n3, float f2) {
        this.gridx = n2;
        this.gridy = n3;
        this.gridSpacing = f2;
    }

    public void e() {
        this.gridx = 1;
        this.gridy = 1;
    }

    public int f() {
        if (this.type == PresentationType.h) {
            return 4;
        }
        return this.gridx;
    }

    public int g() {
        if (this.type == PresentationType.h) {
            return 2;
        }
        return this.gridy;
    }

    public float h() {
        return this.gridSpacing;
    }

    public int i() {
        return this.monitor;
    }

    public void a(int n2) {
        this.monitor = n2;
    }

    public void a(PresentationType presentationType) {
        if (this.seriesInfo != null && this.seriesInfo.b() == this.type && presentationType != PresentationType.d) {
            this.seriesInfo.a(presentationType);
        }
        this.type = presentationType;
    }

    public PresentationType j() {
        return this.type;
    }

    public Rectangle2D.Float k() {
        return new Rectangle2D.Float(this.west.pos, this.north.pos, this.east.pos - this.west.pos, this.south.pos - this.north.pos);
    }

    public Rectangle2D.Double l() {
        return new Rectangle2D.Double(this.west.x, this.north.x, this.east.x - this.west.x, this.south.x - this.north.x);
    }

    public void a(Rectangle2D.Float float_) {
        this.west.pos = (int)float_.x;
        this.north.pos = (int)float_.y;
        this.east.pos = (int)(float_.x + float_.width);
        this.south.pos = (int)(float_.y + float_.height);
    }

    public void b(int n2) {
        double d2 = 0.5;
        this.south.x *= d2;
        this.north.x *= d2;
        this.east.x *= d2;
        this.west.x *= d2;
        if (n2 == 1 || n2 == 3) {
            this.east.x += d2;
            this.west.x += d2;
        }
        if (n2 == 2 || n2 == 3) {
            this.north.x += d2;
            this.south.x += d2;
        }
    }

    public void a(double d2) {
        this.north.x += d2;
        this.south.x += d2;
    }

    public void b(double d2) {
        this.north.x *= d2;
        this.south.x *= d2;
    }

    public void c(double d2) {
        this.east.x += d2;
        this.west.x += d2;
    }

    public void d(double d2) {
        this.east.x *= d2;
        this.west.x *= d2;
    }

    public void m() {
        this.b(1.0 / (this.south.x - this.north.x));
    }

    public void n() {
        this.d(1.0 / (this.east.x - this.west.x));
    }

    public static boolean a(HangingInfo hangingInfo, HangingInfo hangingInfo2) {
        return hangingInfo.north.x == hangingInfo2.north.x && hangingInfo.east.x == hangingInfo2.east.x && hangingInfo.south.x == hangingInfo2.south.x && hangingInfo.west.x == hangingInfo2.west.x && hangingInfo.monitor == hangingInfo2.monitor;
    }

    public boolean o() {
        return this.f() != 1 || this.g() != 1;
    }

    public void c(int n2) {
        this.b = n2;
    }

    public int p() {
        return this.b;
    }
}

