/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.layout;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mimvista.internals.VCRef;
import com.mimvista.internals.ViewController;
import com.mimvista.mui.layout.HangingProtocol;
import com.mimvista.mui.layout.SeriesViewInfo;
import com.mimvista.mui.layout.d;
import com.mimvista.util.ay;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SeriesReference
implements Serializable {
    private static final long serialVersionUID = 1L;

    static SeriesReference a(ViewController ... viewControllerArray) {
        return new SessionSeriesRef(viewControllerArray);
    }

    static SeriesReference a(HangingProtocol hangingProtocol, int ... nArray) {
        return new HPSeriesRef(hangingProtocol, nArray);
    }

    public abstract void a(HangingProtocol var1);

    public boolean b(HangingProtocol hangingProtocol) {
        return Iterables.all(this.a(), viewController -> !hangingProtocol.b((ViewController)viewController).isEmpty());
    }

    public abstract List<ViewController> a();

    public abstract List<SeriesViewInfo> c(HangingProtocol var1);

    public abstract boolean a(ViewController var1);

    public abstract boolean a(SeriesViewInfo var1);

    protected abstract SeriesReference d(HangingProtocol var1);

    abstract Collection<Element> a(Document var1, HangingProtocol var2);

    void e(HangingProtocol hangingProtocol) {
        if (!this.b(hangingProtocol)) {
            throw new IllegalStateException("HangingProtocol doesn't fully contain the series reference");
        }
    }

    private static class HPSeriesRef
    extends SeriesReference {
        private static final long serialVersionUID = 1L;
        final ImmutableSet<Integer> referents;
        final HangingProtocol parent;

        HPSeriesRef(HangingProtocol hangingProtocol, Collection<ViewController> collection) {
            this.parent = hangingProtocol;
            this.referents = ImmutableSet.copyOf((Collection)collection.stream().flatMap(viewController -> hangingProtocol.b((ViewController)viewController).stream()).map(seriesViewInfo -> seriesViewInfo.index).collect(Collectors.toList()));
        }

        HPSeriesRef(HangingProtocol hangingProtocol, int ... nArray) {
            this.parent = hangingProtocol;
            this.referents = ImmutableSet.copyOf((Object[])ArrayUtils.toObject((int[])nArray));
        }

        @Override
        protected SeriesReference d(HangingProtocol hangingProtocol) {
            List<ViewController> list = this.f(hangingProtocol);
            if (!list.contains(null)) {
                return new SessionSeriesRef(list.toArray(new ViewController[0]));
            }
            ay.c((Object)"Copy of unresolved custom view series ref onto protocol. HPSeriesRef propagated", this);
            return new HPSeriesRef(hangingProtocol, ArrayUtils.toPrimitive((Integer[])((Integer[])this.referents.toArray((Object[])new Integer[0]))));
        }

        @Override
        public void a(HangingProtocol hangingProtocol) {
            if (hangingProtocol != this.parent) {
                d d2 = new d(hangingProtocol);
                this.a().forEach(d2::b);
            }
        }

        @Override
        public List<ViewController> a() {
            return this.f(this.parent);
        }

        @Override
        public List<SeriesViewInfo> c(HangingProtocol hangingProtocol) {
            if (!hangingProtocol.j().equals(this.parent.j()) || !hangingProtocol.i().equals(this.parent.i())) {
                throw new IllegalArgumentException("Incorrect protocol. Cannot get series view infos");
            }
            if (this.parent != hangingProtocol) {
                ay.c((Object)"Attempting cross-protocol explicit reference lookup. This should be avoided", this);
            }
            ArrayList arrayList = Lists.newArrayList();
            for (Integer n2 : this.referents) {
                arrayList.add(hangingProtocol.h(n2));
            }
            return arrayList;
        }

        private List<ViewController> f(HangingProtocol hangingProtocol) {
            return this.referents.stream().map(hangingProtocol::h).map(SeriesViewInfo::j).collect(Collectors.toList());
        }

        @Override
        Collection<Element> a(Document document, HangingProtocol hangingProtocol) {
            this.e(hangingProtocol);
            if (hangingProtocol == this.parent) {
                ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)this.referents.size());
                UnmodifiableIterator unmodifiableIterator = this.referents.iterator();
                while (unmodifiableIterator.hasNext()) {
                    int n2 = (Integer)unmodifiableIterator.next();
                    Element element = document.createElementNS(null, "seriesReference");
                    element.setTextContent(String.valueOf(n2));
                    arrayList.add(element);
                }
                return arrayList;
            }
            return new HPSeriesRef(hangingProtocol, this.a()).a(document, hangingProtocol);
        }

        @Override
        public boolean a(ViewController viewController) {
            UnmodifiableIterator unmodifiableIterator = this.referents.iterator();
            while (unmodifiableIterator.hasNext()) {
                int n2 = (Integer)unmodifiableIterator.next();
                if (this.parent.h(n2).j() != viewController) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean a(SeriesViewInfo seriesViewInfo) {
            return this.parent.j().contains(seriesViewInfo) && this.referents.contains((Object)seriesViewInfo.index);
        }

        public boolean equals(Object object) {
            if (!(object instanceof HPSeriesRef)) {
                return false;
            }
            HPSeriesRef hPSeriesRef = (HPSeriesRef)object;
            return Objects.equal(this.referents, hPSeriesRef.referents);
        }

        public int hashCode() {
            int n2 = 137;
            int n3 = 1023;
            n3 = n3 * n2 + this.referents.hashCode();
            return n3;
        }
    }

    private static class SessionSeriesRef
    extends SeriesReference {
        private static final long serialVersionUID = 1L;
        final ImmutableSet<VCRef> referents;

        SessionSeriesRef(ViewController ... viewControllerArray) {
            this.referents = ImmutableSet.copyOf((Collection)Arrays.stream(viewControllerArray).map(ViewController::aT).map(VCRef::a).distinct().collect(Collectors.toList()));
        }

        public SessionSeriesRef f(HangingProtocol hangingProtocol) {
            return this;
        }

        @Override
        public void a(HangingProtocol hangingProtocol) {
            for (VCRef vCRef : this.referents) {
                ViewController viewController = vCRef.b();
                new d(hangingProtocol).b(viewController);
            }
        }

        @Override
        public List<ViewController> a() {
            return Collections.unmodifiableList(this.referents.stream().map(VCRef::b).collect(Collectors.toList()));
        }

        @Override
        public List<SeriesViewInfo> c(HangingProtocol hangingProtocol) {
            List<SeriesViewInfo> list = this.referents.stream().map(VCRef::b).map(hangingProtocol::a).filter(arg_0 -> ((Predicate)Predicates.notNull()).apply(arg_0)).collect(Collectors.toList());
            if (list.size() < this.referents.size()) {
                throw new IllegalArgumentException("protocol doesn't fully contain the references. Cannot get SeriesViewInfos.");
            }
            return list;
        }

        @Override
        Collection<Element> a(Document document, HangingProtocol hangingProtocol) {
            this.e(hangingProtocol);
            Collection collection = this.referents.stream().map(VCRef::b).collect(Collectors.toList());
            HPSeriesRef hPSeriesRef = new HPSeriesRef(hangingProtocol, collection);
            return ((SeriesReference)hPSeriesRef).a(document, hangingProtocol);
        }

        @Override
        public boolean a(ViewController viewController) {
            VCRef vCRef = VCRef.a(viewController.aT());
            return this.referents.contains((Object)vCRef);
        }

        @Override
        public boolean a(SeriesViewInfo seriesViewInfo) {
            ViewController viewController = seriesViewInfo.j();
            if (viewController == null) {
                return false;
            }
            VCRef vCRef = VCRef.a(viewController.aT());
            return this.referents.contains((Object)vCRef);
        }

        public boolean equals(Object object) {
            if (!(object instanceof SessionSeriesRef)) {
                return false;
            }
            SessionSeriesRef sessionSeriesRef = (SessionSeriesRef)object;
            return this.a().equals(sessionSeriesRef.a());
        }

        public int hashCode() {
            return this.referents.hashCode();
        }

        @Override
        public /* synthetic */ SeriesReference d(HangingProtocol hangingProtocol) {
            return this.f(hangingProtocol);
        }
    }
}

