/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.layout;

import com.google.common.collect.Lists;
import com.mimvista.mui.GridPresentation;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.am;
import com.mimvista.mui.az;
import com.mimvista.mui.layout.HangingInfo;
import com.mimvista.mui.presenters.ViewPort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ViewPortSignature
implements Serializable {
    private static final long serialVersionUID = 1403448127057658889L;
    public PresentationType type;
    public boolean showColorbar;
    public int gridx = 1;
    public int gridy = 1;
    public float gridSpacing = 1.0f;
    public int monitor = 0;

    public ViewPortSignature(PresentationType presentationType, boolean bl2, int n2, int n3, float f2, int n4) {
        this(presentationType, bl2, n4);
        this.gridx = n2;
        this.gridy = n3;
        this.gridSpacing = f2;
    }

    public ViewPortSignature(PresentationType presentationType, boolean bl2, int n2) {
        this.type = presentationType;
        this.showColorbar = bl2;
        this.monitor = n2;
    }

    public ViewPortSignature(ViewPort viewPort) {
        this.type = viewPort.N().n();
        this.showColorbar = viewPort.I();
        if (viewPort.L() instanceof GridPresentation) {
            this.gridx = ((GridPresentation)viewPort.L()).w();
            this.gridy = ((GridPresentation)viewPort.L()).x();
            this.gridSpacing = ((GridPresentation)viewPort.L()).y();
        }
        this.monitor = am.a(viewPort.h().c());
    }

    public ViewPortSignature(HangingInfo hangingInfo) {
        this.type = hangingInfo.type;
        this.showColorbar = hangingInfo.seriesInfo.b() == hangingInfo.type;
        this.gridx = hangingInfo.gridx;
        this.gridy = hangingInfo.gridy;
        this.gridSpacing = hangingInfo.gridSpacing;
        this.monitor = hangingInfo.monitor;
    }

    public boolean a(ViewPort viewPort) {
        if (viewPort.N().n() != this.type.n() && (viewPort.e() == null || viewPort.e() != this.type)) {
            return false;
        }
        if (this.monitor != am.a(viewPort.h().c())) {
            return false;
        }
        az az2 = viewPort.L();
        if (!(az2 instanceof GridPresentation)) {
            return this.gridx == 1 && this.gridy == 1;
        }
        if (this.gridx == 1 && this.gridy == 1) {
            return false;
        }
        GridPresentation gridPresentation = (GridPresentation)az2;
        return this.gridx == gridPresentation.w() && this.gridy == gridPresentation.x() && this.gridSpacing == gridPresentation.y();
    }

    public boolean a(HangingInfo hangingInfo) {
        if (this.type.n() != hangingInfo.type.n()) {
            return false;
        }
        return this.monitor == hangingInfo.i();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.monitor;
        n3 = 31 * n3 + (this.type == null ? 0 : this.type.n().hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ViewPortSignature viewPortSignature = (ViewPortSignature)object;
        if (this.monitor != viewPortSignature.monitor) {
            return false;
        }
        return this.type.n() == viewPortSignature.type.n();
    }

    public String toString() {
        return "[VPSig: " + this.monitor + " " + this.type + "]";
    }

    public static List<ViewPortSignature> a(boolean bl2, int n2) {
        if (bl2) {
            return Lists.newArrayList((Object[])new ViewPortSignature[]{new ViewPortSignature(PresentationType.g, false, 0), new ViewPortSignature(PresentationType.d, false, 0)});
        }
        ArrayList arrayList = Lists.newArrayList();
        for (PresentationType presentationType : az.J()) {
            ViewPortSignature viewPortSignature = new ViewPortSignature(presentationType, false, n2);
            arrayList.add(viewPortSignature);
        }
        return arrayList;
    }

    public static List<ViewPortSignature> a(Collection<ViewPort> collection) {
        ArrayList arrayList = Lists.newArrayList();
        for (ViewPort viewPort : collection) {
            arrayList.add(new ViewPortSignature(viewPort));
        }
        return arrayList;
    }

    public static List<ViewPortSignature> a(Iterable<HangingInfo> iterable) {
        ArrayList arrayList = Lists.newArrayList();
        for (HangingInfo hangingInfo : iterable) {
            arrayList.add(new ViewPortSignature(hangingInfo));
        }
        return arrayList;
    }
}

