/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.mouse.mode.protocol;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import sun.awt.dnd.SunDragSourceContextPeer;

public class FullMouseDragGestureRecognizer
extends DragGestureRecognizer
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    private static final int a = 3;
    private static final int b = FullMouseDragGestureRecognizer.a();
    private final MouseAdapter madapter;

    private static int a() {
        try {
            return (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
        }
        catch (Exception exception) {
            return 3;
        }
    }

    public FullMouseDragGestureRecognizer(DragSource dragSource) {
        this(dragSource, (MouseAdapter)null);
    }

    public FullMouseDragGestureRecognizer(DragSource dragSource, MouseAdapter mouseAdapter) {
        super(dragSource, null, 0x40000000, null);
        this.madapter = mouseAdapter;
    }

    protected int a(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiersEx();
        return SunDragSourceContextPeer.convertModifiersToDropAction(n2, this.getSourceActions());
    }

    @Override
    public final void mouseClicked(MouseEvent mouseEvent) {
        if (this.madapter != null) {
            this.madapter.mouseClicked(mouseEvent);
        }
    }

    @Override
    public final void mousePressed(MouseEvent mouseEvent) {
        this.resetRecognizer();
        if (this.a(mouseEvent) != 0) {
            this.appendEvent(mouseEvent);
        }
        if (this.madapter != null) {
            this.madapter.mousePressed(mouseEvent);
        }
    }

    @Override
    public final void mouseReleased(MouseEvent mouseEvent) {
        this.resetRecognizer();
        if (this.madapter != null) {
            this.madapter.mouseReleased(mouseEvent);
        }
    }

    @Override
    public final void mouseEntered(MouseEvent mouseEvent) {
        this.resetRecognizer();
        if (this.madapter != null) {
            this.madapter.mouseEntered(mouseEvent);
        }
    }

    @Override
    public final void mouseExited(MouseEvent mouseEvent) {
        if (this.getTriggerEvent() != null && this.a(mouseEvent) == 0) {
            this.resetRecognizer();
        }
        if (this.madapter != null) {
            this.madapter.mouseExited(mouseEvent);
        }
    }

    @Override
    public final void mouseDragged(MouseEvent mouseEvent) {
        InputEvent inputEvent = this.getTriggerEvent();
        if (inputEvent == null) {
            return;
        }
        int n2 = this.a(mouseEvent);
        if (n2 == 0) {
            return;
        }
        MouseEvent mouseEvent2 = (MouseEvent)inputEvent;
        Point point = mouseEvent2.getPoint();
        Point point2 = mouseEvent.getPoint();
        int n3 = Math.abs(point.x - point2.x);
        int n4 = Math.abs(point.y - point2.y);
        if (n3 >= b || n4 >= b) {
            this.fireDragGestureRecognized(n2, mouseEvent2.getPoint());
        } else {
            this.appendEvent(mouseEvent);
        }
    }

    @Override
    public final void mouseMoved(MouseEvent mouseEvent) {
        if (this.madapter != null) {
            this.madapter.mouseMoved(mouseEvent);
        }
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.madapter != null) {
            this.madapter.mouseWheelMoved(mouseWheelEvent);
        }
        if (mouseWheelEvent.isConsumed()) {
            return;
        }
        Component component = this.getComponent();
        while (component != null) {
            JViewport jViewport;
            if (!((component = component.getParent()) instanceof JScrollPane) || (jViewport = ((JScrollPane)component).getViewport()).getViewRect().contains(jViewport.getView().getBounds())) continue;
            component.dispatchEvent(mouseWheelEvent);
            break;
        }
    }

    @Override
    protected void registerListeners() {
        this.getComponent().addMouseListener(this);
        this.getComponent().addMouseMotionListener(this);
        this.getComponent().addMouseWheelListener(this);
    }

    @Override
    protected void unregisterListeners() {
        this.getComponent().removeMouseListener(this);
        this.getComponent().removeMouseMotionListener(this);
        this.getComponent().removeMouseWheelListener(this);
    }
}

