/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.mouse.mode.suv;

import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.workflow.backend.t;
import java.io.Serializable;
import javax.swing.Icon;
import org.apache.commons.math3.util.FastMath;

public class SUVRegion
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final RegionType type;
    private MetricPoint3f center;
    private double radius;

    public SUVRegion(RegionType regionType, MetricPoint3f metricPoint3f, double d2) {
        this.type = regionType;
        this.center = metricPoint3f;
        this.a(d2);
    }

    public SUVRegion(SUVRegion sUVRegion) {
        this.type = sUVRegion.type;
        this.center = sUVRegion.center;
        this.a(sUVRegion.radius);
    }

    public boolean a(MetricPoint3f metricPoint3f) {
        return this.type.a(this.radius, metricPoint3f.x - this.center.x, metricPoint3f.y - this.center.y, metricPoint3f.z - this.center.z);
    }

    public MetricPoint3f a() {
        return this.center;
    }

    public void b(MetricPoint3f metricPoint3f) {
        this.center = metricPoint3f;
    }

    public void a(double d2) {
        this.radius = d2;
    }

    public RegionType b() {
        return this.type;
    }

    public double c() {
        return this.radius;
    }

    public Pair<MetricPoint3f, MetricPoint3f> d() {
        MetricPoint3f metricPoint3f = this.center.a();
        MetricPoint3f metricPoint3f2 = this.center.a();
        metricPoint3f.x = (float)((double)metricPoint3f.x - this.radius);
        metricPoint3f.y = (float)((double)metricPoint3f.y - this.radius);
        metricPoint3f.z = (float)((double)metricPoint3f.z - this.radius);
        metricPoint3f2.x = (float)((double)metricPoint3f2.x + this.radius);
        metricPoint3f2.y = (float)((double)metricPoint3f2.y + this.radius);
        metricPoint3f2.z = (float)((double)metricPoint3f2.z + this.radius);
        return Pair.get(metricPoint3f, metricPoint3f2);
    }

    public float a(MetricPoint3f[] metricPoint3fArray) {
        return this.type.a(metricPoint3fArray);
    }

    public MetricPoint3f b(MetricPoint3f[] metricPoint3fArray) {
        return metricPoint3fArray[0];
    }

    public boolean c(MetricPoint3f[] metricPoint3fArray) {
        return metricPoint3fArray != null && metricPoint3fArray.length == 2;
    }

    public static enum RegionType implements t
    {
        a("SUV_CUBE"){

            @Override
            public double a(double d2) {
                return FastMath.pow((double)d2, (double)0.3333333333333333) * 5.0;
            }

            @Override
            public double b(double d2) {
                return FastMath.pow((double)(d2 / 5.0), (double)3.0);
            }

            @Override
            public boolean a(double d2, double d3, double d4, double d5) {
                return FastMath.abs((double)d3) < d2 && FastMath.abs((double)d4) < d2 && FastMath.abs((double)d5) < d2;
            }

            @Override
            float a(Point3f[] point3fArray) {
                return point3fArray[0].distanceLinf(point3fArray[1]);
            }
        }
        ,
        b("SUV_SPHERE"){

            @Override
            public double a(double d2) {
                return FastMath.pow((double)(0.75 * d2 / Math.PI), (double)0.3333333333333333) * 10.0;
            }

            @Override
            public double b(double d2) {
                return FastMath.pow((double)(d2 / 10.0), (double)3.0) * Math.PI * 4.0 / 3.0;
            }

            @Override
            public boolean a(double d2, double d3, double d4, double d5) {
                return FastMath.sqrt((double)(d3 * d3 + d4 * d4 + d5 * d5)) < d2;
            }

            @Override
            float a(Point3f[] point3fArray) {
                return point3fArray[0].distance(point3fArray[1]);
            }
        };

        private final String key;

        public abstract double a(double var1);

        public abstract double b(double var1);

        abstract float a(Point3f[] var1);

        public abstract boolean a(double var1, double var3, double var5, double var7);

        private RegionType(String string2) {
            this.key = string2;
        }

        @Override
        public String getExternalizedString() {
            return Messages.a("Commands", "FIND_PEAK_" + this.key);
        }

        @Override
        public Icon getIcon(int n2) {
            return null;
        }
    }
}

