/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.overlays;

import com.google.common.collect.Lists;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.brachytherapy.BrachyReportPlanState;
import com.mimvista.brachytherapy.alg.DoseAccumulator;
import com.mimvista.brachytherapy.mui.overlays.RandomSeedsOverlay;
import com.mimvista.brachytherapy.mui.sidepanel.BrachySidePanel;
import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.rtdose.DoseLoader;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dose.constraints.DoseContext;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.ViewStateNew;
import com.mimvista.internals.dose.IsodoseSetting;
import com.mimvista.internals.dose.IsodoseSettingContext;
import com.mimvista.internals.dose.IsodoseSettingData;
import com.mimvista.internals.linking.AffineTransform;
import com.mimvista.internals.linking.AffineTransformImpl;
import com.mimvista.internals.linking.i;
import com.mimvista.internals.linking.l;
import com.mimvista.internals.statistics.IsodoseStatistician;
import com.mimvista.internals.volumes.ImageVolumeDouble;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.license.j;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.az;
import com.mimvista.mui.ba;
import com.mimvista.mui.bc;
import com.mimvista.mui.overlays.DoseSidePanel;
import com.mimvista.mui.overlays.Overlay;
import com.mimvista.mui.overlays.OverlayDirtParams;
import com.mimvista.mui.overlays.OverlayType;
import com.mimvista.mui.overlays.m;
import com.mimvista.mui.overlays.q;
import com.mimvista.mui.presenters.ViewPort;
import com.mimvista.mui.presenters.display.p;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.Polylines;
import com.mimvista.numerics.VoxelIndexPoint3i;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.bk;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.BrachytherapyPrefs;
import com.mimvista.preferencesNew.DosePrefs;
import com.mimvista.state.ReadHelper;
import com.mimvista.state.SessionState;
import com.mimvista.state.VolumeSourceInfo;
import com.mimvista.state.VolumeState;
import com.mimvista.state.i;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.viewer.Interpolator;
import com.mimvista.viewer.ModalitySeriesInfo;
import com.mimvista.viewer.RTDoseSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.workflow.backend.f;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import org.dcm4che2.data.DicomElement;

public class IsodoseOverlay
extends Overlay
implements com.mimvista.commands.workflow.b,
m,
com.mimvista.report.data.b.a,
f {
    private static final long serialVersionUID = 1L;
    public static final String a = "NOTIFIER SHOW RX DOSE WARNING";
    public static final boolean b = true;
    private transient DoseAccumulator d;
    protected transient ImageVolumeShort c;
    private transient ImageVolumeDouble e;
    private transient boolean f;
    private VolumeState serialDoseVol;
    private IsodoseSetting setting;
    private transient c g;
    private DoseContext doseContext;
    private transient IsodoseStatistician h = null;
    private transient q i = new q();

    public static String b(boolean bl2) {
        if (bl2) {
            return Messages.a("Dose", "SETTING_DIALOG_RADIO_PERCENT");
        }
        return DoseValue.doseUnit.name();
    }

    public IsodoseOverlay(ViewController viewController, ImageVolumeShort imageVolumeShort) {
        this(viewController, imageVolumeShort, true);
    }

    public IsodoseOverlay(ViewController viewController, ImageVolumeShort imageVolumeShort, ImageVolumeDouble imageVolumeDouble) {
        this(viewController, imageVolumeShort, true);
        this.e = imageVolumeDouble;
    }

    public IsodoseOverlay(ViewController viewController, ImageVolumeShort imageVolumeShort, boolean bl2) {
        this(viewController, viewController.aw(), imageVolumeShort, bl2);
    }

    public IsodoseOverlay(ViewController viewController, ImageFrame imageFrame, ImageVolumeShort imageVolumeShort, boolean bl2) {
        super(viewController, imageFrame, OverlayType.n);
        this.c = imageVolumeShort;
        if (imageVolumeShort.x() == -1L) {
            ay.c((Object)"Volume should be registered with the session before creating an IsodoseOverlay.", this);
            viewController.g().x().a(imageVolumeShort);
        } else if (imageVolumeShort.w() != viewController.g()) {
            ay.d((Object)"Dose vol should never be registered in a different session.", this);
        }
        this.aD().q().e(this.c, this.ao(), false);
        this.h = new IsodoseStatistician(this);
        this.g = new c();
        this.i = new q();
        if (bl2) {
            this.b();
        }
    }

    public void a(ImageVolumeDouble imageVolumeDouble) {
        this.e = imageVolumeDouble;
    }

    public void a(DoseAccumulator doseAccumulator) {
        this.d = doseAccumulator;
    }

    public void f() {
        Date date = new Date();
        this.c.getUncopiedMutableInfo().c(DateUtils.b(date));
        this.c.getUncopiedMutableInfo().f(DateUtils.e(date));
        this.c.getUncopiedMutableInfo().acqDate = date;
        this.c.getUncopiedMutableInfo().acqTime = date;
    }

    public DoseContext g() {
        return this.doseContext;
    }

    public void a(DoseContext doseContext) {
        if (this.doseContext != doseContext) {
            this.doseContext = doseContext;
            this.setting.f(doseContext != null);
            IsodoseOverlay.b(this);
        }
    }

    public IsodoseStatistician h() {
        return this.h;
    }

    public boolean i() {
        return this.setting != null;
    }

    public void a(IsodoseSetting isodoseSetting) {
        this.setting = isodoseSetting;
    }

    public IsodoseSetting q() {
        return this.a(DoseSidePanel.m());
    }

    public IsodoseSetting a(IsodoseSettingContext isodoseSettingContext) {
        if (this.setting != null) {
            return this.setting;
        }
        this.setting = new IsodoseSetting(IsodoseSetting.a(isodoseSettingContext), this);
        return this.setting;
    }

    public boolean r() {
        boolean bl2;
        DicomElement dicomElement = null;
        ModalitySeriesInfo modalitySeriesInfo = this.C().getUncopiedMutableInfo().modInfo;
        if (modalitySeriesInfo instanceof RTDoseSeriesInfo) {
            dicomElement = ((RTDoseSeriesInfo)modalitySeriesInfo).dvhSequence;
        }
        boolean bl3 = bl2 = dicomElement != null && dicomElement.countItems() > 0;
        if (DoseLoader.isBadAccurayDVH(this.getUncopiedMutableInfo())) {
            bl2 = false;
        }
        return bl2;
    }

    @Override
    protected void a(OverlayDirtParams overlayDirtParams) {
        if (this.h != null && overlayDirtParams.a && overlayDirtParams.b.a(OverlayDirtParams.OverlayChangeGranularity.a)) {
            this.h.c(false);
            if (!overlayDirtParams.c) {
                this.h.i();
            }
        }
        super.a(overlayDirtParams);
        if (overlayDirtParams.j && overlayDirtParams.b != OverlayDirtParams.OverlayChangeGranularity.c) {
            this.w();
        }
        if (overlayDirtParams.a && overlayDirtParams.b != OverlayDirtParams.OverlayChangeGranularity.c) {
            this.i.a();
        }
    }

    @Override
    public void a(SessionState.a a2) {
        super.a(a2);
        if (!a2.c.containsKey(this.c)) {
            VolumeSourceInfo volumeSourceInfo;
            volumeSourceInfo.b((volumeSourceInfo = this.c.D()).c() || !volumeSourceInfo.f() && !this.c.getUncopiedMutableInfo().mimDerivedVolume && this.c.getUncopiedMutableInfo().volumeHasBeenSaved);
            VolumeState volumeState = new VolumeState(this.c, a2);
            a2.c.put(this.c, volumeState);
        }
        this.serialDoseVol = a2.c.get(this.c);
    }

    public VolumeState s() {
        return this.serialDoseVol;
    }

    @Override
    public void a(i.a a2) {
        super.a(a2);
        if (this.serialDoseVol != null) {
            if (a2.a.containsKey(this.serialDoseVol)) {
                this.c = (ImageVolumeShort)a2.a.get(this.serialDoseVol);
            } else {
                this.c = (ImageVolumeShort)this.serialDoseVol.entireVol;
                a2.a.put(this.serialDoseVol, this.c);
                i.a a3 = a2.a();
                a3.d = this.c.n();
                a3.e = this.serialDoseVol.ocState;
                this.c.n().a(a3);
            }
            this.serialDoseVol = null;
        }
        this.h = new IsodoseStatistician(this);
        this.g = new c();
        this.i = new q();
        if (this.setting != null) {
            this.setting.a(a2.b);
            a2.f.put(this, this.setting);
        }
    }

    public ViewController3D t() {
        return (ViewController3D)super.au();
    }

    public void w() {
        for (ViewController viewController : this.aD().af()) {
            if (!this.q().b(viewController)) continue;
            viewController.bD();
        }
    }

    public void x() {
        this.i.a();
    }

    public void d(boolean bl2) {
        OverlayDirtParams.OverlayChangeGranularity overlayChangeGranularity = bl2 ? OverlayDirtParams.OverlayChangeGranularity.a : OverlayDirtParams.OverlayChangeGranularity.b;
        OverlayDirtParams overlayDirtParams = OverlayDirtParams.a(overlayChangeGranularity);
        overlayDirtParams.c = bl2;
        this.b(overlayDirtParams);
        this.aD().Q();
    }

    public void f(boolean bl2) {
        this.f = bl2;
    }

    public boolean z() {
        return this.f;
    }

    @Override
    public DoseValue getRxDose() {
        return ((RTDoseSeriesInfo)this.c.getUncopiedMutableInfo().modInfo).curDose.c();
    }

    public boolean a(DoseValue doseValue) {
        RTDoseSeriesInfo.RxType rxType = ((RTDoseSeriesInfo)this.c.getUncopiedMutableInfo().modInfo).curDose.b();
        return this.a(new RTDoseSeriesInfo.RxDose(doseValue, rxType));
    }

    public boolean a(RTDoseSeriesInfo.RxDose rxDose) {
        RTDoseSeriesInfo rTDoseSeriesInfo = this.G();
        if (rTDoseSeriesInfo == null) {
            ay.d((Object)"Cannot set rx dose, modality info missing.", this);
            return false;
        }
        RTDoseSeriesInfo.RxDose rxDose2 = rTDoseSeriesInfo.curDose;
        if (!rxDose2.equals(rxDose)) {
            rTDoseSeriesInfo.curDose = rxDose;
            IsodoseOverlay.b(this);
            this.g.a();
            this.g.a(rxDose2, rxDose);
            return true;
        }
        return false;
    }

    public void A() {
        RTDoseSeriesInfo rTDoseSeriesInfo = this.G();
        if (rTDoseSeriesInfo == null) {
            ay.d((Object)"Cannot fire for meta dose, modality info missing.", this);
            return;
        }
        RTDoseSeriesInfo.RxDose rxDose = rTDoseSeriesInfo.curDose;
        this.g.a(rxDose, rxDose);
    }

    public void a(a a2) {
        this.g.a(a2);
    }

    public void b(a a2) {
        this.g.b(a2);
    }

    public Matrix4f B() {
        AffineTransform affineTransform = this.aD().q().h(this.t().cw(), this.c);
        return (Matrix4f)affineTransform.d().clone();
    }

    public ImageVolumeShort C() {
        return this.c;
    }

    public void a(b b2) {
        this.g.a(b2);
    }

    public void b(b b2) {
        this.g.b(b2);
    }

    public void b(String string) {
        String string2 = this.q().k();
        this.q().a(string);
        this.g.a(string2, string);
    }

    public String E() {
        return this.q().k();
    }

    @Override
    public MetricPoint3f v() {
        return null;
    }

    @Override
    public boolean a(ViewStateNew viewStateNew, az az2) {
        return az2.U().g();
    }

    @Override
    public boolean a(PresentationType presentationType) {
        return true;
    }

    public RTDoseSeriesInfo G() {
        ModalitySeriesInfo modalitySeriesInfo = this.c.getUncopiedMutableInfo().modInfo;
        if (modalitySeriesInfo instanceof RTDoseSeriesInfo) {
            return (RTDoseSeriesInfo)modalitySeriesInfo;
        }
        return null;
    }

    @Override
    public void a(Graphics2D graphics2D, az az2, ViewStateNew viewStateNew) {
        if (!this.i()) {
            return;
        }
        RTDoseSeriesInfo rTDoseSeriesInfo = this.G();
        if (rTDoseSeriesInfo != null && Float.compare(0.0f, rTDoseSeriesInfo.curDose.c().getValueInGy()) == 0 && this.setting.c()) {
            return;
        }
        if (az2.U() == PresentationType.f || !this.setting.b(az2.n())) {
            return;
        }
        if (az2.U().m()) {
            return;
        }
        Boolean bl2 = this.c(az2);
        if (bl2 == null) {
            return;
        }
        if (this.setting.a(true) == null) {
            ay.c((Object)"No curves in setting during render... aborting.", this);
            return;
        }
        List<IsodoseSettingData.SingleCurveSetting> list = this.setting.b(this);
        bc bc2 = az2.b(viewStateNew, false);
        bk bk2 = ba.a(bc2.g, new Point3f.PointVolumeInfo(this.c));
        Matrix4f matrix4f = this.d(az2);
        if (matrix4f == null) {
            return;
        }
        Matrix4f matrix4f2 = viewStateNew.rotationMatrix;
        Matrix4f matrix4f3 = new Matrix4f();
        matrix4f3.mul(matrix4f, matrix4f2);
        Matrix4f matrix4f4 = (Matrix4f)matrix4f3.clone();
        matrix4f4.invert();
        float f2 = ba.a(bc2, new Point3f.PointVolumeInfo(this.c));
        Interpolator.InterpolationType interpolationType = this.e(az2);
        boolean bl3 = DosePrefs.useBandedColorTable.getValue();
        if (this.setting.f() || this.setting.g()) {
            d d2 = new d();
            d2.a = f2;
            d2.b = matrix4f3;
            d2.c = bk2;
            d2.d = interpolationType;
            d2.i = this.setting.g();
            d2.g = this.setting.f();
            d2.h = list;
            d2.e = this.c;
            d2.f = this.e;
            d2.k = this.setting.e();
            d2.j = bl3;
            e e2 = (e)this.i.a(az2, d2);
            Rectangle rectangle = az2.a(bc2.g);
            int n2 = rectangle.x;
            int n3 = rectangle.y;
            if (this.setting.g()) {
                graphics2D.drawImage((Image)e2.b, n2, n3, null);
            }
            if (this.setting.f()) {
                Object object;
                Dimension dimension = bk2.h();
                Font font = dimension.width < 100 && dimension.height < 100 ? IsodoseSetting.b : IsodoseSetting.c;
                List<q.a> list2 = e2.a;
                Stroke stroke = graphics2D.getStroke();
                Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    Object object3;
                    Object object4;
                    q.a a2 = list2.get(i2);
                    IsodoseSettingData.SingleCurveSetting singleCurveSetting = a2.b;
                    if (singleCurveSetting.hidden || (object = a2.a).isEmpty()) continue;
                    int n4 = 0;
                    int n5 = Integer.MIN_VALUE;
                    Object object5 = object.iterator();
                    while (object5.hasNext()) {
                        object4 = object5.next();
                        int n6 = ((Polylines.Polyline2f)object4).h() + 1;
                        object3 = new int[n6];
                        int[] nArray = new int[n6];
                        for (int i3 = 0; i3 < n6 - 1; ++i3) {
                            object3[i3] = (int)(((Polylines.Polyline2f)object4).a((int)i3).x + (float)n2 + 0.5f);
                            nArray[i3] = (int)(((Polylines.Polyline2f)object4).a((int)i3).y + (float)n3 + 0.5f);
                            if (nArray[i3] <= n5) continue;
                            n4 = object3[i3];
                            n5 = nArray[i3];
                        }
                        object3[n6 - 1] = (int)(((Polylines.Polyline2f)object4).a((int)0).x + (float)n2 + 0.5f);
                        nArray[n6 - 1] = (int)(((Polylines.Polyline2f)object4).a((int)0).y + (float)n3 + 0.5f);
                        graphics2D.setColor(singleCurveSetting.color);
                        graphics2D.setStroke(new BasicStroke(singleCurveSetting.thickness));
                        graphics2D.drawPolyline((int[])object3, nArray, n6);
                        graphics2D.setStroke(stroke);
                    }
                    if (!this.setting.j()) continue;
                    object5 = Lists.newArrayList(this.setting.a(true));
                    Collections.sort(object5, new IsodoseSettingData.a(true));
                    graphics2D.setColor(singleCurveSetting.color);
                    graphics2D.setFont(font);
                    object4 = this.setting.c() ? String.valueOf(((IsodoseSettingData.SingleCurveSetting)object5.get((int)i2)).value) + "%" : String.valueOf(((IsodoseSettingData.SingleCurveSetting)object5.get((int)i2)).value) + DoseValue.doseUnit.name();
                    FontMetrics fontMetrics = MIMSwingUtils.a(graphics2D);
                    object3 = fontMetrics.getStringBounds((String)object4, graphics2D);
                    graphics2D.drawString((String)object4, (int)((double)n4 - ((RectangularShape)object3).getWidth() / 2.0), (int)((double)n5 - ((RectangularShape)object3).getHeight() / 3.0));
                }
                if (this.d != null && this.d.a(BrachytherapyPrefs.doseAccumIndicationThresholdInMs.getValue())) {
                    String string = Messages.a("Dose", "BRACHY_ACCUMULATING_DOSE");
                    int n7 = Math.min(Math.max(rectangle.width, rectangle.height), 1024);
                    int n8 = n7 / 30;
                    object = new Rectangle(rectangle);
                    graphics2D.setColor(Color.BLACK);
                    MIMSwingUtils.a(graphics2D, string, (Rectangle)object, n8);
                    graphics2D.setColor(Color.WHITE);
                    ((Rectangle)object).x += 2;
                    ((Rectangle)object).y += 2;
                    MIMSwingUtils.a(graphics2D, string, (Rectangle)object, n8);
                }
                graphics2D.setStroke(stroke);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
            }
        }
    }

    public boolean a(az az2) {
        if (!this.i() || this.hidden || !this.setting.h()) {
            return false;
        }
        if (!this.setting.f() && !this.setting.g()) {
            return false;
        }
        return this.setting.b(az2.n());
    }

    protected String d() {
        return DoseValue.doseUnit.name();
    }

    public String b(final az az2) {
        ViewPort viewPort;
        if (!this.i() || this.hidden || !this.setting.b(az2.n()) || this.c(az2) == null) {
            return null;
        }
        boolean bl2 = false;
        if (az2.k(false) && az2.aL()) {
            bl2 = true;
        } else {
            viewPort = az2.n().aX();
            if (viewPort != null && az2.am() == viewPort) {
                bl2 = true;
            }
        }
        if (bl2) {
            Object object;
            Object object2;
            viewPort = this.d(az2);
            if (viewPort == null) {
                return "";
            }
            ViewController viewController = az2.n();
            MetricPoint3f metricPoint3f = viewController.bs().c(viewController.bq()).b();
            viewPort.transform(metricPoint3f);
            final VoxelPoint3f voxelPoint3f = new MetricPoint3f((Tuple3f)metricPoint3f, (SimpleImageFrame)this.c).b();
            final boolean[] blArray = new boolean[]{false};
            double d2 = LicenseTransformer.callLicensed(new j<Double>(){

                @Override
                @com.mimvista.license.q(b="Render hi-res point dose", a={LicenseOption.BRACHYTHERAPY})
                public Double call() {
                    try {
                        RandomSeedsOverlay randomSeedsOverlay;
                        BrachyReportPlanState brachyReportPlanState = BrachySidePanel.v(IsodoseOverlay.this.aD());
                        if (brachyReportPlanState.x() == IsodoseOverlay.this && (randomSeedsOverlay = brachyReportPlanState.s()) != null && randomSeedsOverlay.k() != null) {
                            if (IsodoseOverlay.this.e(az2) != Interpolator.InterpolationType.a) {
                                blArray[0] = true;
                                return randomSeedsOverlay.k().a(voxelPoint3f);
                            }
                            blArray[0] = false;
                            return randomSeedsOverlay.k().a(voxelPoint3f.c().k());
                        }
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)("Failed to compute hi-res dose value for point dose: " + IsodoseOverlay.this.B_()), IsodoseOverlay.class);
                    }
                    return Double.NaN;
                }
            }, Double.valueOf(Double.NaN));
            if (Double.isNaN(d2)) {
                if (this.e(az2) != Interpolator.InterpolationType.a) {
                    blArray[0] = true;
                    d2 = this.c.a(voxelPoint3f.x, voxelPoint3f.y, voxelPoint3f.z, this.c.getUncopiedMutableInfo().rescale.removeRaw(0.0f));
                } else {
                    blArray[0] = false;
                    object2 = voxelPoint3f.c().k();
                    object = this.c.a();
                    d2 = ((VoxelIndexPoint3i)((Object)object2)).x >= 0 && ((VoxelIndexPoint3i)((Object)object2)).x < object[0] && ((VoxelIndexPoint3i)((Object)object2)).y >= 0 && ((VoxelIndexPoint3i)((Object)object2)).y < object[1] && ((VoxelIndexPoint3i)((Object)object2)).z >= 0 && ((VoxelIndexPoint3i)((Object)object2)).z < object[2] ? (double)((ImageCube.ImageCubeShort)this.c.ad()).c(((VoxelIndexPoint3i)((Object)object2)).x, ((VoxelIndexPoint3i)((Object)object2)).y, ((VoxelIndexPoint3i)((Object)object2)).z) : (double)this.c.getUncopiedMutableInfo().rescale.removeRaw(0.0f);
                }
            }
            d2 = this.c.getUncopiedMutableInfo().rescale.apply((float)d2);
            object2 = new DoseValue();
            ((DoseValue)object2).setValueInGy((float)d2);
            object = NumberFormatFactory.a().format(((DoseValue)object2).getValueInCurrentUnit()) + this.d();
            if (blArray[0]) {
                object = (String)object + "\n(" + Messages.a("Dose", "ISODOSE_INTERPOLATED_LABEL") + ")";
            }
            return object;
        }
        return null;
    }

    private Matrix4f d(az az2) {
        l l2 = this.aD().q();
        AffineTransform affineTransform = l2.d(az2.aR_(), this.c);
        if (affineTransform == null) {
            ay.c((Object)"Dose trying to draw but has no transform.  Hopefully just caused by early render attempts during sdession restore...", this);
            return null;
        }
        return affineTransform.d();
    }

    public Boolean c(az az2) {
        ViewController viewController;
        boolean bl2 = this.ao() != az2.aR_() && az2.U().g();
        ViewController viewController2 = p.c(az2.n());
        ViewController viewController3 = viewController2 == this.t() ? az2.n() : this.t();
        if (!viewController3.ba().d(this)) {
            return null;
        }
        if (bl2 && (viewController = az2.n()) instanceof ViewController3D && ((ViewController3D)viewController).bl()) {
            ViewController3D viewController3D = (ViewController3D)viewController;
            if (viewController3D.cw().n().b(this.aG())) {
                return bl2;
            }
            for (ImageVolumeShort imageVolumeShort : viewController3D.cE()) {
                if (this.ao() != imageVolumeShort) continue;
                return null;
            }
        }
        return bl2;
    }

    private Interpolator.InterpolationType e(az az2) {
        Interpolator.InterpolationType interpolationType = az2.m().d();
        if (interpolationType != Interpolator.InterpolationType.a) {
            interpolationType = Interpolator.InterpolationType.b;
        }
        return interpolationType;
    }

    public static AffineTransformImpl a(ImageFrame imageFrame, ImageFrame imageFrame2) {
        return com.mimvista.internals.linking.i.a(imageFrame, imageFrame2);
    }

    private boolean a() {
        return DosePrefs.notifierShowRxDoseWarning.getValue();
    }

    private void b() {
        ModalitySeriesInfo modalitySeriesInfo = this.c.getUncopiedMutableInfo().modInfo;
        if (!(modalitySeriesInfo instanceof RTDoseSeriesInfo)) {
            ay.c((Object)"Dose without dose-type modality info...", this);
            return;
        }
        if (((RTDoseSeriesInfo)modalitySeriesInfo).curDose.b() == RTDoseSeriesInfo.RxType.MAX && this.a()) {
            this.f(true);
        }
    }

    @Override
    public String getName() {
        return IsodoseOverlay.a(this.g(false), (ImageFrame)this.C());
    }

    public String g(boolean bl2) {
        String string = this.q().k();
        String string2 = this.q().l();
        String string3 = !cn.h(string) && !string.equals(string2) ? string : (!bl2 && !cn.h(string2) ? string2 : IsodoseOverlay.b(this.C()));
        return string3;
    }

    public static String a(String string, ImageFrame imageFrame) {
        if (!string.isEmpty()) {
            string = string + " - ";
        }
        string = string + imageFrame.getUncopiedMutableInfo().d();
        return string;
    }

    public static String a(ImageFrame imageFrame) {
        return IsodoseOverlay.a(IsodoseOverlay.b(imageFrame), imageFrame);
    }

    public static String b(ImageFrame imageFrame) {
        SeriesInfo seriesInfo = imageFrame.I();
        String string = "";
        if (!cn.h(seriesInfo.seriesDesc)) {
            string = seriesInfo.seriesDesc;
        }
        if (!cn.h(seriesInfo.doseComment)) {
            String string2 = string = string.isEmpty() ? seriesInfo.doseComment : string + " (" + seriesInfo.doseComment + ")";
        }
        if (!cn.h(seriesInfo.studyDesc) && string.isEmpty()) {
            string = seriesInfo.studyDesc;
        }
        return string;
    }

    public String H() {
        return IsodoseOverlay.b(this.setting.c());
    }

    @Override
    public String getNameFromWorkflow() {
        return this.q().l();
    }

    @Override
    public void setNameFromWorkflow(String string) {
        String string2 = this.q().l();
        this.q().b(string);
        this.g.a(string2, string);
    }

    @Override
    public String getDate() {
        return this.C().getUncopiedMutableInfo().c();
    }

    @Override
    public String getModality() {
        return this.C().getUncopiedMutableInfo().modality;
    }

    @Override
    public boolean is2D() {
        return false;
    }

    @Override
    public String getNumberOfImages() {
        List<SliceInfo> list = this.C().at();
        if (list != null) {
            return Integer.toString(list.size());
        }
        return Integer.toString(this.C().a()[2]);
    }

    @Override
    public String getPatientID() {
        return this.C().getUncopiedMutableInfo().patientId;
    }

    @Override
    public String getPatientName() {
        return this.C().getUncopiedMutableInfo().patientName;
    }

    @Override
    public String getSeriesDescription() {
        return this.C().getUncopiedMutableInfo().seriesDesc;
    }

    @Override
    public String getStudyDescription() {
        return this.C().getUncopiedMutableInfo().studyDesc;
    }

    @Override
    public String I() {
        return this.C().getUncopiedMutableInfo().doseComment;
    }

    @Override
    public String getTime() {
        return this.C().getUncopiedMutableInfo().P();
    }

    @Override
    public Date getDateTime() {
        return this.C().getUncopiedMutableInfo().j();
    }

    @Override
    public String getWorkflowDisplayName() {
        return this.setting.l();
    }

    @Override
    public SeriesInfo getUncopiedMutableInfo() {
        return this.c.getUncopiedMutableInfo();
    }

    @Override
    public DicomSeries getDicomSeries() {
        return null;
    }

    public SeriesInfo J() {
        return this.c.I();
    }

    public SearchSource K() {
        if (this.C().q() != null) {
            return this.C().q().b();
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ReadHelper readHelper = new ReadHelper();
        readHelper.a("serialSetting", "setting");
        readHelper.a(objectInputStream, (Object)this);
    }

    @Override
    public /* synthetic */ ViewController au() {
        return this.t();
    }

    public static interface b {
        public void doseNameChanged(String var1, String var2);
    }

    public static interface a {
        public void doseChanged(RTDoseSeriesInfo.RxDose var1, RTDoseSeriesInfo.RxDose var2);
    }

    private class c {
        private transient List<b> b = new CopyOnWriteArrayList<b>();
        private transient List<a> c = new CopyOnWriteArrayList<a>();

        c() {
        }

        protected void a(String string, String string2) {
            for (b b2 : this.b) {
                try {
                    b2.doseNameChanged(string, string2);
                }
                catch (Exception exception) {
                    ay.d((Object)"Error running name changed listener", (Throwable)exception, this.getClass());
                }
            }
        }

        protected void a(RTDoseSeriesInfo.RxDose rxDose, RTDoseSeriesInfo.RxDose rxDose2) {
            for (a a2 : this.c) {
                try {
                    a2.doseChanged(rxDose, rxDose2);
                }
                catch (Exception exception) {
                    ay.d((Object)"Error running Rx changed listener", (Throwable)exception, this);
                }
            }
        }

        public void a(b b2) {
            if (!this.b.contains(b2)) {
                this.b.add(b2);
            }
        }

        public void a(a a2) {
            if (!this.c.contains(a2)) {
                this.c.add(a2);
            }
        }

        public void b(b b2) {
            this.b.remove(b2);
        }

        public void b(a a2) {
            this.c.remove(a2);
        }

        public void a() {
            int n2 = this.b.size();
            int n3 = this.c.size();
            if (n2 > 50) {
                FuncUtils.a(() -> ay.c((Object)("High NC listener count: " + n2), IsodoseOverlay.class), 10000L, "dosenamechangelistenerwarning");
            }
            if (n3 > 50) {
                FuncUtils.a(() -> ay.c((Object)("High DC listener count: " + n2), IsodoseOverlay.class), 10000L, "dosechangelistenerwarning");
            }
        }
    }

    public static class e {
        public List<q.a> a;
        public BufferedImage b = null;
        public int[] c = null;
        public int d = 1;

        public e(e e2) {
            if (e2 != null) {
                this.a = e2.a;
                this.b = e2.b;
                this.c = e2.c;
                this.d = e2.d;
            }
        }
    }

    public static class d {
        public float a;
        public Matrix4f b;
        public bk c;
        public Interpolator.InterpolationType d;
        public transient ImageVolumeShort e;
        public transient ImageVolumeDouble f;
        public boolean g;
        public List<IsodoseSettingData.SingleCurveSetting> h;
        public boolean i;
        public boolean j;
        public int k;
    }
}

