/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.overlays.planreview;

import com.google.common.collect.Lists;
import com.mimvista.dicom.read.DicomRTplanReader;
import com.mimvista.dicom.rtplan.Collimator;
import com.mimvista.dicom.rtplan.DicomBeamRecord;
import com.mimvista.dicom.rtplan.RtplanStateManager;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.internals.EditTargetInfo;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.ViewStateNew;
import com.mimvista.internals.dose.IsodoseSetting;
import com.mimvista.internals.dose.IsodoseSettingContext;
import com.mimvista.internals.dose.IsodoseSettingData;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.Session;
import com.mimvista.mui.az;
import com.mimvista.mui.bm;
import com.mimvista.mui.overlays.Overlay;
import com.mimvista.mui.overlays.OverlayType;
import com.mimvista.mui.overlays.m;
import com.mimvista.mui.overlays.r;
import com.mimvista.mui.presenters.ViewPort;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point2f;
import com.mimvista.numerics.be;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.swing.DelayedActionRunner;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.SwingUtilities;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class CollimatorPercentOpenOverlay
extends Overlay
implements m {
    private static final long serialVersionUID = -7593706351601742215L;
    private final DicomBeamRecord beam;
    private List<ControlSegment> segments;
    protected transient Map<a, BufferedImage> a;
    private transient List<a> d;
    static final int b = 12;
    static final float c = 0.75f;
    private int[] lut;
    private transient DelayedActionRunner e;
    private boolean firstTimeRendering = true;

    public static CollimatorPercentOpenOverlay a(ViewController3D viewController3D, DicomBeamRecord dicomBeamRecord) {
        if (!viewController3D.cz()) {
            ay.d((Object)"Cannot create a collimator percent open overlay on a VC that isn't a DRR.", CollimatorPercentOpenOverlay.class);
            CollimatorPercentOpenOverlay.a(viewController3D.g(), "PR_COLL_PERCENT_OPEN_OVERLAY_NOT_DRR", BasicNotification.NotificationType.a);
            return null;
        }
        if (!dicomBeamRecord.isStandardFluenceShaping()) {
            ay.d((Object)("Skipping collimator percent open overlay generation for beam: " + dicomBeamRecord.getBeamName() + "; its Fluence Mode is defined as something other than \"STANDARD\"."), CollimatorPercentOpenOverlay.class);
            return null;
        }
        float[] fArray = dicomBeamRecord.getCumulativeMetersets();
        for (int i2 = 1; i2 < dicomBeamRecord.getNumberOfControlPoints(); ++i2) {
            if (MathUtils.a(fArray[i2], fArray[i2 - 1], 0.001f) || MathUtils.a(dicomBeamRecord.getCollimatorAngle(i2).getValue(), dicomBeamRecord.getCollimatorAngle(i2 - 1).getValue(), 0.1f)) continue;
            ay.d((Object)"MIM does not currently support collimator percent open overlays for collimators that rotate during irradiation.", CollimatorPercentOpenOverlay.class);
            CollimatorPercentOpenOverlay.a(viewController3D.g(), "PR_COLL_PERCENT_OPEN_OVERLAY_ROTATION_AND_IRRADIATION", BasicNotification.NotificationType.a);
        }
        return new CollimatorPercentOpenOverlay(viewController3D, dicomBeamRecord);
    }

    public static void a(Session session, String string, BasicNotification.NotificationType notificationType) {
        BasicNotification basicNotification = new BasicNotification(notificationType, Messages.a("PlanReview", string), new Notification.a());
        basicNotification.setPriority(100);
        com.mimvista.swing.widgets.u.b().c(basicNotification);
    }

    public static boolean a(DicomBeamRecord dicomBeamRecord) {
        boolean bl2 = false;
        for (Collimator collimator : dicomBeamRecord.getCollimators()) {
            if (collimator.getTimePoints().size() <= 1) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    protected CollimatorPercentOpenOverlay(ViewController3D viewController3D, DicomBeamRecord dicomBeamRecord) {
        super(viewController3D, viewController3D.cw(), OverlayType.A);
        this.beam = dicomBeamRecord;
        this.i();
        this.q();
        this.h();
        this.f();
    }

    private void f() {
        this.e = new DelayedActionRunner(500, () -> this.g());
    }

    private void g() {
        for (a a2 : this.d) {
            a2.k();
            com.mimvista.util.work.m.e.a(() -> {
                BufferedImage bufferedImage = this.a(a2);
                SwingUtilities.invokeLater(() -> {
                    this.a.put(a2, bufferedImage);
                    this.d.remove(a2);
                    Session session = this.aD();
                    if (!a2.j()) {
                        session.c(a2.g()).bD();
                    }
                    RtplanStateManager.getForSession(session).getState(this.beam.getRtplanSOPUID()).fireOverlayChangedListeners(this.beam);
                    session.Q();
                });
            }, "Collimator Percent Open Overlay deferred rendering");
        }
    }

    private void h() {
        this.a = Collections.synchronizedMap(new LinkedHashMap<a, BufferedImage>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<a, BufferedImage> entry) {
                return this.size() > 12;
            }
        });
        this.d = Collections.synchronizedList(Lists.newLinkedList());
    }

    public String a() {
        return this.beam.getRtplanSOPUID();
    }

    public Integer b() {
        return this.beam.getRefBeamNumber();
    }

    private void i() {
        this.segments = new ArrayList<ControlSegment>();
        for (int i2 = 1; i2 < this.beam.getNumberOfControlPoints(); ++i2) {
            this.segments.add(new ControlSegment(this.beam, i2 - 1, i2));
        }
    }

    private void q() {
        IsodoseSettingData isodoseSettingData = new IsodoseSettingData(IsodoseSetting.a(IsodoseSettingContext.a));
        for (IsodoseSettingData.SingleCurveSetting singleCurveSetting : isodoseSettingData.a()) {
            singleCurveSetting.value = singleCurveSetting.value * 32767.0f / 100.0f;
        }
        isodoseSettingData.b(new IsodoseSettingData.SingleCurveSetting(new Color(31, 22, 157), 327.67f, false, 1));
        this.lut = r.c(isodoseSettingData.a(), 128, new RescaleConverter(32767.0f, 0.0f, 1.0f));
    }

    protected BufferedImage a(a a2) {
        com.mimvista.numerics.bm bm2 = a2.a();
        com.mimvista.numerics.bm bm3 = a2.b();
        com.mimvista.numerics.bm bm4 = a2.c();
        com.mimvista.numerics.bm bm5 = a2.d();
        final int n2 = bm5.b.x - bm2.b.x + 1;
        int n3 = bm5.b.y - bm2.b.y + 1;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        final int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        final float[] fArray = new float[nArray.length];
        Matrix4f matrix4f = a2.e();
        final DicomPoint3f dicomPoint3f = bm2.a.a(matrix4f).d();
        final DicomPoint3f dicomPoint3f2 = bm3.a.a(matrix4f).d();
        dicomPoint3f2.sub((Tuple3f)dicomPoint3f);
        dicomPoint3f2.scale(1.0f / (float)(n2 - 1));
        final DicomPoint3f dicomPoint3f3 = bm4.a.a(matrix4f).d();
        dicomPoint3f3.sub((Tuple3f)dicomPoint3f);
        dicomPoint3f3.scale(1.0f / (float)(n3 - 1));
        com.mimvista.util.work.m m2 = com.mimvista.util.work.m.c;
        final float[] fArray2 = new float[m2.getCorePoolSize()];
        FuncUtils.a((ThreadPoolExecutor)m2, n3, new FuncUtils.e(){

            @Override
            public void f(int n22, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                int n5 = n22 * n2;
                float f2 = 0.0f;
                for (int i2 = n22; i2 < n3; ++i2) {
                    DicomPoint3f dicomPoint3f4 = new DicomPoint3f(dicomPoint3f3);
                    dicomPoint3f4.scaleAdd(i2, (Tuple3f)dicomPoint3f);
                    DicomPoint3f dicomPoint3f22 = new DicomPoint3f(dicomPoint3f4);
                    while (n5 < (i2 + 1) * n2) {
                        dicomPoint3f22.add((Tuple3f)dicomPoint3f2);
                        float f3 = 0.0f;
                        for (ControlSegment controlSegment : CollimatorPercentOpenOverlay.this.segments) {
                            f3 += controlSegment.a(dicomPoint3f22);
                        }
                        f2 = Math.max(f3, f2);
                        fArray[n5] = f3;
                        ++n5;
                    }
                }
                fArray2[n4] = f2;
            }
        }, "Collimator Percent Open Overlay Generation");
        float f2 = 0.0f;
        for (float f3 : fArray2) {
            f2 = Math.max(f3, f2);
        }
        final float f4 = f2;
        FuncUtils.a((ThreadPoolExecutor)m2, n3, new FuncUtils.e(){

            @Override
            public void f(int n22, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                for (int i2 = n22 * n2; i2 < n3 * n2; ++i2) {
                    float f2 = fArray[i2] / f4;
                    int n5 = (int)(f2 * 32767.0f);
                    nArray[i2] = CollimatorPercentOpenOverlay.this.lut[n5 - Short.MIN_VALUE];
                }
            }
        }, "Collimator Percent Open Overlay LUT lookup");
        return bufferedImage;
    }

    @Override
    public boolean a(PresentationType presentationType) {
        return presentationType == PresentationType.a;
    }

    @Override
    public void a(Graphics2D graphics2D, az az2, ViewStateNew viewStateNew) {
        Rectangle rectangle = az2.am() != null ? az2.am().getBounds() : az2.X();
        a a2 = new a(viewStateNew, rectangle.width, rectangle.height, az2);
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.a.containsKey(a2)) {
                boolean bl2 = false;
                for (a a3 : this.d) {
                    if (a3.g() != a2.g()) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    this.d.add(a2);
                }
                if (this.firstTimeRendering) {
                    this.firstTimeRendering = false;
                    this.g();
                } else {
                    this.e.b();
                }
            } else {
                Point point = a2.a().b;
                graphics2D.drawImage((Image)this.a.get(a2), point.x, point.y, null);
            }
        } else {
            Point point = a2.a().b;
            graphics2D.drawImage((Image)this.a(a2), point.x, point.y, null);
        }
    }

    @Override
    public boolean a(ViewStateNew viewStateNew, az az2) {
        return this.a != null && viewStateNew != null && this.au().aT().equals((ViewController3D)viewStateNew.f().aT()) && az2.U() == PresentationType.a;
    }

    @Override
    public MetricPoint3f v() {
        return this.au().bc();
    }

    @Override
    public void G_() {
        super.G_();
        this.firstTimeRendering = true;
        this.h();
        this.f();
    }

    public static class ControlSegment
    implements Serializable {
        private static final long serialVersionUID = 1842381766748482428L;
        private final float[] leafBoundaries;
        private final float[] prevPos;
        private final float[] nextPos;
        public final float segmentMeterset;
        private final float[] prevXEdges;
        private final float[] prevYEdges;
        private final float[] nextXEdges;
        private final float[] nextYEdges;
        private final DicomPoint3f isocenter;
        private final Vector3f xBar;
        private final Vector3f yBar;
        private final boolean hasMlc;

        public ControlSegment(DicomBeamRecord dicomBeamRecord, int n2, int n3) {
            Collimator.MultiLeafCollimator multiLeafCollimator = dicomBeamRecord.getFirstMLC();
            boolean bl2 = this.hasMlc = multiLeafCollimator != null;
            if (this.hasMlc) {
                this.leafBoundaries = multiLeafCollimator.getLeafBoundaries();
                this.prevPos = multiLeafCollimator.getTimePointByIndex(n2).getLeafJawPositions();
                this.nextPos = multiLeafCollimator.getTimePointByIndex(n3).getLeafJawPositions();
            } else {
                this.leafBoundaries = null;
                this.prevPos = null;
                this.nextPos = null;
            }
            Vector3f[] vector3fArray = dicomBeamRecord.getCollimatorAxes(n2);
            Collimator.CollimatorTimepoint collimatorTimepoint = dicomBeamRecord.getXJaws().getTimePointByIndex(n2);
            Collimator.CollimatorTimepoint collimatorTimepoint2 = dicomBeamRecord.getYJaws().getTimePointByIndex(n2);
            Collimator.CollimatorTimepoint collimatorTimepoint3 = dicomBeamRecord.getXJaws().getTimePointByIndex(n3);
            Collimator.CollimatorTimepoint collimatorTimepoint4 = dicomBeamRecord.getYJaws().getTimePointByIndex(n3);
            if (!this.hasMlc || multiLeafCollimator.getLeafOrientation() == Collimator.LeafOrientation.X) {
                this.prevXEdges = collimatorTimepoint.getLeafJawPositions();
                this.prevYEdges = collimatorTimepoint2.getLeafJawPositions();
                this.nextXEdges = collimatorTimepoint3.getLeafJawPositions();
                this.nextYEdges = collimatorTimepoint4.getLeafJawPositions();
                this.xBar = vector3fArray[0];
                this.yBar = vector3fArray[1];
            } else {
                this.prevXEdges = collimatorTimepoint2.getLeafJawPositions();
                this.prevYEdges = collimatorTimepoint.getLeafJawPositions();
                this.nextXEdges = collimatorTimepoint4.getLeafJawPositions();
                this.nextYEdges = collimatorTimepoint3.getLeafJawPositions();
                this.xBar = vector3fArray[1];
                this.yBar = vector3fArray[0];
            }
            this.isocenter = dicomBeamRecord.getIsocenter();
            float f2 = dicomBeamRecord.getXJaws().getMetersetAt(n3) - dicomBeamRecord.getXJaws().getMetersetAt(n2);
            if (dicomBeamRecord.getPrimaryDosimeterUnit() == DicomBeamRecord.DosimeterUnit.MINUTE) {
                f2 *= dicomBeamRecord.getDoseRate(n2).getValue();
            }
            this.segmentMeterset = f2;
        }

        public boolean a() {
            return this.segmentMeterset != 0.0f;
        }

        public float a(DicomPoint3f dicomPoint3f) {
            if (!this.a()) {
                return 0.0f;
            }
            Point2f point2f = this.b(dicomPoint3f);
            Pair<Float, Float> pair = Pair.get(Float.valueOf(0.0f), Float.valueOf(1.0f));
            this.a(pair, this.prevXEdges[0], this.nextXEdges[0], this.prevXEdges[1], this.nextXEdges[1], point2f.x);
            this.a(pair, this.prevYEdges[0], this.nextYEdges[0], this.prevYEdges[1], this.nextYEdges[1], point2f.y);
            if (((Float)pair.y).floatValue() == 0.0f && ((Float)pair.x).floatValue() == 0.0f) {
                return 0.0f;
            }
            if (this.hasMlc) {
                int n2 = this.a(point2f.y);
                int n3 = n2 + this.nextPos.length / 2;
                this.a(pair, this.prevPos[n2], this.nextPos[n2], this.prevPos[n3], this.nextPos[n3], point2f.x);
            }
            return (((Float)pair.y).floatValue() - ((Float)pair.x).floatValue()) * this.segmentMeterset;
        }

        private void a(Pair<Float, Float> pair, float f2, float f3, float f4, float f5, float f6) {
            if (((Float)pair.x).floatValue() == 0.0f && ((Float)pair.y).floatValue() == 0.0f) {
                return;
            }
            float f7 = Math.max(f2, f3);
            float f8 = Math.min(f2, f3);
            float f9 = Math.min(f4, f5);
            float f10 = Math.max(f4, f5);
            if (f6 <= f8 || f6 >= f10) {
                pair.x = Float.valueOf(0.0f);
                pair.y = Float.valueOf(0.0f);
                return;
            }
            if (f6 >= f7 && f6 <= f9) {
                return;
            }
            if (f6 < f7 && f6 > f8) {
                if (f2 > f3) {
                    pair.x = Float.valueOf(Math.max(((Float)pair.x).floatValue(), (f6 - f7) / (f8 - f7)));
                } else {
                    pair.y = Float.valueOf(Math.min(((Float)pair.y).floatValue(), (f6 - f8) / (f7 - f8)));
                }
            }
            if (f6 > f9 && f6 < f10) {
                if (f4 > f5) {
                    pair.y = Float.valueOf(Math.min(((Float)pair.y).floatValue(), (f6 - f10) / (f9 - f10)));
                } else {
                    pair.x = Float.valueOf(Math.max(((Float)pair.x).floatValue(), (f6 - f9) / (f10 - f9)));
                }
            }
        }

        private Point2f b(DicomPoint3f dicomPoint3f) {
            Vector3f vector3f = dicomPoint3f.g();
            vector3f.sub((Tuple3f)this.isocenter);
            return new Point2f(vector3f.dot(this.xBar), vector3f.dot(this.yBar));
        }

        private int a(float f2) {
            int n2 = Arrays.binarySearch(this.leafBoundaries, f2);
            if (n2 < 0) {
                n2 = -(n2 + 1);
                --n2;
            }
            return n2;
        }
    }

    protected class a {
        static final long a = Long.MIN_VALUE;
        private Matrix4f c = null;
        private float d = -1.0f;
        private long e = -1L;
        private int f = -1;
        private int g = -1;
        private com.mimvista.numerics.bm h;
        private com.mimvista.numerics.bm i;
        private com.mimvista.numerics.bm j;
        private com.mimvista.numerics.bm k;

        public com.mimvista.numerics.bm a() {
            return this.h;
        }

        public com.mimvista.numerics.bm b() {
            return this.i;
        }

        public com.mimvista.numerics.bm c() {
            return this.j;
        }

        public com.mimvista.numerics.bm d() {
            return this.k;
        }

        public Matrix4f e() {
            return this.c;
        }

        public float f() {
            return this.d;
        }

        public long g() {
            return this.e;
        }

        public int h() {
            return this.g;
        }

        public int i() {
            return this.f;
        }

        public String toString() {
            return "[panelHeight: " + this.g + " panelWidth: " + this.f + " zoom: " + this.d + " ID: " + this.e + "]";
        }

        public boolean j() {
            return this.e == Long.MIN_VALUE;
        }

        public a(ViewStateNew viewStateNew, int n2, int n3, az az2) {
            EditTargetInfo editTargetInfo = new EditTargetInfo(-1, PresentationType.a);
            editTargetInfo.imageNum = viewStateNew.currentFrame;
            this.e = bm.b().af().contains(viewStateNew.f()) ? viewStateNew.seriesId : Long.MIN_VALUE;
            this.c = viewStateNew.ap_();
            this.d = viewStateNew.a(editTargetInfo);
            this.f = n2;
            this.g = n3;
            this.a(viewStateNew, az2);
        }

        public void k() {
            if (this.j()) {
                return;
            }
            ViewStateNew viewStateNew = bm.b().c(this.e).ap();
            Optional<ViewPort> optional = viewStateNew.g().ab().stream().flatMap(protocolPage -> protocolPage.u().stream()).filter(viewPort -> viewPort.M() == viewStateNew.f() && viewPort.N() == PresentationType.a).findFirst();
            if (!optional.isPresent()) {
                return;
            }
            az az2 = optional.get().L();
            EditTargetInfo editTargetInfo = new EditTargetInfo(-1, PresentationType.a);
            editTargetInfo.imageNum = viewStateNew.currentFrame;
            this.c = viewStateNew.ap_();
            this.d = viewStateNew.a(editTargetInfo);
            this.a(viewStateNew, az2);
        }

        private void a(ViewStateNew viewStateNew, az az2) {
            DicomPoint3f[] dicomPoint3fArray = CollimatorPercentOpenOverlay.this.beam.getCollimatorCorners();
            MetricPoint3f[] metricPoint3fArray = new MetricPoint3f[dicomPoint3fArray.length];
            for (int i2 = 0; i2 < metricPoint3fArray.length; ++i2) {
                metricPoint3fArray[i2] = dicomPoint3fArray[i2].b(viewStateNew.aw());
            }
            DicomRTplanReader.projectPointsOntoIsocentricPlane(metricPoint3fArray, CollimatorPercentOpenOverlay.this.beam);
            Point point = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
            Point point2 = new Point(0, 0);
            for (MetricPoint3f metricPoint3f : metricPoint3fArray) {
                be be2 = az2.a(metricPoint3f.b(), viewStateNew);
                point.x = Math.min(point.x, be2.a);
                point.y = Math.min(point.y, be2.b);
                point2.x = Math.max(point2.x, be2.a);
                point2.y = Math.max(point2.y, be2.b);
            }
            this.h = new com.mimvista.numerics.bm(point, az2);
            this.i = new com.mimvista.numerics.bm(new Point(point2.x, point.y), az2);
            this.j = new com.mimvista.numerics.bm(new Point(point.x, point2.y), az2);
            this.k = new com.mimvista.numerics.bm(point2, az2);
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.g;
            n3 = 31 * n3 + this.f;
            n3 = 31 * n3 + (this.c == null ? 0 : this.c.hashCode());
            n3 = 31 * n3 + (int)(this.e ^ this.e >>> 32);
            n3 = 31 * n3 + Float.floatToIntBits(this.d);
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            a a2 = (a)object;
            if (this.g != a2.g) {
                return false;
            }
            if (this.f != a2.f) {
                return false;
            }
            if (this.c == null ? a2.c != null : !this.c.equals(a2.c)) {
                return false;
            }
            if (this.e != a2.e) {
                return false;
            }
            return Float.floatToIntBits(this.d) == Float.floatToIntBits(a2.d);
        }
    }
}

