/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.overlays.planreview;

import com.google.common.collect.Lists;
import com.mimvista.dicom.read.DicomRTplanReader;
import com.mimvista.dicom.rtplan.DicomBeamRecord;
import com.mimvista.dicom.rtplan.RtplanSessionState;
import com.mimvista.dicom.rtplan.RtplanStateManager;
import com.mimvista.internals.CollimatorState;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewStateNew;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.az;
import com.mimvista.mui.mouse.mode.s;
import com.mimvista.mui.overlays.AbstractPointBasedOverlay;
import com.mimvista.mui.overlays.MoveableOverlayish;
import com.mimvista.mui.overlays.OverlayType;
import com.mimvista.mui.overlays.findings.FindingsOverlayish;
import com.mimvista.mui.overlays.findings.c;
import com.mimvista.mui.overlays.m;
import com.mimvista.mui.overlays.remote.RemoteOverlay;
import com.mimvista.mui.overlays.remote.RemoteRTBeamsEyeViewCollimatorOverlay;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.be;
import com.mimvista.numerics.contourtools.a.a;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Tuple3f;

public class RTBeamsEyeViewCollimatorOverlay
extends AbstractPointBasedOverlay<RemoteRTBeamsEyeViewCollimatorOverlay, FindingsOverlayish>
implements MoveableOverlayish,
m {
    private static final long serialVersionUID = 1L;
    private String rtPlanSOP;
    protected transient RtplanSessionState.BeamDataListener a;
    private DicomBeamRecord beam;

    public RTBeamsEyeViewCollimatorOverlay(ViewController viewController, PresentationType presentationType, DicomBeamRecord dicomBeamRecord) {
        super(viewController, viewController.aw(), presentationType, OverlayType.r, 4);
        this.plane = presentationType;
        this.rtPlanSOP = dicomBeamRecord.getRtplanSOPUID();
        this.beam = dicomBeamRecord;
        this.p(false);
        this.o(false);
        this.z();
        this.C();
    }

    public void g() {
        this.au().bz();
    }

    @Override
    public void a(MetricPoint3f[] metricPoint3fArray, boolean bl2) {
        MetricPoint3f[] metricPoint3fArray2 = (MetricPoint3f[])metricPoint3fArray.clone();
        if (!Arrays.equals((Object[])this.points, (Object[])metricPoint3fArray2)) {
            this.points = metricPoint3fArray2;
            RTBeamsEyeViewCollimatorOverlay.b(this);
        }
    }

    @Override
    public boolean ay_() {
        return true;
    }

    @Override
    public boolean a(PresentationType presentationType) {
        return presentationType == this.plane;
    }

    @Override
    public void a(Graphics2D graphics2D, az az2, ViewStateNew viewStateNew) {
        this.a(graphics2D, az2, viewStateNew, this);
    }

    @Override
    public boolean p() {
        return false;
    }

    @Override
    public RemoteOverlay a(ViewController viewController, ImageFrame imageFrame) {
        return new RemoteRTBeamsEyeViewCollimatorOverlay(viewController, imageFrame, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(Graphics2D graphics2D, az az2, ViewStateNew viewStateNew, MoveableOverlayish moveableOverlayish) {
        MetricPoint3f[] metricPoint3fArray = moveableOverlayish.t();
        Graphics2D graphics2D2 = null;
        try {
            graphics2D2 = (Graphics2D)graphics2D.create();
            if (!viewStateNew.a()) {
                graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            graphics2D2.setStroke(new BasicStroke(6.0f));
            graphics2D2.setColor(Color.BLACK);
            this.a(graphics2D2, az2, viewStateNew, metricPoint3fArray);
            graphics2D2.setStroke(new BasicStroke(3.0f));
            graphics2D2.setColor(this.bn_());
            this.a(graphics2D2, az2, viewStateNew, metricPoint3fArray);
        }
        finally {
            if (graphics2D2 != null) {
                graphics2D2.dispose();
            }
        }
    }

    private void a(Graphics2D graphics2D, az az2, ViewStateNew viewStateNew, MetricPoint3f[] metricPoint3fArray) {
        for (int i2 = 0; i2 < metricPoint3fArray.length; ++i2) {
            be be2 = az2.a(metricPoint3fArray[i2 % metricPoint3fArray.length].b(), viewStateNew);
            be be3 = az2.a(metricPoint3fArray[(i2 + 1) % metricPoint3fArray.length].b(), viewStateNew);
            graphics2D.drawLine(be2.a, be2.b, be3.a, be3.b);
        }
    }

    @Override
    public MetricPoint3f v() {
        MetricPoint3f metricPoint3f = this.points[0].a();
        for (int i2 = 1; i2 < this.points.length; ++i2) {
            metricPoint3f.add((Tuple3f)this.points[i2]);
        }
        metricPoint3f.scale(1.0f / (float)this.points.length);
        return metricPoint3f;
    }

    @Override
    public MetricPoint3f[] t() {
        return this.points;
    }

    @Override
    public String Q() {
        return "type: RT collimator";
    }

    @Override
    public boolean x() {
        return false;
    }

    @Override
    public boolean w() {
        return true;
    }

    @Override
    protected List<? extends c> f() {
        return Collections.emptyList();
    }

    @Override
    public List<Shape> b(ViewStateNew viewStateNew, az az2) {
        return this.b(viewStateNew, az2, this.t());
    }

    @Override
    public List<Shape> b(ViewStateNew viewStateNew, az az2, MetricPoint3f[] metricPoint3fArray) {
        if (this.a_(viewStateNew, az2, metricPoint3fArray) && metricPoint3fArray[0] != null && metricPoint3fArray[1] != null) {
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)metricPoint3fArray.length);
            for (int i2 = 0; i2 < metricPoint3fArray.length; ++i2) {
                be be2 = az2.a(metricPoint3fArray[i2 % metricPoint3fArray.length].a(viewStateNew.i()), viewStateNew);
                be be3 = az2.a(metricPoint3fArray[(i2 + 1) % metricPoint3fArray.length].a(viewStateNew.i()), viewStateNew);
                arrayList.add(new Line2D.Float(be2.a, be2.b, be3.a, be3.b));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    @Override
    public Class<? extends s> ba_() {
        return null;
    }

    public DicomBeamRecord h() {
        return this.beam;
    }

    private void C() {
        this.a = new RtplanSessionState.BeamDataListener(){

            @Override
            public void actionPerformed(RtplanSessionState.BeamDataEvent beamDataEvent) {
                if (beamDataEvent.getBeam().equals(RTBeamsEyeViewCollimatorOverlay.this.beam)) {
                    RTBeamsEyeViewCollimatorOverlay.this.z();
                    RTBeamsEyeViewCollimatorOverlay.this.au().bz();
                    RTBeamsEyeViewCollimatorOverlay.this.aD().Q();
                }
            }
        };
        RtplanStateManager.getForSession(this.aD()).getState(this.rtPlanSOP).addDataChangedListener(this.a);
    }

    @Override
    public void G_() {
        if (this.beam == null) {
            RtplanSessionState rtplanSessionState = RtplanStateManager.getForSession(this.aD()).getStateByDRR(this.au());
            this.beam = (DicomBeamRecord)rtplanSessionState.getBeam(this.au());
            this.rtPlanSOP = rtplanSessionState.getSop();
        }
        this.C();
        this.z();
    }

    protected void z() {
        CollimatorState collimatorState = RtplanStateManager.getForSession(this.aD()).getState(this.rtPlanSOP).getCollimatorState(this.beam);
        DicomPoint3f[] dicomPoint3fArray = this.beam.getCollimatorCorners(collimatorState.l());
        MetricPoint3f[] metricPoint3fArray = new MetricPoint3f[4];
        Point3f.PointVolumeInfo pointVolumeInfo = new Point3f.PointVolumeInfo(this.ao());
        for (int i2 = 0; i2 < 4; ++i2) {
            metricPoint3fArray[i2] = dicomPoint3fArray[i2].b(pointVolumeInfo);
        }
        DicomRTplanReader.projectPointsOntoIsocentricPlane(metricPoint3fArray, this.beam);
        this.a(metricPoint3fArray, false);
    }

    @Override
    public void H_() {
        if (this.t().length > 0) {
            this.v = com.mimvista.numerics.contourtools.a.a.a(this.t());
        }
    }
}

