/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.presenters.companion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.mimvista.MimJsonSerializable;
import com.mimvista.file.PathUtils;
import com.mimvista.imports.ImportContainer;
import com.mimvista.imports.b;
import com.mimvista.internals.ViewController;
import com.mimvista.mui.info.CornerInfoItem;
import com.mimvista.mui.overlays.LabelDrawer;
import com.mimvista.preferences.PrefParsers;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.preferencesNew.cascade.c;
import com.mimvista.preferencesNew.e;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.workflow.backend.Target;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@MimJsonSerializable
public class CustomCornerLayout
implements ImportContainer.a,
Serializable {
    public static final String layoutFileEnding = ".cljson";
    private static final long serialVersionUID = 3763953050868190097L;
    private EnumMap<LabelDrawer.LabelPosition, List<CornerInfoItem>> customLocations;
    private String sourceFile;
    @JsonIgnore
    private transient File actualFile = null;

    public CustomCornerLayout() {
        this(new EnumMap<LabelDrawer.LabelPosition, List<CornerInfoItem>>(LabelDrawer.LabelPosition.class));
    }

    public CustomCornerLayout(EnumMap<LabelDrawer.LabelPosition, List<CornerInfoItem>> enumMap) {
        this.customLocations = enumMap;
    }

    public Map<LabelDrawer.LabelPosition, List<CornerInfoItem>> getCustomLocations() {
        return this.customLocations;
    }

    public static CustomCornerLayout createCustomCornerLayoutDialogue(Component component) {
        Messages messages = Messages.a("GeneralPreferencesCollectionFactory");
        List<String> list = CustomCornerLayout.getImportedLayouts();
        if (list.isEmpty()) {
            return new CustomCornerLayout();
        }
        String string = (String)JOptionPane.showInputDialog(component, messages.getProperty("GENERALPREF_CUSTOM_SOURCE_FILE"), messages.getProperty("GENERALPREF_CUSTOM_SOURCE_FILE"), 3, null, list.toArray(), list.get(0));
        CustomCornerLayout customCornerLayout = CustomCornerLayout.createFromFile(string);
        if (customCornerLayout != null) {
            return customCornerLayout;
        }
        return new CustomCornerLayout();
    }

    public static CustomCornerLayout createFromFile(String string) {
        if (string == null) {
            return null;
        }
        File file = CustomCornerLayout.getFile(string);
        CustomCornerLayout customCornerLayout = null;
        if (file != null && file.exists()) {
            try {
                customCornerLayout = (CustomCornerLayout)PrefParsers.a().readValue(file, CustomCornerLayout.class);
            }
            catch (IOException iOException) {
                ay.d((Object)"Could not read customcornerLayout from file", (Throwable)iOException, "CustomCornerLayout");
            }
        }
        if (customCornerLayout == null) {
            customCornerLayout = new CustomCornerLayout();
        }
        customCornerLayout.setSourceFile(CustomCornerLayout.getWithCustomCornerLayoutEnding(string));
        return customCornerLayout;
    }

    public static CustomCornerLayout createFromAbsolutePath(String string) {
        File file = new File(string);
        if (file.exists()) {
            try {
                CustomCornerLayout customCornerLayout = (CustomCornerLayout)PrefParsers.a().readValue(file, CustomCornerLayout.class);
                customCornerLayout.setSourceFile(file.getName());
                customCornerLayout.a(file);
                return customCornerLayout;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public void saveToFile(String string) {
        File file = new File(b.m(), CustomCornerLayout.getWithCustomCornerLayoutEnding(string));
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            PrefParsers.a().writeValue(file, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void a(File file) {
        this.actualFile = file;
    }

    @Override
    public String getFilename() {
        return this.sourceFile;
    }

    public void setSourceFile(String string) {
        this.sourceFile = PathUtils.changeFileExtension(string, null);
    }

    public static File getFile(String string) {
        if (cn.h(string)) {
            return null;
        }
        string = CustomCornerLayout.getWithCustomCornerLayoutEnding(string);
        return c.d().a(CascadeSubfolder.g, string);
    }

    public static String getWithCustomCornerLayoutEnding(String string) {
        if (!string.endsWith(layoutFileEnding)) {
            string = string + layoutFileEnding;
        }
        return string;
    }

    public static List<String> getImportedLayouts() {
        ArrayList arrayList = Lists.newArrayList();
        for (ImportContainer importContainer : b.a(CascadeSubfolder.g, Arrays.asList(ImportContainer.ImportType.h)).a()) {
            arrayList.add(importContainer.f().getName());
        }
        return arrayList;
    }

    private File a() {
        if (this.actualFile == null) {
            return CustomCornerLayout.getFile(this.sourceFile);
        }
        return this.actualFile;
    }

    @Override
    public String getName() {
        return this.sourceFile;
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public String getPath() {
        return CustomCornerLayout.getWithCustomCornerLayoutEnding(this.sourceFile);
    }

    @Override
    public long getFileLastModifiedTime() {
        File file = this.a();
        if (file != null && file.exists()) {
            return file.lastModified();
        }
        return Long.MIN_VALUE;
    }

    @Override
    public ImportContainer.ImportType getImportType() {
        return ImportContainer.ImportType.h;
    }

    @Override
    public Iterable<Target> getTargets() {
        ArrayList<Target> arrayList = new ArrayList<Target>();
        return arrayList;
    }

    public void SetDefaultColor(Color color) {
        for (List<CornerInfoItem> list : this.customLocations.values()) {
            for (CornerInfoItem cornerInfoItem : list) {
                cornerInfoItem.setDefaultColor(color);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @MimJsonSerializable
    public static class a
    implements e {
        private String id;
        private String modality;
        private String source;
        @JsonIgnore
        private CustomCornerLayout cachedlayout;

        @JsonCreator
        public a(@JsonProperty(value="id") String string, @JsonProperty(value="source") String string2, @JsonProperty(value="modality") String string3) {
            this.id = string;
            this.modality = string3;
            this.source = string2;
        }

        public CustomCornerLayout getLayout() {
            if (this.cachedlayout == null) {
                this.cachedlayout = CustomCornerLayout.createFromFile(this.source);
            }
            return this.cachedlayout;
        }

        public String getModality() {
            return this.modality;
        }

        @Override
        @JsonGetter(value="id")
        public String getUniqueId() {
            return this.id;
        }

        public boolean matches(ViewController viewController) {
            return viewController.getModality().equalsIgnoreCase(this.modality);
        }
    }
}

