/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.presenters.planreview;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.commands.keyboard.QuickMaximizeCommand;
import com.mimvista.dicom.rtplan.FloatQuantity;
import com.mimvista.dicom.rtplan.ReportableRtplanState;
import com.mimvista.dicom.rtplan.RtplanSessionState;
import com.mimvista.dicom.rtplan.RtplanStateManager;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.internals.CollimatorState;
import com.mimvista.internals.ViewController;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.Session;
import com.mimvista.mui.az;
import com.mimvista.mui.layout.CustomView;
import com.mimvista.mui.layout.g;
import com.mimvista.mui.mouse.mode.an;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.Overlay;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.mui.overlays.OverlayDirtParams;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.y;
import com.mimvista.mui.presenters.ProtocolPage;
import com.mimvista.mui.presenters.ViewPortUtilities;
import com.mimvista.mui.presenters.companion.a;
import com.mimvista.mui.presenters.companion.f;
import com.mimvista.mui.presenters.planreview.AbstractPlanReviewCustomViewPanel;
import com.mimvista.mui.presenters.roomview.BeamSummaryTableModel;
import com.mimvista.numerics.MathUtils;
import com.mimvista.swing.DelayedActionRunner;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class PlanReviewMultiDRRView
extends AbstractPlanReviewCustomViewPanel {
    static final Messages a = Messages.a("mui");
    private JPanel drrGrid;
    private String rtplanSOP;
    private Session session;
    private RtplanSessionState.BeamVisibilityListener bvl;
    private RtplanSessionState.BeamSelectedListener bsl;
    private RtplanSessionState.FinishingTouchListener ftl;
    private Map<ReportableRtplanState.BeamRecord, DRRView> displayedBeams = Maps.newHashMap();
    private y ol;
    private Dimension previousViewportSize;

    public PlanReviewMultiDRRView(CustomView customView, Session session, String string) {
        super(session, customView, new BorderLayout(), string);
        this.session = session;
        List<RtplanSessionState> list = RtplanStateManager.getForSession(session).getValidatedStatesByPlanningVolume(string);
        this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        if (list.size() > 0) {
            this.rtplanSOP = list.get(0).getSop();
        } else {
            list = RtplanStateManager.getForSession(session).getValidatedRtplanStates();
            this.rtplanSOP = list.get(0).getSop();
        }
        this.drrGrid = new JPanel(new GridLayout()){

            @Override
            public void doLayout() {
                if (this.getHeight() != 0 && this.getWidth() != 0 && (((PlanReviewMultiDRRView)PlanReviewMultiDRRView.this).previousViewportSize.height != this.getHeight() || ((PlanReviewMultiDRRView)PlanReviewMultiDRRView.this).previousViewportSize.width != this.getWidth())) {
                    PlanReviewMultiDRRView.this.f();
                    PlanReviewMultiDRRView.this.previousViewportSize = this.getSize();
                }
                super.doLayout();
            }
        };
        this.add((Component)this.drrGrid, "Center");
        this.g();
        this.validate();
        this.repaint();
        this.bvl = beamVisibilityEvent -> this.e();
        this.bsl = beamSelectedEvent -> this.e();
        this.ftl = new RtplanSessionState.FinishingTouchListener(){

            @Override
            public void actionPerformed(RtplanSessionState.FinishingTouchEvent finishingTouchEvent) {
                RtplanSessionState.BeamDataEvent beamDataEvent = finishingTouchEvent.getDataEvent();
                if (beamDataEvent != null) {
                    PlanReviewMultiDRRView.this.a(beamDataEvent.getBeam());
                }
            }
        };
        this.ol = new y(){

            @Override
            public void overlayDataChanged(Overlayish overlayish, OverlayDirtParams.OverlayChangeGranularity overlayChangeGranularity) {
                if (overlayChangeGranularity == OverlayDirtParams.OverlayChangeGranularity.c) {
                    this.overlayMetadataChanged(overlayish);
                }
            }

            @Override
            public void overlayMetadataChanged(Overlayish overlayish) {
                PlanReviewMultiDRRView.this.d();
            }
        };
        for (RtplanSessionState rtplanSessionState : list) {
            rtplanSessionState.addVisiblityChangedListener(this.bvl);
            rtplanSessionState.addSelectionChangedListener(this.bsl);
            rtplanSessionState.addFinishingTouchListener(this.ftl);
            OverlayCollection overlayCollection = rtplanSessionState.getPlanningVolumeAsImageFrame().n();
            overlayCollection.a(new OverlayCollection.c<PlanReviewMultiDRRView>(this, overlayCollection){

                protected void a(Overlayish overlayish, PlanReviewMultiDRRView planReviewMultiDRRView) {
                    if (overlayish.u() || overlayish instanceof IsodoseOverlay) {
                        overlayish.b(PlanReviewMultiDRRView.this.ol);
                    }
                    PlanReviewMultiDRRView.this.d();
                }

                protected void b(Overlayish overlayish, PlanReviewMultiDRRView planReviewMultiDRRView) {
                    PlanReviewMultiDRRView.this.d();
                }

                protected void a(ArrayList<Overlay> arrayList, PlanReviewMultiDRRView planReviewMultiDRRView) {
                    PlanReviewMultiDRRView.this.d();
                }

                protected void c(Overlayish overlayish, PlanReviewMultiDRRView planReviewMultiDRRView) {
                    PlanReviewMultiDRRView.this.d();
                }

                @Override
                protected /* synthetic */ void currentContourChangedI(Overlayish overlayish, Object object) {
                    this.c(overlayish, (PlanReviewMultiDRRView)object);
                }

                @Override
                protected /* synthetic */ void overlaysRemovedI(ArrayList arrayList, Object object) {
                    this.a(arrayList, (PlanReviewMultiDRRView)object);
                }

                @Override
                protected /* synthetic */ void overlayRemovedI(Overlayish overlayish, Object object) {
                    this.b(overlayish, (PlanReviewMultiDRRView)object);
                }

                @Override
                protected /* synthetic */ void overlayAddedI(Overlayish overlayish, Object object) {
                    this.a(overlayish, (PlanReviewMultiDRRView)object);
                }
            });
            for (Overlayish overlayish : overlayCollection.f()) {
                if (!overlayish.u() && !(overlayish instanceof IsodoseOverlay)) continue;
                overlayish.b(this.ol);
            }
        }
        this.previousViewportSize = this.getSize();
    }

    public String c() {
        return new String(this.rtplanSOP);
    }

    private void f() {
        int n2;
        GridLayout gridLayout;
        Rectangle rectangle = this.drrGrid.getBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        boolean bl2 = rectangle.width >= rectangle.height;
        int n3 = Math.min(rectangle.width, rectangle.height);
        int n4 = Math.max(rectangle.width, rectangle.height);
        int n5 = this.h().size();
        int n6 = (int)Math.round(Math.sqrt((double)n5 * (double)n3 / (double)n4));
        if (n6 == 0) {
            n6 = 1;
        }
        boolean bl3 = (gridLayout = (GridLayout)this.drrGrid.getLayout()).getRows() != 0;
        int n7 = n2 = bl3 ? gridLayout.getRows() : gridLayout.getColumns();
        if (n2 != n6 || bl3 != bl2) {
            GridLayout gridLayout2 = new GridLayout();
            if (bl2) {
                gridLayout2.setRows(n6);
                gridLayout2.setColumns(0);
            } else {
                gridLayout2.setColumns(n6);
                gridLayout2.setRows(0);
            }
            this.drrGrid.setLayout(gridLayout2);
        }
    }

    public void d() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!PlanReviewMultiDRRView.this.isVisible()) {
                    return;
                }
                PlanReviewMultiDRRView.this.g();
                PlanReviewMultiDRRView.this.validate();
                PlanReviewMultiDRRView.this.repaint();
            }
        });
    }

    public void e() {
        List<ReportableRtplanState.BeamRecord> list = this.h();
        if (list.size() == this.displayedBeams.size() && this.displayedBeams.keySet().containsAll(list)) {
            this.repaint();
        } else {
            this.f();
            this.d();
        }
    }

    private void g() {
        if (this.rtplanSOP == null) {
            return;
        }
        List<ReportableRtplanState.BeamRecord> list = this.h();
        this.displayedBeams.clear();
        this.drrGrid.removeAll();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ReportableRtplanState.BeamRecord beamRecord = list.get(i2);
            CollimatorState collimatorState = RtplanStateManager.getForSession(this.session).getState(this.rtplanSOP).getCollimatorState(beamRecord);
            DRRView dRRView = new DRRView(i2, collimatorState);
            this.drrGrid.add(dRRView);
            this.displayedBeams.put(beamRecord, dRRView);
        }
    }

    private void a(ReportableRtplanState.BeamRecord beamRecord) {
        DRRView dRRView = this.displayedBeams.get(beamRecord);
        if (dRRView == null) {
            return;
        }
        dRRView.a();
        dRRView.a(false);
        dRRView.repaint();
        dRRView.b();
    }

    private List<ReportableRtplanState.BeamRecord> h() {
        RtplanSessionState rtplanSessionState = RtplanStateManager.getForSession(this.session).getState(this.rtplanSOP);
        List<ReportableRtplanState.BeamRecord> list = rtplanSessionState.getCurrentlyVisibleBeams();
        ReportableRtplanState.BeamRecord beamRecord = rtplanSessionState.getCurrentlySelectedBeam();
        if (rtplanSessionState.isAlwaysShowingSelectedBeam() && !list.contains(beamRecord)) {
            list.add(beamRecord);
        }
        if (list.isEmpty()) {
            if (this.displayedBeams.containsKey(beamRecord) || this.displayedBeams.isEmpty()) {
                list.add(beamRecord);
            } else {
                list.add(this.displayedBeams.keySet().iterator().next());
            }
        }
        Collections.sort(list, BeamSummaryTableModel.a());
        return list;
    }

    private class DRRView
    extends JPanel {
        int number;
        BufferedImage buff;
        CollimatorState state;
        boolean buffHasContours = false;
        private boolean overlaysNeedRefresh = true;
        private final int PADDING = f.b;
        JPanel controlPanel = null;
        private JButton prevPosition;
        private JButton nextPosition;
        private JButton currPosition;
        private JButton maxMU;
        private JButton increaseRate;
        private JButton decreaseRate;
        private JButton playOrPause;
        private JToggleButton maxProjection;
        private static final int a = 8;
        private int buttonHeight = -1;
        private DelayedActionRunner rerenderDar = new DelayedActionRunner(500, () -> {
            this.a(true);
            this.repaint();
        });

        public void a() {
            this.overlaysNeedRefresh = true;
        }

        DRRView(final int n2, CollimatorState collimatorState) {
            this.setLayout(null);
            this.number = n2;
            this.state = collimatorState;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    RtplanSessionState rtplanSessionState = RtplanStateManager.getForSession(PlanReviewMultiDRRView.this.session).getState(PlanReviewMultiDRRView.this.rtplanSOP);
                    List list = PlanReviewMultiDRRView.this.h();
                    if (n2 < list.size() && mouseEvent.getButton() == 1) {
                        ViewController viewController;
                        ReportableRtplanState.BeamRecord beamRecord = (ReportableRtplanState.BeamRecord)list.get(n2);
                        int n22 = mouseEvent.getClickCount();
                        if (n22 == 1) {
                            rtplanSessionState.setSelectedBeam(beamRecord);
                        } else if (n22 == 2 && (viewController = rtplanSessionState.getDRR(beamRecord).b().an()) != null) {
                            DRRView.this.a(viewController);
                        }
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiersEx() & 0x400) == 1024) {
                        return;
                    }
                    super.mouseEntered(mouseEvent);
                    if (DRRView.this.controlPanel != null) {
                        DRRView.this.controlPanel.setVisible(true);
                        DRRView.this.f();
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    point.translate(DRRView.this.getBounds().x, DRRView.this.getBounds().y);
                    if (DRRView.this.getBounds().contains(point) || (mouseEvent.getModifiersEx() & 0x400) == 1024) {
                        return;
                    }
                    super.mouseExited(mouseEvent);
                    if (DRRView.this.controlPanel != null) {
                        DRRView.this.controlPanel.setVisible(false);
                    }
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiersEx() & 0x400) == 1024 || DRRView.this.controlPanel != null && DRRView.this.controlPanel.isVisible()) {
                        return;
                    }
                    super.mouseMoved(mouseEvent);
                    if (DRRView.this.controlPanel != null) {
                        DRRView.this.controlPanel.setVisible(true);
                        DRRView.this.f();
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    if (DRRView.this.controlPanel != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DRRView.this.e();
                            }
                        });
                    }
                }
            });
            if (collimatorState.numTimePoints > 1) {
                this.c();
            }
        }

        void a(ViewController viewController) {
            ProtocolPage protocolPage = PlanReviewMultiDRRView.this.getView().h();
            az az2 = az.a(new g(PresentationType.a, viewController));
            QuickMaximizeCommand quickMaximizeCommand = new QuickMaximizeCommand(protocolPage);
            quickMaximizeCommand.a(az2);
        }

        private void c() {
            this.controlPanel = new JPanel(new GridLayout(8, 1, 2, 2));
            this.controlPanel.setOpaque(false);
            this.controlPanel.setBackground(new Color(0, 0, 0, 255));
            this.e();
            this.controlPanel.invalidate();
            this.controlPanel.validate();
            this.controlPanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    DRRView.this.e();
                }
            });
            this.increaseRate = (JButton)this.a("add_bronze", "DYNAMIC_CTRL_INCR", new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    DRRView.this.state.j();
                }
            }, false);
            this.controlPanel.add(this.increaseRate);
            this.decreaseRate = (JButton)this.a("subtract_bronze", "DYNAMIC_CTRL_DECR", new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    DRRView.this.state.k();
                }
            }, false);
            this.controlPanel.add(this.decreaseRate);
            this.playOrPause = (JButton)this.a("play", "DYNAMIC_CTRL_PLAY", new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    DRRView.this.d();
                }
            }, false);
            this.controlPanel.add(this.playOrPause);
            this.currPosition = (JButton)this.a("", "COMPANIONCONTROLFACT_PLAN_REVIEW_COLL_TIMEPOINT_SLIDER", null, false);
            this.currPosition.addMouseMotionListener(new MouseAdapter(){
                int a = Integer.MIN_VALUE;
                int b;
                final int c = 5;

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    if (this.a == Integer.MIN_VALUE) {
                        this.a = mouseEvent.getX();
                        return;
                    }
                    int n2 = mouseEvent.getX() - this.a;
                    this.a = mouseEvent.getX();
                    int n3 = this.b + n2;
                    while (Math.abs(n3) > 5) {
                        if (n3 > 0) {
                            n3 -= 5;
                            DRRView.this.state.b();
                            continue;
                        }
                        n3 += 5;
                        DRRView.this.state.c();
                    }
                    this.b = n3;
                }
            });
            this.controlPanel.add(this.currPosition);
            this.prevPosition = (JButton)this.a("rewind", "COMPANIONCONTROLFACT_PLAN_REVIEW_PREV_COLL_TIMEPOINT", new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    DRRView.this.state.c();
                    DRRView.this.maxProjection.setSelected(false);
                }
            }, false);
            this.controlPanel.add(this.prevPosition);
            this.nextPosition = (JButton)this.a("fast_forward", "COMPANIONCONTROLFACT_PLAN_REVIEW_NEXT_COLL_TIMEPOINT", new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    DRRView.this.state.b();
                    DRRView.this.maxProjection.setSelected(false);
                }
            }, false);
            this.controlPanel.add(this.nextPosition);
            this.maxMU = (JButton)this.a("equal_graph_annotation", "COMPANIONCONTROLFACT_PLAN_REVIEW_MAX_MU_TIMEPOINT", new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    DRRView.this.state.e();
                    DRRView.this.maxProjection.setSelected(false);
                }
            }, false);
            this.controlPanel.add(this.maxMU);
            this.maxProjection = (JToggleButton)this.a("complete_irradiation_outline", "COMPANIONCONTROLFACT_PLAN_REVIEW_MAX_PROJ_TIMEPOINT", new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    DRRView.this.state.d();
                }
            }, true);
            this.b();
            this.controlPanel.add(this.maxProjection);
            this.controlPanel.setVisible(false);
            this.add(this.controlPanel);
        }

        private void d() {
            String string;
            String string2;
            if (this.state.m()) {
                this.state.i();
                string2 = "play";
                string = "DYNAMIC_CTRL_PLAY";
            } else {
                this.state.h();
                string2 = "pause";
                string = "DYNAMIC_CTRL_PAUSE";
            }
            this.playOrPause.setIcon(ImageManipulator.c(string2, this.buttonHeight - 8));
            this.playOrPause.setToolTipText(a.getProperty(string));
        }

        private AbstractButton a(String string, String string2, MouseAdapter mouseAdapter, boolean bl2) {
            AbstractButton abstractButton;
            AbstractButton abstractButton2 = abstractButton = bl2 ? new JToggleButton() : new JButton();
            if (!cn.h(string)) {
                abstractButton.setIcon(ImageManipulator.a(string, this.controlPanel.getWidth() - 4));
            }
            abstractButton.setToolTipText(a.getProperty(string2));
            abstractButton.setFocusable(false);
            abstractButton.setMargin(new Insets(0, 0, 0, 0));
            abstractButton.addMouseListener(mouseAdapter);
            return abstractButton;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            BufferedImage bufferedImage = this.a(false);
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 0, 0, null);
                List list = PlanReviewMultiDRRView.this.h();
                if (this.number < list.size()) {
                    RtplanSessionState rtplanSessionState = RtplanStateManager.getForSession(PlanReviewMultiDRRView.this.session).getState(PlanReviewMultiDRRView.this.rtplanSOP);
                    ReportableRtplanState.BeamRecord beamRecord = rtplanSessionState.getCurrentlySelectedBeam();
                    ReportableRtplanState.BeamRecord beamRecord2 = (ReportableRtplanState.BeamRecord)list.get(this.number);
                    if (beamRecord2 == beamRecord) {
                        graphics.setColor(Color.GREEN);
                        graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage a(boolean bl2) {
            int n2 = this.getHeight();
            int n3 = this.getWidth();
            if (n2 == 0 || n3 == 0) {
                return null;
            }
            boolean bl3 = this.buff == null || n2 != this.buff.getHeight() || n3 != this.buff.getWidth();
            boolean bl4 = bl3 || bl2 && !this.buffHasContours || this.overlaysNeedRefresh;
            ViewController viewController = null;
            try {
                if (bl4) {
                    List list;
                    if (bl3 && this.controlPanel != null) {
                        this.e();
                    }
                    if (this.number >= (list = PlanReviewMultiDRRView.this.h()).size()) {
                        BufferedImage bufferedImage = null;
                        return bufferedImage;
                    }
                    ReportableRtplanState.BeamRecord beamRecord = (ReportableRtplanState.BeamRecord)list.get(this.number);
                    RtplanSessionState rtplanSessionState = RtplanStateManager.getForSession(PlanReviewMultiDRRView.this.session).getState(PlanReviewMultiDRRView.this.rtplanSOP);
                    viewController = rtplanSessionState.getDRR(beamRecord).b().aQ();
                    if (viewController == null) {
                        BufferedImage bufferedImage = null;
                        return bufferedImage;
                    }
                    Dimension dimension = new Dimension(n3, n2);
                    Rectangle rectangle = new Rectangle(dimension);
                    az az2 = az.a(new g(rectangle, PresentationType.a, viewController));
                    an.a(az2, false);
                    FloatQuantity.MMQuantity[] mMQuantityArray = beamRecord.getFieldSize();
                    float f2 = MathUtils.E(mMQuantityArray[0].getValue(), mMQuantityArray[1].getValue());
                    float[] fArray = viewController.aw().v();
                    float f3 = MathUtils.E(fArray[0], fArray[1]);
                    viewController.a(0.6f * f3 / f2, null);
                    PresentationType presentationType = az2.U();
                    ArrayList arrayList = Lists.newArrayList((Object[])new PresentationType[]{presentationType});
                    ArrayList arrayList2 = Lists.newArrayList((Object[])new ViewPortUtilities.CapturePrevent[]{ViewPortUtilities.CapturePrevent.a, ViewPortUtilities.CapturePrevent.g, ViewPortUtilities.CapturePrevent.b});
                    if (!bl2) {
                        arrayList2.add(ViewPortUtilities.CapturePrevent.i);
                        this.rerenderDar.b();
                    }
                    this.buff = ViewPortUtilities.a(viewController, arrayList, dimension, arrayList2, true, false, true, null);
                    this.buffHasContours = bl2;
                    this.overlaysNeedRefresh = false;
                    BufferedImage bufferedImage = this.buff;
                    return bufferedImage;
                }
                BufferedImage bufferedImage = this.buff;
                return bufferedImage;
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, PlanReviewMultiDRRView.class);
                throwable.printStackTrace();
            }
            finally {
                if (viewController != null) {
                    viewController.ac();
                }
            }
            return null;
        }

        private void e() {
            if (this.controlPanel == null) {
                return;
            }
            Rectangle rectangle = this.getBounds();
            int n2 = f.a;
            int n3 = Math.min(32, Math.max(rectangle.width, rectangle.height));
            int n4 = Math.max(n2, Math.min(n3, rectangle.height / 9));
            int n5 = Math.max(n2, Math.min(n3, rectangle.width / 9));
            int n6 = Math.min(n4, n5);
            int n7 = 2;
            this.buttonHeight = n6 - 2;
            GridLayout gridLayout = new GridLayout(0, 1, 2, 2);
            if (rectangle.height < n6 * 8 + 2 * this.PADDING) {
                gridLayout.setColumns(2);
            }
            Rectangle rectangle2 = new Rectangle();
            rectangle2.width = n6 * gridLayout.getColumns();
            rectangle2.height = n6 * 8 / gridLayout.getColumns();
            rectangle2.x = this.PADDING;
            rectangle2.y = (rectangle.height - rectangle2.height) / 2;
            this.controlPanel.setBounds(rectangle2);
            if (((GridLayout)this.controlPanel.getLayout()).getColumns() != gridLayout.getColumns()) {
                this.controlPanel.setLayout(gridLayout);
            }
            if (this.prevPosition != null) {
                this.prevPosition.setIcon(ImageManipulator.c("rewind", this.buttonHeight - 8));
            }
            if (this.nextPosition != null) {
                this.nextPosition.setIcon(ImageManipulator.c("fast_forward", this.buttonHeight - 8));
            }
            if (this.currPosition != null) {
                this.b();
            }
            if (this.maxMU != null) {
                this.maxMU.setIcon(ImageManipulator.c("equal_graph_annotation", this.buttonHeight - 8));
            }
            if (this.maxProjection != null) {
                this.maxProjection.setIcon(ImageManipulator.c("complete_irradiation_outline", this.buttonHeight - 8));
            }
            if (this.increaseRate != null) {
                this.increaseRate.setIcon(ImageManipulator.c("add_bronze", this.buttonHeight - 8));
            }
            if (this.decreaseRate != null) {
                this.decreaseRate.setIcon(ImageManipulator.c("subtract_bronze", this.buttonHeight - 8));
            }
            if (this.playOrPause != null) {
                this.playOrPause.setIcon(ImageManipulator.c(this.state.m() ? "pause" : "play", this.buttonHeight - 8));
            }
        }

        void b() {
            if (this.controlPanel == null) {
                return;
            }
            int n2 = this.state.l();
            String string = n2 == -1 ? "*" : Integer.toString(n2 + 1);
            this.currPosition.setFont(MetalLookAndFeel.getControlTextFont().deriveFont(10.0f));
            this.currPosition.setIconTextGap(-1);
            this.currPosition.setVerticalTextPosition(3);
            this.currPosition.setHorizontalTextPosition(0);
            this.currPosition.setText(string + "/" + this.state.numTimePoints);
            this.currPosition.setIcon(com.mimvista.mui.presenters.companion.a.a(this.controlPanel.getWidth(), 9, n2 + 1, this.state.numTimePoints));
            this.maxProjection.setSelected(this.state.g());
        }

        private void f() {
            for (ReportableRtplanState.BeamRecord beamRecord : PlanReviewMultiDRRView.this.displayedBeams.keySet()) {
                DRRView dRRView = (DRRView)PlanReviewMultiDRRView.this.displayedBeams.get(beamRecord);
                if (dRRView == null || dRRView == this || dRRView.controlPanel == null) continue;
                dRRView.controlPanel.setVisible(false);
            }
        }
    }
}

