/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.presenters.roomview;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtplan.FloatQuantity;
import com.mimvista.dicom.rtplan.ReportableRtplanState;
import com.mimvista.dicom.rtplan.RtplanSessionState;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.ay;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class BeamSummaryTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    RtplanSessionState state;
    List<ReportableRtplanState.BeamRecord> beams;

    public BeamSummaryTableModel(RtplanSessionState rtplanSessionState) {
        this.state = rtplanSessionState;
        this.beams = Lists.newArrayList(rtplanSessionState.getBeamRecords());
        Collections.sort(this.beams, BeamSummaryTableModel.a());
    }

    public ReportableRtplanState.BeamRecord a(int n2) {
        return this.beams.get(n2);
    }

    public int a(ReportableRtplanState.BeamRecord beamRecord) {
        return this.beams.indexOf(beamRecord);
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        try {
            ReportableRtplanState.BeamRecord beamRecord = this.a(n2);
            switch (n3) {
                case 0: {
                    return this.state.getCurrentlyVisibleBeams().contains(beamRecord);
                }
                case 1: {
                    return beamRecord.getBeamName();
                }
                case 2: {
                    return beamRecord.getGantryAngle();
                }
                case 3: {
                    return beamRecord.getMachineId();
                }
                case 4: {
                    FloatQuantity.EnergyQuantity energyQuantity = beamRecord.getBeamEnergy();
                    return NumberFormatFactory.a(Float.valueOf(energyQuantity.getValue())) + " " + energyQuantity.getUnit().a();
                }
                case 5: {
                    return beamRecord.getEnergyMode();
                }
                case 6: {
                    DoseValue doseValue = new DoseValue();
                    doseValue.setValueInGy(beamRecord.getReferenceDose().getValue() * (float)beamRecord.getNumberOfFractions());
                    return NumberFormatFactory.a(Float.valueOf(doseValue.getValueInCurrentUnit()));
                }
                case 7: {
                    String string = "{0}, {1}, {2}";
                    DicomPoint3f dicomPoint3f = beamRecord.getIsocenter();
                    String string2 = MIMFormat.a(string, NumberFormatFactory.a(Float.valueOf(dicomPoint3f.x)), NumberFormatFactory.a(Float.valueOf(dicomPoint3f.y)), NumberFormatFactory.a(Float.valueOf(dicomPoint3f.z)));
                    return string2;
                }
                case 8: {
                    if (beamRecord.getSourceSurfaceDistance() == null) break;
                    FloatQuantity.MMQuantity mMQuantity = beamRecord.getSourceSurfaceDistance();
                    return NumberFormatFactory.a(Float.valueOf(mMQuantity.inCM().getValue())) + " " + mMQuantity.inCM().getUnit().a();
                }
                case 9: {
                    return NumberFormatFactory.a(Float.valueOf(beamRecord.getMonitorUnits().getValue()));
                }
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, BeamSummaryTableModel.class);
        }
        return Messages.a("InfoItem", "NA_STRING");
    }

    @Override
    public String getColumnName(int n2) {
        switch (n2) {
            case 0: {
                return "";
            }
            case 1: {
                return Messages.a("PlanReview", "PR_BEAM_NAME");
            }
            case 2: {
                return Messages.a("PlanReview", "PR_GANTRY_ANGLE");
            }
            case 3: {
                return Messages.a("PlanReview", "PR_MACHINE_ID");
            }
            case 4: {
                return Messages.a("PlanReview", "PR_ENERGY");
            }
            case 5: {
                return Messages.a("PlanReview", "PR_ENERGY_ID");
            }
            case 6: {
                return MIMFormat.a(Messages.a("PlanReview", "PR_BEAM_DOSE_HEADER"), DoseValue.doseUnit);
            }
            case 7: {
                return Messages.a("PlanReview", "PR_ISOCENTER");
            }
            case 8: {
                return Messages.a("PlanReview", "PR_SOURCE_SURFACE_DIST_SHORT");
            }
            case 9: {
                return Messages.a("PlanReview", "PR_BEAM_MONITOR_UNITS_PER_FRACTION");
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        switch (n2) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return String.class;
            }
            case 8: {
                return String.class;
            }
            case 9: {
                return String.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.beams == null ? 0 : this.beams.size();
    }

    @Override
    public int getColumnCount() {
        return 10;
    }

    public static Comparator<ReportableRtplanState.BeamRecord> a() {
        return new Comparator<ReportableRtplanState.BeamRecord>(){

            public int a(ReportableRtplanState.BeamRecord beamRecord, ReportableRtplanState.BeamRecord beamRecord2) {
                Integer n2 = beamRecord.getRefBeamNumber();
                Integer n3 = beamRecord2.getRefBeamNumber();
                if (n2 != null && n3 != null) {
                    return n2.compareTo(n3);
                }
                return beamRecord.getBeamName().compareTo(beamRecord2.getBeamName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((ReportableRtplanState.BeamRecord)object, (ReportableRtplanState.BeamRecord)object2);
            }
        };
    }
}

