/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.presenters.roomview;

import com.google.common.collect.ImmutableList;
import com.mimvista.commands.keyboard.bt;
import com.mimvista.commands.keyboard.o;
import com.mimvista.dicom.rtplan.ReportableRtplanState;
import com.mimvista.dicom.rtplan.RtplanSessionState;
import com.mimvista.dicom.rtplan.RtplanStateManager;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.internals.CollimatorState;
import com.mimvista.mui.Session;
import com.mimvista.mui.bm;
import com.mimvista.mui.layout.CustomView;
import com.mimvista.mui.presenters.ProtocolPage;
import com.mimvista.mui.presenters.planreview.AbstractPlanReviewCustomViewPanel;
import com.mimvista.mui.presenters.roomview.BeamSummaryTableModel;
import com.mimvista.report.b;
import com.mimvista.util.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class BeamSummaryViewportView
extends AbstractPlanReviewCustomViewPanel {
    private static final long serialVersionUID = 1L;
    private static final int a = 50;
    private RtplanSessionState.BeamSelectedListener bsl;
    private RtplanSessionState.BeamVisibilityListener bvl;
    private Icon closed = ImageManipulator.c("view_eyeclosed", 16);
    private Icon open = ImageManipulator.c("view_eyeopen", 16);
    private Icon leafBoundaries = ImageManipulator.c("slabbing_mode", 16);
    private Icon percentOpenOverlay = ImageManipulator.c("color_wash", 16);
    private Icon maxProjection = ImageManipulator.c("complete_irradiation_outline", 16);
    private Icon maxMU = ImageManipulator.c("equal_graph_annotation", 16);
    JButton showHideAll;
    JButton toggleLeafBoundaries;
    JButton togglePercentOpenOverlays;
    JButton toggleMaxProjection;
    JButton toMaxMU;
    JCheckBox showCurrentlySelected;
    JCheckBox showBeamLabels;
    boolean allShow = true;

    public BeamSummaryViewportView(Session session, CustomView customView, String string) {
        super(session, customView, new BorderLayout(), string);
        List<RtplanSessionState> list = RtplanStateManager.getForSession(session).getValidatedStatesByPlanningVolume(string);
        RtplanSessionState rtplanSessionState = null;
        if (list.size() > 0) {
            rtplanSessionState = list.get(0);
        }
        this.showHideAll = new JButton(this.open);
        this.toggleLeafBoundaries = new JButton(this.leafBoundaries);
        this.showCurrentlySelected = new JCheckBox(Messages.a("PlanReview", "PR_ALWAYS_SHOW_SELECTED_BEAM"));
        this.showBeamLabels = new JCheckBox(Messages.a("PlanReview", "PR_SHOW_BEAM_LABELS"));
        this.togglePercentOpenOverlays = new JButton(this.percentOpenOverlay);
        this.toggleMaxProjection = new JButton(this.maxProjection);
        this.toMaxMU = new JButton(this.maxMU);
        this.showHideAll.setToolTipText(Messages.a("PlanReview", "PR_TOGGLE_ALL_BEAMS"));
        this.toggleLeafBoundaries.setToolTipText(Messages.a("PlanReview", "PR_TOGGLE_ALL_LEAF_BOUNDARIES"));
        this.togglePercentOpenOverlays.setToolTipText(Messages.a("PlanReview", "PR_TOGGLE_ALL_COLLIMATOR_PERCENT_OPEN_OVERLAYS"));
        this.toggleMaxProjection.setToolTipText(Messages.a("PlanReview", "PR_ALL_TO_MAX_PROJECTION_TIMEPOINT"));
        this.toMaxMU.setToolTipText(Messages.a("PlanReview", "PR_ALL_TO_MAX_MU_TIMEPOINT"));
        JXTable jXTable = this.c();
        JComboBox<RtplanSessionState> jComboBox = this.a(list, rtplanSessionState, jXTable);
        JLabel jLabel = this.d();
        JButton jButton = this.e();
        for (RtplanSessionState serializable2 : list) {
            this.bsl = beamSelectedEvent -> this.a(jXTable);
            this.bvl = beamVisibilityEvent -> this.a(jXTable);
            serializable2.addSelectionChangedListener(this.bsl);
            serializable2.addVisiblityChangedListener(this.bvl);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box box = new Box(0);
        box.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        box.add(jLabel);
        box.add(Box.createHorizontalGlue());
        box.add(jComboBox);
        jPanel.add(box);
        JScrollPane jScrollPane = new JScrollPane((Component)jXTable);
        Dimension dimension = new Dimension(Integer.MAX_VALUE, jXTable.getRowCount() * jXTable.getRowHeight() + jXTable.getHeight());
        jXTable.setPreferredScrollableViewportSize(dimension);
        jScrollPane.setMaximumSize(dimension);
        jPanel.add(jScrollPane);
        this.showHideAll.addActionListener(actionEvent -> {
            if (this.allShow) {
                this.allShow = false;
                this.showHideAll.setIcon(this.closed);
            } else {
                this.allShow = true;
                this.showHideAll.setIcon(this.open);
            }
            BeamSummaryTableModel beamSummaryTableModel = (BeamSummaryTableModel)jXTable.getModel();
            for (ReportableRtplanState.BeamRecord beamRecord : beamSummaryTableModel.state.getBeamRecords()) {
                beamSummaryTableModel.state.setBeamVisiblity(beamRecord, this.allShow);
            }
        });
        this.showCurrentlySelected.setSelected(((BeamSummaryTableModel)jXTable.getModel()).state.isAlwaysShowingSelectedBeam());
        this.showCurrentlySelected.addActionListener(actionEvent -> {
            RtplanSessionState rtplanSessionState = ((BeamSummaryTableModel)jXTable.getModel()).state;
            rtplanSessionState.setAlwaysShowingSelectedBeam(this.showCurrentlySelected.isSelected());
            rtplanSessionState.fireSelectionChangedListeners();
        });
        this.showBeamLabels.setSelected(((BeamSummaryTableModel)jXTable.getModel()).state.isShowBeamLabelsOnScreen());
        this.showBeamLabels.addActionListener(actionEvent -> {
            RtplanSessionState rtplanSessionState = ((BeamSummaryTableModel)jXTable.getModel()).state;
            rtplanSessionState.setShowBeamLabelsOnScreen(this.showBeamLabels.isSelected());
            rtplanSessionState.fireSelectionChangedListeners();
        });
        this.toggleLeafBoundaries.addActionListener(actionEvent -> {
            ProtocolPage protocolPage = session.ac().n().iterator().next();
            new bt.a().a(protocolPage);
        });
        this.togglePercentOpenOverlays.addActionListener(actionEvent -> {
            ProtocolPage protocolPage = session.ac().n().iterator().next();
            new o.a().a(protocolPage);
        });
        this.toggleMaxProjection.addActionListener(actionEvent -> {
            RtplanSessionState rtplanSessionState = (RtplanSessionState)jComboBox.getSelectedItem();
            if (rtplanSessionState != null) {
                if (rtplanSessionState.getBeamRecords().stream().map(rtplanSessionState::getCollimatorState).allMatch(CollimatorState::g)) {
                    rtplanSessionState.getBeamRecords().stream().map(rtplanSessionState::getCollimatorState).forEach(CollimatorState::d);
                } else {
                    rtplanSessionState.getBeamRecords().stream().map(rtplanSessionState::getCollimatorState).filter(collimatorState -> !collimatorState.g()).forEach(CollimatorState::d);
                }
            }
        });
        this.toMaxMU.addActionListener(actionEvent -> {
            RtplanSessionState rtplanSessionState = (RtplanSessionState)jComboBox.getSelectedItem();
            if (rtplanSessionState != null) {
                rtplanSessionState.getBeamRecords().stream().map(rtplanSessionState::getCollimatorState).forEach(CollimatorState::e);
            }
        });
        Box box2 = new Box(0);
        box2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        box2.add(this.showHideAll);
        box2.add(Box.createRigidArea(new Dimension(5, 0)));
        box2.add(this.toggleLeafBoundaries);
        box2.add(Box.createRigidArea(new Dimension(5, 0)));
        box2.add(this.togglePercentOpenOverlays);
        box2.add(Box.createRigidArea(new Dimension(5, 0)));
        box2.add(this.toggleMaxProjection);
        box2.add(Box.createRigidArea(new Dimension(5, 0)));
        box2.add(this.toMaxMU);
        box2.add(Box.createHorizontalGlue());
        box2.add(jButton);
        jPanel.add(box2);
        Box box3 = new Box(1);
        box3.setAlignmentX(0.5f);
        box3.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        box3.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        box3.add(this.showCurrentlySelected);
        box3.add(Box.createRigidArea(new Dimension(0, 5)));
        box3.add(this.showBeamLabels);
        box3.add(Box.createVerticalGlue());
        jPanel.add(box3);
        jPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                BeamSummaryViewportView.this.requestFocusInWindow();
            }
        });
        this.add(jPanel);
    }

    private void a(JXTable jXTable) {
        if (jXTable.getModel() instanceof BeamSummaryTableModel) {
            BeamSummaryTableModel beamSummaryTableModel = (BeamSummaryTableModel)jXTable.getModel();
            int n2 = beamSummaryTableModel.a(beamSummaryTableModel.state.getCurrentlySelectedBeam());
            jXTable.setRowSelectionInterval(n2, n2);
            ImmutableList<ReportableRtplanState.BeamRecord> immutableList = beamSummaryTableModel.state.getBeamRecords();
            Optional optional = immutableList.stream().map(beamRecord -> beamSummaryTableModel.state.getBeamVisiblity((ReportableRtplanState.BeamRecord)beamRecord)).collect(Collectors.reducing((bl2, bl3) -> bl2 != false || bl3 != false));
            Optional optional2 = immutableList.stream().map(beamRecord -> beamSummaryTableModel.state.getBeamVisiblity((ReportableRtplanState.BeamRecord)beamRecord)).collect(Collectors.reducing((bl2, bl3) -> bl2 != false && bl3 != false));
            if (!((Boolean)optional.get()).booleanValue() && this.allShow) {
                this.allShow = false;
                this.showHideAll.setIcon(this.closed);
            } else if (((Boolean)optional2.get()).booleanValue() && !this.allShow) {
                this.allShow = true;
                this.showHideAll.setIcon(this.open);
            }
        }
        this.repaint();
    }

    private JXTable c() {
        final JXTable jXTable = new JXTable();
        jXTable.setSelectionMode(0);
        jXTable.getTableHeader().setReorderingAllowed(false);
        jXTable.setRowSorter(null);
        jXTable.setAutoCreateRowSorter(false);
        jXTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n2 = jXTable.getSelectedRow();
                int n3 = jXTable.getSelectedColumn();
                if (n2 >= 0 && jXTable.getModel() instanceof BeamSummaryTableModel) {
                    BeamSummaryTableModel beamSummaryTableModel = (BeamSummaryTableModel)jXTable.getModel();
                    ReportableRtplanState.BeamRecord beamRecord = beamSummaryTableModel.a(n2);
                    if (n3 == 0) {
                        beamSummaryTableModel.state.setBeamVisiblity(beamRecord, !beamSummaryTableModel.state.getBeamVisiblity(beamRecord));
                    }
                }
                jXTable.updateUI();
            }
        });
        jXTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n2 = jXTable.getSelectedRow();
                if (n2 >= 0 && jXTable.getModel() instanceof BeamSummaryTableModel) {
                    BeamSummaryTableModel beamSummaryTableModel = (BeamSummaryTableModel)jXTable.getModel();
                    ReportableRtplanState.BeamRecord beamRecord = beamSummaryTableModel.a(n2);
                    beamSummaryTableModel.state.setSelectedBeam(beamRecord);
                }
            }
        });
        jXTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                this.setHorizontalAlignment(0);
                this.setText("");
                if (((Boolean)object).booleanValue()) {
                    this.setIcon(BeamSummaryViewportView.this.open);
                } else {
                    this.setIcon(BeamSummaryViewportView.this.closed);
                }
                return this;
            }
        });
        return jXTable;
    }

    private JComboBox<RtplanSessionState> a(List<RtplanSessionState> list, RtplanSessionState rtplanSessionState, final JXTable jXTable) {
        final JComboBox<RtplanSessionState> jComboBox = new JComboBox<RtplanSessionState>(list.toArray(new RtplanSessionState[list.size()]));
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RtplanSessionState rtplanSessionState = (RtplanSessionState)jComboBox.getSelectedItem();
                BeamSummaryTableModel beamSummaryTableModel = new BeamSummaryTableModel(rtplanSessionState);
                jXTable.setModel((TableModel)beamSummaryTableModel);
                jXTable.getColumn(0).setMaxWidth(50);
                BeamSummaryViewportView.this.a(jXTable);
            }
        });
        jComboBox.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                RtplanSessionState rtplanSessionState = (RtplanSessionState)object;
                String string = rtplanSessionState.getSeriesDescription();
                return new JLabel(string);
            }
        });
        Dimension dimension = new Dimension(300, 30);
        jComboBox.setMaximumSize(dimension);
        jComboBox.setPreferredSize(dimension);
        if (rtplanSessionState != null) {
            jComboBox.setSelectedItem(rtplanSessionState);
        }
        return jComboBox;
    }

    private JLabel d() {
        JLabel jLabel = new JLabel(Messages.a("PlanReview", "PR_PLAN_REVIEW"));
        Font font = jLabel.getFont().deriveFont(20.0f);
        jLabel.setFont(font);
        return jLabel;
    }

    private JButton e() {
        JButton jButton = new JButton(Messages.a("Report", "REPORT_DEFAULT_TITLE"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                b.a(bm.b());
            }
        });
        return jButton;
    }
}

