/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.presenters.roomview;

import com.badlogic.gdx.math.Quaternion;
import com.mimvista.commands.keyboard.QuickMaximizeCommand;
import com.mimvista.dicom.rtplan.ReportableRtplanState;
import com.mimvista.dicom.rtplan.RtplanSessionState;
import com.mimvista.dicom.rtplan.RtplanStateManager;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.linking.ViewLink;
import com.mimvista.mui.Session;
import com.mimvista.mui.ax;
import com.mimvista.mui.layout.CustomView;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.mui.overlays.OverlayDirtParams;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.y;
import com.mimvista.mui.p;
import com.mimvista.mui.presenters.planreview.AbstractPlanReviewCustomViewPanel;
import com.mimvista.mui.presenters.protocol.a;
import com.mimvista.mui.presenters.roomview.d;
import com.mimvista.mui.presenters.roomview.f;
import com.mimvista.numerics.MathUtils;
import com.mimvista.osdep.GetOSPath;
import com.mimvista.swing.DelayedActionRunner;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

public class RoomViewViewportView
extends AbstractPlanReviewCustomViewPanel {
    private static final long serialVersionUID = 1L;
    private Canvas roomViewCanvas;
    private Canvas controlBoxCanvas;
    private JLayeredPane layeredPane;
    private f roomViewModel;
    private d contolBoxModel;
    private Dimension dim;
    private Point mousePressedPoint;
    private DelayedActionRunner updateModel;
    private RtplanSessionState.BeamSelectedListener bsl;
    private RtplanSessionState.BeamVisibilityListener bvl;
    private OverlayCollection.a ocl;
    private y ol;
    private ActionListener al;

    public RoomViewViewportView(Session session, final CustomView customView, String string) {
        super(session, customView, string);
        this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.dim = new Dimension(this.getHeight(), this.getWidth());
        this.layeredPane = new JLayeredPane();
        RtplanStateManager rtplanStateManager = RtplanStateManager.getForSession(session);
        final RtplanSessionState rtplanSessionState = rtplanStateManager.getValidatedStatesByPlanningVolume(string).get(0);
        this.roomViewModel = new f(rtplanSessionState, customView);
        this.roomViewCanvas = this.roomViewModel.b();
        SimpleOrientationHelper.PatientPosition patientPosition = rtplanSessionState.getPlanningVolumeAsImageFrame().getUncopiedMutableInfo().origPatientPosition;
        this.contolBoxModel = new d(patientPosition);
        this.controlBoxCanvas = this.contolBoxModel.b();
        this.setBackground(Color.BLACK);
        this.add(this.layeredPane);
        final JLabel jLabel = new JLabel();
        final JLabel jLabel2 = new JLabel();
        final JLabel jLabel3 = new JLabel();
        this.layeredPane.add((Component)jLabel3, 0);
        this.layeredPane.add((Component)jLabel2, 1);
        this.layeredPane.add((Component)jLabel, 2);
        this.layeredPane.add((Component)this.roomViewCanvas, 3);
        this.layeredPane.add((Component)this.controlBoxCanvas, 4);
        this.roomViewModel.a(new Runnable(){

            @Override
            public void run() {
                if (RoomViewViewportView.this.c()) {
                    return;
                }
                jLabel.setIcon(new ImageIcon(RoomViewViewportView.this.roomViewModel.c()));
                jLabel.setBounds(0, 0, ((RoomViewViewportView)RoomViewViewportView.this).dim.width, ((RoomViewViewportView)RoomViewViewportView.this).dim.height);
                jLabel3.setText(RoomViewViewportView.this.roomViewModel.g());
                jLabel3.setBounds(((RoomViewViewportView)RoomViewViewportView.this).dim.width - 200, 50, 200, 50);
                RoomViewViewportView.this.roomViewCanvas.setVisible(false);
                RoomViewViewportView.this.contolBoxModel.a(RoomViewViewportView.this.roomViewModel.f());
                RoomViewViewportView.this.controlBoxCanvas.setVisible(true);
                RoomViewViewportView.this.validate();
                RoomViewViewportView.this.repaint();
            }
        });
        this.contolBoxModel.a(new Runnable(){

            @Override
            public void run() {
                if (RoomViewViewportView.this.c()) {
                    return;
                }
                jLabel2.setIcon(new ImageIcon(RoomViewViewportView.this.contolBoxModel.c()));
                jLabel2.setBounds(0, 0, ((RoomViewViewportView)RoomViewViewportView.this).dim.width, ((RoomViewViewportView)RoomViewViewportView.this).dim.height);
                RoomViewViewportView.this.controlBoxCanvas.setVisible(false);
                RoomViewViewportView.this.validate();
                RoomViewViewportView.this.repaint();
            }
        });
        this.updateModel = new DelayedActionRunner(100, new Runnable(){

            @Override
            public void run() {
                RoomViewViewportView.this.roomViewModel.e();
                RoomViewViewportView.this.roomViewCanvas.setVisible(true);
            }
        });
        this.bsl = new RtplanSessionState.BeamSelectedListener(){

            @Override
            public void actionPerformed(RtplanSessionState.BeamSelectedEvent beamSelectedEvent) {
                if (RoomViewViewportView.this.getParent() == null) {
                    rtplanSessionState.removeSelectionChangedListener(RoomViewViewportView.this.bsl);
                    return;
                }
                RoomViewViewportView.this.updateModel.b();
            }
        };
        rtplanSessionState.addSelectionChangedListener(this.bsl);
        this.bvl = new RtplanSessionState.BeamVisibilityListener(){

            @Override
            public void actionPerformed(RtplanSessionState.BeamVisibilityEvent beamVisibilityEvent) {
                if (RoomViewViewportView.this.getParent() == null) {
                    rtplanSessionState.removeVisiblityChangedListener(RoomViewViewportView.this.bvl);
                    return;
                }
                RoomViewViewportView.this.updateModel.b();
            }
        };
        rtplanSessionState.addVisiblityChangedListener(this.bvl);
        this.al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RoomViewViewportView.this.getParent() == null) {
                    rtplanSessionState.getPlanningVolumeAsImageFrame().j().b(RoomViewViewportView.this.al, ViewLink.ViewEvent.q, ViewLink.ViewEvent.p);
                    return;
                }
                RoomViewViewportView.this.updateModel.b();
            }
        };
        rtplanSessionState.getPlanningVolumeAsImageFrame().j().a(this.al, true, ViewLink.ViewEvent.q, ViewLink.ViewEvent.p);
        this.ol = new y(){

            @Override
            public void overlayDataChanged(Overlayish overlayish, OverlayDirtParams.OverlayChangeGranularity overlayChangeGranularity) {
                this.overlayMetadataChanged(overlayish);
            }

            @Override
            public void overlayMetadataChanged(Overlayish overlayish) {
                if (RoomViewViewportView.this.getParent() == null) {
                    overlayish.c(RoomViewViewportView.this.ol);
                    return;
                }
                RoomViewViewportView.this.updateModel.b();
            }
        };
        OverlayCollection overlayCollection = rtplanSessionState.getPlanningVolumeAsImageFrame().n();
        for (Overlayish overlayish : overlayCollection.f()) {
            if (!overlayish.u() && !(overlayish instanceof IsodoseOverlay)) continue;
            overlayish.b(this.ol);
        }
        this.ocl = new OverlayCollection.a(){

            @Override
            public void currentContourChanged(Overlayish overlayish) {
                if (!this.a(overlayish)) {
                    RoomViewViewportView.this.updateModel.b();
                }
            }

            @Override
            public void overlayAdded(Overlayish overlayish) {
                if (!this.a(overlayish) && (overlayish.u() || overlayish instanceof IsodoseOverlay)) {
                    overlayish.b(RoomViewViewportView.this.ol);
                }
            }

            private boolean a(Overlayish overlayish) {
                if (RoomViewViewportView.this.getParent() == null) {
                    overlayish.aL().c(RoomViewViewportView.this.ocl);
                    return true;
                }
                return false;
            }
        };
        overlayCollection.a(this.ocl);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (RoomViewViewportView.this.c()) {
                    RoomViewViewportView.this.roomViewCanvas.setVisible(true);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                RoomViewViewportView.this.mousePressedPoint = mouseEvent.getPoint();
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ReportableRtplanState.BeamRecord beamRecord;
                int n2 = mouseEvent.getClickCount();
                if (mouseEvent.getButton() == 1 && n2 == 2) {
                    new QuickMaximizeCommand().a(customView);
                    return;
                }
                Point point = mouseEvent.getPoint();
                point = SwingUtilities.convertPoint(RoomViewViewportView.this, point, RoomViewViewportView.this.contolBoxModel.b());
                Quaternion quaternion = RoomViewViewportView.this.contolBoxModel.a(point);
                if (quaternion != null) {
                    RoomViewViewportView.this.roomViewModel.a(quaternion);
                    RoomViewViewportView.this.roomViewCanvas.setVisible(true);
                }
                if ((beamRecord = RoomViewViewportView.this.roomViewModel.a(point)) != null) {
                    ((RoomViewViewportView)RoomViewViewportView.this).roomViewModel.k.setSelectedBeam(beamRecord);
                    RoomViewViewportView.this.roomViewCanvas.setVisible(true);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n2 = mouseEvent.getX() - ((RoomViewViewportView)RoomViewViewportView.this).mousePressedPoint.x;
                int n3 = mouseEvent.getY() - ((RoomViewViewportView)RoomViewViewportView.this).mousePressedPoint.y;
                if (mouseEvent.getModifiersEx() == 1024) {
                    RoomViewViewportView.this.roomViewModel.a(n2, n3);
                } else if (mouseEvent.getModifiersEx() == 4096) {
                    RoomViewViewportView.this.roomViewModel.a(MathUtils.e(-n3));
                }
                RoomViewViewportView.this.mousePressedPoint = mouseEvent.getPoint();
                RoomViewViewportView.this.roomViewCanvas.setVisible(true);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                RoomViewViewportView.this.roomViewModel.a(-mouseWheelEvent.getWheelRotation());
                RoomViewViewportView.this.roomViewCanvas.setVisible(true);
            }
        });
        session.a(new ax(){

            @Override
            public void pageGroupAdded(a a2, a a3) {
            }

            @Override
            public void pageGroupRemoved(a a2, a a3) {
            }

            @Override
            public void pageGroupActivated(a a2, a a3) {
                if (customView.h().k() == a2) {
                    RoomViewViewportView.this.updateModel.b();
                }
            }

            @Override
            public void pageGroupNameChanged(a a2) {
            }
        });
    }

    private boolean c() {
        Dimension dimension = new Dimension(this.getWidth(), this.getHeight());
        if (!(this.dim.equals(dimension) && this.roomViewModel.d() != null && this.roomViewModel.d().equals(dimension) && this.contolBoxModel.d() != null && this.contolBoxModel.d().equals(dimension))) {
            this.dim.setSize(dimension);
            this.roomViewModel.resize(dimension.width, dimension.height);
            this.contolBoxModel.resize(dimension.width, dimension.height);
            this.contolBoxModel.a(this.roomViewModel.f());
            this.layeredPane.setBounds(this.getBounds());
            this.layeredPane.setPreferredSize(this.dim);
            return true;
        }
        return false;
    }

    @Override
    public void removeNotify() {
        if (!GetOSPath.isMacOs() || !(p.a().g() instanceof com.mimvista.mui.mouse.mode.protocol.d)) {
            super.removeNotify();
        }
    }
}

