/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.qa;

import com.google.common.collect.Lists;
import com.mimvista.intensitybasedwarp.IntensityWarpSettings;
import com.mimvista.mui.ai;
import com.mimvista.util.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EnumSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WarpSettingsUI
extends JPanel {
    private static final long serialVersionUID = 1L;
    IntensityWarpSettings settings = new IntensityWarpSettings();
    private boolean allowNewParams;
    JComboBox<IntensityWarpSettings.WarpParameterSet> paramsCombo;
    JTextField smoothnessField;
    JCheckBox normalizeBox;
    JCheckBox dynamicRegularizationBox;
    List<Runnable> listeners = Lists.newArrayList();

    public WarpSettingsUI(IntensityWarpSettings intensityWarpSettings, boolean bl2) {
        this.settings = intensityWarpSettings;
        this.allowNewParams = bl2;
        if (this.settings == null) {
            this.settings = new IntensityWarpSettings();
            if (!bl2) {
                this.settings.params = IntensityWarpSettings.WarpParameterSet.a;
            }
        }
        this.c();
    }

    public IntensityWarpSettings a() {
        this.settings.params = (IntensityWarpSettings.WarpParameterSet)this.paramsCombo.getSelectedItem();
        if (!this.smoothnessField.getText().isEmpty()) {
            this.settings.smoothnessFactor = Float.valueOf(Float.parseFloat(this.smoothnessField.getText()));
        }
        this.settings.normalize = this.normalizeBox.isSelected();
        this.settings.dynamicRegularization = this.dynamicRegularizationBox.isSelected();
        return this.settings;
    }

    public boolean b() {
        try {
            if (!this.smoothnessField.getText().isEmpty()) {
                Float.parseFloat(this.smoothnessField.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.smoothnessField.setBorder(BorderFactory.createLineBorder(Color.RED, 2));
            return true;
        }
        return false;
    }

    public void a(Runnable runnable) {
        this.listeners.add(runnable);
    }

    private void c() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        Messages messages = Messages.a("PropertyCollectionFactory");
        String[] stringArray = new String[]{messages.getProperty("DEF_REG_CONFIGS_PARAM_TYPE"), messages.getProperty("DEF_REG_CONFIGS_SMOOTHNESS"), messages.getProperty("DEF_REG_CONFIGS_NORMALIZATION"), messages.getProperty("DEF_REG_CONFIGS_REGULARIZATION")};
        EnumSet<IntensityWarpSettings.WarpParameterSet> enumSet = EnumSet.allOf(IntensityWarpSettings.WarpParameterSet.class);
        enumSet.removeIf(warpParameterSet -> !warpParameterSet.b() || !this.allowNewParams && warpParameterSet != IntensityWarpSettings.WarpParameterSet.a);
        this.paramsCombo = new JComboBox<IntensityWarpSettings.WarpParameterSet>(enumSet.toArray(new IntensityWarpSettings.WarpParameterSet[enumSet.size()]));
        this.paramsCombo.setRenderer(ai.a());
        this.paramsCombo.setSelectedItem(this.settings.params);
        this.smoothnessField = new JTextField();
        this.smoothnessField.addActionListener(actionEvent -> this.smoothnessField.setBorder(BorderFactory.createEmptyBorder()));
        this.smoothnessField.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    for (Runnable runnable : WarpSettingsUI.this.listeners) {
                        runnable.run();
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        if (this.settings.smoothnessFactor != null) {
            this.smoothnessField.setText(this.settings.smoothnessFactor.toString());
        }
        this.normalizeBox = new JCheckBox();
        this.normalizeBox.setSelected(this.settings.normalize);
        this.dynamicRegularizationBox = new JCheckBox();
        this.dynamicRegularizationBox.setSelected(this.settings.dynamicRegularization);
        JComponent[] jComponentArray = new JComponent[]{this.paramsCombo, this.smoothnessField, this.normalizeBox, this.dynamicRegularizationBox};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            gridBagConstraints.weightx = 0.1;
            JLabel jLabel = new JLabel(stringArray[i2]);
            jLabel.setForeground(Color.GRAY);
            this.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 0.9;
            JComponent jComponent = jComponentArray[i2];
            this.add((Component)jComponent, gridBagConstraints);
            --gridBagConstraints.gridx;
            ++gridBagConstraints.gridy;
        }
        this.revalidate();
        this.repaint();
    }
}

