/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.volumetric;

import com.mimvista.internals.ContrastState;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.casting.w;
import com.mimvista.internals.linking.ViewLink;
import com.mimvista.mui.volumetric.Volumetric3DOptionMode;
import com.mimvista.mui.volumetric.a;
import com.mimvista.mui.volumetric.b;
import com.mimvista.viewer.algo.BestContrastor;
import com.mimvista.viewer.algo.c;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Volumetric3DGraphPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    Rectangle graphRect;
    private int lastX;
    private int lastY;
    private ViewController3D vc;
    private int maxCount;
    private int minBin;
    private int maxBin;
    private Point lastPoint = null;

    public Volumetric3DGraphPanel(ViewController3D viewController3D) {
        this.vc = viewController3D;
        this.setPreferredSize(new Dimension(600, 100));
        this.setBounds(0, 0, 600, 100);
        viewController3D.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Volumetric3DGraphPanel.this.repaint();
            }
        }, ViewLink.ViewEvent.p, ViewLink.ViewEvent.q);
        this.a();
    }

    private void a(MouseEvent mouseEvent) {
        int n2 = (mouseEvent.getY() - this.lastY) * 2;
        int n3 = (mouseEvent.getX() - this.lastX) * 2;
        if ((mouseEvent.getModifiersEx() & 0x400) != 0) {
            this.minBin += n2 / 2;
            this.maxBin -= n2 / 2;
            this.minBin -= n3;
            this.maxBin -= n3;
            if (this.maxBin - this.minBin < 5) {
                this.minBin -= n2 / 2;
                this.maxBin += n2 / 2;
            }
        } else if ((mouseEvent.getModifiersEx() & 0x1000) != 0) {
            // empty if block
        }
    }

    private void b(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this);
        com.mimvista.util.contrast.b b2 = this.vc.cJ().a();
        long[] lArray = this.vc.am().rayState.colorTable;
        Rectangle rectangle = new Rectangle(0, 0, (int)this.getBounds().getWidth(), (int)(this.getBounds().getHeight() - 50.0));
        int n2 = rectangle.width;
        ContrastState contrastState = b2.e();
        int n3 = c.a(contrastState.A(), (int)contrastState.k()) - this.minBin;
        int n4 = c.b(contrastState.A(), (int)contrastState.k()) - this.minBin;
        int n5 = this.maxBin - this.minBin;
        int n6 = Volumetric3DGraphPanel.a(n4 - n3, n2, this.maxBin, this.minBin);
        int n7 = n3;
        int n8 = Volumetric3DGraphPanel.a(n7, n2, this.maxBin, this.minBin);
        int n9 = Volumetric3DGraphPanel.a(Math.min(n4 - n7, n5 - n7), n2, this.maxBin, this.minBin);
        float f2 = (float)lArray.length / (float)n6;
        int n10 = (int)Math.ceil(lArray.length / n6);
        if (this.lastPoint == null) {
            this.lastPoint = point;
        }
        int n11 = (int)((float)(point.x - n8) * f2);
        n11 = Math.max(0, n11);
        n11 = Math.min(lArray.length, n11);
        long l2 = (long)(Math.max(0.0f, Math.min(1.0f, 1.0f - (float)point.y / (float)rectangle.getHeight())) * 32767.0f);
        int n12 = (int)((float)(this.lastPoint.x - n8) * f2);
        n12 = Math.max(0, n12);
        n12 = Math.min(lArray.length, n12);
        long l3 = (long)(Math.max(0.0f, Math.min(1.0f, 1.0f - (float)this.lastPoint.y / (float)rectangle.getHeight())) * 32767.0f);
        boolean bl2 = true;
        if ((mouseEvent.getModifiersEx() & 0x400) != 0) {
            bl2 = true;
        } else if ((mouseEvent.getModifiersEx() & 0x1000) != 0) {
            bl2 = false;
        }
        this.a(lArray, n11, l2, n12, l3, bl2);
        this.lastPoint = point;
    }

    private void a(long[] lArray, int n2, long l2, int n3, long l3, boolean bl2) {
        long l4;
        long l5;
        int n4 = Math.abs(n2 - n3);
        if (n2 > n3) {
            l5 = l3;
            l4 = l2;
        } else {
            l5 = l2;
            l4 = l3;
        }
        float f2 = 0.0f;
        if (n4 != 0) {
            f2 = l4 - l5;
            f2 /= (float)n4;
        }
        for (int i2 = 0; i2 < n4 && i2 < lArray.length; ++i2) {
            int n5 = i2 + Math.min(n2, n3);
            if (n5 >= lArray.length) continue;
            long l6 = (long)((float)l5 + (float)i2 * f2);
            if (bl2 && this.a(lArray, n5) < l6) {
                this.a(lArray, n5, (long)((float)l5 + (float)i2 * f2));
                continue;
            }
            if (bl2 || this.a(lArray, n5) < l6) continue;
            this.a(lArray, n5, (long)((float)l5 + (float)i2 * f2));
        }
        this.vc.bB();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                w.a(Volumetric3DGraphPanel.this.vc);
                Volumetric3DGraphPanel.this.vc.bB();
            }
        });
    }

    private void a(final int n2, final int n3) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                com.mimvista.util.contrast.b b2 = Volumetric3DGraphPanel.this.vc.cJ().a();
                ContrastState contrastState = b2.e();
                b2.a(contrastState, null, n3, n2);
                b2.a(contrastState);
                Volumetric3DGraphPanel.this.vc.bB();
                Volumetric3DGraphPanel.this.repaint();
            }
        });
    }

    private void b(final int n2, final int n3) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                com.mimvista.util.contrast.b b2 = Volumetric3DGraphPanel.this.vc.i();
                ContrastState contrastState = b2.e();
                b2.a(contrastState, null, n3, n2);
                b2.a(contrastState);
                Volumetric3DGraphPanel.this.vc.bB();
                Volumetric3DGraphPanel.this.repaint();
            }
        });
    }

    private void a(long[] lArray, int n2, long l2) {
        if (n2 < 0 || n2 >= lArray.length) {
            return;
        }
        int n3 = n2;
        lArray[n3] = lArray[n3] & 0xFFFFFFFFFFFFL;
        int n4 = n2;
        lArray[n4] = lArray[n4] | l2 << 48;
    }

    private long a(long[] lArray, int n2) {
        if (n2 < 0 || n2 >= lArray.length) {
            return 0L;
        }
        long l2 = lArray[n2] & 0xFFFF000000000000L;
        return l2 >>= 48;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.a((Graphics2D)graphics, this.getBounds());
    }

    private void a(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphRect = new Rectangle(0, 0, (int)this.getBounds().getWidth(), (int)(this.getBounds().getHeight() - 50.0));
        b.a(graphics2D, this.graphRect, this.vc, this.minBin, this.maxBin, this.maxCount);
        b.b(graphics2D, this.graphRect, this.vc, this.minBin, this.maxBin, this.maxCount);
        a.a(graphics2D, new Rectangle(0, (int)this.getBounds().getHeight() - 50, (int)this.getBounds().getWidth(), 50), this.vc, this.minBin, this.maxBin);
    }

    public static int a(float f2, int n2, int n3, int n4) {
        return (int)(f2 / (float)(n3 - n4) * (float)n2);
    }

    public void a() {
        int n2;
        BestContrastor bestContrastor = this.vc.cw().k();
        int[] nArray = bestContrastor.f();
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n5 = nArray[n2];
            if (n5 > 0 && n4 == -1) {
                n4 = n2;
            }
            if (n5 <= this.maxCount) continue;
            this.maxCount = n5;
        }
        n3 = -1;
        for (n2 = nArray.length - 1; n2 >= 0; --n2) {
            if (nArray[n2] <= 0) continue;
            n3 = n2;
            break;
        }
        this.c(n4, n3);
    }

    public void b() {
        this.a();
        int n2 = this.minBin;
        this.minBin = n2 + (int)this.vc.av().d();
        this.maxBin = this.minBin + (int)this.vc.av().m();
    }

    public void c() {
        this.a();
        com.mimvista.util.contrast.b b2 = this.vc.cJ().a();
        ContrastState contrastState = b2.e();
        int n2 = this.minBin;
        this.minBin = n2 + (int)contrastState.d();
        this.maxBin = this.minBin + (int)contrastState.m();
    }

    public int d() {
        return this.minBin;
    }

    public int e() {
        return this.maxBin;
    }

    private void c(int n2, int n3) {
        if (n2 > n3) {
            return;
        }
        this.minBin = n2;
        this.maxBin = n3;
    }

    public void a(final Volumetric3DOptionMode volumetric3DOptionMode) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n2 = (mouseEvent.getY() - Volumetric3DGraphPanel.this.lastY) * 2;
                int n3 = (mouseEvent.getX() - Volumetric3DGraphPanel.this.lastX) * 2;
                if (volumetric3DOptionMode.editViewMouseMode.isSelected()) {
                    Volumetric3DGraphPanel.this.a(mouseEvent);
                } else if (volumetric3DOptionMode.editAlphaTableMode.isSelected()) {
                    Volumetric3DGraphPanel.this.b(mouseEvent);
                } else if (volumetric3DOptionMode.editAlphaContrastMode.isSelected()) {
                    Volumetric3DGraphPanel.this.a(n2, n3);
                } else if (volumetric3DOptionMode.editColorContrastMode.isSelected()) {
                    Volumetric3DGraphPanel.this.b(n2, n3);
                }
                Volumetric3DGraphPanel.this.lastX = mouseEvent.getX();
                Volumetric3DGraphPanel.this.lastY = mouseEvent.getY();
                Volumetric3DGraphPanel.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Volumetric3DGraphPanel.this.lastX = mouseEvent.getX();
                Volumetric3DGraphPanel.this.lastY = mouseEvent.getY();
                Volumetric3DGraphPanel.this.lastPoint = null;
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }
}

