/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.volumetric;

import com.mimvista.dataparallel.e;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.casting.RayCastState;
import com.mimvista.internals.casting.VolumetricType;
import com.mimvista.internals.casting.gui.ViewPresetPanelFor3D;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.util.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Volumetric3DRenderingOptions
extends JMenu {
    private static final long serialVersionUID = 1L;
    private static float b = 50.0f;
    private JMenu viewingOptions;
    private JRadioButtonMenuItem orthogonal;
    private JRadioButtonMenuItem perspective;
    private JMenu pushbackLabel;
    private JSlider pushbackPlane;
    private JMenu viewPresetsMenu;
    private ViewPresetPanelFor3D viewPresets;
    private JCheckBoxMenuItem centerOnVolume;
    private JCheckBoxMenuItem shadeSurfaces;
    public static boolean a = false;
    private JMenu renderModeOptions;
    private JMenuItem volumetric;
    private JMenuItem mip;
    private JMenuItem drr;

    public Volumetric3DRenderingOptions(ViewController3D viewController3D) {
        Messages messages = Messages.a("3D_General");
        this.setText(messages.getProperty("VOLUMETRIC_GUI_RENDER_OPTIONS_TITLE"));
        RayCastState rayCastState = viewController3D.cJ().j();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.viewingOptions = new JMenu(messages.getProperty("VOLUMETRIC_GUI_VIEW_MODES_GROUP"));
        this.orthogonal = new JRadioButtonMenuItem(messages.getProperty("VOLUMETRIC_GUI_ORTHOGONAL"));
        this.viewingOptions.add(this.orthogonal);
        buttonGroup.add(this.orthogonal);
        this.perspective = new JRadioButtonMenuItem(messages.getProperty("VOLUMETRIC_GUI_PERSPECTIVE"));
        this.viewingOptions.add(this.perspective);
        buttonGroup.add(this.perspective);
        this.b(viewController3D);
        this.add(this.viewingOptions);
        this.pushbackLabel = new JMenu(messages.getProperty("VOLUMETRIC_GUI_SLICE_PLANE"));
        this.pushbackPlane = new JSlider(0, (int)(1024.0f * b), 0);
        this.pushbackLabel.add(this.pushbackPlane);
        this.add(this.pushbackLabel);
        this.viewPresetsMenu = new JMenu(messages.getProperty("VOLUMETRIC_GUI_VIEW_PRESET_MENU_ITEM"));
        this.viewPresets = new ViewPresetPanelFor3D(viewController3D);
        this.viewPresetsMenu.add(this.viewPresets.a());
        this.add(this.viewPresetsMenu);
        this.centerOnVolume = new JCheckBoxMenuItem(messages.getProperty("VOLUMETRIC_GUI_CENTER_ON_VOLUME"));
        if (rayCastState.camera.centerOfRotation != null) {
            this.centerOnVolume.setSelected(true);
        } else {
            this.centerOnVolume.setSelected(false);
        }
        this.add(this.centerOnVolume);
        this.shadeSurfaces = new JCheckBoxMenuItem(messages.getProperty("VOLUMETRIC_GUI_SHADE_SURFACES"));
        if (rayCastState.doShading) {
            this.shadeSurfaces.setSelected(true);
        } else {
            this.shadeSurfaces.setSelected(false);
        }
        if (!e.a().u()) {
            this.shadeSurfaces.setSelected(false);
            viewController3D.cJ().a(false);
            this.shadeSurfaces.setEnabled(false);
        }
        this.add(this.shadeSurfaces);
        if (a) {
            this.renderModeOptions = new JMenu("EX: volumetric modes");
            this.volumetric = new JMenuItem("EX: Volumetric");
            this.renderModeOptions.add(this.volumetric);
            this.mip = new JMenuItem("EX: MIP");
            this.renderModeOptions.add(this.mip);
            this.drr = new JMenuItem("EX: DRR");
            this.renderModeOptions.add(this.drr);
            this.add(this.renderModeOptions);
        }
        this.a(viewController3D);
    }

    public void a(final ViewController3D viewController3D) {
        this.orthogonal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                viewController3D.cJ().c(1);
                viewController3D.bB();
                viewController3D.g().Q();
            }
        });
        this.perspective.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                viewController3D.cJ().c(0);
                viewController3D.bB();
                viewController3D.g().Q();
            }
        });
        this.pushbackPlane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                viewController3D.cJ().b((float)Volumetric3DRenderingOptions.this.pushbackPlane.getValue() / b);
                viewController3D.bB();
                viewController3D.g().Q();
            }
        });
        this.centerOnVolume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Volumetric3DRenderingOptions.this.centerOnVolume.isSelected()) {
                    viewController3D.cJ().a((VoxelPoint3f)null);
                } else {
                    viewController3D.cJ().f();
                }
                viewController3D.bB();
                viewController3D.g().Q();
            }
        });
        this.shadeSurfaces.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                viewController3D.cJ().a(Volumetric3DRenderingOptions.this.shadeSurfaces.isSelected());
                viewController3D.bB();
                viewController3D.g().Q();
            }
        });
        if (a) {
            this.volumetric.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    viewController3D.cJ().a(VolumetricType.b);
                    viewController3D.g().Q();
                }
            });
            this.mip.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    viewController3D.cJ().a(VolumetricType.c);
                    viewController3D.g().Q();
                }
            });
            this.drr.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    viewController3D.cJ().a(VolumetricType.d);
                    viewController3D.g().Q();
                }
            });
        }
    }

    private void b(ViewController3D viewController3D) {
        if (viewController3D.cJ().j().camera.viewMode == 1) {
            this.orthogonal.setSelected(true);
        } else if (viewController3D.cJ().j().camera.viewMode == 0) {
            this.perspective.setSelected(true);
        }
    }
}

